/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.webframework.provider.IServiceFilter;
import java.util.HashMap;
import java.util.Map;

public class ServiceFilterConfig {
    private IServiceFilter m_oServiceFilter = null;
    private String m_sServiceId = null;
    private String m_sMethodName = null;
    private String m_sClassName = null;
    private Map m_mapParameters = null;

    public ServiceFilterConfig(String _sServiceId, String _sMethodName, String _sClassName) throws WCMException {
        this.m_sServiceId = _sServiceId;
        this.m_sMethodName = _sMethodName;
        this.setClassName(_sClassName);
    }

    public void setParameter(String _sParameterName, String _sValue) {
        if (this.m_mapParameters == null) {
            this.m_mapParameters = new HashMap(1);
        }
        this.m_mapParameters.put(_sParameterName.toUpperCase(), _sValue);
    }

    public String getParameterValue(String _sParameterName) {
        if (this.m_mapParameters == null) {
            return null;
        }
        return (String)this.m_mapParameters.get(_sParameterName.toUpperCase());
    }

    public IServiceFilter getServiceFilter() {
        return this.m_oServiceFilter;
    }

    public String getClassName() {
        return this.m_sClassName;
    }

    public void setClassName(String _className) throws WCMException {
        if (_className == null || (_className = _className.trim()).length() == 0) {
            throw new WCMException(I18NMessage.get(ServiceFilterConfig.class, "ServiceFilterConfig.label1", "\u6ca1\u6709\u6307\u5b9aServiceFilter\u7684ClassName"));
        }
        this.m_sClassName = _className;
        try {
            this.m_oServiceFilter = (IServiceFilter)Class.forName(this.m_sClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new WCMException(I18NMessage.get(ServiceFilterConfig.class, "ServiceFilterConfig.label2", "\u6307\u5b9a\u7684ServiceFilter[") + this.m_sClassName + I18NMessage.get(ServiceFilterConfig.class, "ServiceFilterConfig.label3", "]\u65e0\u6548\uff01"), e);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ServiceFilterConfig.class, "ServiceFilterConfig.label2", "\u6307\u5b9a\u7684ServiceFilter[") + this.m_sClassName + I18NMessage.get(ServiceFilterConfig.class, "ServiceFilterConfig.label4", "]\u4e0d\u80fd\u521d\u59cb\u5316\uff01"), e);
        }
    }

    public String getServiceId() {
        return this.m_sServiceId;
    }

    public String getMethodName() {
        return this.m_sMethodName;
    }
}

