/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework;

import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.domain.LoggerSwitchMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.support.log.OperType;
import com.trs.infra.support.log.OperTypes;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.webframework.ServiceExcuteLogger;
import com.trs.webframework.config.MethodConfig;
import org.apache.log4j.Logger;

public abstract class AbstractLogger
implements ServiceExcuteLogger {
    private static final Logger LOG = Logger.getLogger(AbstractLogger.class);
    protected static final Class CMSOBJS_KLASS = CMSBaseObjs.class;
    protected static final Class BASEOBJ_KLASS = BaseObj.class;

    @Override
    public boolean isLogEnable() {
        return LoggerSwitchMgr.getInstance().checkLoggerState(this.getClass().getName());
    }

    protected String getLogType(MethodConfig _methodConf) {
        String sMethodName = _methodConf.getName();
        String sProvider = _methodConf.getServiceConfig().getServiceId();
        String sLogType = sProvider.replaceAll("wcm61", "wcm6") + "_" + sMethodName;
        String sDesc = _methodConf.getDesc();
        if (CMyString.isEmpty(sDesc)) {
            sDesc = sMethodName;
        }
        sDesc = sDesc + " (wcm6)";
        try {
            if (!LogServer.existsLogType(sLogType)) {
                this.createLogTypeIfNeed(sLogType, sDesc);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"get logtype fail", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)"get logtype fail", throwable);
        }
        return sLogType;
    }

    protected void createLogTypeIfNeed(String sLogType, String sDesc) throws WCMException {
        OperTypes types = new OperTypes();
        WCMFilter filter = new WCMFilter("", "NAME=?", "");
        filter.setMaxRowNumber(1);
        filter.addSearchValues(sLogType);
        types.open(filter);
        if (!types.isEmpty()) {
            LogServer.cachedLogtype((OperType)types.getAt(0));
            return;
        }
        OperType type = new OperType();
        type.setName(sLogType);
        type.setDesc(sDesc);
        type.setProperty("CRTIME", CMyDateTime.now());
        type.setProperty("CRUSER", "admin");
        type.insert();
        LogServer.cachedLogtype(type);
    }

    protected int log(MethodConfig _methodConf, String _sLogDesc, BaseObj _baseobj) {
        try {
            String sUserName = ContextHelper.getLoginUser().getName();
            String sLogType = this.getLogType(_methodConf);
            if (sLogType == null) {
                sLogType = "UNKNOWN_OPERTYPE";
            }
            return (int)LogServer.startRecord(sUserName, sLogType, _sLogDesc, _baseobj);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception to record error![MethodInfo=" + _methodConf + "]"), (Throwable)e);
            return 0;
        }
    }

    @Override
    public void endLog(int _nLogId) {
        LogServer.endRecordSucceedOperation(_nLogId);
    }

    @Override
    public void endLogWithFaliure(int _nLogId, Throwable _throwable) {
        LogServer.endRecordFailedOperation(_nLogId, _throwable);
    }

    @Override
    public String getClassDesc() {
        return "";
    }
}

