/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ObjectBodyValidator
extends AbstractValidator {
    protected String m_sType = "Objects";
    protected Object m_oWarning = I18NMessage.get(ObjectBodyValidator.class, "ObjectBodyValidator.label1", "Object/Applet\u8282\u70b9\u4e2d\u4e0d\u5305\u542b\u5185\u5bb9");
    protected String m_oExample = I18NMessage.get(ObjectBodyValidator.class, "ObjectBodyValidator.label2", "\u4e3a\u9875\u9762\u4e2d\u7684Object/Applet\u8282\u70b9\u6dfb\u52a0\u5185\u5bb9\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;OBJECT codeBase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=70190\" classid=clsid:D27CDB6E-AE6D-11cf-96B8-444553540000 width=\"400\" height=\"100\"&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;PARAM NAME=\"movie\" VALUE=\"head.swf\"&gt;&lt;PARAM NAME=\"quality\" VALUE=\"high\"&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;embed src=\"head.swf\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" width=\"400\" height=\"100\" alt=\"head.swf\"&gt;&lt;/embed&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;<span style=\"color:blue\">&lt;span class=\"nav_hide\"&gt;head.swf&lt;/span&gt;</span><br>&nbsp;&nbsp;&lt;/OBJECT&gt;";

    @Override
    public Object doValid(String content, HashMap known) {
        ArrayList rst = new ArrayList();
        this.renderEle(content, rst, "Object");
        this.renderEle(content, rst, "Applet");
        return rst;
    }

    private void renderEle(String content, List rstFail, String eleName) {
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            int[] pos = (int[])tags.get(i);
            String innerHTML = HTMLUtil.getEleInnerHTML(content, pos).trim();
            innerHTML = HTMLUtil.removeTags(innerHTML, "PARAM");
            if ((innerHTML = HTMLUtil.removeTags(innerHTML, "EMBED")).trim().length() != 0) continue;
            this.addToList(content, rstFail, pos);
        }
    }

    private void addToList(String content, List rstFail, int[] pos) {
        int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
        rstFail.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), HTMLUtil.getEleOuterHTML(content, pos)});
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

