/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImgAltValidator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(ImgAltValidator.class, "ImgAltValidator.label1", "\u56fe\u7247");
    protected Object m_oWarning = I18NMessage.get(ImgAltValidator.class, "ImgAltValidator.label2", "IMG,AREA,INPUT(type=image)\u7684\u8282\u70b9\u6ca1\u6709\u6307\u5b9aalt\u5c5e\u6027");
    protected String m_oExample = I18NMessage.get(ImgAltValidator.class, "ImgAltValidator.label4", "\u4e3a\u9875\u9762\u4e2d\u8868\u793a\u5185\u5bb9\u7684\u56fe\u7247\u6307\u5b9aalt\u5c5e\u6027\uff0c\u4f8b\u5982\uff1a<br>") + "&nbsp;&nbsp;&lt;IMG src=\"sqgk.jpg\" <span style=\"color:blue\">alt=\"" + I18NMessage.get(ImgAltValidator.class, "ImgAltValidator.label5", "\u56fe\u7247\u8bf4\u660e\"</span>&gt;") + I18NMessage.get(ImgAltValidator.class, "ImgAltValidator.label6", "<br>\u4e3a\u9875\u9762\u4e2d\u4e0d\u7528\u4e8e\u8868\u793a\u5185\u5bb9\u7684\u56fe\u7247\u6307\u5b9aalt\u5c5e\u6027\uff0c\u8bbe\u7f6e\u5176\u8bf4\u660e\u4e3a\u7a7a\uff0c\u4f8b\u5982\uff1a<br>") + "&nbsp;&nbsp;&lt;IMG src=\"dot3.jpg\" width=9 height=9 <span style=\"color:blue\">alt=\"\"</span> OLDSRC=\"dot3.jpg\" OLDID=\"172\" RELATED=\"1\"&gt;";

    @Override
    public Object doValid(String content, HashMap known) {
        HashMap rst = new HashMap();
        ArrayList rstWarn = new ArrayList();
        ArrayList rstFail = new ArrayList();
        this.renderEle(content, rstWarn, rstFail, "IMG");
        this.renderEle(content, rstWarn, rstFail, "AREA");
        this.renderEle(content, rstWarn, rstFail, "INPUT");
        if (rstWarn.size() == 0 && rstFail.size() == 0) {
            return Boolean.TRUE;
        }
        rst.put("warn", rstWarn);
        rst.put("fail", rstFail);
        return rst;
    }

    private void renderEle(String content, List rstWarn, List rstFail, String eleName) {
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            int[] pos = (int[])tags.get(i);
            String attrs = HTMLUtil.getEleAttrs(content, pos, eleName);
            HashMap hsAttrs = HTMLUtil.makeHsAttrs(attrs);
            if (CMyString.showNull((String)hsAttrs.get("class")).indexOf("FCK_") != -1 || !CMyString.isEmpty((String)hsAttrs.get("_fckflash")) || "INPUT".equalsIgnoreCase(eleName) && !"image".equalsIgnoreCase((String)hsAttrs.get("type")) || !CMyString.isEmpty((String)hsAttrs.get("alt"))) continue;
            if ("".equals((String)hsAttrs.get("alt"))) {
                this.addToList(content, rstWarn, pos);
                continue;
            }
            this.addToList(content, rstFail, pos);
        }
    }

    private void addToList(String content, List rstFail, int[] pos) {
        int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
        rstFail.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), HTMLUtil.getEleOuterHTML(content, pos)});
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public String getWarning(Object o) {
        if ("warn".equals(o)) {
            return I18NMessage.get(ImgAltValidator.class, "ImgAltValidator.label3", "IMG\u8282\u70b9\u7684alt\u5c5e\u6027\u4e3a\u7a7a");
        }
        return (String)this.m_oWarning;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }

    @Override
    public String getExample(Object o) {
        if ("warn".equals(o)) {
            return I18NMessage.get(ImgAltValidator.class, "ImgAltValidator.label7", "\u8bf7\u786e\u5b9a\u5f53\u524dalt\u5c5e\u6027\u4e3a\u7a7a\u7684\u56fe\u7247\u4e0d\u7528\u4e8e\u8868\u793a\u5185\u5bb9\uff0c\u5426\u5219\u9700\u8981\u4e3a\u5176\u6307\u5b9a\u8bf4\u660e\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;IMG src=\"sqgk.jpg\" <span style=\"color:blue\">alt=\"" + I18NMessage.get(ImgAltValidator.class, "ImgAltValidator.label5", "\u56fe\u7247\u8bf4\u660e\"</span>&gt;");
        }
        return this.m_oExample;
    }
}

