/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FormSubmitValidator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(FormSubmitValidator.class, "FormSubmitValidator.label1", "\u8868\u5355");
    protected Object m_oWarning = I18NMessage.get(FormSubmitValidator.class, "FormSubmitValidator.label2", "Form\u8868\u5355\u4e2d\u6ca1\u6709\u8868\u793a\u63d0\u4ea4\u7684\u6309\u94ae(input type=submit/image \u6216button type=submit)");
    protected String m_oExample = I18NMessage.get(FormSubmitValidator.class, "FormSubmitValidator.label3", "Form\u8868\u5355\u4e2d\u589e\u52a0\u8868\u793a\u63d0\u4ea4\u7684\u6309\u94ae\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;input type=\"submit\" value=\"Ok\"&gt;";

    @Override
    public Object doValid(String content, HashMap known) {
        ArrayList rst = new ArrayList();
        this.renderEle(content, rst, "Form");
        return rst;
    }

    private void renderEle(String content, List rstFail, String eleName) {
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        for (int i = 0; i < tags.size(); ++i) {
            int[] pos = (int[])tags.get(i);
            String innerHTML = HTMLUtil.getEleInnerHTML(content, pos).trim();
            List inputs = HTMLUtil.findTagOuterHTML(innerHTML, "INPUT");
            for (int j = 0; j < inputs.size(); ++j) {
                int[] pos2 = (int[])inputs.get(j);
                String attrs = HTMLUtil.getEleAttrs(innerHTML, pos2, "INPUT");
                HashMap hsAttrs = HTMLUtil.makeHsAttrs(attrs);
                String attType = (String)hsAttrs.get("type");
                if (!"submit".equalsIgnoreCase(attType) && !"image".equalsIgnoreCase(attType)) continue;
                return;
            }
            List btns = HTMLUtil.findTagOuterHTML(innerHTML, "BUTTON");
            for (int j = 0; j < btns.size(); ++j) {
                int[] pos2 = (int[])btns.get(j);
                String attrs = HTMLUtil.getEleAttrs(innerHTML, pos2, "BUTTON");
                HashMap hsAttrs = HTMLUtil.makeHsAttrs(attrs);
                String attType = (String)hsAttrs.get("type");
                if (!"submit".equalsIgnoreCase(attType)) continue;
                return;
            }
            this.addToList(content, rstFail, pos);
        }
    }

    private void addToList(String content, List rstFail, int[] pos) {
        int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
        rstFail.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), HTMLUtil.getEleOuterHTML(content, pos)});
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

