/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.tools.CommonResourceBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceAnalyzer {
    private static Pattern ptJavascript = Pattern.compile("(?si)<script[^>]*? src=[\"']([^\"']*)[\"'][^>]*>(\\s)*</script>");
    private static Pattern ptCssLink = Pattern.compile("(?mi)<link[^>]* href=[\"']([^\"']*)[\"'][^>]*>");
    private static Map m_arrCombinedRs = new HashMap();
    static String m_sSourceWcmPath;
    private static String m_sRuntimeWcmPath;
    private static String m_sWcm61Uri;
    private static String m_sWcmRootUri;
    private static boolean m_bOnePage;
    private static String m_sOnePage;
    public static String locale;

    private static void debug(String s) {
    }

    public static void setSrcPath(String srcPath) {
        m_sSourceWcmPath = srcPath;
    }

    public static void setRuntimePath(String runtimePath) {
        m_sRuntimeWcmPath = runtimePath;
    }

    public static void analyzer(String[] args) throws Exception {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                ResourceAnalyzer.analyzerFile(args[i]);
            }
            return;
        }
        ResourceAnalyzer.analyzerFolder(m_sSourceWcmPath);
    }

    public static void main(String[] args) throws Exception {
        if (args.length >= 2) {
            m_sSourceWcmPath = CMyString.setStrEndWith(args[0].replace('/', File.separatorChar), File.separatorChar);
            m_sRuntimeWcmPath = CMyString.setStrEndWith(args[1].replace('/', File.separatorChar), File.separatorChar);
            m_bOnePage = false;
        }
        if (args.length >= 3) {
            locale = args[2];
        }
        System.out.println("===>" + m_sSourceWcmPath + "==>" + m_sRuntimeWcmPath + "==>" + locale);
        CommonResourceBuilder.locale = locale;
        CommonResourceBuilder.build(m_sSourceWcmPath);
        ResourceAnalyzer.analyzerFolder(m_sSourceWcmPath);
    }

    public static void analyzerFolder(String sAbsFilePath) throws Exception {
        FileService fileSource = new FileService(sAbsFilePath);
        if (!fileSource.exists()) {
            return;
        }
        if (fileSource.isDirectory()) {
            String sFilePath = fileSource.getAbsolutePath();
            String[] aExcludes = new String[]{".svn", "CVS"};
            for (int i = 0; i < aExcludes.length; ++i) {
                if (!sFilePath.endsWith(aExcludes[i])) continue;
                return;
            }
        }
        FileStore[] files = fileSource.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                String childFileName = files[i].getAbsolutePath().substring(m_sSourceWcmPath.length()).replace('\\', '/');
                if (!m_bOnePage) {
                    System.out.println("^^^^^^^^^^" + childFileName);
                }
                if (m_bOnePage && !childFileName.endsWith(m_sOnePage)) continue;
                ResourceAnalyzer.analyzerFile(childFileName);
                continue;
            }
            ResourceAnalyzer.analyzerFolder(files[i].getAbsolutePath());
        }
    }

    private static boolean isExcludeFile(String fileName) {
        boolean result = !fileName.endsWith(".html") && !fileName.endsWith(".jsp") && !fileName.endsWith(".htm");
        result = result || "login.jsp".equals(fileName) || "login_dowith.jsp".equals(fileName);
        result = result || fileName.startsWith("js/source/wcmlib/");
        result = result || fileName.startsWith("editor/");
        result = result || fileName.equals("include/error.jsp");
        result = result || fileName.startsWith("logo/");
        result = result || fileName.startsWith("application/");
        result = result || fileName.endsWith("individual.html");
        return result;
    }

    private static HashMap getFirstHash(String string, ArrayList jsFiles) {
        ArrayList<String> list = CommonResourceBuilder.getMapped(string);
        if (list == null || list.size() == 0) {
            list = new ArrayList<String>();
            list.add(string);
        }
        HashMap rst = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String filename = m_sWcm61Uri + (String)iter.next();
            for (int j = 0; j < jsFiles.size(); ++j) {
                HashMap hs = (HashMap)jsFiles.get(j);
                if (hs == null || !hs.containsKey("file") || hs.containsKey("html")) continue;
                Object myFile = hs.get("file");
                if (!"js/runtime/data/list.js".equals(string) ? !myFile.equals(filename) : !myFile.equals(filename) && !myFile.equals(m_sWcm61Uri + "js/data/combine.jsp?s=operpanel,tab")) continue;
                if (rst != null) {
                    int p1 = Integer.valueOf((String)rst.get("ps1"));
                    int p2 = Integer.valueOf((String)hs.get("ps1"));
                    if (p2 >= p1) continue;
                    rst = hs;
                    continue;
                }
                rst = hs;
            }
        }
        return rst;
    }

    public static void analyzerFile(String sFileName) throws Exception {
        int i;
        boolean bHasCompressJs;
        String sRealFile = m_sSourceWcmPath + sFileName;
        String sToRealFile = m_sRuntimeWcmPath + sFileName;
        if (ResourceAnalyzer.isExcludeFile(sFileName)) {
            CMyFile.copyFile(sRealFile, sToRealFile, true, true);
            return;
        }
        String sMainFileName = CMyFile.extractMainFileName(sFileName);
        String sFileLocaleJs = sMainFileName + locale + ".js";
        String sFileLocaleCss = sMainFileName + locale + ".css";
        String fileEncoding = CharsetDetector.detect(sRealFile);
        String sContent = CMyFile.readFile(sRealFile, fileEncoding);
        Matcher matcher = ptJavascript.matcher(sContent);
        ArrayList hsJsFiles = new ArrayList();
        ArrayList jsFiles = new ArrayList();
        while (matcher.find()) {
            String file = ResourceAnalyzer.formatRealPath(matcher.group(1), sFileName);
            if (ResourceAnalyzer.isExCollectJs(file) || file.indexOf(sFileLocaleJs) >= 0) continue;
            HashMap<String, String> hs = new HashMap<String, String>();
            hs.put("ps1", "" + matcher.start());
            hs.put("ps2", "" + matcher.end());
            hs.put("file", file);
            hs.put("script", "1");
            hs.put("oldhtml", matcher.group(0));
            hsJsFiles.add(hs);
            jsFiles.add(file);
        }
        matcher = ptCssLink.matcher(sContent);
        ArrayList hsCssFiles = new ArrayList();
        ArrayList cssFiles = new ArrayList();
        while (matcher.find()) {
            String file;
            if (matcher.group().indexOf("text/css") == -1 || (file = ResourceAnalyzer.formatRealPath(matcher.group(1), sFileName)).indexOf(sFileLocaleCss) >= 0) continue;
            HashMap<String, String> hs = new HashMap<String, String>();
            hs.put("ps1", "" + matcher.start());
            hs.put("ps2", "" + matcher.end());
            hs.put("file", file);
            hs.put("oldhtml", matcher.group(0));
            hsCssFiles.add(hs);
            cssFiles.add(file);
        }
        ArrayList pageResources = ResourceAnalyzer.orderIt(hsJsFiles, hsCssFiles);
        String sPageType = ResourceAnalyzer.getPageType(sFileName, jsFiles);
        if (sPageType == null) {
            CMyFile.copyFile(sRealFile, sToRealFile, true, true);
            return;
        }
        if ("combinpage".equals(sPageType)) {
            ResourceAnalyzer.doWithCombinePage(sFileName, pageResources);
            String html = ResourceAnalyzer.replaceResource(sContent, pageResources);
            CMyFile.writeFile(sToRealFile, html, fileEncoding);
            return;
        }
        String[] resources = ResourceAnalyzer.getResourcesByPageType(sPageType);
        StringBuffer sbMoreJs = new StringBuffer();
        ResourceAnalyzer.doWithPreDefined(sFileName, pageResources, resources, sbMoreJs);
        jsFiles = ResourceAnalyzer.withoutJsCombined(resources, jsFiles, sFileName);
        String sCurrPageName = sFileName.replaceAll(".*/([^/]*)\\.(htm|html|jsp)$", "$1");
        String sPageCombineJs = sFileName.replaceAll(".*/([^/]*)$", "$1") + ".compress.js";
        System.out.println(sCurrPageName + ".js");
        StringBuffer outx = new StringBuffer();
        for (int i2 = 0; i2 < jsFiles.size(); ++i2) {
            String tmpFile = (String)jsFiles.get(i2);
            if (tmpFile.endsWith(sCurrPageName + ".js") && tmpFile.indexOf("/locale/") < 0 || tmpFile.indexOf(".jsp") != -1 && tmpFile.indexOf("js/data/combine.jsp") == -1 && tmpFile.indexOf("js/list/plugins.jsp") == -1) continue;
            if (tmpFile.startsWith(m_sWcm61Uri)) {
                tmpFile = tmpFile.replaceAll("^" + m_sWcm61Uri, "");
                CommonResourceBuilder.outContent(m_sSourceWcmPath + tmpFile, outx, false, false);
                continue;
            }
            System.out.println(tmpFile + "-->" + m_sSourceWcmPath.replace('\\', '/').replaceAll(m_sWcm61Uri, "") + tmpFile);
        }
        boolean bl = bHasCompressJs = outx.length() > 0;
        if (outx.length() > 0) {
            try {
                CMyFile.writeFile(m_sRuntimeWcmPath + sFileName + ".compress.js", outx.toString(), "utf-8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        boolean hasPageJs = false;
        for (i = jsFiles.size() - 1; i >= 0; --i) {
            String tmpFile = (String)jsFiles.get(i);
            if (tmpFile.endsWith(sCurrPageName + ".js")) {
                hasPageJs = true;
            }
            if (tmpFile.indexOf(".jsp") != -1 && tmpFile.indexOf("js/data/combine.jsp") == -1 && tmpFile.indexOf("js/list/plugins.jsp") == -1 || !tmpFile.startsWith(m_sWcm61Uri)) continue;
            jsFiles.remove(i);
        }
        for (i = 0; i < jsFiles.size(); ++i) {
            sbMoreJs.append("<script src=\"");
            sbMoreJs.append(ResourceAnalyzer.getRelativePath((String)jsFiles.get(i), sFileName));
            sbMoreJs.append("\"></script>\n");
        }
        if (bHasCompressJs) {
            sbMoreJs.append("<script src=\"");
            sbMoreJs.append(sPageCombineJs);
            sbMoreJs.append("\"></script>\n");
        }
        if (hasPageJs) {
            sbMoreJs.append("<script src=\"");
            sbMoreJs.append(sCurrPageName + ".js");
            sbMoreJs.append("\"></script>\n");
        }
        if (CMyFile.fileExists(m_sSourceWcmPath + sFileLocaleJs)) {
            sbMoreJs.append("<script src=\"");
            sbMoreJs.append(sFileLocaleJs);
            sbMoreJs.append("\"></script>\n");
            System.out.println("==========================>" + sFileLocaleJs);
        }
        StringBuffer sbMoreCss = new StringBuffer();
        cssFiles = ResourceAnalyzer.withoutCssCombined(resources, cssFiles, sFileName);
        for (int i3 = 0; i3 < cssFiles.size(); ++i3) {
            sbMoreCss.append("<link href=\"");
            sbMoreCss.append(ResourceAnalyzer.getRelativePath((String)cssFiles.get(i3), sFileName));
            sbMoreCss.append("\" rel=\"stylesheet\" type=\"text/css\">\n");
        }
        String html = ResourceAnalyzer.replaceResource(sContent, pageResources);
        if (CMyFile.fileExists(m_sSourceWcmPath + sFileLocaleCss)) {
            sbMoreJs.append("<link href=\"");
            sbMoreJs.append(sFileLocaleCss);
            sbMoreJs.append("\" rel=\"stylesheet\" type=\"text/css\">\n");
            System.out.println("==========================>" + sFileLocaleJs);
        }
        html = html.replaceAll("(?m)^\\s*$", "").replaceAll("(?im)^\\s*<\\!--.*?-->\\s*$", "").replaceAll("\n{2,}", "\n");
        StringBuffer result = null;
        int nHeadEnd = html.toLowerCase().indexOf("</head>");
        if (nHeadEnd == -1) {
            html = sbMoreCss.toString() + html;
        } else {
            result = new StringBuffer();
            result.append(html.substring(0, nHeadEnd));
            result.append(sbMoreCss);
            result.append(html.substring(nHeadEnd));
            html = result.toString();
        }
        int nBodyEnd = html.toLowerCase().indexOf("</body>");
        if (nBodyEnd == -1) {
            html = html + sbMoreJs.toString();
        } else {
            result = new StringBuffer();
            result.append(html.substring(0, nBodyEnd));
            result.append(sbMoreJs);
            result.append(html.substring(nBodyEnd));
            html = result.toString();
        }
        CMyFile.writeFile(sToRealFile, html, fileEncoding);
    }

    private static void doWithPreDefined(String sFileName, ArrayList pageResources, String[] resources, StringBuffer sbMoreJs) {
        HashMap lastHs1 = null;
        HashMap lastHs2 = null;
        HashMap lastHs = null;
        for (int i = 0; i < resources.length; ++i) {
            StringBuffer sb = new StringBuffer();
            if (resources[i].endsWith(".js")) {
                sb.append("<script src=\"");
                sb.append(ResourceAnalyzer.getRelativePath(resources[i], sFileName));
                sb.append("\"></script>");
            } else {
                sb.append("<link href=\"");
                sb.append(ResourceAnalyzer.getRelativePath(resources[i], sFileName));
                sb.append("\" rel=\"stylesheet\" type=\"text/css\">\n");
            }
            HashMap hs2 = ResourceAnalyzer.getFirstHash(resources[i], pageResources);
            if (hs2 == null) {
                HashMap hashMap = lastHs = resources[i].endsWith(".js") ? lastHs1 : lastHs2;
                if (lastHs != null) {
                    lastHs.put("html", lastHs.get("html") + "\n" + sb.toString());
                    continue;
                }
                sbMoreJs.append(sb.toString() + "\n");
                continue;
            }
            if (resources[i].endsWith(".js")) {
                lastHs1 = hs2;
            } else {
                lastHs2 = hs2;
            }
            hs2.put("html", sb.toString());
        }
    }

    private static void doWithCombinePage(String sFileName, ArrayList pageResources) {
        for (int i = 0; i < pageResources.size(); ++i) {
            HashMap hs = (HashMap)pageResources.get(i);
            String file = (String)hs.get("file");
            if (hs.containsKey("script") && file.indexOf("js/data/combine.jsp") != -1) {
                StringBuffer sb = new StringBuffer();
                sb.append("<script src=\"");
                String datas = file.replaceAll(".*\\?s=([^?]*)$", "$1");
                String[] arrDatas = datas.split(",");
                String tmpFile = CommonResourceBuilder.getCombineFile(arrDatas);
                if (tmpFile == null) continue;
                sb.append(ResourceAnalyzer.getRelativePath(tmpFile, sFileName));
                sb.append("\"></script>");
                hs.put("html", sb.toString());
                continue;
            }
            hs.put("html", hs.get("oldhtml"));
        }
    }

    private static String[] getResourcesByPageType(String sPageType) {
        String[] arr = sPageType.split("#");
        String[] resources = (String[])m_arrCombinedRs.get(arr[0]);
        if (resources == null) {
            resources = new String[]{};
        }
        if (arr.length > 1 && arr[1].length() != 0) {
            ArrayList<String> lstResources = new ArrayList<String>();
            for (int i = 0; i < resources.length; ++i) {
                lstResources.add(resources[i]);
            }
            if (!"website".equals(arr[1]) && !"channel".equals(arr[1])) {
                lstResources.add("js/runtime/data/oper_channelwebsite.js");
            } else if ("channel".equals(arr[1])) {
                lstResources.add("js/runtime/data/oper_website.js");
            }
            lstResources.add("js/runtime/data/oper_cmsobj_" + arr[1] + ".js");
            resources = new String[lstResources.size()];
            lstResources.toArray(resources);
        }
        return resources;
    }

    private static String replaceResource(String sContent, ArrayList pageResources) {
        StringBuffer result = new StringBuffer();
        int lastIndex = 0;
        for (int i = 0; i < pageResources.size(); ++i) {
            HashMap hs = (HashMap)pageResources.get(i);
            int ps1 = Integer.valueOf((String)hs.get("ps1"));
            int ps2 = Integer.valueOf((String)hs.get("ps2"));
            if (ps1 != lastIndex) {
                result.append(sContent.substring(lastIndex, ps1));
            }
            if (hs.containsKey("html")) {
                result.append(hs.get("html"));
            }
            lastIndex = ps2;
        }
        if (lastIndex != sContent.length()) {
            result.append(sContent.substring(lastIndex));
        }
        return result.toString();
    }

    private static boolean isExCollectJs(String file) {
        if (file.indexOf("/extension.js") != -1) {
            return true;
        }
        if (file.indexOf("/cssrender.js") != -1) {
            return true;
        }
        if (file.indexOf("/individuation/customize_config.jsp") != -1) {
            return true;
        }
        return file.indexOf("/template/trsad_config.jsp") != -1;
    }

    private static ArrayList orderIt(ArrayList jsFiles1, ArrayList cssFiles1) {
        ArrayList<HashMap> rst = new ArrayList<HashMap>();
        int i = 0;
        int j = 0;
        while (i < jsFiles1.size() || j < cssFiles1.size()) {
            HashMap o1 = null;
            HashMap o2 = null;
            if (i < jsFiles1.size()) {
                o1 = (HashMap)jsFiles1.get(i);
            }
            if (j < cssFiles1.size()) {
                o2 = (HashMap)cssFiles1.get(j);
            }
            int ps1 = 100000000;
            int ps2 = 100000000;
            if (o1 != null) {
                ps1 = Integer.valueOf((String)o1.get("ps1"));
            }
            if (o2 != null) {
                ps2 = Integer.valueOf((String)o2.get("ps1"));
            }
            if (ps1 > ps2) {
                rst.add(o2);
                ++j;
                continue;
            }
            if (ps1 < ps2) {
                rst.add(o1);
                ++i;
                continue;
            }
            ++i;
            ++j;
        }
        return rst;
    }

    private static String formatRealPath(String pageResource, String fileName) {
        if (pageResource.startsWith("/")) {
            return pageResource;
        }
        String sCurrPath = fileName.indexOf("/") == -1 ? "" : fileName.replaceAll("^(.*/)[^/]*$", "$1");
        String lastString = pageResource = m_sWcm61Uri + sCurrPath + pageResource;
        while (!(pageResource = pageResource.replaceAll("(/|^)\\./", "$1").replaceAll("(/|^)[^/\\.]*/\\.\\./", "$1")).equals(lastString)) {
            lastString = pageResource;
        }
        ResourceAnalyzer.debug(">>>>>" + pageResource);
        return pageResource;
    }

    private static String getRelativePath(String pageResource, String fileName) {
        if ((pageResource = pageResource.replaceAll("^" + m_sWcm61Uri, "")).startsWith(m_sWcmRootUri)) {
            String sPrefix = "";
            int nCount = fileName.split("/").length - 1;
            if (!fileName.startsWith(m_sWcm61Uri)) {
                ++nCount;
            }
            for (int i = 0; i < nCount; ++i) {
                sPrefix = "../" + sPrefix;
            }
            System.out.println("----------->" + sPrefix + pageResource.replaceFirst("^" + m_sWcmRootUri, ""));
            return sPrefix + pageResource.replaceFirst("^" + m_sWcmRootUri, "");
        }
        int nCount = fileName.split("/").length - 1;
        for (int i = 0; i < nCount; ++i) {
            pageResource = "../" + pageResource;
        }
        ResourceAnalyzer.debug("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<" + pageResource);
        return pageResource;
    }

    private static ArrayList withoutCssCombined(String[] resources, ArrayList cssFiles, String sPageFileName) {
        for (int j = cssFiles.size() - 1; j >= 0; --j) {
            String tmpFile = (String)cssFiles.get(j);
            if (tmpFile.indexOf("js/source/wcmlib/") == -1) continue;
            cssFiles.remove(j);
        }
        for (int i = 0; i < resources.length; ++i) {
            ArrayList list = CommonResourceBuilder.getMapped(resources[i]);
            if (list == null || list.size() == 0) continue;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String filename = m_sWcm61Uri + (String)iter.next();
                for (int j = cssFiles.size() - 1; j >= 0; --j) {
                    String tmpFile = (String)cssFiles.get(j);
                    if (!tmpFile.equals(filename)) continue;
                    cssFiles.remove(j);
                }
            }
        }
        return cssFiles;
    }

    private static ArrayList withoutJsCombined(String[] resources, ArrayList jsFiles, String sPageFileName) {
        for (int j = jsFiles.size() - 1; j >= 0; --j) {
            String tmpFile = (String)jsFiles.get(j);
            if (tmpFile.indexOf("js/data/combine.jsp") == -1 && tmpFile.indexOf("js/list/plugins.jsp") == -1) continue;
            jsFiles.remove(j);
        }
        for (int i = 0; i < resources.length; ++i) {
            ArrayList<String> list = CommonResourceBuilder.getMapped(resources[i]);
            if (list == null || list.size() == 0) {
                list = new ArrayList<String>();
                list.add(resources[i]);
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String filename = m_sWcm61Uri + (String)iter.next();
                ResourceAnalyzer.debug(resources[i] + "**********" + filename);
                for (int j = jsFiles.size() - 1; j >= 0; --j) {
                    String tmpFile = (String)jsFiles.get(j);
                    ResourceAnalyzer.debug("**********^^^^^^^^^^^^^^^" + tmpFile);
                    if (!tmpFile.equals(filename)) continue;
                    jsFiles.remove(j);
                }
            }
        }
        return jsFiles;
    }

    private static String getPageType(String fileName, ArrayList jsFiles) {
        if (fileName.equals("main.jsp")) {
            return "main";
        }
        if (fileName.endsWith("/document_addedit.jsp")) {
            return "document-addedit";
        }
        if (fileName.endsWith("nav_tree.html") || fileName.endsWith("nav_tree_select.jsp") || fileName.endsWith("nav_tree_select_site.jsp") || fileName.endsWith("nav_tree_inner.html")) {
            return "nav-tree";
        }
        boolean isListPage = false;
        boolean isThumbPage = false;
        boolean isLightbase = false;
        boolean isCombin = false;
        String sXxx = "";
        for (String jsFileName : jsFiles) {
            if (jsFileName.endsWith("tab_fittable.js")) {
                return "fittable";
            }
            if (jsFileName.endsWith("AbsList.js")) {
                isListPage = true;
                continue;
            }
            if (jsFileName.endsWith("AbsThumb.js")) {
                isThumbPage = true;
                continue;
            }
            if (jsFileName.matches("(^|.*/)js/data/cmsobj/.*\\.js$")) {
                sXxx = jsFileName.replaceAll(".*/([^/]*)\\.js$", "$1");
                continue;
            }
            if (jsFileName.endsWith("lightbase.js")) {
                isLightbase = true;
                continue;
            }
            if (jsFileName.indexOf("js/data/combine.jsp") == -1) continue;
            isCombin = true;
        }
        ResourceAnalyzer.debug("xxxx-----------sXxx:" + sXxx);
        if (isListPage && !isThumbPage) {
            if (isLightbase) {
                return "list#" + sXxx;
            }
            return "list-old#" + sXxx;
        }
        if (isThumbPage) {
            if (isLightbase) {
                return "thumb#" + sXxx;
            }
            return "thumb-old#" + sXxx;
        }
        if (isCombin) {
            return "combinpage";
        }
        return null;
    }

    static {
        m_arrCombinedRs.put("main", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/data/locale_all.js", "js/runtime/menu_cmsmenu.js", "js/runtime/data/main.js", "main/main.js", "js/runtime/ajax_bdh.js", "js/runtime/components_dd.js", "css/common_main.css", "js/resource/full_widgets.css"});
        m_arrCombinedRs.put("list-old", new String[]{"js/runtime/myext-debug.js", "js/runtime/core_main.js", "js/runtime/abs_list_old.js", "js/runtime/data/list.js", "css/common_list.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("list", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/abs_list.js", "js/runtime/data/list.js", "css/common_list.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("thumb-old", new String[]{"js/runtime/myext-debug.js", "js/runtime/core_main.js", "js/runtime/abs_thumb_old.js", "js/runtime/data/list.js", "css/common_thumb.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("thumb", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/abs_thumb.js", "js/runtime/data/list.js", "css/common_thumb.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("fittable", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/data/fittable.js", "js/runtime/widgets_fittable.js", "css/wcm-common.css"});
        m_arrCombinedRs.put("document-addedit", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/runtime/light_comps.js", "js/runtime/dialog_dd.js", "css/common_main.css", "js/resource/all_widgets.css"});
        m_arrCombinedRs.put("nav-tree", new String[]{"js/runtime/lightlib.js", "js/runtime/core_main.js", "js/source/wcmlib/com.trs.tree/TreeNav.js", "js/easyversion/ajax.js", "js/runtime/components_dd.js", "css/common_tree.css"});
        m_sSourceWcmPath = "D:\\workspace\\TRS.WCM.V6.1.Std\\release\\wcm\\app\\";
        m_sRuntimeWcmPath = "D:\\workspace\\TRS.WCM.V6.1.Std\\runtime2\\wcm\\app\\";
        m_sWcm61Uri = "/wcm/app/";
        m_sWcmRootUri = "/wcm/";
        m_bOnePage = true;
        m_sOnePage = "individual.html";
        locale = "cn";
    }
}

