/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.tools.Localizer2;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OldLocalizer2 {
    private static final String WEB_INF_CLASSES_LOCALE = "/WEB-INF/classes/wcm6-locale/";
    String m_sLang = "cn";
    static Pattern m_pBlockWhere = Pattern.compile("(?i)<(title|span|b|div|td|option|a|legend|button|label|noscript)\\b[^>]* WCMAnt:param=[\"']([^\"']*)[\"'][^>]*>");
    static Pattern m_pAttrTrans = Pattern.compile("(?i)(<[^>]* WCMAnt:paramattr=[\"']([^\"':]*):([^\"':]*?)[\"']( [^>/]*)?)([\\s/\\s]?)>");
    Hashtable m_htTranslates = new Hashtable();
    String m_sRootPath = "/wcm";
    String m_sTargetPath = "";
    String[] m_arrToTransPaths = new String[]{"app", "console"};
    static Pattern m_pScriptLocale = Pattern.compile("(?i)(<script(?: [^>]*)? WCMAnt:locale=[\"']([^\"']*)[\"'](?: [^>]*)?)>");
    Writer m_localePropsWriter = null;
    static boolean m_recordLocaleProps = false;
    private Map m_tmpTranParams = null;
    private List list = new ArrayList();

    public OldLocalizer2(String sRootPath, String sTargetPath, String sLang) {
        this.m_sRootPath = new FileService(sRootPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sTargetPath = new FileService(sTargetPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sLang = sLang;
        if (!m_recordLocaleProps) {
            this.loadTranslates();
        }
    }

    public String[] getToTransPaths() {
        return this.m_arrToTransPaths;
    }

    public void setToTransPaths(String[] toTransPaths) {
        this.m_arrToTransPaths = toTransPaths;
    }

    private void loadTranslates() {
        try {
            String sLocaleFile = this.m_sRootPath + WEB_INF_CLASSES_LOCALE + this.m_sLang + ".properties";
            sLocaleFile = sLocaleFile.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            if (!new FileService(sLocaleFile).exists()) {
                return;
            }
            String sContent = CMyFile.readFile(sLocaleFile, "GBK");
            String[] arrLines = sContent.split("\n(\r)?");
            for (int i = 0; i < arrLines.length; ++i) {
                String sLine = arrLines[i].trim();
                if (sLine.length() == 0 || sLine.startsWith("#") || sLine.indexOf("=") == -1) continue;
                int nIndex = sLine.indexOf(61);
                this.m_htTranslates.put(sLine.substring(0, nIndex).toUpperCase(), sLine.substring(nIndex + 1));
            }
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
    }

    public void localize() throws CMyException {
        try {
            if (m_recordLocaleProps) {
                this.getLocalePropsWriter();
            }
            this.localize1();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (m_recordLocaleProps) {
                try {
                    this.writeLocale();
                    this.closeLocalePropsWriter();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void writeLocale() throws IOException {
        Collections.sort(this.list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] pair1 = (String[])o1;
                String[] pair2 = (String[])o2;
                return pair1[0].compareToIgnoreCase(pair2[0]);
            }
        });
        Writer writer = this.getLocalePropsWriter();
        int length = this.list.size();
        for (int i = 0; i < length; ++i) {
            String[] pair = (String[])this.list.get(i);
            writer.write(pair[0]);
            writer.write("=");
            writer.write(pair[1]);
            writer.write("\n");
        }
    }

    public void localizeNew(Date date) throws CMyException {
        try {
            if (m_recordLocaleProps) {
                this.getLocalePropsWriter();
            }
            this.localizeNew1(date);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (m_recordLocaleProps) {
                try {
                    this.closeLocalePropsWriter();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void localize1() throws CMyException {
        for (int i = 0; i < this.m_arrToTransPaths.length; ++i) {
            FileService toTrans = new FileService(this.m_sRootPath + File.separatorChar + this.m_arrToTransPaths[i]);
            this.localizePath(toTrans);
        }
    }

    public void localizeNew1(Date date) throws CMyException {
        for (int i = 0; i < this.m_arrToTransPaths.length; ++i) {
            FileService toTrans = new FileService(this.m_sRootPath + File.separatorChar + this.m_arrToTransPaths[i]);
            this.localizePathNew(toTrans, date);
        }
    }

    public void localizePath(FileStore oPath) throws CMyException {
        if (oPath.isDirectory()) {
            FileStore[] arrFiles = oPath.listFiles();
            for (int i = 0; i < arrFiles.length; ++i) {
                this.localizePath(arrFiles[i]);
            }
            return;
        }
        this.localizeFile(oPath, this.getToFileName(oPath));
    }

    private void localizePathNew(FileStore oPath, Date date) throws CMyException {
        if (date == null) {
            this.localizePath(oPath);
            return;
        }
        if (oPath.isDirectory()) {
            FileStore[] arrFiles = oPath.listFiles();
            for (int i = 0; i < arrFiles.length; ++i) {
                this.localizePathNew(arrFiles[i], date);
            }
            return;
        }
        if (oPath.lastModified() >= date.getTime()) {
            this.localizeFile(oPath, this.getToFileName(oPath));
        }
    }

    public void localizeFile(FileStore oFile, String _toFileName) throws CMyException {
        String sOldFileName = oFile.getAbsolutePath();
        if (this.isBinaryFile(sOldFileName) || !this.isPageFile(sOldFileName)) {
            CMyFile.copyFile(sOldFileName, _toFileName, true, true);
            return;
        }
        System.out.println("----------From :" + sOldFileName);
        System.out.println(">>>>>>>>>>>>To :" + _toFileName);
        String sFileEncoding = this.genFileEncoding(sOldFileName);
        String sHtml = CMyFile.readFile(sOldFileName, sFileEncoding);
        sHtml = sHtml.replaceAll("\\%>", "%_!_%");
        sHtml = this.blockTrans(sHtml);
        sHtml = this.attrTrans(sHtml);
        sHtml = this.scriptLocalize(sHtml);
        sHtml = sHtml.replaceAll("\\%_\\!_\\%", "%>");
        if (sOldFileName.endsWith("login_dowith.jsp")) {
            sHtml = sHtml.replaceAll("\"zh_CN\"", "\"" + ("cn".equalsIgnoreCase(this.m_sLang) ? "zh_CN" : this.m_sLang) + "\"");
        }
        CMyFile.writeFile(_toFileName, sHtml, sFileEncoding);
    }

    private String scriptLocalize(String html) {
        Matcher oMatcher = m_pScriptLocale.matcher(html);
        StringBuffer sbResult = new StringBuffer();
        int nIndex = 0;
        while (oMatcher.find()) {
            int nStartIndex = oMatcher.start();
            sbResult.append(html.substring(nIndex, nStartIndex));
            String strSrc = oMatcher.group(2).replaceAll("(?i)\\$locale\\$", this.m_sLang);
            sbResult.append(oMatcher.group(1).replaceAll("(?i) src=[\"'][^\"']*[\"']", ""));
            sbResult.append(" src=\"");
            sbResult.append(strSrc);
            sbResult.append("\">");
            nIndex = oMatcher.end();
        }
        if (nIndex != html.length() - 1) {
            sbResult.append(html.substring(nIndex));
        }
        return sbResult.toString();
    }

    private String replacePaths(String content) {
        if (this.m_arrToTransPaths == null || this.m_arrToTransPaths.length == 0) {
            return content;
        }
        String sForReplace = "/(" + CMyString.join(this.m_arrToTransPaths, "|") + ")/";
        return content.replaceAll(sForReplace, "/$1_" + this.m_sLang + "/");
    }

    private boolean isTxtFile(String sFileName) {
        String strExt = sFileName.replaceFirst("^.*\\.([^\\.]*)", "$1").toLowerCase();
        return "jsp".equals(strExt) || "html".equals(strExt) || "htm".equals(strExt) || "js".equals(strExt) || "css".equals(strExt) || "xml".equals(strExt);
    }

    private boolean isBinaryFile(String sFileName) {
        return !this.isTxtFile(sFileName);
    }

    private boolean isPageFile(String sFileName) {
        String strExt = sFileName.replaceFirst("^.*\\.([^\\.]*)", "$1").toLowerCase();
        return "jsp".equals(strExt) || "html".equals(strExt) || "htm".equals(strExt);
    }

    private String attrTrans(String html) {
        Matcher oMatcher = m_pAttrTrans.matcher(html);
        StringBuffer sbResult = new StringBuffer();
        int nIndex = 0;
        while (oMatcher.find()) {
            int nStartIndex = oMatcher.start();
            sbResult.append(html.substring(nIndex, nStartIndex));
            String sAttrName = oMatcher.group(2);
            String sTranParam = oMatcher.group(3);
            String sTranValue = this.getTranslate(sTranParam, m_recordLocaleProps ? this.getAttrValue(oMatcher.group(1), sAttrName) : "");
            if (sTranValue != null) {
                sbResult.append(oMatcher.group(1).replaceAll("(?i) " + sAttrName + "=[\"'][^\"']*[\"']", ""));
                sbResult.append(" ");
                sbResult.append(sAttrName);
                sbResult.append("=\"");
                sbResult.append(sTranValue);
                sbResult.append("\"");
                sbResult.append(oMatcher.group(5));
                sbResult.append(">");
            } else {
                sbResult.append(oMatcher.group(0));
            }
            nIndex = oMatcher.end();
        }
        if (nIndex != html.length() - 1) {
            sbResult.append(html.substring(nIndex));
        }
        return sbResult.toString();
    }

    private int getNextQuoteIndex(String nodeAttrs, char quoteChar, int nStartIndex) {
        int nNextIndex = nodeAttrs.indexOf(quoteChar, nStartIndex);
        while (nNextIndex > 0 && nodeAttrs.charAt(nNextIndex - 1) == '\\') {
            nNextIndex = nodeAttrs.indexOf(quoteChar, nNextIndex + 1);
        }
        return nNextIndex;
    }

    private String getAttrValue(String nodeAttrs, String attrName) {
        int nLastJspEnd;
        String attrPattern = " " + attrName.toLowerCase() + "=";
        int nIndex = nodeAttrs.toLowerCase().indexOf(attrPattern);
        if (nIndex < 0) {
            return "";
        }
        char quoteChar = nodeAttrs.charAt(nIndex += attrPattern.length());
        int nNextIndex = this.getNextQuoteIndex(nodeAttrs = nodeAttrs.substring(nIndex + 1), quoteChar, 0);
        if (nNextIndex < 0) {
            return "";
        }
        String strJspStart = "<%";
        String strJspEnd = "%_!_%";
        String tmpValue = nodeAttrs.substring(0, nNextIndex);
        if (tmpValue.indexOf(strJspStart) == -1) {
            return tmpValue;
        }
        int nLastJspStart = tmpValue.lastIndexOf(strJspStart);
        if (nLastJspStart < (nLastJspEnd = tmpValue.lastIndexOf(strJspEnd))) {
            return tmpValue;
        }
        int nTmpIndex = nodeAttrs.indexOf(strJspEnd, nNextIndex);
        while (nNextIndex > 0 && nTmpIndex > 0) {
            nNextIndex = this.getNextQuoteIndex(nodeAttrs, quoteChar, nTmpIndex);
            if (nNextIndex < 0) {
                return "";
            }
            tmpValue = nodeAttrs.substring(nTmpIndex, nNextIndex);
            if (tmpValue.indexOf(strJspStart) == -1) {
                return nodeAttrs.substring(0, nNextIndex);
            }
            nTmpIndex = nodeAttrs.indexOf(strJspEnd, nNextIndex);
        }
        return "";
    }

    private String blockTrans(String html) {
        Matcher oMatcher = m_pBlockWhere.matcher(html);
        StringBuffer sbResult = new StringBuffer();
        int nIndex = 0;
        while (oMatcher.find()) {
            int nStartIndex = oMatcher.start();
            if (nStartIndex < nIndex) continue;
            sbResult.append(html.substring(nIndex, nStartIndex));
            String sBlockTagName = oMatcher.group(1);
            nIndex = this.doBlock(oMatcher, html, sBlockTagName, sbResult);
        }
        if (nIndex != html.length() - 1) {
            sbResult.append(html.substring(nIndex));
        }
        return sbResult.toString();
    }

    private int doBlock(Matcher matcher, String html, String blockTagName, StringBuffer sbResult) {
        blockTagName = blockTagName.toLowerCase();
        String sStartTag = "<" + blockTagName;
        String sEndTag = "</" + blockTagName + ">";
        int nMatchEnd = matcher.end();
        String endHtml = html.substring(nMatchEnd);
        String lowerEndHtml = endHtml.toLowerCase();
        int nNextStart = lowerEndHtml.indexOf(sStartTag);
        int nNextEnd = lowerEndHtml.indexOf(sEndTag);
        if (nNextEnd < 0) {
            sbResult.append(matcher.group(0));
            return nMatchEnd;
        }
        if (nNextStart < 0 || nNextEnd < nNextStart) {
            String sTranParam = matcher.group(2);
            String sTranValue = this.getTranslate(sTranParam, endHtml.substring(0, nNextEnd));
            sbResult.append(matcher.group(0));
            sbResult.append(sTranValue);
            sbResult.append(sEndTag);
            return nMatchEnd + nNextEnd + sEndTag.length();
        }
        int nNestNum = 2;
        int nMinIndex = nNextStart + sStartTag.length();
        String tmpHtml = null;
        while (nNestNum > 0 && nMinIndex >= 0) {
            tmpHtml = lowerEndHtml.substring(nMinIndex);
            int nTmpNextStart = tmpHtml.indexOf(sStartTag);
            int nTmpNextEnd = tmpHtml.indexOf(sEndTag);
            if (nTmpNextEnd < 0) {
                nMinIndex = -1;
                break;
            }
            if (nTmpNextStart < 0 || nTmpNextEnd < nTmpNextStart) {
                --nNestNum;
                nMinIndex += nTmpNextEnd + sEndTag.length();
                continue;
            }
            ++nNestNum;
            nMinIndex += nTmpNextStart + sStartTag.length();
        }
        if (nMinIndex > 0) {
            String sTranParam = matcher.group(2);
            String sTranValue = this.getTranslate(sTranParam, endHtml.substring(0, nMinIndex - sEndTag.length()));
            sbResult.append(matcher.group(0));
            sbResult.append(sTranValue);
            sbResult.append(sEndTag);
            return nMatchEnd + nMinIndex;
        }
        sbResult.append(matcher.group(0));
        return nMatchEnd;
    }

    private Writer getLocalePropsWriter() throws IOException {
        String sLocaleFile = this.m_sRootPath + WEB_INF_CLASSES_LOCALE + this.m_sLang + ".properties";
        if (this.m_localePropsWriter == null) {
            if (!new FileService(sLocaleFile).exists()) {
                CMyFile.makeDir(this.m_sRootPath + WEB_INF_CLASSES_LOCALE, true);
            }
            this.m_tmpTranParams = new HashMap();
            OutputStream fileos = new FileService(sLocaleFile).getOutputStream();
            this.m_localePropsWriter = new OutputStreamWriter(fileos, "GBK");
        }
        return this.m_localePropsWriter;
    }

    private void closeLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter != null) {
            this.m_localePropsWriter.close();
        }
    }

    private String getTranslate(String tranParam, String currValue) {
        currValue = CMyString.showEmpty(currValue).trim().replaceAll("\\%_\\!_\\%", "%>");
        if (m_recordLocaleProps) {
            try {
                String lastValue = (String)this.m_tmpTranParams.get(tranParam.toUpperCase());
                if (lastValue != null) {
                    if (!lastValue.equalsIgnoreCase(currValue)) {
                        System.out.println(I18NMessage.get(Localizer2.class, "Localizer2.label1", I18NMessage.get(Localizer2.class, "Localizer2.label1", "\u91cd\u590d\u4f7f\u7528\u540c\u4e00\u4e2a\u53d8\u91cf:")) + tranParam + I18NMessage.get(Localizer2.class, "Localizer2.label2", I18NMessage.get(Localizer2.class, "Localizer2.label2", ",\u65e7\u503c:")) + lastValue + I18NMessage.get(Localizer2.class, "Localizer2.label3", I18NMessage.get(Localizer2.class, "Localizer2.label3", ",\u65b0\u503c:")) + currValue);
                        this.m_tmpTranParams.put(tranParam.toUpperCase(), currValue);
                        this.list.add(new String[]{tranParam, currValue});
                    }
                } else {
                    this.m_tmpTranParams.put(tranParam.toUpperCase(), currValue);
                    this.list.add(new String[]{tranParam, currValue});
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return CMyString.showNull((String)this.m_htTranslates.get(tranParam.toUpperCase()), currValue);
    }

    private String genFileEncoding(String sAbsFilePath) {
        String sFileEncoding = "GBK";
        if ((sAbsFilePath = sAbsFilePath.replace('\\', '/')).indexOf("/metadata/application/") != -1) {
            return "utf-8";
        }
        if (sAbsFilePath.indexOf("/ext/") != -1 && sAbsFilePath.indexOf("/locale/") == -1 && sAbsFilePath.indexOf("wcm") == -1) {
            return "GBK";
        }
        if (sAbsFilePath.endsWith(".xml")) {
            return "GBK";
        }
        if (!sAbsFilePath.endsWith(".jsp")) {
            return "utf-8";
        }
        return sFileEncoding;
    }

    private String getToFileName(FileStore toTrans) {
        String sFileName = toTrans.getAbsolutePath();
        return this.m_sTargetPath + sFileName.substring(this.m_sRootPath.length());
    }

    public static void mainTest(String sRootPath, String sTargetPath, String locale) {
        if (CMyString.isEmpty(locale)) {
            return;
        }
        OldLocalizer2 oLocalizer = new OldLocalizer2(sRootPath, sTargetPath, locale);
        oLocalizer.setToTransPaths(new String[]{"app"});
        try {
            oLocalizer.localize();
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String sRootPath = "D:\\workspace\\TRS.WCM.V6.1.Std\\runtime\\wcm\\";
        String sTargetPath = "D:\\workspace\\TRS.WCM.V6.1.Std\\runtime2\\wcm\\";
        String sLocales = "en";
        if (args.length > 0) {
            sRootPath = args[0];
            sTargetPath = args[1];
            sLocales = args[2];
        }
        boolean bl = m_recordLocaleProps = args.length > 3 ? "true".equalsIgnoreCase(args[3]) : false;
        if (CMyString.isEmpty(sLocales)) {
            return;
        }
        String[] arrLocales = sLocales.split(",");
        for (int i = 0; i < arrLocales.length; ++i) {
            OldLocalizer2.mainTest(sRootPath, sTargetPath, arrLocales[i]);
        }
    }
}

