/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.tool;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateExporter;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.template.tool.ITemplateModifyMgr;
import com.trs.template.tool.TemplateFragment;
import com.trs.template.tool.TemplateModifyInfo;
import com.trs.template.tool.TemplateModifyInfos;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TemplateModifyMgr
implements ITemplateModifyMgr {
    private static Logger logger = Logger.getLogger(TemplateModifyMgr.class);

    @Override
    public ArrayList<ArrayList<TemplateFragment>> queryTemplateFragments(WCMFilter _filter, String _match) throws WCMException {
        Templates templates = this.queryTemplates(_filter);
        if (templates.isEmpty()) {
            return null;
        }
        if (_match == null || "".equals(_match)) {
            throw new WCMException("\u8bf7\u8f93\u5165\u9700\u8981\u67e5\u8be2\u503c");
        }
        ArrayList<ArrayList<TemplateFragment>> tempFragmentList = new ArrayList<ArrayList<TemplateFragment>>();
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            int nTemplateID = template.getId();
            String tempText = template.getText();
            HashMap<Integer, Integer> rowMap = this.queryRowFlagMap(template);
            String match = _match.substring(1);
            Matcher matcher = Pattern.compile(match, 2).matcher(tempText);
            if (_match.startsWith("1")) {
                matcher = Pattern.compile(match).matcher(tempText);
            }
            boolean found = false;
            ArrayList<TemplateFragment> tempList = new ArrayList<TemplateFragment>();
            int profixPos = 0;
            while (matcher.find()) {
                found = true;
                int start = matcher.start();
                int end = matcher.end();
                String frgment = "";
                frgment = start - 50 > 0 ? (start - 50 <= profixPos ? tempText.substring(profixPos, start) : frgment + tempText.substring(start - 50, start)) : frgment + tempText.substring(0, start);
                frgment = frgment + "[~#" + matcher.group() + "#~]";
                frgment = end + 50 <= tempText.length() ? frgment + tempText.substring(end, end + 50) : frgment + tempText.substring(end, tempText.length());
                String rowNoStr = this.getRowNO(rowMap, start);
                TemplateFragment tempFragment = new TemplateFragment(nTemplateID, rowNoStr, start, frgment);
                tempList.add(tempFragment);
                profixPos = end;
            }
            if (!found) {
                logger.debug((Object)"No match found.");
            }
            if (tempList.isEmpty()) continue;
            tempFragmentList.add(tempList);
        }
        return tempFragmentList;
    }

    @Override
    public String modifyTemplateFragment(ArrayList<String> _tempidAndPoslist, String _match, String _newValue) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        StringBuffer errorInfo = new StringBuffer();
        CMyDateTime myDateTime = CMyDateTime.now();
        for (String tempidAndPoses : _tempidAndPoslist) {
            String[] tempPosArr = tempidAndPoses.split(",");
            String sTempId = tempPosArr[0];
            int tempID = Integer.parseInt(sTempId);
            Template template = null;
            try {
                template = Template.findById(tempID);
            }
            catch (Exception e) {
                throw new WCMException("\u4fee\u6539\u7684\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            String tempText = template.getText();
            String match = _match.substring(1);
            Matcher matcher = Pattern.compile(match, 2).matcher(tempText);
            if (_match.startsWith("1")) {
                matcher = Pattern.compile(match).matcher(tempText);
            }
            StringBuffer newTempText = new StringBuffer();
            int nExporttempFlag = 0;
            while (matcher.find()) {
                int queryPos = matcher.start();
                for (int i = 1; i < tempPosArr.length; ++i) {
                    int modifyPos = Integer.parseInt(tempPosArr[i]);
                    if (modifyPos != queryPos) continue;
                    if (++nExporttempFlag == 1) {
                        String teplateFilePath = this.exportTemplate(template, myDateTime);
                        TemplateModifyInfo templateModifyInfo = new TemplateModifyInfo();
                        templateModifyInfo.setTemplateID(tempID);
                        templateModifyInfo.setNewValue(_newValue);
                        templateModifyInfo.setOldValue(match);
                        templateModifyInfo.setUpdateTime(myDateTime);
                        templateModifyInfo.setTempFilePath(teplateFilePath);
                        templateModifyInfo.setLoginUser(loginUser.getName());
                        templateModifyInfo.setStatus(1);
                        templateModifyInfo.save();
                    }
                    matcher.appendReplacement(newTempText, _newValue);
                }
            }
            matcher.appendTail(newTempText);
            template.setText(newTempText.toString());
            template.save();
        }
        return errorInfo.toString();
    }

    @Override
    public TemplateModifyInfos queryTemplateModifyInfos(WCMFilter _extrafilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "", "updatetime desc", "");
        return TemplateModifyInfos.openWCMObjs(null, filter.mergeWith(_extrafilter));
    }

    @Override
    public String rollBackModifiedTemplate(TemplateModifyInfo _modifyInfo) throws WCMException {
        Template template = null;
        String sReport = null;
        try {
            template = Template.findById(_modifyInfo.getTemplateID());
            int nImportMode = 1;
            int nPicMode = 1;
            IPublishFolder publishFolder = template.getFolder();
            String sSrcFilePath = _modifyInfo.getTempFilePath();
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sTempFilePath = aFilesMan.getNextFilePathName("ST", "zip");
            String tempFile = CMyFile.extractFileName(sSrcFilePath);
            sTempFilePath = CMyFile.extractFilePath(sTempFilePath) + tempFile;
            CMyFile.copyFile(sSrcFilePath, sTempFilePath, true);
            if (CMyString.isEmpty(sTempFilePath)) {
                throw new WCMException("\u9700\u8981\u8fd8\u539f\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            TemplateImporter importer = new TemplateImporter();
            sReport = importer.importFromZip(publishFolder, sTempFilePath, nImportMode, nPicMode, null, null).toJSONXML();
            _modifyInfo.setStatus(0);
            _modifyInfo.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sReport;
    }

    private String exportTemplate(Template _template, CMyDateTime _myDateTime) {
        logger.debug((Object)"\u6a21\u677f\u5bfc\u51fa\u4e86");
        String fileDirName = "1990-1";
        String subFileDirName = "1990-1-1";
        String sSrcPath = "";
        String targetPath = "";
        try {
            fileDirName = _myDateTime.getDateTimeAsString("yyyyMM");
            subFileDirName = _myDateTime.getDateTimeAsString("yyyyMMdd");
            Templates tempates = Templates.createNewInstance(null);
            tempates.addElement(_template);
            TemplateExporter exporter = new TemplateExporter();
            String tempFile = exporter.export(tempates);
            FilesMan aFilesMan = FilesMan.getFilesMan();
            sSrcPath = aFilesMan.getNextFilePathName("ST", "zip");
            sSrcPath = CMyFile.extractFilePath(sSrcPath) + tempFile;
            sSrcPath = sSrcPath.replace('\\', File.separatorChar);
            String sProtectPathStr = ConfigServer.getServer().getInitProperty("P0");
            String sProtectPath = sProtectPathStr.substring(0, sProtectPathStr.indexOf(";"));
            targetPath = sProtectPath + "\\p0" + fileDirName + "\\p0" + subFileDirName + "\\" + tempFile;
            targetPath = targetPath.replace('\\', File.separatorChar);
            CMyFile.copyFile(sSrcPath, targetPath, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetPath;
    }

    private Templates queryTemplates(WCMFilter _extraFilter) {
        Templates templates = null;
        try {
            templates = Templates.openWCMObjs(null, _extraFilter);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        return templates;
    }

    private HashMap<Integer, Integer> queryRowFlagMap(Template template) {
        String tempText = template.getText();
        Matcher matcher = Pattern.compile("\n").matcher(tempText);
        int nRowNo = 0;
        int lastend = 0;
        HashMap<Integer, Integer> mapPos = new HashMap<Integer, Integer>();
        while (matcher.find()) {
            int endPos = matcher.end();
            mapPos.put(endPos, ++nRowNo);
            lastend = endPos;
        }
        if (lastend < tempText.length()) {
            mapPos.put(tempText.length(), ++nRowNo);
        }
        return mapPos;
    }

    private String getRowNO(HashMap<Integer, Integer> _mapPos, int _pos) {
        String sRowNo = "";
        Object[] keyArr = _mapPos.keySet().toArray();
        Arrays.sort(keyArr);
        int pos = _pos;
        int keyArrLenght = keyArr.length;
        for (int i = 0; i < keyArrLenght; ++i) {
            int key = Integer.parseInt(keyArr[i].toString());
            if (i == 0 && pos <= key) {
                sRowNo = "[" + _mapPos.get(keyArr[0]) + "\u884c ," + pos + "\u5217]";
                break;
            }
            int nextKey = Integer.parseInt(keyArr[i + 1].toString());
            if (key >= pos || pos > nextKey) continue;
            sRowNo = "[ " + _mapPos.get(nextKey) + "\u884c ," + (pos - key) + "\u5217 ]";
            break;
        }
        return sRowNo;
    }
}

