/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.store.FileService;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class TemplateServiceConfig {
    private static int m_InitStatus = 0;
    private static Properties m_TemplateServiceConfigProperties = new Properties();
    private static String m_ConfigFileName = "templateservice-config.properties";

    public static Properties getConfigs() throws Exception {
        if (m_InitStatus == 0) {
            TemplateServiceConfig.init();
        }
        if (m_InitStatus == 1) {
            throw new Exception("TemplateServiceConfig is initing,Please wait......");
        }
        return m_TemplateServiceConfigProperties;
    }

    public static String getConfigValue(String strConfigKey) throws Exception {
        String strConfigValue = "";
        Properties propsTemplateServiceConfig = TemplateServiceConfig.getConfigs();
        if (!propsTemplateServiceConfig.containsKey(strConfigKey)) {
            throw new Exception(I18NMessage.get(TemplateServiceConfig.class, "TemplateServiceConfig.label1", "\u914d\u7f6e\u4fe1\u606f\u4e2d\u6ca1\u6709\u914d\u7f6e'") + strConfigKey + I18NMessage.get(TemplateServiceConfig.class, "TemplateServiceConfig.label2", "'\u4e3b\u952e"));
        }
        strConfigValue = propsTemplateServiceConfig.getProperty(strConfigKey);
        if (strConfigValue == null) {
            strConfigValue = "";
        }
        strConfigValue = strConfigValue.trim();
        return strConfigValue;
    }

    public static void setInitStatus(int iInitStatus) {
        m_InitStatus = iInitStatus;
    }

    private static void init() throws Exception {
        Exception _ex = null;
        try {
            m_InitStatus = 1;
            TemplateServiceConfig.initProcess();
            m_InitStatus = 2;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            _ex = ex;
            throw ex;
        }
        finally {
            if (_ex != null) {
                m_InitStatus = 0;
            }
        }
    }

    private static void initProcess() throws Exception {
        try {
            Properties propsTemplateConfig = new Properties();
            String strFilePath = TemplateServiceConfig.getConfigFile();
            InputStream fins = new FileService(strFilePath).getInputStream();
            propsTemplateConfig.load(fins);
            fins.close();
            fins = null;
            m_TemplateServiceConfigProperties = propsTemplateConfig;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw ex;
        }
    }

    public static void main(String[] args) {
        try {
            Properties properties = TemplateServiceConfig.getConfigs();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String strKey = (String)enumeration.nextElement();
                String strValue = TemplateServiceConfig.getConfigValue(strKey);
                System.out.println(strKey + "=" + strValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void reWriteConfigFile() throws Exception {
    }

    private static String getConfigFile() {
        URL configUrl = TemplateServiceConfig.class.getClassLoader().getResource("com/trs/template/service/" + m_ConfigFileName);
        String strFilePath = configUrl.getFile();
        return strFilePath;
    }
}

