/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template;

import com.trs.template.TemplateRemoteException;
import com.trs.template.TemplateServiceConfig;
import com.trs.template.TemplateServiceFactory;
import com.trs.template.service.ITemplateService;
import org.apache.log4j.Logger;

public class TRSTemplateFacade {
    Logger logger = Logger.getLogger(TRSTemplateFacade.class);
    private ITemplateService m_TemplateService = null;

    public String login(String username, String password, String encrypttype, String remoteip) throws TemplateRemoteException {
        this.logger.info((Object)("start login, username:" + username + ", remoteip:" + remoteip));
        this.getTemplateService();
        String strSessionID = this.m_TemplateService.login(username, password, encrypttype, remoteip);
        this.logger.info((Object)("end login, username:" + username + ", remoteip:" + remoteip + ", sessionid:" + strSessionID));
        return strSessionID;
    }

    public boolean logout(String sessionid) throws TemplateRemoteException {
        this.getTemplateService();
        return this.m_TemplateService.logout(sessionid);
    }

    public boolean checkin(String sessionid, String appname, String primarykey, byte[] templatezipcontent) throws TemplateRemoteException {
        boolean bReturn = false;
        try {
            this.getTemplateService();
            bReturn = this.m_TemplateService.checkin(sessionid, appname, primarykey, templatezipcontent);
        }
        catch (TemplateRemoteException ex) {
            ex.printStackTrace(System.out);
            throw ex;
        }
        return bReturn;
    }

    public boolean confirm(String sessionid, String appname, String primarykey) throws TemplateRemoteException {
        this.getTemplateService();
        return this.m_TemplateService.confirm(sessionid, appname, primarykey);
    }

    public byte[] checkout(String sessionid, String appname, String primarykey) throws TemplateRemoteException {
        this.getTemplateService();
        return this.m_TemplateService.checkout(sessionid, appname, primarykey);
    }

    public String preview(String sessionid, String appname, String primarykey, byte[] templatezipcontent, String query) throws TemplateRemoteException {
        this.getTemplateService();
        return this.m_TemplateService.preview(sessionid, appname, primarykey, templatezipcontent, query);
    }

    public byte[] getAllSettings(String sessionid) throws TemplateRemoteException {
        this.getTemplateService();
        return this.m_TemplateService.getAllSettings(sessionid);
    }

    public String[] getAllSite(String sessionid) throws TemplateRemoteException {
        this.getTemplateService();
        return this.m_TemplateService.getAllSites(sessionid);
    }

    public byte[] getSettingByType(String sessionid, String settingtype) throws TemplateRemoteException {
        this.getTemplateService();
        return this.m_TemplateService.getSettingByType(sessionid, settingtype);
    }

    public String[] getSettingTypeList(String sessionid) throws TemplateRemoteException {
        this.getTemplateService();
        return this.m_TemplateService.getSettingTypeList(sessionid);
    }

    private void getTemplateService() throws TemplateRemoteException {
        if (this.m_TemplateService == null) {
            try {
                String strITemplateServiceImpl = TemplateServiceConfig.getConfigValue("ITemplateService");
                this.m_TemplateService = TemplateServiceFactory.createTemplateService(strITemplateServiceImpl);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                TemplateRemoteException remoteException = new TemplateRemoteException(ex);
                throw remoteException;
            }
        }
    }

    public static void main(String[] args) {
    }
}

