/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import com.trs.presentation.util.LoginHelper;
import com.trs.servlet.FilterContentCollector;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginCheckFilter
implements Filter {
    private String[] aJspLoginExclude;
    private String[] aJspWithPathLoginExclude;
    private String[] aExcludeDirsLoginExclude;
    private String sRedictPageValue = null;
    private String sRedictPage = "redictPage";
    private static final String ISLOGGED = "isLogged";
    FilterContentCollector oFilterContentCollector;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ContextHelper.clear();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ServletContext application = httpRequest.getSession().getServletContext();
        String sUri = httpRequest.getRequestURI();
        int nIdx = sUri.lastIndexOf("/");
        String sFileName = sUri.substring(nIdx + 1);
        String sContextPath = CMyString.showNull(httpRequest.getContextPath(), "/wcm");
        sContextPath = CMyString.setStrEndWith(sContextPath, '/');
        String sFileNameWithPath = sUri.substring(sContextPath.length());
        this.addNoCacheHeader(httpResponse);
        this.aExcludeDirsLoginExclude = this.oFilterContentCollector.getPathExclude();
        this.aJspLoginExclude = this.oFilterContentCollector.getJspExclude();
        this.aJspWithPathLoginExclude = this.oFilterContentCollector.getPathJspExclude();
        if (this.isExcludeDirs(this.aExcludeDirsLoginExclude, sFileNameWithPath)) {
            ContextHelper.setLoginUser(User.getSystem());
            chain.doFilter(request, response);
            return;
        }
        if (!this.bArrIncludeStr(this.aJspLoginExclude, sFileName) && !this.bArrIncludeStr(this.aJspWithPathLoginExclude, sFileNameWithPath)) {
            LoginHelper currLoginHelper = new LoginHelper(httpRequest, application);
            if (!currLoginHelper.checkLogin()) {
                httpResponse.setHeader("TRSNoLogin", "1");
                httpResponse.sendRedirect(this.sRedictPageValue);
                return;
            }
            User loginUser = currLoginHelper.getLoginUser();
            if (loginUser != null) {
                ContextHelper.initContext(loginUser);
                boolean isLogged = String.valueOf(httpRequest.getSession().getAttribute(ISLOGGED)).equalsIgnoreCase(Boolean.TRUE.toString());
                if (!isLogged) {
                    this.addSecurityLog(httpRequest);
                }
                if ("system".equals(loginUser.getName())) {
                    httpResponse.setStatus(401);
                    return;
                }
                loginUser.setExtProperty("LOGINIP", RemoteAddrUtil.getRemoteAddr(httpRequest));
            }
            chain.doFilter(request, response);
            return;
        }
        ContextHelper.setLoginUser(User.getSystem());
        chain.doFilter(request, response);
    }

    private synchronized void addSecurityLog(HttpServletRequest httpRequest) {
        boolean isLogged = String.valueOf(httpRequest.getSession().getAttribute(ISLOGGED)).equalsIgnoreCase(Boolean.TRUE.toString());
        if (isLogged) {
            return;
        }
        SimpleLogServer.security(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "\u6210\u529f", RemoteAddrUtil.getRemoteAddr(httpRequest));
        httpRequest.getSession().setAttribute(ISLOGGED, (Object)true);
    }

    private void addNoCacheHeader(HttpServletResponse resp) {
        resp.addHeader("Cache-Control", "no-cache");
        resp.addHeader("Pragma", "no-cache");
        resp.addHeader("Expires", "-1");
        resp.addHeader("max-age", "0");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.oFilterContentCollector = new FilterContentCollector();
        this.oFilterContentCollector.loadFilterContent();
        this.sRedictPageValue = filterConfig.getInitParameter(this.sRedictPage);
    }

    private boolean bArrIncludeStr(String[] aValue, String sFileName) {
        if (aValue == null || aValue.length == 0 || CMyString.isEmpty(sFileName)) {
            return false;
        }
        for (int i = 0; i < aValue.length; ++i) {
            if (!sFileName.equals(aValue[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludeDirs(String[] aValue, String sFileNameWithPath) {
        if (aValue == null || aValue.length <= 0) {
            return false;
        }
        if (CMyString.isEmpty(sFileNameWithPath)) {
            return true;
        }
        for (int i = 0; i < aValue.length; ++i) {
            if (!sFileNameWithPath.startsWith(aValue[i])) continue;
            return true;
        }
        return false;
    }
}

