/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JspDenyFilter
implements Filter {
    private String[] aValue;
    private String[] aValueWithPath;
    private String[] aExcludeDirs;
    private String sFilterParameter = "notFilterJsp";
    private String sFilterparameterWithPath = "notFilterJspWithPath";
    private String sFilterparameterWithDir = "notFilterPath";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String sUri = httpRequest.getRequestURI();
        if (!sUri.endsWith(".jsp") && !sUri.endsWith(".jspf")) {
            chain.doFilter(request, response);
            return;
        }
        int nIdx = sUri.lastIndexOf("/");
        String sFileName = sUri.substring(nIdx + 1);
        String sContextPath = httpRequest.getContextPath();
        if (this.isEmpty(sContextPath)) {
            sContextPath = "/pub";
        }
        sContextPath = this.setStrEndWith(sContextPath, '/');
        String sFileNameWithPath = sUri;
        if (sUri.indexOf(sContextPath) > 0) {
            sFileNameWithPath = sUri.substring(sContextPath.length());
        }
        if (this.isExcludeDirs(this.aExcludeDirs, sFileNameWithPath)) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.bArrIncludeStr(this.aValue, sFileName) && !this.bArrIncludeStr(this.aValueWithPath, sFileNameWithPath)) {
            httpResponse.setStatus(403);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String sNotFilterJspValue = filterConfig.getInitParameter(this.sFilterParameter);
        String sNotFilterWithPathValue = filterConfig.getInitParameter(this.sFilterparameterWithPath);
        this.aValueWithPath = this.isEmpty(sNotFilterWithPathValue) ? null : sNotFilterWithPathValue.split(",");
        this.aValue = this.isEmpty(sNotFilterJspValue) ? null : sNotFilterJspValue.split(",");
        String sExcludeDirs = filterConfig.getInitParameter(this.sFilterparameterWithDir);
        this.aExcludeDirs = this.isEmpty(sExcludeDirs) ? null : sExcludeDirs.split(",");
    }

    private boolean bArrIncludeStr(String[] aValue, String sFileName) {
        if (aValue == null || this.isEmpty(sFileName)) {
            return false;
        }
        for (int i = 0; i < aValue.length; ++i) {
            if (!sFileName.equals(aValue[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludeDirs(String[] aValue, String sFileNameWithPath) {
        if (aValue == null || aValue.length <= 0) {
            return false;
        }
        if (this.isEmpty(sFileNameWithPath)) {
            return true;
        }
        for (int i = 0; i < aValue.length; ++i) {
            if (!sFileNameWithPath.startsWith(aValue[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    private String setStrEndWith(String _str, char _charEnd) {
        if (this.isEmpty(_str) || _str.endsWith(String.valueOf(_charEnd))) {
            return _str;
        }
        return _str + _charEnd;
    }
}

