/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowServer;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.ProcessConstants;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.definition.FlowMgr;
import com.trs.cms.process.definition.Flows;
import com.trs.cms.process.engine.FlowContentHelper;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.FlowParamers;
import com.trs.cms.process.xml.FlowImporter;
import com.trs.cms.process.xml.FlowXmlConverter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.Reports;
import com.trs.service.IWCMProcessService;
import java.io.File;
import org.apache.log4j.Logger;

public class WCMProcessServiceImpl
implements IWCMProcessService {
    private static Logger s_logger = Logger.getLogger(WCMProcessServiceImpl.class);
    private FlowServer m_oFlowServer = null;

    public WCMProcessServiceImpl() {
        try {
            this.m_oFlowServer = FlowServer.getFlowServer();
        }
        catch (WCMException ignore) {
            s_logger.error((Object)I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label1", "\u83b7\u53d6FlowServer\u5931\u8d25"), (Throwable)ignore);
        }
    }

    @Override
    public Flows getFlows(WCMFilter _filter) throws WCMException {
        return Flows.openWCMObjs(this.getLoginUser(), _filter);
    }

    @Override
    public void deleteFlows(String _sFlowIds) throws WCMException {
        if (!this.getLoginUser().isAdministrator()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label2", "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u5220\u9664\u5de5\u4f5c\u6d41\uff01"));
        }
        Flows aFlows = Flows.findByIds(this.getLoginUser(), _sFlowIds);
        Flow deleteFlow = null;
        for (int i = 0; i < aFlows.size(); ++i) {
            deleteFlow = (Flow)aFlows.getAt(i);
            if (deleteFlow == null) continue;
            this.getFlowMgr().delete(deleteFlow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reports saveFlow(String _sFlowXML) throws WCMException {
        User loginUser = this.getLoginUser();
        if (!this.getLoginUser().isAdministrator()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label3", "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4fee\u6539\u5de5\u4f5c\u6d41\uff01"));
        }
        File fileXMLTemp = null;
        String sXmlFile = null;
        try {
            try {
                fileXMLTemp = File.createTempFile("wcm", ".xml");
                sXmlFile = fileXMLTemp.getPath();
                CMyFile.writeFile(sXmlFile, _sFlowXML, "utf-8");
            }
            catch (Exception ex) {
                s_logger.error((Object)"fail to create the temp xml file", (Throwable)ex);
                throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label4", "\u4ea7\u751f\u6587\u4ef6\u5931\u8d25!") + ex.getMessage());
            }
            FlowImporter aImporter = new FlowImporter(loginUser, 3);
            Reports reports = aImporter.importFromFile(sXmlFile, null);
            if (!reports.getFailedReporter().isEmpty()) {
                throw new WCMException(reports.getFailedReporterAt(0).getRportDetail());
            }
            Reports reports2 = reports;
            return reports2;
        }
        finally {
            if (fileXMLTemp != null) {
                fileXMLTemp.delete();
                fileXMLTemp = null;
            }
        }
    }

    @Override
    public Reports importFlows(String _sImportFile) throws WCMException {
        return this.importFlows(_sImportFile, null);
    }

    @Override
    public Reports importFlows(String _sImportFile, String _sXslFile) throws WCMException {
        FlowImporter importer = new FlowImporter(1);
        return importer.importFromFile(_sImportFile, _sXslFile);
    }

    @Override
    public String exportFlow(int _nFlowId) throws WCMException {
        return this.exportFlows(String.valueOf(_nFlowId));
    }

    @Override
    public String exportFlows(String _sFlowIds) throws WCMException {
        Flows flows = Flows.findByIds(this.getLoginUser(), _sFlowIds);
        FlowXmlConverter converter = new FlowXmlConverter();
        String sXmlFile = FilesMan.getFilesMan().getNextFileName("ST", ".xml", null, true);
        converter.toXMLFile(flows, sXmlFile);
        return CMyFile.extractFileName(sXmlFile);
    }

    @Override
    public FlowDocs getFlowDocs(int _nFlag, WCMFilter _filter) throws WCMException {
        return FlowServer.getFlowServer().getFlowDocs(this.getLoginUser(), _nFlag, _filter);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void submitTo(FlowParamers _currParamerts) throws WCMException {
        this.m_oFlowServer.submitTo(_currParamerts);
    }

    @Override
    public void submitBack(User _postUser, String _sFromFlowDocId, String _sOpinion) throws WCMException {
        FlowDocs aFlowDocs = FlowDocs.findByIds(_postUser, _sFromFlowDocId);
        int nCount = aFlowDocs.size();
        FlowDoc aFlowDoc = null;
        for (int i = 0; i < nCount; ++i) {
            aFlowDoc = (FlowDoc)aFlowDocs.getAt(i);
            if (aFlowDoc == null) continue;
            this.m_oFlowServer.submitBack(_postUser, aFlowDoc.getFlowContent(), _sOpinion);
        }
        aFlowDocs.clear();
    }

    @Override
    public String toFlowXMLString(Flow _currFlow) throws WCMException {
        if (_currFlow == null) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label5", "\u6ca1\u6709\u6307\u5b9a\u5de5\u4f5c\u6d41"));
        }
        if (!this.getLoginUser().isAdministrator()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label3", "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4fee\u6539\u5de5\u4f5c\u6d41\uff01"));
        }
        FlowXmlConverter aConvert = new FlowXmlConverter();
        return aConvert.toXMLString(_currFlow);
    }

    @Override
    public String toFlowsXMLString(String _sFlowIds) throws WCMException {
        if (!this.getLoginUser().isAdministrator()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label3", "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4fee\u6539\u5de5\u4f5c\u6d41\uff01"));
        }
        FlowXmlConverter aConvert = new FlowXmlConverter();
        return aConvert.toXMLString(Flows.findByIds(this.getLoginUser(), _sFlowIds));
    }

    @Override
    public void setFlowEmploy(BaseObj _employer, int _nFlowId) throws WCMException {
        this.getFlowEmployMgr().setFlow(_employer, _nFlowId);
    }

    @Override
    public Flow getFlowOfEmployer(BaseObj _employer) throws WCMException {
        return this.getFlowEmployMgr().getFlow(_employer);
    }

    @Override
    public FlowDoc startContentInFlow(int _nContentType, int _nContentId) throws WCMException {
        IFlowContent currContent = FlowContentHelper.createFlowContent(_nContentType, _nContentId);
        if (currContent == null) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label6", "\u4f7f\u6307\u5b9a\u7684\u5185\u5bb9\u5f00\u59cb\u6d41\u8f6c\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u5185\u5bb9\u5bf9\u8c61\uff01ContentTypeConfig:") + _nContentType + " ContentId:" + _nContentId);
        }
        CMSObj oSubinstance = currContent.getSubinstance();
        String sDesc = I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label7", "\u4f7f\u6307\u5b9a\u7684\u5185\u5bb9[") + oSubinstance + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label8", "]\u5f00\u59cb\u6d41\u8f6c");
        int nRightIndex = 32;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), oSubinstance, nRightIndex)) {
            throw new WCMException(sDesc + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label9", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "FLOW_START", sDesc, oSubinstance);
        try {
            FlowDoc newFlowDoc = this.m_oFlowServer.startContentInFlow(this.getLoginUser(), currContent);
            LogServer.endRecordSucceedOperation(lStartTime);
            return newFlowDoc;
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(sDesc + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label10", "\u5931\u8d25!"), e);
        }
    }

    @Override
    public void forceContentEndInFlow(int _nContentType, int _nContentId) throws WCMException {
        IFlowContent currContent = FlowContentHelper.createFlowContent(_nContentType, _nContentId);
        if (currContent == null) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label6", "\u4f7f\u6307\u5b9a\u7684\u5185\u5bb9\u5f00\u59cb\u6d41\u8f6c\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u5185\u5bb9\u5bf9\u8c61\uff01ContentTypeConfig:") + _nContentType + " ContentId:" + _nContentId);
        }
        CMSObj oSubinstance = currContent.getSubinstance();
        String sDesc = I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label7", "\u4f7f\u6307\u5b9a\u7684\u5185\u5bb9[") + oSubinstance + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label11", "]\u5f3a\u5236\u7ed3\u675f\u6d41\u8f6c");
        int nRightIndex = 32;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), oSubinstance, nRightIndex)) {
            throw new WCMException(sDesc + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label9", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "FLOW_FORCE_END", sDesc, oSubinstance);
        try {
            this.m_oFlowServer.forceDocToEnd(currContent, this.getLoginUser());
            LogServer.endRecordSucceedOperation(lStartTime);
        }
        catch (Exception e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(sDesc + I18NMessage.get(WCMProcessServiceImpl.class, "WCMProcessServiceImpl.label10", "\u5931\u8d25!"), e);
        }
    }

    private FlowMgr getFlowMgr() {
        return (FlowMgr)DreamFactory.createObjectById("FlowMgr");
    }

    private FlowEmployMgr getFlowEmployMgr() {
        return (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
    }

    @Override
    public FlowDoc getCurrentFlowDoc(int _nContentType, int _nContentId) {
        return this.m_oFlowServer.getFlowDoc(_nContentType, _nContentId);
    }

    @Override
    public String getCurrFlowFlagDesc(int _nContentType, int _nContentId) throws WCMException {
        return ProcessConstants.getFlagDesc(this.getCurrFlowFlag(_nContentType, _nContentId));
    }

    @Override
    public int getCurrFlowFlag(int _nContentType, int _nContentId) throws WCMException {
        return this.m_oFlowServer.getCurrFlowFlag(_nContentType, _nContentId);
    }

    @Override
    public FlowDocs getFlowDocsOfContent(int _nContentType, int _nContentId) throws WCMException {
        return this.m_oFlowServer.getFlowDocsOfContent(_nContentType, _nContentId);
    }

    @Override
    public void submitAgain(User _postUser, int _nFlowDocId, String _sOpinion) throws WCMException {
        this.m_oFlowServer.submitAgain(_postUser, _nFlowDocId, _sOpinion);
    }

    @Override
    public FlowDocs getSubmitFlowDocs(User _operator, WCMFilter _filter) throws WCMException {
        return this.m_oFlowServer.getSubmitFlowDocs(_operator, _filter);
    }

    @Override
    public boolean isCanInFlow(int _nContentType, int _nContentId) throws WCMException {
        IFlowContent currContent = FlowContentHelper.createFlowContent(_nContentType, _nContentId);
        if (currContent == null) {
            return false;
        }
        int nRightIndex = 32;
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), currContent.getSubinstance(), nRightIndex)) {
            return false;
        }
        return this.m_oFlowServer.isCanInFlow(currContent);
    }
}

