/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.wcm.content.domain.UserDocumentMgr;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import com.trs.service.IGroupService;
import com.trs.service.IUserService;
import org.apache.log4j.Logger;

public class UserService
implements IUserService {
    private static final Logger m_oLogger = Logger.getLogger((String)UserService.class.getName());

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public Documents getDocuments() throws WCMException {
        return this.getDocuments(null);
    }

    @Override
    public Documents getDocuments(WCMFilter _filter) throws WCMException {
        return this.getUserDocumentMgr().getDocuments(_filter);
    }

    @Override
    public Documents getDraft() throws WCMException {
        return this.getDraft(null);
    }

    @Override
    public Documents getDraft(WCMFilter _filter) throws WCMException {
        return this.getUserDocumentMgr().getDraft(_filter);
    }

    @Override
    public Documents getRecycleDocuments() throws WCMException {
        return this.getRecycleDocuments(null);
    }

    @Override
    public Documents getRecycleDocuments(WCMFilter _filter) throws WCMException {
        return this.getUserDocumentMgr().getRecycleDocuments(_filter);
    }

    @Override
    public Groups getGroups(User _currUser) throws WCMException {
        return this.getUserMgr().getGroups(_currUser);
    }

    @Override
    public Groups getGroups() throws WCMException {
        return this.getUserMgr().getGroups(this.getLoginUser());
    }

    @Override
    public Roles getRoles(User _currUser) throws WCMException {
        return this.getUserMgr().getRoles(_currUser);
    }

    @Override
    public Roles getRoles() throws WCMException {
        return this.getUserMgr().getRoles(this.getLoginUser());
    }

    @Override
    public User save(User _userToSave) throws WCMException {
        boolean bIsManagerOfUser;
        User currUser = _userToSave;
        User loginUser = this.getLoginUser();
        boolean bUserSelf = loginUser.getName().equals(_userToSave.getName());
        boolean bIsAdmin = loginUser.isSecurityAdmin();
        if (!(bIsAdmin || bUserSelf || (bIsManagerOfUser = this.getUserMgr().isManagerOfUser(currUser)))) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label1", "\u60a8\u65e0\u6743\u4fdd\u5b58\u7528\u6237\uff01\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u7528\u6237\u81ea\u8eab\u6216\u7528\u6237\u521b\u5efa\u8005\u624d\u53ef\u4ee5\u66f4\u6539\u4fdd\u5b58\u7528\u6237\u4fe1\u606f."));
        }
        String sDesc = I18NMessage.get(UserService.class, "UserService.label2", "\u4fdd\u5b58") + this.wrapObj(currUser);
        String sOperType = currUser.isAddMode() ? "USER_ADD" : "USER_EDIT";
        long lStartId = LogServer.startRecord(loginUser.getName(), sOperType, sDesc, currUser);
        try {
            currUser = this.getUserMgr().save(currUser);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartId, e);
            throw e;
        }
        LogServer.endRecordSucceedOperation(lStartId);
        return currUser;
    }

    @Override
    public User save(User _userToSave, Group _currGrp) throws WCMException {
        IGroupService currGroupService = (IGroupService)DreamFactory.createObjectById("IGroupService");
        if (_currGrp == null) {
            return this.save(_userToSave);
        }
        User currUser = _userToSave;
        User loginUser = this.getLoginUser();
        if (!AuthServer.hasRight(loginUser, _currGrp)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label3", "\u60a8\u65e0\u6743\u4fdd\u5b58\u7528\u6237\uff01"));
        }
        String sDesc = CMyString.format(I18NMessage.get(UserService.class, "UserService.label42", "\u5728{0}\u4e2d\u65b0\u5efa{1}"), new Object[]{_currGrp, _userToSave});
        long lStartId = LogServer.startRecord(loginUser.getName(), "GROUPUSER_ADD", sDesc, _userToSave);
        try {
            currUser = this.getUserMgr().save(currUser);
            currGroupService.addUser(currUser, _currGrp);
        }
        catch (Exception ex) {
            LogServer.endRecordFailedOperation(lStartId, ex);
            throw new WCMException(1104, I18NMessage.get(UserService.class, "UserService.label6", "\u6dfb\u52a0\u5230\u7ec4\u5931\u8d25\u4e2d\u6b62\uff01"), ex);
        }
        LogServer.endRecordSucceedOperation(lStartId);
        return currUser;
    }

    private UserMgr getUserMgr() throws WCMException {
        UserMgr aMgr = (UserMgr)DreamFactory.createObjectById("UserMgr");
        if (aMgr == null) {
            throw new WCMException(I18NMessage.get(UserService.class, "UserService.label7", "UserMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u9519\u8bef\uff01"));
        }
        return aMgr;
    }

    private GroupMgr getGroupMgr() throws WCMException {
        GroupMgr aMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        if (aMgr == null) {
            throw new WCMException(I18NMessage.get(UserService.class, "UserService.label7", "UserMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u9519\u8bef\uff01"));
        }
        return aMgr;
    }

    private UserDocumentMgr getUserDocumentMgr() throws WCMException {
        UserDocumentMgr aMgr = (UserDocumentMgr)DreamFactory.createObjectById("UserDocumentMgr");
        if (aMgr == null) {
            throw new WCMException(I18NMessage.get(UserService.class, "UserService.label8", "UserDocumentMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u9519\u8bef\uff01"));
        }
        return aMgr;
    }

    @Override
    public boolean enable(User _userToEnable) throws WCMException {
        boolean bUserCrUser;
        User oCrUser = _userToEnable.getCrUser();
        boolean bl = bUserCrUser = oCrUser != null ? this.getLoginUser().getName().equals(oCrUser.getName()) : false;
        if (!this.getLoginUser().isSecurityAdmin() && !bUserCrUser) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label9", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5f00\u901a\u7528\u6237!"));
        }
        boolean bSuccessed = false;
        String sDesc = CMyString.format(I18NMessage.get(UserService.class, "UserService.label43", "\u5f00\u901a{0}\u7684\u5e10\u53f7."), new Object[]{_userToEnable});
        long lStartId = LogServer.startRecord(this.getLoginUser().getName(), "USER_ENABLE", sDesc, _userToEnable);
        try {
            bSuccessed = this.changeUserRegStatus(_userToEnable, 30);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartId, e);
            throw e;
        }
        LogServer.endRecordSucceedOperation(lStartId);
        if (bSuccessed) {
            final User currUser = _userToEnable;
            final User opUser = this.getLoginUser();
            Thread t = new Thread(){

                @Override
                public void run() {
                    ContextHelper.initContext(opUser);
                    String sEmail = currUser.getEmail();
                    if (sEmail != null && sEmail.length() > 0) {
                        UserService.this.sendEmailNotice(currUser);
                    }
                }
            };
            t.start();
        }
        return bSuccessed;
    }

    void sendEmailNotice(User _userToEnable) {
        try {
            Message message = this.createNotice(_userToEnable);
            MessageServer.send(message);
        }
        catch (WCMException e) {
            m_oLogger.error((Object)"failed to send email to notice the user!", (Throwable)e);
        }
    }

    private Message createNotice(User _user) throws WCMException {
        Message message = new Message();
        message.setTitle(I18NMessage.get(UserService.class, "UserService.label12", "\u5e10\u53f7\u5f00\u901a"));
        StringBuffer msgbody = new StringBuffer(I18NMessage.get(UserService.class, "UserService.label44", " "));
        msgbody.append(" " + _user.getName());
        msgbody.append(I18NMessage.get(UserService.class, "UserService.label13", ",\u60a8\u597d!\n\n\t\t\u60a8\u7533\u8bf7\u7684\u7528\u6237\u5e10\u53f7\u5df2\u7ecf\u5f00\u901a,"));
        String url = "";
        try {
            url = ConfigServer.getServer().getSysConfigValue("WCM_URL", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!"".equals(url)) {
            msgbody.append(I18NMessage.get(UserService.class, "UserService.label14", "\n\u53ef\u4ee5\u901a\u8fc7")).append("<a href=" + url + ">" + url + "</a>").append(I18NMessage.get(UserService.class, "UserService.label15", "\u8bbf\u95ee\u7cfb\u7edf.\n"));
        } else {
            msgbody.append(I18NMessage.get(UserService.class, "UserService.label45", "\u53ef\u4ee5\u767b\u5f55/\u4f7f\u7528\u7cfb\u7edf\u4e86.\n"));
        }
        msgbody.append(I18NMessage.get(UserService.class, "UserService.label16", "\n\u795d\u60a8\u5de5\u4f5c\u6109\u5feb."));
        message.setBody(msgbody.toString());
        message.setSendTypes("Email");
        message.setReceivers(_user.getWCMType(), String.valueOf(_user.getId()));
        return message;
    }

    @Override
    public boolean disable(User _userToDisable) throws WCMException {
        boolean bUserCrUser;
        User oCrUser = _userToDisable.getCrUser();
        boolean bl = bUserCrUser = oCrUser != null ? this.getLoginUser().getName().equals(oCrUser.getName()) : false;
        if (!this.getLoginUser().isSecurityAdmin() && !bUserCrUser) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label17", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u505c\u7528\u7528\u6237!"));
        }
        String sLogDesc = I18NMessage.get(UserService.class, "UserService.label18", "\u505c\u7528:") + this.wrapObj(_userToDisable);
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "USER_DISABLE", sLogDesc, _userToDisable);
        try {
            this.changeUserRegStatus(_userToDisable, 20);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label19", "\u505c\u7528\u7528\u6237\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public boolean restore(User _userToRestore) throws WCMException {
        boolean bUserCrUser;
        User oCrUser = _userToRestore.getCrUser();
        boolean bl = bUserCrUser = oCrUser != null ? this.getLoginUser().getName().equals(oCrUser.getName()) : false;
        if (!this.getLoginUser().isSecurityAdmin() && !bUserCrUser) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label20", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u6062\u590d\u5df2\u505c\u7528\u7684\u7528\u6237!"));
        }
        String sLogDesc = I18NMessage.get(UserService.class, "UserService.label21", "\u6062\u590d\u5df2\u5220\u9664\u7684") + this.wrapObj(_userToRestore);
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "USER_RESTORE", sLogDesc, _userToRestore);
        try {
            _userToRestore.canEdit(this.getLoginUser());
            _userToRestore.setDeleted(false);
            this.save(_userToRestore);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label22", "\u6062\u590d\u5220\u9664\u7684\u7528\u6237\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public boolean restore(Users _usersToRestore) throws WCMException {
        if (_usersToRestore == null || _usersToRestore.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(UserService.class, "UserService.label23", "\u65e0\u6548\u7684\u7528\u6237\u96c6\u5408!"));
        }
        User currUser = null;
        for (int i = 0; i < _usersToRestore.size(); ++i) {
            currUser = (User)_usersToRestore.getAt(i);
            if (currUser == null) continue;
            this.restore(currUser);
        }
        return true;
    }

    @Override
    public boolean resetPassword(User _dstUser, String _sOldPassword, String _sNewPassword) throws WCMException {
        if (!this.getLoginUser().equals(_dstUser)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label24", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u7528\u6237\u7684\u5bc6\u7801!"));
        }
        String sLogDesc = I18NMessage.get(UserService.class, "UserService.label25", "\u4fee\u6539\u5bc6\u7801");
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "USER_EDIT", sLogDesc, _dstUser);
        try {
            this.getUserMgr().resetPassword(_dstUser, _sOldPassword, _sNewPassword);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label26", "\u4fee\u6539\u5bc6\u7801\u5931\u8d25"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public boolean resetPassword(User _dstUser) throws WCMException {
        if (!this.getLoginUser().isSecurityAdmin()) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label24", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u7528\u6237\u7684\u5bc6\u7801!"));
        }
        String sLogDesc = I18NMessage.get(UserService.class, "UserService.label27", "\u91cd\u8bbe") + this.wrapObj(_dstUser) + I18NMessage.get(UserService.class, "UserService.label28", "\u7684\u5bc6\u7801");
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "USER_EDIT", sLogDesc, _dstUser);
        try {
            this.getUserMgr().resetPassword(_dstUser);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label29", "\u91cd\u8bbe\u5bc6\u7801\u5931\u8d25"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    public boolean resetPassword(User _dstUser, String _sNewPassword) throws WCMException {
        if ("true".equals(ConfigServer.getServer().getSysConfigValue("ENABLE_GADMIN_RESETPASSWORD", "false")) ? !this.getLoginUser().isSecurityAdmin() && !this.isAdminOfGroup(this.getLoginUser()) : !this.getLoginUser().isSecurityAdmin() && (!this.isAdminOfGroup(this.getLoginUser()) || !_dstUser.getCrUser().equals(this.getLoginUser()))) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label24", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u7528\u6237\u7684\u5bc6\u7801!"));
        }
        String sLogDesc = I18NMessage.get(UserService.class, "UserService.label27", "\u91cd\u8bbe") + this.wrapObj(_dstUser) + I18NMessage.get(UserService.class, "UserService.label28", "\u7684\u5bc6\u7801");
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "USER_EDIT", sLogDesc, _dstUser);
        try {
            this.getUserMgr().resetPassword(_dstUser, _sNewPassword);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label29", "\u91cd\u8bbe\u5bc6\u7801\u5931\u8d25"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    private String wrapObj(User user) {
        return "[" + user + "] ";
    }

    @Override
    public boolean delete(String _sUserIds, boolean _bDrop) throws WCMException {
        if (_sUserIds == null || _sUserIds.length() == 0) {
            return true;
        }
        Users aUsers = Users.findByIds(this.getLoginUser(), _sUserIds);
        if (aUsers.isEmpty()) {
            return true;
        }
        return this.delete(aUsers, _bDrop);
    }

    @Override
    public boolean delete(Users _usersToDelete, boolean _bDrop) throws WCMException {
        if (_usersToDelete == null) {
            throw new WCMException(20, I18NMessage.get(UserService.class, "UserService.label30", "\u7528\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Users delUsers = _usersToDelete;
        for (int i = 0; i < delUsers.size(); ++i) {
            User delUser = (User)delUsers.getAt(i);
            if (delUser != null) {
                this.delete(delUser, _bDrop);
                continue;
            }
            m_oLogger.error((Object)I18NMessage.get(UserService.class, "UserService.label31", "\u4ece\u7528\u6237\u96c6\u5408\u4e2d\u53d6\u7528\u6237\u65f6\uff0c\u7528\u6237\u4e3a\u7a7a\uff01"));
        }
        return true;
    }

    @Override
    public boolean delete(int _nUserId, boolean _bDrop) throws WCMException {
        if (_nUserId <= 0) {
            throw new WCMException(10, I18NMessage.get(UserService.class, "UserService.label32", "\u65e0\u6548\u7684\u7528\u6237Id[") + _nUserId + "]");
        }
        User currUser = User.findById(_nUserId);
        if (currUser == null) {
            throw new WCMException(200006, I18NMessage.get(UserService.class, "UserService.label33", "\u6ca1\u6709\u627e\u5230Id\u4e3a[") + _nUserId + I18NMessage.get(UserService.class, "UserService.label34", "]\u7684\u7528\u6237!"));
        }
        return this.delete(currUser, _bDrop);
    }

    @Override
    public boolean delete(User _userToDelete, boolean _bDrop) throws WCMException {
        boolean bUserCrUser;
        if (_userToDelete == null) {
            throw new WCMException(20, I18NMessage.get(UserService.class, "UserService.label30", "\u7528\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        User delUser = _userToDelete;
        boolean bHasRight = AuthServer.hasRight(this.getLoginUser(), (CMSObj)delUser, 12);
        User oCrUser = _userToDelete.getCrUser();
        boolean bl = bUserCrUser = oCrUser != null ? this.getLoginUser().getName().equals(oCrUser.getName()) : false;
        if (!bHasRight && !bUserCrUser) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label35", "\u60a8\u65e0\u6743\u5220\u9664\u7528\u6237\uff01"));
        }
        String sLogDesc = I18NMessage.get(UserService.class, "UserService.label36", "\u5220\u9664") + this.wrapObj(delUser);
        if (_bDrop) {
            sLogDesc = "\u5f7b\u5e95" + sLogDesc;
        }
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "USER_DEL", sLogDesc, _userToDelete);
        boolean bSucceed = false;
        try {
            bSucceed = this.getUserMgr().delete(delUser, _bDrop);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(UserService.class, "UserService.label37", "\u5220\u9664\u7528\u6237\u5931\u8d25\uff01"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return bSucceed;
    }

    @Override
    public boolean disable(int _nUserId) throws WCMException {
        User currUser = User.findById(_nUserId);
        return this.disable(currUser);
    }

    @Override
    public boolean enable(int _nUserId) throws WCMException {
        User currUser = User.findById(_nUserId);
        if (currUser == null) {
            throw new WCMException(200006, I18NMessage.get(UserService.class, "UserService.label38", "\u6ca1\u6709\u627e\u5230\u7528\u6237[") + _nUserId + "]!");
        }
        return this.enable(currUser);
    }

    private boolean changeUserRegStatus(User _dstUser, int _nNewStatus) throws WCMException {
        if (this.getLoginUser() == null) {
            throw new WCMException(20, I18NMessage.get(UserService.class, "UserService.label39", "\u7528\u6237\u6ca1\u6709\u767b\u9646!"));
        }
        return this.getUserMgr().changeUserRegStatus(_dstUser, _nNewStatus);
    }

    @Override
    public Users getUsers(int _nUserRegStatus, WCMFilter _filter) throws WCMException {
        if (this.getLoginUser() == null || !this.getLoginUser().isSecurityAdmin()) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label40", "\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u53ef\u4ee5\u7ba1\u7406\u6240\u6709\u7528\u6237!"));
        }
        WCMFilter aFilter = new WCMFilter("", "", "");
        StringBuffer buffWhere = new StringBuffer(64);
        if (-1 == _nUserRegStatus) {
            buffWhere.append("STATUS<=").append(30);
        } else if (10 == _nUserRegStatus) {
            buffWhere.append("ISDELETED=?");
            aFilter.addSearchValues(1);
        } else {
            buffWhere.append("STATUS=? and ISDELETED=?");
            aFilter.addSearchValues(_nUserRegStatus);
            aFilter.addSearchValues(0);
        }
        aFilter.setWhere(buffWhere.toString());
        aFilter.mergeWith(_filter);
        return Users.openWCMObjs(this.getLoginUser(), aFilter);
    }

    @Override
    public Users getMyUsers(int _nUserRegStatus, WCMFilter _filter) throws WCMException {
        User loginUser = this.getLoginUser();
        if (loginUser == null || !loginUser.isSecurityAdmin() && !this.isAdminOfGroup(loginUser)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label41", "\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u8005\u7ec4\u7ba1\u7406\u5458\u53ef\u4ee5\u7ba1\u7406\u81ea\u8eab\u521b\u5efa\u7684\u7528\u6237!"));
        }
        WCMFilter aFilter = new WCMFilter("", "", "");
        StringBuffer buffWhere = new StringBuffer(64);
        if (-1 == _nUserRegStatus) {
            buffWhere.append("STATUS<=").append(30);
        } else if (10 == _nUserRegStatus) {
            buffWhere.append("ISDELETED=?");
            aFilter.addSearchValues(1);
        } else {
            buffWhere.append("STATUS=? and ISDELETED=?");
            aFilter.addSearchValues(_nUserRegStatus);
            aFilter.addSearchValues(0);
        }
        buffWhere.append(" and CRUSER=?");
        aFilter.addSearchValues(loginUser.getName());
        aFilter.setWhere(buffWhere.toString());
        aFilter.mergeWith(_filter);
        return Users.openWCMObjs(loginUser, aFilter);
    }

    @Override
    public Users getCanMgrUsers(int _nUserRegStatus, WCMFilter _filter) throws WCMException {
        User loginUser = this.getLoginUser();
        if (loginUser == null || !loginUser.isSecurityAdmin() && !this.isAdminOfGroup(loginUser)) {
            throw new WCMException(1002, I18NMessage.get(UserService.class, "UserService.label41", "\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u8005\u7ec4\u7ba1\u7406\u5458\u53ef\u4ee5\u7ba1\u7406\u7528\u6237!"));
        }
        WCMFilter aFilter = new WCMFilter("", "", "");
        StringBuffer buffWhere = new StringBuffer(64);
        if (-1 == _nUserRegStatus) {
            buffWhere.append("STATUS<=").append(30);
        } else if (10 == _nUserRegStatus) {
            buffWhere.append("ISDELETED=?");
            aFilter.addSearchValues(1);
        } else {
            buffWhere.append("STATUS=? and ISDELETED=?");
            aFilter.addSearchValues(_nUserRegStatus);
            aFilter.addSearchValues(0);
        }
        aFilter.setWhere(buffWhere.toString());
        aFilter.mergeWith(_filter);
        if (loginUser.isSecurityAdmin()) {
            return Users.openWCMObjs(loginUser, aFilter);
        }
        Groups groups = this.getGroupMgr().getOffspringGroups(loginUser, null);
        String sGroupIds = groups.getIdListAsString();
        String sGroupIdsSQL = "";
        if (!CMyString.isEmpty(sGroupIds)) {
            sGroupIdsSQL = " and " + IdFilterSqlUtil.makeAsString("WCMGrpUser.GroupId", sGroupIds);
        }
        String sWhere = "exists(select 1 from WCMGrpUser where WCMGrpUser.UserId = WCMUser.UserId " + sGroupIdsSQL + ")";
        WCMFilter filter = new WCMFilter(null, sWhere, null);
        filter.mergeWith(aFilter);
        return Users.openWCMObjs(loginUser, filter);
    }

    @Override
    public boolean isAdminOfGroup(User _user) throws WCMException {
        return this.getUserMgr().isAdminOfGroup(_user);
    }

    @Override
    public boolean isManagerOfRole(User _user) throws WCMException {
        return this.getUserMgr().isManagerOfRole(_user);
    }
}

