/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.domain.DocumentImporter;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import com.trs.service.ISOAPService;
import java.io.File;
import java.io.OutputStream;
import org.apache.axis.encoding.Base64;
import org.apache.log4j.Logger;

public class SOAPServiceImpl
implements ISOAPService {
    private static Logger logger = Logger.getLogger(SOAPServiceImpl.class);
    private static final String SITE_FIELDS_LIST = "SITEID,SITENAME";
    private static final String CHANNEL_FIELDS_LIST = "CHANNELID,CHNLNAME,CHNLDESC,CHNLTYPE,CHNLORDER,PARENTID,CHNLQUERY,CHNLPROP,LINKURL";

    @Override
    public String importDocuments(byte[] _pImportFileContent, String _sFileExt) {
        if (_sFileExt.endsWith(".jsp") || _sFileExt.endsWith(".jspx")) {
            return "<FILENAME>\u975e\u6cd5\u8c03\u7528</FILENAME>";
        }
        ContextHelper.initContext(User.getSystem());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"importDocuments...");
        }
        String sFileName = null;
        Reports aReports = new Reports(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label1", "\u5bfc\u5165\u6587\u6863"));
        try {
            sFileName = this.writeFile(_pImportFileContent, _sFileExt);
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label2", "\u4fdd\u5b58\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label3", "]\u5931\u8d25\uff01")), e);
            aReports.setTitle(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label5", "]\u4e2d\u5bfc\u5165\u6587\u6863\uff01"));
            aReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label2", "\u4fdd\u5b58\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label3", "]\u5931\u8d25\uff01"), e);
            return aReports.toXML();
        }
        try {
            DocumentImporter aImporter = new DocumentImporter();
            String titleChecked = ConfigServer.getServer().getInitProperty("DOC_IMPORT_DUPTITLE_CHECKED");
            boolean bExit = "true".equals(titleChecked);
            aReports = aImporter.importFromFile(sFileName, null, null, bExit, false);
            if (logger.isDebugEnabled() || !aReports.getFailedReporter().isEmpty() || !aReports.getWarnedReporter().isEmpty()) {
                logger.info((Object)I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label6", "\u5bfc\u5165\u51fa\u73b0\u8b66\u544a\u6216\u8005\u5931\u8d25\uff01\u6216\u8005\u662f\u7531\u4e8e\u8c03\u8bd5\u5f00\u5173\u6253\u5f00\u4e86\uff01"));
                logger.info((Object)("Success=[" + aReports.getSucessedReporter().size() + "]Fail=[" + aReports.getFailedReporter().size() + "]Warning=[" + aReports.getWarnedReporter().size() + "]"));
                logger.info((Object)aReports.toXML());
            }
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label7", "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\uff01")), e);
            aReports.setTitle(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label5", "]\u4e2d\u5bfc\u5165\u6587\u6863\uff01"));
            aReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label7", "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\uff01"), e);
            return aReports.toXML();
        }
        return aReports.toXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importDocumentsByLocalFile(String _sUserName, String _sFileName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("importDocumentsByLocalFile...[UserName=" + _sUserName + ", sFileName=" + _sFileName + "]"));
        }
        Reports aReports = new Reports(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label1", "\u5bfc\u5165\u6587\u6863"));
        String sFileName = _sFileName;
        if (!CMyFile.fileExists(sFileName)) {
            String sImportFileStoragePath = null;
            try {
                sImportFileStoragePath = ConfigServer.getServer().getSysConfigValue("IMPORT_FILE_PATH", "d:\\temp\\");
            }
            catch (Throwable e) {
                String sErrorInfo = I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label8", "\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf\u7cfb\u7edf\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38\uff01\u786e\u8ba4\u7cfb\u7edf\u662f\u5426\u6b63\u5728\u542f\u52a8");
                logger.error((Object)sErrorInfo);
                aReports.setTitle(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label9", "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\u2014\u2014\u83b7\u53d6\u914d\u7f6e\u5f02\u5e38\uff01"));
                aReports.addFailedReport(sErrorInfo, e);
                return aReports.toXML();
            }
            sImportFileStoragePath = CMyString.setStrEndWith(sImportFileStoragePath, File.separatorChar);
            if (!CMyFile.pathExists(sImportFileStoragePath)) {
                String sErrorInfo = I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label10", "\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf\u7cfb\u7edf\u4e2d\u4fdd\u5b58SOAP\u5bfc\u5165\u6587\u4ef6\u76ee\u5f55\u914d\u7f6e\u5f97\u4e0d\u5bf9\uff01\u60a8\u53ef\u80fd\u6ca1\u6709\u914d\u7f6e\u6216\u8005\u914d\u7f6e\u9519\u8bef[\u9ed8\u8ba4\u503c=d:\\temp\\,\u5f53\u524d\u503c=") + sImportFileStoragePath + "]";
                logger.error((Object)sErrorInfo);
                aReports.setTitle(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label11", "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\u2014\u2014\u8def\u5f84\u4e0d\u5b58\u5728\uff01"));
                aReports.addFailedReport(sErrorInfo, null);
                return aReports.toXML();
            }
            sFileName = CMyFile.extractFileName(sFileName);
            sFileName = sImportFileStoragePath + sFileName;
            if (!CMyFile.fileExists(sFileName)) {
                String sErrorInfo = I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label12", "\u60a8\u6307\u5b9a\u7684\u5bfc\u5165\u6587\u4ef6\u5728\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01\u8bf7\u68c0\u67e5\u63d0\u4ea4\u6570\u636e\u6bb5\u7684\u76ee\u5f55\u914d\u7f6e\u548c\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf\u914d\u7f6e\u4e00\u81f4[\u5f53\u524d\u6587\u4ef6=") + sFileName + "]";
                logger.error((Object)sErrorInfo);
                aReports.setTitle(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label13", "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\u2014\u2014\u6587\u4ef6\u4e0d\u5b58\u5728\uff01"));
                aReports.addFailedReport(sErrorInfo, null);
                return aReports.toXML();
            }
        }
        User currUser = null;
        if (CMyString.isEmpty(_sUserName)) {
            currUser = User.getSystem();
        } else {
            try {
                currUser = User.findByName(_sUserName.trim());
                if (currUser == null) {
                    logger.error((Object)(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label14", "\u5f53\u524d\u4f20\u5165\u7684\u7528\u6237[") + _sUserName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label15", "]\u65e0\u6548\uff01")));
                    currUser = User.getSystem();
                }
            }
            catch (Exception e) {
                currUser = User.getSystem();
            }
        }
        ContextHelper.initContext(currUser);
        try {
            DocumentImporter aImporter = new DocumentImporter();
            String titleChecked = ConfigServer.getServer().getInitProperty("DOC_IMPORT_DUPTITLE_CHECKED");
            boolean bExit = "true".equals(titleChecked);
            aReports = aImporter.importFromFile(sFileName, null, null, bExit, false);
            if (logger.isDebugEnabled() || !aReports.getFailedReporter().isEmpty() || !aReports.getWarnedReporter().isEmpty()) {
                logger.info((Object)I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label6", "\u5bfc\u5165\u51fa\u73b0\u8b66\u544a\u6216\u8005\u5931\u8d25\uff01\u6216\u8005\u662f\u7531\u4e8e\u8c03\u8bd5\u5f00\u5173\u6253\u5f00\u4e86\uff01"));
                logger.info((Object)("Success=[" + aReports.getSucessedReporter().size() + "]Fail=[" + aReports.getFailedReporter().size() + "]Warning=[" + aReports.getWarnedReporter().size() + "]"));
                logger.info((Object)aReports.toXML());
            }
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label7", "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\uff01")), e);
            aReports.setTitle(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label5", "]\u4e2d\u5bfc\u5165\u6587\u6863\uff01"));
            aReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label4", "\u4ece\u6587\u4ef6[") + sFileName + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label7", "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\uff01"), e);
            String string = aReports.toXML();
            return string;
        }
        finally {
            ContextHelper.clear();
        }
        return aReports.toXML();
    }

    @Override
    public String getAllChannelXML() {
        ContextHelper.initContext(User.getSystem());
        try {
            WebSites aSites = WebSites.openWCMObjs(null, new WCMFilter("", "STATUS>=0", ""));
            ChannelExporter aExporter = new ChannelExporter(SITE_FIELDS_LIST, CHANNEL_FIELDS_LIST);
            String sXMLFile = aExporter.export(aSites, true, false);
            return CMyFile.readFile(FilesMan.getFilesMan().mapFilePath(sXMLFile, 0) + sXMLFile, "utf-8");
        }
        catch (Exception e) {
            Reports aReports = new Reports(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label16", "\u83b7\u53d6\u7cfb\u7edf\u680f\u76ee\u7ed3\u6784\u5931\u8d25\uff01"));
            aReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label17", "\u83b7\u53d6\u680f\u76ee\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff01"), e);
            return aReports.toXML();
        }
    }

    @Override
    public String uploadFile(byte[] _pUploadFileContent, String _sFileExt, boolean _bOnlyReturnFileName) {
        if (_sFileExt.endsWith(".jsp") || _sFileExt.endsWith(".jspx")) {
            return "<FILENAME>\u975e\u6cd5\u8c03\u7528</FILENAME>";
        }
        String sReturnValue = "";
        Reports currReports = new Reports(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label18", "\u4e0a\u4f20\u6587\u4ef6"));
        try {
            String sFileName = this.writeFile(_pUploadFileContent, _sFileExt);
            sReturnValue = CMyFile.extractFileName(sFileName);
            if (_bOnlyReturnFileName) {
                return sReturnValue;
            }
            currReports.addSucessedReport(sReturnValue + ":" + sFileName);
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label19", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25!"), e);
            currReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label20", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01"), e);
        }
        return currReports.toXML();
    }

    @Override
    public String getChannelChildrenXML(int _nSiteId, int _nChannelId, boolean _bAllChildren) {
        return null;
    }

    @Override
    public String getChannelXML(int _nChannelId) {
        return null;
    }

    @Override
    public String getSiteXML(int _nSiteId) {
        Reports currReports = null;
        if (_nSiteId <= 0) {
            currReports = new Reports(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label21", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9\u7684XML\u5931\u8d25\uff1a\u63d0\u4ea4\u7684\u6570\u636e\u975e\u6cd5"));
            currReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label22", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9\u7684XML\u5931\u8d25\uff1aSiteId[") + _nSiteId + "]<=0", null);
            return currReports.toXML();
        }
        WebSite currSite = null;
        try {
            currSite = WebSite.findById(_nSiteId);
        }
        catch (Throwable e) {
            currReports = new Reports(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label23", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9\u7684XML\u5931\u8d25\uff1a\u83b7\u53d6\u7ad9\u70b9\u53d1\u751f\u5f02\u5e38"));
            currReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label24", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9\u7684XML\u5931\u8d25\uff1a\u83b7\u53d6\u7ad9\u70b9\u53d1\u751f\u5f02\u5e38\uff01"), e);
            return currReports.toXML();
        }
        if (currSite == null) {
            if (currReports == null) {
                currReports = new Reports(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label21", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9\u7684XML\u5931\u8d25\uff1a\u63d0\u4ea4\u7684\u6570\u636e\u975e\u6cd5"));
            } else {
                currReports.setTitle(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label21", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9\u7684XML\u5931\u8d25\uff1a\u63d0\u4ea4\u7684\u6570\u636e\u975e\u6cd5"));
            }
            currReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label25", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9\u7684XML\u5931\u8d25\uff1a\u6307\u5b9a\u7684SiteId[") + _nSiteId + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label26", "]\u6ca1\u6709\u627e\u5230"), null);
            return currReports.toXML();
        }
        try {
            ChannelExporter aExporter = new ChannelExporter(SITE_FIELDS_LIST, CHANNEL_FIELDS_LIST);
            String sXMLFile = aExporter.export(currSite, true, false);
            return CMyFile.readFile(FilesMan.getFilesMan().mapFilePath(sXMLFile, 0) + sXMLFile, "utf-8");
        }
        catch (Exception e) {
            Reports aReports = new Reports(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label27", "\u83b7\u53d6 ") + currSite + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label28", " \u7684\u4fe1\u606f\u5931\u8d25\uff01"));
            aReports.addFailedReport(I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label27", "\u83b7\u53d6 ") + currSite + I18NMessage.get(SOAPServiceImpl.class, "SOAPServiceImpl.label28", " \u7684\u4fe1\u606f\u5931\u8d25\uff01"), e);
            return aReports.toXML();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(byte[] _pFileContent, String _sFileExt) throws Exception {
        OutputStream fos = null;
        try {
            String sFileName = FilesMan.getFilesMan().getNextFilePathName("U0", _sFileExt);
            fos = new FileService(sFileName).getOutputStream();
            fos.write(_pFileContent);
            String string = sFileName;
            return string;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public int getMajorVersion() {
        return 7;
    }

    @Override
    public String sendFileBase64(String strData, String Server, String fileExt) {
        if (fileExt.endsWith(".jsp") || fileExt.endsWith(".jspx")) {
            return "<FILENAME>\u975e\u6cd5\u8c03\u7528</FILENAME>";
        }
        return "<FILENAME>" + this.uploadFile(Base64.decode((String)strData), fileExt, true) + "</FILENAME>";
    }
}

