/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.content.HTMLContent;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.soap.OcrSoapClient;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import com.trs.net.ftp.FtpURL;
import com.trs.net.ftp.impl.FtpClientImpl;
import com.trs.service.IOfficeDocumentService;
import com.trs.service.impl.OfficeExtractDocumentService;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class OfficeDocumentService
extends OfficeExtractDocumentService
implements IOfficeDocumentService {
    private static Logger m_oLogger = Logger.getLogger(OfficeDocumentService.class);
    String mFtpHost = null;
    int nFtpPort = 21;
    String mFtpUploadPath = null;
    String mFtpDownloadPath = null;
    String mFtpUserName = null;
    String mFtpPwd = null;
    FtpClientImpl m_oFtpClient = null;
    String mSoapUrl = null;
    String mSoapUrn = null;
    String mSoapUserName = null;
    String mSoapPwd = null;
    String mSoapEncoding = null;

    public OfficeDocumentService() {
        ConfigServer oConfigServer = ConfigServer.getServer();
        try {
            this.mFtpHost = oConfigServer.getSysConfigValue("OCR_FTP_HOST", "127.0.0.1");
            String sFtpPort = oConfigServer.getSysConfigValue("OCR_FTP_PORT", "21");
            try {
                this.nFtpPort = Integer.parseInt(sFtpPort);
            }
            catch (Exception ex) {
                this.nFtpPort = 21;
            }
            this.mFtpUploadPath = oConfigServer.getSysConfigValue("OCR_FTP_UPLOAD_PATH", "");
            this.mFtpDownloadPath = oConfigServer.getSysConfigValue("OCR_FTP_DOWNLOAD_PATH", "");
            this.mFtpUserName = oConfigServer.getSysConfigValue("OCR_FTP_USR", "trs");
            this.mFtpPwd = oConfigServer.getSysConfigValue("OCR_FTP_PWD", "trs");
            this.mSoapUrl = oConfigServer.getSysConfigValue("OCR_SOAP_URL", "http://127.0.0.1:8000");
            this.mSoapUrn = oConfigServer.getSysConfigValue("OCR_SOAP_URN", "urn:Office2HTML");
            this.mSoapUserName = oConfigServer.getSysConfigValue("OCR_SOAP_USR", "trs");
            this.mSoapPwd = oConfigServer.getSysConfigValue("OCR_SOAP_PWD", "trs");
            this.mSoapEncoding = oConfigServer.getSysConfigValue("OCR_SOAP_ENCODING", "GBK");
        }
        catch (WCMException ex1) {
            m_oLogger.error((Object)I18NMessage.get(OfficeDocumentService.class, "OfficeDocumentService.label1", "\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u51fa\u9519!"), (Throwable)ex1);
        }
    }

    private FtpClientImpl openFtpClient() throws IOException {
        FtpURL url = new FtpURL("ftp://trs:trs@abc:21");
        url.setHost(this.mFtpHost);
        url.setPort(this.nFtpPort);
        url.setUserName(this.mFtpUserName);
        url.setPassWord(this.mFtpPwd);
        this.m_oFtpClient = new FtpClientImpl(url);
        this.m_oFtpClient.open();
        return this.m_oFtpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ftpUpload(String _sFileName) throws IOException {
        try {
            this.m_oFtpClient = this.openFtpClient();
            FileService fSaveFile = new FileService(_sFileName);
            String sShortFileName = CMyFile.extractFileName(_sFileName, null);
            this.m_oFtpClient.upload((File)new FileWrapper(fSaveFile), this.mFtpUploadPath + "/" + sShortFileName);
            fSaveFile.delete();
        }
        finally {
            if (this.m_oFtpClient != null) {
                this.m_oFtpClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ftpDownload(String _sFileName, String _sDestFileName) throws IOException {
        try {
            this.m_oFtpClient = this.openFtpClient();
            FileService fDestZip = new FileService(_sDestFileName);
            this.m_oFtpClient.download(this.mFtpDownloadPath + "/" + _sFileName, (File)new FileWrapper(fDestZip));
            try {
                this.m_oFtpClient.deleteFile(this.mFtpDownloadPath + "/" + _sFileName);
            }
            catch (IOException ex) {
                m_oLogger.warn((Object)(I18NMessage.get(OfficeDocumentService.class, "OfficeDocumentService.label2", "\u4e0b\u8f7d\u76ee\u5f55\u672a\u914d\u7f6e\u5220\u9664\u6587\u4ef6\u7684\u6743\u9650!:") + ex.getMessage()));
            }
        }
        finally {
            if (this.m_oFtpClient != null) {
                this.m_oFtpClient.close();
            }
        }
    }

    String renderHtmlFormat(String _sZipFile) throws CMyException {
        String sUnZipFile = CMyFile.extractFilePath(_sZipFile);
        sUnZipFile = sUnZipFile + "temp" + System.currentTimeMillis() + File.separator;
        CMyUnZipFile uzf = new CMyUnZipFile(_sZipFile, sUnZipFile);
        try {
            uzf.doUnZipAnd();
            CMyFile.deleteFile(_sZipFile);
        }
        catch (CMyException e) {
            throw new WCMException(200, I18NMessage.get(OfficeDocumentService.class, "OfficeDocumentService.label3", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!"), e);
        }
        Hashtable allFiles = uzf.getAllFileNameIndex();
        String sTmpFile = null;
        String sShortFileName = CMyFile.extractFileName(_sZipFile, null);
        String sHtmlFileName = sShortFileName.replaceAll("\\..*$", ".html");
        HashMap<String, String> hmSrcFile = new HashMap<String, String>();
        Enumeration allFileKeys = allFiles.keys();
        String sHtmlFileNameAbs = null;
        if (m_oLogger.isDebugEnabled()) {
            m_oLogger.debug((Object)sHtmlFileName);
        }
        while (allFileKeys.hasMoreElements()) {
            sTmpFile = (String)allFileKeys.nextElement();
            if (m_oLogger.isDebugEnabled()) {
                m_oLogger.debug((Object)(sTmpFile + ":" + allFiles.get(sTmpFile)));
            }
            if (!sTmpFile.equalsIgnoreCase(sHtmlFileName)) {
                hmSrcFile.put(sTmpFile.toLowerCase(), (String)allFiles.get(sTmpFile));
                continue;
            }
            sHtmlFileNameAbs = (String)allFiles.get(sTmpFile);
        }
        String sContent = CMyFile.readFile(sHtmlFileNameAbs, this.mSoapEncoding);
        String sResult = HTMLContent.saveHTMLContentFromOut(sContent, hmSrcFile);
        HTMLContent aHTMLContent = new HTMLContent(sResult);
        sResult = aHTMLContent.parseHTMLContent(null);
        new FileService(sHtmlFileNameAbs).delete();
        return sResult;
    }

    String soapConvert(String _sFileName) throws RemoteException, ServiceException {
        OcrSoapClient soapClient = new OcrSoapClient();
        soapClient.setServer(this.mSoapUrl, this.mSoapUserName, this.mSoapPwd);
        soapClient.setUrn(this.mSoapUrn);
        String sDestFile = soapClient.ConvertOfficeFile(_sFileName);
        return sDestFile;
    }

    @Override
    public String convert2Html(String _sFileName) throws Exception {
        String sShortFileName = CMyFile.extractFileName(_sFileName, null);
        String sUploadFilePath = CMyFile.extractFilePath(_sFileName);
        this.ftpUpload(_sFileName);
        String sZipFileName = this.soapConvert(sShortFileName);
        this.ftpDownload(sZipFileName, sUploadFilePath + sZipFileName);
        return this.renderHtmlFormat(sUploadFilePath + sZipFileName);
    }
}

