/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.util.List;

public class NetSnapTool {
    private static final char BLANK = ' ';
    private static String ENCODING = "GBK";

    public static void setENCODING(String eNCODING) {
        ENCODING = eNCODING;
    }

    public static String getTreeInfo2(String name, int rightIndex, int siteType, boolean addRoot) throws Exception {
        User user;
        String tree_encoding = ConfigServer.getServer().getSysConfigValue("TREE_STRUCTURE_ENCODING", "GBK");
        if (!tree_encoding.trim().equals("")) {
            NetSnapTool.setENCODING(tree_encoding);
        }
        if ((user = User.findByName(name)) == null) {
            throw new WCMException(200006, "user not found!usernmae=" + name);
        }
        StringBuffer buff = new StringBuffer(2048);
        buff.append("<?xml version=\"1.0\" encoding=\"");
        buff.append(ENCODING);
        buff.append("\"?>");
        if (addRoot) {
            buff.append("<ss>");
        }
        WebSites sites = new WebSites(user);
        WCMFilter filter = new WCMFilter("", "SITETYPE=0 or SITETYPE=4", "");
        if (siteType > 0) {
            filter = new WCMFilter("", "SITETYPE=" + siteType, "");
        }
        sites.open(filter);
        int nSize = sites.size();
        for (int i = 0; i < nSize; ++i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null || site.isDeleted()) continue;
            buff.append("<s n=\"").append(CMyString.filterForXML(site.getName())).append("\" id=\"");
            buff.append(site.getId()).append("\">");
            NetSnapTool.appendVisibleChildren(buff, user, site, rightIndex);
            buff.append("</s>");
        }
        if (addRoot) {
            buff.append("</ss>");
        }
        return buff.toString();
    }

    public static String getTreeInfo(String name, int rightIndex, int siteType, boolean addRoot) throws Exception {
        User user;
        String tree_encoding = ConfigServer.getServer().getSysConfigValue("TREE_STRUCTURE_ENCODING", "GBK");
        if (!tree_encoding.trim().equals("")) {
            NetSnapTool.setENCODING(tree_encoding);
        }
        if ((user = User.findByName(name)) == null) {
            throw new WCMException(200006, "user not found!usernmae=" + name);
        }
        StringBuffer buff = new StringBuffer(2048);
        buff.append("<?xml version=\"1.0\" encoding=\"");
        buff.append(ENCODING);
        buff.append("\"?>");
        if (addRoot) {
            buff.append("<ss>");
        }
        WebSites sites = new WebSites(user);
        WCMFilter filter = new WCMFilter("", "SITETYPE=0 or SITETYPE=4", "");
        if (siteType > 0) {
            filter = new WCMFilter("", "SITETYPE=" + siteType, "");
        }
        sites.open(filter);
        int nSize = sites.size();
        for (int i = 0; i < nSize; ++i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null || site.isDeleted()) continue;
            buff.append("<s n=\"").append(CMyString.filterForXML(site.getName())).append("\" id=\"");
            buff.append(site.getId()).append("\">");
            NetSnapTool.appendVisibleChildren(buff, user, site, rightIndex);
            buff.append("</s>");
        }
        if (addRoot) {
            buff.append("</ss>");
        }
        return NetSnapTool.encode(buff.toString());
    }

    private static final void appendVisibleChildren(StringBuffer buff, User user, BaseChannel parent, int rightIndex) throws WCMException {
        List<Channel> arChildren = parent.getChildren(null, 0);
        if (arChildren == null || arChildren.isEmpty()) {
            return;
        }
        int nChildrenSize = arChildren.size();
        for (int j = 0; j < nChildrenSize; ++j) {
            List<Channel> temp;
            boolean hasRight;
            Channel channel = arChildren.get(j);
            if (channel == null || channel.isDeleted() || !AuthServer.hasRight(user, (CMSObj)channel, 64) || !(hasRight = AuthServer.hasRight(user, (CMSObj)channel, rightIndex)) && ((temp = channel.getChildren(null, 0)) == null || temp.isEmpty())) continue;
            buff.append("<c n=\"");
            buff.append(CMyString.filterForXML(channel.getDesc()));
            buff.append("\" id=\"");
            buff.append(channel.getId());
            buff.append("\" addable=\"");
            buff.append(hasRight);
            buff.append("\">");
            NetSnapTool.appendVisibleChildren(buff, user, channel, rightIndex);
            buff.append("</c>");
        }
    }

    static String encode(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            throw new IllegalArgumentException("no need to encode an empty string?");
        }
        byte[] data = source.getBytes(ENCODING);
        StringBuffer buff = new StringBuffer(data.length * 2);
        byte[] byteBuff = new byte[3];
        int len = data.length;
        for (int i = 0; i < len; i += 3) {
            for (int j = 0; j < 3 && i + j < len; ++j) {
                byteBuff[j] = data[i + j];
            }
            int a = (byteBuff[0] >>> 2 & 0x3F) + 32;
            int b = (byteBuff[0] << 4 & 0x30 | byteBuff[1] >>> 4 & 0xF) + 32;
            int c = (byteBuff[1] << 2 & 0x3C | byteBuff[2] >>> 6 & 3) + 32;
            int d = (byteBuff[2] & 0x3F) + 32;
            buff.append((char)a);
            buff.append((char)b);
            buff.append((char)c);
            buff.append((char)d);
            for (int j = 0; j < 3; ++j) {
                byteBuff[j] = 0;
            }
        }
        return buff.toString();
    }

    String standardEncode(String source) {
        byte[] data = source.getBytes();
        StringBuffer buff = new StringBuffer(data.length * 5);
        int pos = 0;
        int len = data.length;
        for (int i = 0; i < len; i += 45) {
            int j = 0;
            j = i + 45 > len ? len - i : 45;
            buff.append((char)(j + 32));
            for (int k = 0; k < j && pos < len; k += 3) {
                byte a = 0;
                byte b = 0;
                byte c = 0;
                a = data[pos++];
                if (pos < len) {
                    b = data[pos++];
                }
                if (pos < len) {
                    c = data[pos++];
                }
                int c1 = a >>> 2 & 0x3F;
                int c2 = a << 4 & 0x30 | b >>> 4 & 0xF;
                int c3 = b << 2 & 0x3C | c >>> 6 & 3;
                int c4 = c & 0x3F;
                buff.append((char)(c1 + 32));
                buff.append((char)(c2 + 32));
                buff.append((char)(c3 + 32));
                buff.append((char)(c4 + 32));
            }
            buff.append('\n');
        }
        return buff.toString();
    }

    static String decode(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            throw new IllegalArgumentException("no need to decode an empty string?");
        }
        byte[] data = source.getBytes();
        if (data.length % 4 > 0) {
            throw new IllegalArgumentException("Bad data!");
        }
        byte[] buff = new byte[4];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = data.length;
        for (int i = 0; i < len; i += 4) {
            for (int j = 0; j < 4; ++j) {
                buff[j] = (byte)(data[i + j] - 32);
            }
            int a = (buff[0] << 2 & 0xFC | buff[1] >>> 4 & 3) & 0xFF;
            int b = (buff[1] << 4 & 0xF0 | buff[2] >>> 2 & 0xF) & 0xFF;
            int c = (buff[2] << 6 & 0xC0 | buff[3] & 0x3F) & 0xFF;
            baos.write(a);
            if (b > 0) {
                baos.write(b);
            }
            if (c <= 0) continue;
            baos.write(c);
        }
        return new String(baos.toByteArray(), ENCODING);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(URLEncoder.encode(";&IW", "ISO8859-1"));
    }
}

