/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.address.Contact;
import com.trs.components.common.address.ContactGrp;
import com.trs.components.common.address.ContactGrps;
import com.trs.components.common.address.ContactMgr;
import com.trs.components.common.address.Contacts;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.service.IContactService;

public class ContactService
implements IContactService {
    @Override
    public Contact addContactFromSystemUser(int _nUserId) throws WCMException {
        User user = User.findById(_nUserId);
        if (user == null) {
            throw new WCMException(200006, I18NMessage.get(ContactService.class, "ContactService.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237[id=") + _nUserId + "]!");
        }
        return this.getContactMgr().addContactFromSystemUser(user);
    }

    @Override
    public Contact addContactFromSystemUser(User _user) throws WCMException {
        return this.getContactMgr().addContactFromSystemUser(_user);
    }

    @Override
    public void addContact(String _sContactIds, int _nContactGrpId) throws WCMException {
        Contacts contacts = Contacts.findByIds(this.getLoginUser(), _sContactIds);
        ContactGrp contactGroup = this.findContactGroup(_nContactGrpId);
        Contact contact = null;
        for (int i = 0; i < contacts.size(); ++i) {
            contact = (Contact)contacts.getAt(i);
            if (contact == null) continue;
            this.addContact(contact, contactGroup);
        }
    }

    @Override
    public Contact addContact(int _nContactId, int _nContactGrpId) throws WCMException {
        Contact contact = this.findContact(_nContactId);
        ContactGrp contactGroup = this.findContactGroup(_nContactGrpId);
        return this.getContactMgr().addContact(contact, contactGroup);
    }

    @Override
    public Contact addContact(Contact _contact, ContactGrp _contactGroup) throws WCMException {
        return this.getContactMgr().addContact(_contact, _contactGroup);
    }

    @Override
    public Contact saveContact(Contact _contact) throws WCMException {
        return this.getContactMgr().saveContact(_contact);
    }

    @Override
    public void deleteContacts(String _sContactIds) throws WCMException {
        Contacts contacts = Contacts.findByIds(this.getLoginUser(), _sContactIds);
        if (contacts == null || contacts.isEmpty()) {
            return;
        }
        this.deleteContacts(contacts);
    }

    @Override
    public void deleteContacts(Contacts _contacts) throws WCMException {
        if (_contacts == null || _contacts.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ContactService.class, "ContactService.label2", "\u65e0\u6548\u7684\u96c6\u5408!"));
        }
        Contact contact = null;
        for (int i = 0; i < _contacts.size(); ++i) {
            contact = (Contact)_contacts.getAt(i);
            if (contact == null) continue;
            this.deleteContact(contact);
        }
    }

    @Override
    public void deleteContact(int _nContactId) throws WCMException {
        Contact contact = this.findContact(_nContactId);
        this.deleteContact(contact);
    }

    @Override
    public void deleteContact(Contact _contact) throws WCMException {
        if (_contact == null) {
            throw new WCMException(10, I18NMessage.get(ContactService.class, "ContactService.label3", "\u65e0\u6548\u7684\u8054\u7cfb\u4eba\u5bf9\u8c61[null]!"));
        }
        this.assertNoRight(_contact.getCrUserName());
        this.getContactMgr().deleteContact(_contact);
    }

    @Override
    public ContactGrp saveContactGroup(ContactGrp _contactGrp) throws WCMException {
        return this.getContactMgr().saveContactGroup(_contactGrp);
    }

    @Override
    public void deleteContactGroups(String _sContactGroupIds) throws WCMException {
        ContactGrps contactgroups = ContactGrps.findByIds(this.getLoginUser(), _sContactGroupIds);
        if (contactgroups == null || contactgroups.isEmpty()) {
            return;
        }
        this.deleteContactGroups(contactgroups);
    }

    @Override
    public void deleteContactGroups(ContactGrps _contactGroups) throws WCMException {
        if (_contactGroups == null || _contactGroups.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ContactService.class, "ContactService.label2", "\u65e0\u6548\u7684\u96c6\u5408!"));
        }
        ContactGrp contactGroup = null;
        for (int i = 0; i < _contactGroups.size(); ++i) {
            contactGroup = (ContactGrp)_contactGroups.getAt(i);
            if (contactGroup == null) continue;
            this.deleteContactGroup(contactGroup);
        }
    }

    @Override
    public void deleteContactGroup(int _nContactGroupId) throws WCMException {
        ContactGrp contactGroup = this.findContactGroup(_nContactGroupId);
        this.deleteContactGroup(contactGroup);
    }

    @Override
    public void deleteContactGroup(ContactGrp _contactGroup) throws WCMException {
        if (_contactGroup == null) {
            throw new WCMException(10, I18NMessage.get(ContactService.class, "ContactService.label3", "\u65e0\u6548\u7684\u8054\u7cfb\u4eba\u5bf9\u8c61[null]!"));
        }
        this.assertNoRight(_contactGroup.getCrUserName());
        this.getContactMgr().deleteContactGroup(_contactGroup);
    }

    @Override
    public ContactGrps getGroups(Contact _contact) throws WCMException {
        return this.getContactMgr().getGroups(_contact);
    }

    @Override
    public ContactGrps getContactGroups(WCMFilter _filter) throws WCMException {
        return this.getContactMgr().getContactGroups(_filter);
    }

    @Override
    public Contacts getContacts(WCMFilter _filter, ContactGrp _contactGroup) throws WCMException {
        return this.getContactMgr().getContacts(_filter, _contactGroup);
    }

    @Override
    public Contacts getContacts(WCMFilter _filter) throws WCMException {
        return this.getContactMgr().getContacts(_filter);
    }

    @Override
    public void removeContacts(String _sContactIds, int _nContactGrpId) throws WCMException {
        Contacts contacts = Contacts.findByIds(this.getLoginUser(), _sContactIds);
        ContactGrp contactGroup = this.findContactGroup(_nContactGrpId);
        Contact contact = null;
        for (int i = 0; i < contacts.size(); ++i) {
            contact = (Contact)contacts.getAt(i);
            if (contact == null) continue;
            this.removeContact(contact, contactGroup);
        }
    }

    @Override
    public void removeContact(int _nContactId, int _nContactGrpId) throws WCMException {
        Contact contact = Contact.findById(_nContactId);
        ContactGrp contactGroup = ContactGrp.findById(_nContactGrpId);
        this.removeContact(contact, contactGroup);
    }

    @Override
    public void removeContact(Contact _contact, ContactGrp _contactGroup) throws WCMException {
        this.assertNoRight(_contact.getCrUserName());
        this.getContactMgr().removeContact(_contact, _contactGroup);
    }

    @Override
    public void changeGroup(int _nContactId, int _nSrcGroupId, int _nDestGroupId) throws WCMException {
        Contact contact = this.findContact(_nContactId);
        ContactGrp srcGroup = this.findContactGroup(_nSrcGroupId);
        ContactGrp destGroup = this.findContactGroup(_nDestGroupId);
        this.changeGroup(contact, srcGroup, destGroup);
    }

    @Override
    public void changeGroup(Contact _contact, ContactGrp _srcGroup, ContactGrp _destGroup) throws WCMException {
        this.getContactMgr().changeGroup(_contact, _srcGroup, _destGroup);
    }

    private ContactMgr getContactMgr() {
        return (ContactMgr)DreamFactory.createObjectById("ContactMgr");
    }

    private Contact findContact(int _nContactId) throws WCMException {
        Contact contact = Contact.findById(_nContactId);
        if (contact == null) {
            throw new WCMException(200006, I18NMessage.get(ContactService.class, "ContactService.label4", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8054\u7cfb\u4eba\u5bf9\u8c61[id=") + _nContactId + "]!");
        }
        return contact;
    }

    private ContactGrp findContactGroup(int _nContactGrpId) throws WCMException {
        ContactGrp contactGroup = ContactGrp.findById(_nContactGrpId);
        if (contactGroup == null) {
            throw new WCMException(200006, I18NMessage.get(ContactService.class, "ContactService.label5", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8054\u7cfb\u4eba\u5206\u7ec4\u5bf9\u8c61[id=") + _nContactGrpId + "]!");
        }
        return contactGroup;
    }

    private void assertNoRight(String _username) throws WCMException {
        String rightName = this.getLoginUser().getName();
        if (!rightName.equals(_username)) {
            throw new WCMException(1002, I18NMessage.get(ContactService.class, "ContactService.label6", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u8fdb\u884c\u8be5\u64cd\u4f5c\t"));
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

