/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.TableInfo;
import com.trs.service.ICDSService;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CDSServiceImpl
implements ICDSService {
    private static Logger logger = Logger.getLogger(CDSServiceImpl.class);
    private static final String XML_ENCODING = "GBK";

    @Override
    public String getSystemInfo(String _sCDSType, int _nParentSiteId, int _nParentChannelId) throws WCMException {
        return this.getSystemInfo(_sCDSType, _nParentSiteId, _nParentChannelId, null, null);
    }

    @Override
    public String getSystemInfo(String _sCDSType, int _nParentSiteId, int _nParentChannelId, String _sSiteFields, String _sChannelFields) throws WCMException {
        if (_sCDSType == null) {
            throw new WCMDatainvalidException(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label1", "\u6ca1\u6709\u4f20\u5165\u6307\u5b9a\u7684Type\uff01"));
        }
        String sCDSType = _sCDSType.toUpperCase();
        if (sCDSType.equals("CDS1") || sCDSType.equals("CDS2")) {
            boolean bIncludeChildren = sCDSType.equals("CDS2");
            if (_nParentSiteId <= 0) {
                return this.getAllChannelsXML(bIncludeChildren);
            }
            WebSite currSite = WebSite.findById(_nParentSiteId);
            if (currSite == null) {
                throw new WCMException(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label2", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[SiteId=") + _nParentSiteId + "].");
            }
            return this.toXMLInfo(currSite, bIncludeChildren, _sSiteFields, _sChannelFields);
        }
        if (sCDSType.equals("CDS3")) {
            Channel currChannel = Channel.findById(_nParentChannelId);
            if (currChannel == null) {
                throw new WCMException(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053[ChannelId=") + _nParentChannelId + "].");
            }
            Element elChannel = this.toCDSXMLElement(currChannel);
            WebSite currSite = currChannel.getSite();
            WebSites sites = new WebSites(null);
            sites.addElement(currSite);
            ObjToXmlConverter converter = new ObjToXmlConverter();
            Element elSites = converter.toXmlElement(sites, null);
            Element elChannels = DocumentHelper.createElement((String)"WCMCHANNELS");
            elChannels.add(elChannel);
            elSites.element("WCMWEBSITE").add(elChannels);
            return elSites.asXML();
        }
        throw new WCMDatainvalidException(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label4", "\u6ca1\u6709\u4f20\u5165\u6307\u5b9a\u7684Type[") + sCDSType + I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label5", "]\u65e0\u6548\uff01"));
    }

    @Override
    public String getChannelsXML(BaseChannel _oBaseChannel, boolean _bIncludeChildren) throws WCMException {
        return this.toXMLInfo(_oBaseChannel, _bIncludeChildren, null, null);
    }

    @Override
    public String getAllChannelsXML(boolean _bIncludeChildren) throws WCMException {
        WCMFilter filter = new WCMFilter("", "Status>=0", "", "SiteOrder");
        WebSites allSites = WebSites.openWCMObjs(null, filter);
        return this.toXMLInfo(allSites, _bIncludeChildren, null, null);
    }

    private String toXMLInfo(Object _exportObject, boolean _bIncludeChildren, String _sSiteFields, String _sChannelFields) throws WCMException {
        ChannelExporter exporter = new ChannelExporter(_sSiteFields, _sChannelFields);
        exporter.setXMLEncoding(XML_ENCODING);
        return exporter.exportToXMLContent(_exportObject, _bIncludeChildren, false);
    }

    private String getChannelWhere(Channel _currChannel) {
        boolean bInCurrChannelSearch;
        IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        String sStatusIds = null;
        try {
            int[] _pStatuses = m_oCacheMgr.findStatusesCanDoPub(103, _currChannel.getSiteId());
            sStatusIds = "WCMCHNLDOC.DOCSTATUS in(" + _pStatuses[0];
            int nSize = _pStatuses.length;
            for (int i = 1; i < nSize; ++i) {
                sStatusIds = sStatusIds + "," + _pStatuses[i];
            }
            sStatusIds = sStatusIds + ")";
        }
        catch (Exception e) {
            sStatusIds = "WCMCHNLDOC.DOCSTATUS =10";
            logger.error((Object)I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label6", "\u83b7\u53d6\u7ad9\u70b9\u53ef\u53d1\u5e03\u72b6\u6001\u5931\u8d25\uff01"), (Throwable)e);
        }
        String sChannelWhere = sStatusIds + " and WCMDocument.DocChannel>0 and WCMDocument.DocStatus>0";
        StringBuffer buff = new StringBuffer();
        String sQuery = _currChannel.getQuery();
        boolean bl = bInCurrChannelSearch = CMyString.isEmpty(sQuery) || !_currChannel.isOnlySearch();
        if (bInCurrChannelSearch) {
            buff.append("WCMCHNLDOC").append(".CHNLID=" + _currChannel.getId());
            buff.append(" AND ");
        }
        buff.append("WCMCHNLDOC").append(".DOCID=");
        buff.append("WCMDOCUMENT").append(".DOCID");
        if (sQuery != null && sQuery.length() > 0) {
            buff.append(" AND (").append(sQuery).append(')');
        }
        if (_currChannel.isOnlySearch()) {
            buff.append(" AND (").append("WCMCHNLDOC").append(".MODAL=").append(1).append(')');
        }
        sChannelWhere = sChannelWhere + " and (" + buff.toString() + ")";
        return sChannelWhere;
    }

    private Element toCDSXMLElement(Channel _currChannel) throws WCMException {
        _currChannel.getProperties().put("CDSCHNLSQL", this.getChannelWhere(_currChannel));
        String sOldChnlOrder = null;
        String sOrder = _currChannel.getOrderBy();
        if (sOrder != null && sOrder.trim().length() > 0) {
            sOldChnlOrder = sOrder;
            sOrder = this.filterOrderForChannel(sOrder);
            _currChannel.getProperties().put("CHNLORDERBY", sOrder);
        }
        ObjToXmlConverter converter = new ObjToXmlConverter();
        Element elChannel = converter.toXmlElement(_currChannel);
        _currChannel.getProperties().remove("CDSCHNLSQL");
        if (sOldChnlOrder != null) {
            _currChannel.getProperties().put("CHNLORDERBY", sOldChnlOrder);
        }
        if (_currChannel.getChildrenSize(null) == 0) {
            return elChannel;
        }
        Element elChildren = DocumentHelper.createElement((String)"WCMCHANNELS");
        List<Channel> vChild = _currChannel.getChildren(null);
        for (int i = 0; i < vChild.size(); ++i) {
            Element elChild;
            Channel aChnl = vChild.get(i);
            if (aChnl == null || (elChild = this.toCDSXMLElement(aChnl)) == null) continue;
            elChildren.add(elChild);
        }
        elChannel.add(elChildren);
        return elChannel;
    }

    private String filterOrderForChannel(String _sOrder) throws WCMException {
        String sDefaultOrder = "";
        DBManager dbManager = DBManager.getDBManager();
        if (ChnlDoc.IS_ORDER_BY_PRI) {
            sDefaultOrder = "WCMCHNLDOC.DOCORDERPRI desc,";
        }
        sDefaultOrder = sDefaultOrder + "WCMCHNLDOC.DOCORDER desc ";
        if (_sOrder == null || _sOrder.length() == 0) {
            return sDefaultOrder;
        }
        TableInfo tblDocument = dbManager.getTableInfo("WCMDOCUMENT");
        if (tblDocument == null) {
            return sDefaultOrder;
        }
        TableInfo tblChnlDoc = dbManager.getTableInfo("WCMCHNLDOC");
        if (tblChnlDoc == null) {
            return sDefaultOrder;
        }
        String sNewOrder = "";
        StringTokenizer stOrderField = new StringTokenizer(_sOrder, ",");
        int i = -1;
        do {
            String sOrderFiled = (String)stOrderField.nextElement();
            sOrderFiled = sOrderFiled.trim();
            ++i;
            int nEndPose = sOrderFiled.indexOf(" ");
            String sField = "";
            String sOrderMode = "";
            if (nEndPose < 0) {
                sField = sOrderFiled;
                sOrderMode = "asc";
            } else {
                sField = sOrderFiled.substring(0, nEndPose).toUpperCase();
                sOrderMode = sOrderFiled.substring(nEndPose).toUpperCase();
            }
            int nTablePose = sField.indexOf(".");
            if (nTablePose >= 0) {
                if (i > 0) {
                    sNewOrder = sNewOrder + "," + sField + " " + sOrderMode;
                    continue;
                }
                sNewOrder = sField + " " + sOrderMode;
                continue;
            }
            if (tblDocument.getFieldInfo(sField) != null) {
                sField = "WCMDOCUMENT." + sField;
            } else if (tblChnlDoc.getFieldInfo(sField) != null) {
                sField = "WCMCHNLDOC." + sField;
            } else {
                Exception ex = new Exception(I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label7", "\u5b57\u6bb5\u4e0d\u5b58\u5728!"));
                throw new WCMException(10, I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label8", "\u6307\u5b9a\u7684\u6392\u5e8f\u5b57\u6bb5[") + sField + I18NMessage.get(CDSServiceImpl.class, "CDSServiceImpl.label9", "]\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!"), ex);
            }
            sNewOrder = i > 0 ? sNewOrder + "," + sField + " " + sOrderMode : sField + " " + sOrderMode;
        } while (stOrderField.hasMoreElements());
        return sNewOrder;
    }
}

