/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.scm.domain.ISCMGroupMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroups;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SCMGroupServiceProvider
implements IGlueServiceProvider {
    private static Logger logger = Logger.getLogger(SCMGroupServiceProvider.class);
    ISCMGroupMgr m_oSCMGroupMgr = (ISCMGroupMgr)DreamFactory.createObjectById("ISCMGroupMgr");

    @Override
    public void delete(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        SCMGroups oSCMGroups = SCMGroups.findByIds(oLoginUser, _oContext.getObjectIds());
        for (int i = 0; i < oSCMGroups.size(); ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
            if (oSCMGroup == null) continue;
            if (!SCMAuthServer.hasRightInGroup(oLoginUser, oSCMGroup, 2)) {
                throw new WCMException("\u60a8\u5bf9\u8be5\u5206\u7ec4\u6ca1\u6709\u5220\u9664\u6743\u9650\uff01[ID=" + oSCMGroup.getId() + "]");
            }
            SCMGroups oTSCMGroups = this.m_oSCMGroupMgr.getSubGroups(oSCMGroup);
            if (oTSCMGroups != null && oTSCMGroups.size() > 0) {
                throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e2d\u8fd8\u5b58\u5b50\u5206\u7ec4\uff01");
            }
            this.m_oSCMGroupMgr.delete(oSCMGroup);
        }
    }

    @Override
    public Object query(MethodContext _oContext) throws Throwable {
        _oContext.getExtraWCMFilter();
        WCMFilter oWCMFilter = _oContext.getExtraWCMFilter();
        SCMGroups oSCMGroups = this.m_oSCMGroupMgr.query(oWCMFilter);
        return oSCMGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int save(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        int nObjectId = _oContext.getValue("ObjectId", 0);
        int nParentId = _oContext.getValue("ParentId", -1);
        SCMGroup oParentSCMGroup = null;
        if (nParentId != -1 && (oParentSCMGroup = SCMGroup.findById(nParentId)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7236\u5206\u7ec4\u4e0d\u5b58\u5728\uff01[ID=" + nParentId + "]");
        }
        if (oParentSCMGroup != null && !SCMAuthServer.hasRight(oLoginUser, oParentSCMGroup, 1)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5728\u6b64\u5206\u7ec4\u4e0b\u521b\u5efa\u5206\u7ec4\uff01");
        }
        SCMGroup oSCMGroup = null;
        if (nObjectId == 0) {
            oSCMGroup = SCMGroup.createNewInstance();
        } else {
            oSCMGroup = SCMGroup.findById(nObjectId);
            if (oSCMGroup == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u4e0d\u5b58\u5728\uff01[ID=" + nObjectId + "]");
            }
            if (oParentSCMGroup != null && !SCMAuthServer.hasRight(oLoginUser, oSCMGroup, 1)) {
                throw new WCMException("\u60a8\u65e0\u6cd5\u5bf9\u8be5\u5206\u7ec4\u8fdb\u884c\u64cd\u4f5c\uff01[ID=" + nObjectId + "]");
            }
            oSCMGroup.validCanEditAndLock(oLoginUser);
        }
        try {
            String[] sLogicFields = new String[]{"ObjectId"};
            oSCMGroup = (SCMGroup)WCMAJAXServiceHelper.setWCMObjectProperties(oLoginUser, _oContext, oSCMGroup, sLogicFields);
            int n = this.m_oSCMGroupMgr.save(oSCMGroup).getId();
            return n;
        }
        finally {
            if (oSCMGroup.isLocked()) {
                try {
                    oSCMGroup.unlock();
                }
                catch (Exception e) {
                    throw new WCMException("\u89e3\u9501\u5bf9\u8c61\u65f6\u51fa\u73b0\u5f02\u5e38" + nObjectId);
                }
            }
        }
    }

    @Override
    public Object findById(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        int nObjectId = _oContext.getValue("ObjectId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nObjectId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u4e0d\u5b58\u5728\uff01[ID=" + nObjectId + "]");
        }
        if (!SCMAuthServer.hasRightInGroup(oLoginUser, oSCMGroup, 6)) {
            throw new WCMException("\u60a8\u65e0\u6743\u5bf9\u8be5\u5206\u7ec4\u8fdb\u884c\u64cd\u4f5c\uff01[ID=" + nObjectId + "]");
        }
        return oSCMGroup;
    }

    @Override
    public Object findByIds(MethodContext _oContext) throws Throwable {
        String sObjectIds;
        User oLoginUser = this.getLoginUser();
        SCMGroups oSCMGroups = SCMGroups.findByIds(oLoginUser, sObjectIds = _oContext.getValue("ObjectIds"));
        if (oSCMGroups == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u96c6\u5408\u4e0d\u5b58\u5728\uff01[ID=" + sObjectIds + "]");
        }
        int nSize = oSCMGroups.size();
        for (int i = 0; i < nSize; ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
            if (oSCMGroup == null || SCMAuthServer.hasRightInGroup(oLoginUser, oSCMGroup, 6)) continue;
            throw new WCMException("\u60a8\u65e0\u6cd5\u5bf9\u8be5\u5206\u7ec4\u96c6\u5408\u8fdb\u884c\u64cd\u4f5c\uff01[IDS=" + sObjectIds + "]");
        }
        return oSCMGroups;
    }

    public SCMGroups getGroupsOfUser(MethodContext _oContext) throws Throwable {
        int nUserId = _oContext.getValue("UserId", 0);
        User oUser = User.findById(nUserId);
        if (oUser == null) {
            throw new WCMException("\u7528\u6237\u4e3a\u7a7a\uff01[ID=" + nUserId + "]");
        }
        SCMGroups oSCMGroups = this.m_oSCMGroupMgr.getManagedGroups(oUser);
        return oSCMGroups;
    }

    public SCMGroups getGroupsForRightSet(MethodContext _oMethodContext) throws Throwable {
        int nUserId = _oMethodContext.getValue("UserId", 0);
        User oCurrUser = User.findById(nUserId);
        if (oCurrUser == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7528\u6237[Id=" + nUserId + "]");
        }
        if (!SCMAuthServer.canManageSCMRights(oCurrUser, 23)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u5206\u7ec4\u7684\u6743\u9650\u7ba1\u7406\uff01");
        }
        return SCMGroups.openWCMObjs(oCurrUser, null);
    }

    public boolean isAdminsOfSCMGroups(MethodContext _oContext) throws Exception {
        if (!SCMAuthServer.isStartSCM()) {
            logger.debug((Object)"\u65e0\u6cd5\u8bbf\u95ee\uff01\u672a\u7533\u8bf7SCM\u9009\u4ef6\u6ce8\u518c\u7801\uff01");
            return false;
        }
        User oCurrLgoinUser = this.getLoginUser();
        if (SCMAuthServer.isAdminOfSCM(oCurrLgoinUser)) {
            return true;
        }
        SCMGroups oSCMGroups = this.m_oSCMGroupMgr.getManagedGroups(oCurrLgoinUser);
        return oSCMGroups != null && oSCMGroups.size() > 0;
    }

    public Users getAdminsOfGroup(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u4e0d\u5b58\u5728\uff01[ID=" + nSCMGroupId + "]");
        }
        if (!SCMAuthServer.hasRight(oLoginUser, oSCMGroup, 6)) {
            throw new WCMException("\u60a8\u65e0\u6743\u67e5\u770b\u5206\u7ec4\u7684\u7ef4\u62a4\u4eba\u5458\uff01");
        }
        return this.m_oSCMGroupMgr.getAdmins(oSCMGroup);
    }

    public void saveAdminsOfGroup(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        String sUserIds = _oContext.getValue("UserIds");
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a" + nSCMGroupId);
        }
        Users oUsers = Users.findByIds(oLoginUser, sUserIds);
        if (oUsers == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a" + sUserIds);
        }
        if (!SCMAuthServer.canManageSCMRights(oLoginUser, 21) && !SCMAuthServer.isGroupAdminOfSCM(oLoginUser)) {
            throw new WCMException("\u60a8\u65e0\u6743\u8bbe\u7f6e\u5206\u7ec4\u7684\u7ef4\u62a4\u4eba\u5458\uff01");
        }
        this.m_oSCMGroupMgr.saveAdminsOfGroup(oSCMGroup, oUsers);
    }

    public void saveAdminOfGroup(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a" + nSCMGroupId);
        }
        if (!SCMAuthServer.hasRightInGroup(oLoginUser, oSCMGroup, 8)) {
            throw new WCMException("\u60a8\u65e0\u6743\u8bbe\u7f6e\u5206\u7ec4\u7684\u7ba1\u7406\u4eba\u5458\uff01");
        }
        int nUserId = Integer.parseInt(_oContext.getValue("UserId"));
        int nIsAdmin = _oContext.getValue("IsAdmin", 0);
        User oUser = User.findById(nUserId);
        if (oUser == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a" + nUserId);
        }
        this.m_oSCMGroupMgr.saveAdminOfGroup(oSCMGroup, oUser, nIsAdmin);
    }

    public int deleteAdminOfGroup(MethodContext _oContext) throws Throwable {
        User oLoginUser = this.getLoginUser();
        int nUserId = _oContext.getValue("UserId", 0);
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a" + nSCMGroupId);
        }
        User oUser = User.findById(nUserId);
        if (oUser == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a![ID=" + nUserId + "]");
        }
        if (!SCMAuthServer.hasRight(oLoginUser, oSCMGroup, 7)) {
            throw new WCMException("\u60a8\u65e0\u6743\u5220\u9664\u5206\u7ec4\u7684\u7ef4\u62a4\u4eba\u5458\uff01");
        }
        return this.m_oSCMGroupMgr.deleteAdminOfGroup(oSCMGroup, oUser);
    }

    public boolean addAccountToGroup(MethodContext _oMethodContext) throws Throwable {
        int nSCMGroupId = _oMethodContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u6ca1\u6709\u627e\u5230\uff01[ID=" + nSCMGroupId + "]");
        }
        User oUser = this.getLoginUser();
        if (!SCMAuthServer.hasRightInGroup(oUser, oSCMGroup, 4)) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4ece\u5f53\u524d\u5206\u7ec4\u6dfb\u52a0\u8d26\u53f7\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u5f80\u5206\u7ec4\u4e2d\u6dfb\u52a0\u8d26\u53f7\uff01");
        }
        int nAccountId = _oMethodContext.getValue("AccountId", 0);
        return this.m_oSCMGroupMgr.addAccountToGroup(Account.findById(nAccountId), oSCMGroup);
    }

    public boolean removeAccountFromGroup(MethodContext _oMethodContext) throws Throwable {
        int nSCMGroupId = _oMethodContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u6ca1\u6709\u627e\u5230\uff01[ID=" + nSCMGroupId + "]");
        }
        User oUser = this.getLoginUser();
        if (!SCMAuthServer.hasRightInGroup(oUser, oSCMGroup, 3)) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4ece\u5f53\u524d\u5206\u7ec4\u5220\u9664\u8d26\u53f7\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u4ece\u5206\u7ec4\u4e2d\u5220\u9664\u8d26\u53f7\uff01");
        }
        int nAccountId = _oMethodContext.getValue("AccountId", 0);
        return this.m_oSCMGroupMgr.removeAccountFromGroup(Account.findById(nAccountId), oSCMGroup);
    }

    public boolean isHasAccounts(MethodContext _oMethodContext) throws Throwable {
        int nSCMGroupId = _oMethodContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u6ca1\u6709\u627e\u5230\uff01[ID=" + nSCMGroupId + "]");
        }
        return this.m_oSCMGroupMgr.hasAccounts(oSCMGroup);
    }

    public SCMGroups getAllSubGroups(MethodContext _oMethodContext) throws Throwable {
        int nParentGroupId = _oMethodContext.getValue("ParentGroupId", 0);
        SCMGroup oParentGroup = SCMGroup.findById(nParentGroupId);
        if (oParentGroup == null) {
            throw new WCMException("ID\u53f7\u4e3a[" + nParentGroupId + "]\u7684\u5206\u7ec4\u6ca1\u6709\u627e\u5230\uff01");
        }
        if (!SCMAuthServer.hasRightInGroup(this.getLoginUser(), oParentGroup, 6)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u5206\u7ec4\u6ca1\u6709\u67e5\u770b\u6743\u9650\uff01");
        }
        SCMGroups oSCMGroups = this.m_oSCMGroupMgr.getAllSubGroups(oParentGroup);
        if (oSCMGroups == null) {
            return null;
        }
        return oSCMGroups;
    }

    public SCMGroups getAllUserCanMgrGroups(MethodContext _oMethodContext) throws Throwable {
        User currUser;
        int nUserId = _oMethodContext.getValue("UserId", 0);
        if (nUserId == 0) {
            currUser = this.getLoginUser();
        } else {
            currUser = User.findById(nUserId);
            if (currUser == null) {
                currUser = this.getLoginUser();
            }
        }
        SCMGroups oSCMGroups = this.m_oSCMGroupMgr.getAllUserCanMgrGroups(currUser);
        if (oSCMGroups == null) {
            return null;
        }
        return oSCMGroups;
    }

    public SCMGroups getSubGroups(MethodContext _oMethodContext) throws Throwable {
        int nParentGroupId = _oMethodContext.getValue("ParentGroupId", 0);
        SCMGroup oParentGroup = SCMGroup.findById(nParentGroupId);
        if (oParentGroup == null && nParentGroupId != -1) {
            throw new WCMException("ID\u53f7\u4e3a[" + nParentGroupId + "]\u7684\u5206\u7ec4\u6ca1\u6709\u627e\u5230\uff01");
        }
        SCMGroups oSCMGroups = null;
        if (nParentGroupId == -1) {
            WCMFilter oFilter = new WCMFilter("", "PARENTID=?", "");
            oFilter.addSearchValues(nParentGroupId);
            oSCMGroups = SCMGroups.openWCMObjs(null, oFilter);
        } else {
            if (!SCMAuthServer.hasRightInGroup(this.getLoginUser(), oParentGroup, 6)) {
                throw new WCMException("\u60a8\u5bf9\u8be5\u5206\u7ec4\u6ca1\u6709\u67e5\u770b\u6743\u9650\uff01");
            }
            oSCMGroups = this.m_oSCMGroupMgr.getSubGroups(oParentGroup);
        }
        if (oSCMGroups == null) {
            return null;
        }
        SCMGroups oReturnGroups = SCMGroups.createNewInstance(this.getLoginUser());
        for (int i = 0; i < oSCMGroups.size(); ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
            if (oSCMGroup == null || !SCMAuthServer.hasRightInGroup(this.getLoginUser(), oSCMGroup, 6)) continue;
            oReturnGroups.addElement(oSCMGroup);
        }
        if (oReturnGroups == null || oReturnGroups.size() == 0) {
            return null;
        }
        return oReturnGroups;
    }

    private User getLoginUser() {
        User oLoginUser = ContextHelper.getLoginUser();
        return oLoginUser;
    }

    public List<SCMGroup> getNavByCurrId(MethodContext _oMethodContext) throws Throwable {
        ArrayList<SCMGroup> pGroups = new ArrayList<SCMGroup>();
        int nSCMGroupId = _oMethodContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup.getParent() == null) {
            return null;
        }
        pGroups.add(oSCMGroup);
        SCMGroup tempSCMGroup = (SCMGroup)oSCMGroup.clone();
        while (tempSCMGroup.getParent() != null) {
            pGroups.add(tempSCMGroup.getParent());
            tempSCMGroup = tempSCMGroup.getParent();
        }
        return pGroups;
    }
}

