/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.scm.sdk.impl.AbstractFavoriteMgr;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.Favorite;
import com.trs.scm.sdk.model.FavoriteWrapper;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.T163ErrorMessage;
import com.trs.scm.sdk.util.T163ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import t4j.TBlog;
import t4j.data.Paging;
import t4j.data.Status;
import t4j.data.User;

public class T163FavoriteMgr
extends AbstractFavoriteMgr {
    private static Logger logger = Logger.getLogger(T163FavoriteMgr.class);
    private final String SINCE_ID = "Since_Id";
    private static Map<String, FavoriteWrapper> m_OAuthFavoriteMap = null;
    private static Map<String, CMyDateTime> m_oLastRefreshDate = null;
    private OAuth m_oT163OAuth;
    private TBlog tBlog;

    public T163FavoriteMgr(OAuth auth) {
        super(auth);
        this.m_oT163OAuth = auth;
        this.tBlog = new TBlog();
        this.tBlog.setToken(auth.getOAuth_token(), auth.getOAuth_token_secret());
    }

    @Override
    public Favorite createFavorite(String microContentId) throws Exception {
        if (microContentId == null || microContentId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        Status status = null;
        Favorite oResult = null;
        try {
            status = this.tBlog.createFavorite(Long.parseLong(microContentId));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        try {
            oResult = T163ObjectUtil.constructMicroFavorite(status, this.tBlog);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaFavorite\u5bf9\u8c61\u629b\u9519\uff01");
            this.reSetCache();
            throw new Exception("\u521b\u5efaFavorite\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        this.reSetCache();
        return oResult;
    }

    @Override
    public boolean destroyFavorite(String microContentId) throws Exception {
        if (microContentId == null || microContentId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        boolean bool = false;
        Status status = null;
        try {
            status = this.tBlog.destroyFavorite(Long.parseLong(microContentId));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            this.reSetCache();
            throw oCMyException;
        }
        if (status != null) {
            bool = true;
        }
        if (bool) {
            this.reSetCache();
            return true;
        }
        return false;
    }

    @Override
    public FavoriteWrapper getFavorites(int _nPageIndex, int _nPageSize, ExtraParams extraParams) throws Exception {
        boolean bRefreshed = this.refreshIfNeed(_nPageIndex, _nPageSize, extraParams);
        String sAccessToken = this.m_oT163OAuth.getOAuth_token();
        FavoriteWrapper oFavoriteWrapper = m_OAuthFavoriteMap.get(sAccessToken);
        if (oFavoriteWrapper == null) {
            return null;
        }
        if (bRefreshed) {
            return this.constructResult(_nPageIndex, _nPageSize, oFavoriteWrapper);
        }
        int nToIndex = _nPageIndex * _nPageSize;
        List<Favorite> favorites = oFavoriteWrapper.getFavorites();
        int nListSize = favorites.size();
        if (nListSize >= nToIndex) {
            return this.constructResult(_nPageIndex, _nPageSize, oFavoriteWrapper);
        }
        extraParams.setParam("Since_Id", favorites.get(nListSize - 1).getExtraAttribute("Cursor_Id"));
        oFavoriteWrapper = this.loadFavorites(oFavoriteWrapper, _nPageIndex, _nPageSize, extraParams);
        if (m_OAuthFavoriteMap == null) {
            m_OAuthFavoriteMap = new HashMap<String, FavoriteWrapper>();
        }
        if (m_oLastRefreshDate == null) {
            m_oLastRefreshDate = new HashMap<String, CMyDateTime>();
        }
        m_OAuthFavoriteMap.put(sAccessToken, oFavoriteWrapper);
        m_oLastRefreshDate.put(sAccessToken, CMyDateTime.now());
        return this.constructResult(_nPageIndex, _nPageSize, oFavoriteWrapper);
    }

    private boolean refreshIfNeed(int _nPageIndex, int _nPageSize, ExtraParams extraParams) throws Exception {
        String sAccessToken = this.m_oT163OAuth.getOAuth_token();
        boolean bIsSatisfied = false;
        FavoriteWrapper favoriteWrapper = null;
        if (m_OAuthFavoriteMap != null) {
            favoriteWrapper = m_OAuthFavoriteMap.get(sAccessToken);
        }
        if (favoriteWrapper != null) {
            boolean bl = bIsSatisfied = favoriteWrapper.getFavorites().size() >= _nPageIndex * _nPageSize;
        }
        if (!this.needRefresh() && bIsSatisfied) {
            return false;
        }
        favoriteWrapper = !bIsSatisfied && favoriteWrapper != null ? this.loadFavorites(favoriteWrapper, _nPageIndex, _nPageSize, extraParams) : this.loadFavorites(null, _nPageIndex, _nPageSize, extraParams);
        if (m_OAuthFavoriteMap == null) {
            m_OAuthFavoriteMap = new HashMap<String, FavoriteWrapper>();
        }
        if (m_oLastRefreshDate == null) {
            m_oLastRefreshDate = new HashMap<String, CMyDateTime>();
        }
        m_OAuthFavoriteMap.put(sAccessToken, favoriteWrapper);
        m_oLastRefreshDate.put(sAccessToken, CMyDateTime.now());
        return true;
    }

    private FavoriteWrapper loadFavorites(FavoriteWrapper favoriteWrapper, int _nPageIndex, int _nPageSize, ExtraParams extraParams) throws Exception {
        if (_nPageSize < 1 || _nPageSize > 70) {
            throw new Exception("\u8f93\u5165\u7684\u9875\u9762\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u9875\u9762\u5927\u5c0f\u8303\u56f4\u4e3a\uff1a1-70\u3002");
        }
        if (_nPageIndex < 1) {
            _nPageIndex = 1;
        }
        FavoriteWrapper oAllCachedWrapper = favoriteWrapper;
        FavoriteWrapper oNewestWrapper = null;
        Paging page = null;
        int nRequestNumber = 0;
        if (oAllCachedWrapper == null) {
            nRequestNumber = _nPageSize * _nPageIndex;
            page = T163ObjectUtil.constructPaging(nRequestNumber + 1, null);
            oNewestWrapper = this.loadFavorites(page);
            if (oNewestWrapper != null && oNewestWrapper.getFavorites().size() >= nRequestNumber) {
                oNewestWrapper.setTotalNumber(100L);
            }
            return oNewestWrapper;
        }
        extraParams.setParam("Since_Id", oAllCachedWrapper.getExtraAttribute("Since_Id"));
        int nToIndex = _nPageIndex * _nPageSize;
        int nListSize = oAllCachedWrapper.getFavorites().size();
        nRequestNumber = nToIndex - nListSize;
        page = T163ObjectUtil.constructPaging(nRequestNumber + 1, extraParams);
        oNewestWrapper = this.loadFavorites(page);
        oAllCachedWrapper = this.mergeWrapper(oAllCachedWrapper, oNewestWrapper);
        int nSize = oAllCachedWrapper.getFavorites().size();
        if (nSize > 100 || nSize < nToIndex) {
            oAllCachedWrapper.setTotalNumber(nSize);
        } else {
            oAllCachedWrapper.setTotalNumber(100L);
        }
        return oAllCachedWrapper;
    }

    private FavoriteWrapper loadFavorites(Paging page) throws Exception {
        FavoriteWrapper oResult = null;
        List list = null;
        try {
            User user = this.tBlog.verifyCredentials();
            list = this.tBlog.getFavorites(user.getId(), page);
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        try {
            oResult = T163ObjectUtil.constructMicroFavoriteWrapper(list, this.tBlog);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaFavoriteWrapper\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaFavoriteWrapper\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    private FavoriteWrapper constructResult(int _nPageIndex, int _nPageSize, FavoriteWrapper favoriteWrapper) {
        if (favoriteWrapper == null) {
            return null;
        }
        List<Favorite> oFavoritesList = favoriteWrapper.getFavorites();
        int nNum = oFavoritesList.size();
        if (oFavoritesList == null || nNum == 0) {
            return null;
        }
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        int nToIndex = _nPageIndex * _nPageSize;
        if (nNum <= nFromIndex) {
            nToIndex = nNum;
            nFromIndex = nNum / _nPageSize * _nPageSize;
            favoriteWrapper.setTotalNumber(nNum);
        }
        if (nNum < nToIndex) {
            nToIndex = nNum;
            favoriteWrapper.setTotalNumber(nNum);
        }
        ArrayList<Favorite> oAllFavorites = new ArrayList<Favorite>();
        oAllFavorites.addAll(oFavoritesList);
        List<Favorite> oResultFavorites = oAllFavorites.subList(nFromIndex, nToIndex);
        long nTotalNum = favoriteWrapper.getTotalNumber();
        if (favoriteWrapper.getFavorites().size() < _nPageIndex * _nPageSize + 1) {
            nTotalNum = favoriteWrapper.getFavorites().size();
        }
        FavoriteWrapper oResultfavoriteWrapper = new FavoriteWrapper(oResultFavorites, nTotalNum);
        if (oResultFavorites == null || oResultFavorites.size() == 0) {
            return oResultfavoriteWrapper;
        }
        oResultfavoriteWrapper.setExtraAttribute("Since_Id", oResultFavorites.get(oResultFavorites.size() - 1).getExtraAttribute("Cursor_Id"));
        return oResultfavoriteWrapper;
    }

    private boolean needRefresh() {
        if (m_oLastRefreshDate == null) {
            return true;
        }
        CMyDateTime oLastRefreshTime = m_oLastRefreshDate.get(this.m_oT163OAuth.getOAuth_token());
        if (oLastRefreshTime == null) {
            return true;
        }
        CMyDateTime now = CMyDateTime.now();
        return now.getTimeInMillis() - oLastRefreshTime.getTimeInMillis() > 120000L;
    }

    private FavoriteWrapper mergeWrapper(FavoriteWrapper _oHeadWrapper, FavoriteWrapper _oTailWrapper) {
        if (_oHeadWrapper == null) {
            return _oTailWrapper;
        }
        String sSince_Id = (String)_oHeadWrapper.getExtraAttribute("Since_Id");
        if (CMyString.isEmpty(sSince_Id)) {
            int nSize = _oHeadWrapper.getFavorites().size();
            sSince_Id = _oHeadWrapper.getFavorites().get(nSize - 1).getExtraAttributeAsString("Cursor_Id");
        }
        long lBaseCursor = Long.valueOf(sSince_Id.split(":")[1]);
        List<Favorite> oHeadFavorites = _oHeadWrapper.getFavorites();
        List<Favorite> oTailFavorites = null;
        if (_oTailWrapper != null) {
            oTailFavorites = _oTailWrapper.getFavorites();
        }
        if (oTailFavorites != null) {
            Favorite oTempFavorite = null;
            String sCurrCursor = "";
            long lCurrCursor = 0L;
            for (int i = 0; i < oTailFavorites.size(); ++i) {
                oTempFavorite = oTailFavorites.get(i);
                sCurrCursor = oTempFavorite.getExtraAttributeAsString("Cursor_Id").split(":")[1];
                lCurrCursor = Long.valueOf(sCurrCursor);
                if (lCurrCursor >= lBaseCursor) continue;
                oHeadFavorites.add(oTempFavorite);
            }
        }
        _oHeadWrapper.setFavorites(oHeadFavorites);
        _oHeadWrapper.setExtraAttribute("Since_Id", oHeadFavorites.get(oHeadFavorites.size() - 1).getExtraAttribute("Since_Id"));
        return _oHeadWrapper;
    }

    private void reSetCache() throws CMyException {
        String sAccessToken = this.m_oT163OAuth.getOAuth_token();
        CMyDateTime oLastRefreshedTime = CMyDateTime.now().dateAdd(5, -2);
        if (m_oLastRefreshDate != null) {
            m_oLastRefreshDate.put(sAccessToken, oLastRefreshedTime);
        }
        if (m_OAuthFavoriteMap != null) {
            m_OAuthFavoriteMap.put(sAccessToken, null);
        }
    }
}

