/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.scm.sdk.impl.AbstractCommentMgr;
import com.trs.scm.sdk.model.Comment;
import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.T163ErrorMessage;
import com.trs.scm.sdk.util.T163ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import t4j.TBlog;
import t4j.TBlogResponse;
import t4j.data.Paging;
import t4j.data.Status;

public class T163CommentMgr
extends AbstractCommentMgr {
    private static Logger logger = Logger.getLogger(T163CommentMgr.class);
    private final int COMMENTS_OF_MC = 1;
    private final int COMMENTS_BY_ME = 2;
    private final int COMMENTS_TO_ME = 3;
    private final int COMMENTS_MENTIONS = 4;
    private static Map<String, CommentWrapper> m_OAuthCommentMap = null;
    private static Map<String, CMyDateTime> m_oLastRefreshDate = null;
    private OAuth m_oT163OAuth;
    private TBlog tBlog;

    public T163CommentMgr(OAuth auth) {
        super(auth);
        this.m_oT163OAuth = auth;
        this.tBlog = new TBlog();
        this.tBlog.setToken(auth.getOAuth_token(), auth.getOAuth_token_secret());
    }

    @Override
    public Comment createComment(String content, String microContentId, ExtraParams extraParams) throws Exception {
        if (microContentId == null || microContentId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        this.checkContentLength(content);
        Status oStatus = null;
        try {
            oStatus = this.tBlog.showStatus(Long.parseLong(microContentId));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        int comment_ori = -1;
        if (oStatus.getRootInReplyToStatusId() == 0L || oStatus.getRootInReplyToStatusId() == oStatus.getId()) {
            comment_ori = extraParams.getParamAsInt("comment_ori", 0);
        }
        Object t163Comment = null;
        Status status = null;
        try {
            if (comment_ori >= 0) {
                boolean bIsRepleyComment = false;
                if (extraParams.getParam("isReplyComment") != null) {
                    bIsRepleyComment = Integer.valueOf(extraParams.getParamAsString("isReplyComment")) != 0;
                }
                status = this.tBlog.reply(Long.parseLong(microContentId), content, false, bIsRepleyComment);
            } else {
                status = this.tBlog.reply(Long.parseLong(microContentId), content);
            }
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        Comment oResult = null;
        try {
            oResult = T163ObjectUtil.constructMicroComment((TBlogResponse)status, this.tBlog);
            Long wbid = status.getInReplyToStatusId();
            MicroContent oResult1 = null;
            oResult1 = T163ObjectUtil.constructMicroContent(this.tBlog.showStatus(wbid.longValue()), this.tBlog);
            oResult.setReplyMicroContent(oResult1);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroComment\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroComment\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        String sKey = this.makeKey(2, this.m_oT163OAuth.getOAuth_token(), microContentId);
        if (m_OAuthCommentMap != null && m_OAuthCommentMap.get(sKey) != null) {
            m_oLastRefreshDate.put(sKey, CMyDateTime.now().dateAdd(5, -2));
        }
        sKey = this.makeKey(1, this.m_oT163OAuth.getOAuth_token(), microContentId);
        if (m_OAuthCommentMap != null && m_OAuthCommentMap.get(sKey) != null) {
            m_oLastRefreshDate.put(sKey, CMyDateTime.now().dateAdd(5, -2));
        }
        return oResult;
    }

    @Override
    public boolean destroyComment(String commentId) throws Exception {
        if (commentId == null || commentId.trim().length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u8bc4\u8bbaID\u4e3a\u7a7a\uff01");
        }
        boolean bool = false;
        Status status = null;
        try {
            status = this.tBlog.destroy(Long.parseLong(commentId.trim()));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        if (status != null) {
            bool = true;
            String sKey = this.makeKey(2, this.m_oT163OAuth.getOAuth_token(), null);
            if (m_OAuthCommentMap != null && m_OAuthCommentMap.get(sKey) != null) {
                m_oLastRefreshDate.put(sKey, CMyDateTime.now().dateAdd(5, -2));
            }
        }
        return bool;
    }

    @Override
    public CommentWrapper getCommentMentions(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        int nCommentType = 4;
        return this.getCommentsByType(nCommentType, null, pageIndex, pageSize, extraParams);
    }

    @Override
    public CommentWrapper getCommentsByMCId(String microContentId, int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        if (CMyString.isEmpty(microContentId)) {
            throw new WCMException("\u8f93\u5165\u7684\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        int nCommentType = 1;
        return this.getCommentsByType(nCommentType, microContentId, pageIndex, pageSize, extraParams);
    }

    @Override
    public CommentWrapper getCommentsByMe(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        int nCommentType = 2;
        return this.getCommentsByType(nCommentType, null, pageIndex, pageSize, extraParams);
    }

    @Override
    public CommentWrapper getCommentsToMe(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        int nCommentType = 3;
        return this.getCommentsByType(nCommentType, null, pageIndex, pageSize, extraParams);
    }

    @Override
    public Comment replyComment(String content, String commentId, ExtraParams extraParams) throws Exception {
        if (commentId == null || commentId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        this.checkContentLength(content);
        Comment oResult = null;
        Status status = null;
        try {
            status = this.tBlog.reply(Long.parseLong(commentId), content);
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        try {
            oResult = T163ObjectUtil.constructMicroComment((TBlogResponse)status, this.tBlog);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroComment\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroComment\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    private CommentWrapper getCommentsByType(int _nCommentType, String _sMicroContentId, int _nPageIndex, int _nPageSize, ExtraParams _extraParams) throws Exception {
        boolean bRefreshed = this.refreshIfNeed(_nCommentType, _sMicroContentId, _nPageIndex, _nPageSize, _extraParams);
        String sAccessToken = this.m_oT163OAuth.getOAuth_token();
        String sKey = this.makeKey(_nCommentType, sAccessToken, _sMicroContentId);
        CommentWrapper commentWrapper = m_OAuthCommentMap.get(sKey);
        if (bRefreshed) {
            return this.constructResult(_nPageIndex, _nPageSize, commentWrapper);
        }
        if (commentWrapper == null || commentWrapper.getComments().size() == 0) {
            return null;
        }
        int nToIndex = _nPageIndex * _nPageSize;
        List<Comment> oCommentsList = commentWrapper.getComments();
        int nListSize = oCommentsList.size();
        if (nListSize >= nToIndex) {
            return this.constructResult(_nPageIndex, _nPageSize, commentWrapper);
        }
        commentWrapper = this.loadComments(commentWrapper, _nCommentType, _sMicroContentId, _nPageIndex, _nPageSize, _extraParams);
        return this.constructResult(_nPageIndex, _nPageSize, commentWrapper);
    }

    private boolean refreshIfNeed(int _nCommentType, String _sMCId, int _nPageIndex, int _nPageSize, ExtraParams _extraParams) throws Exception {
        boolean bIsOutdated;
        String sAccessToken = this.m_oT163OAuth.getOAuth_token();
        String sKey = this.makeKey(_nCommentType, sAccessToken, _sMCId);
        boolean bIsSatisfied = false;
        CommentWrapper oCommentWrapper = null;
        if (m_OAuthCommentMap != null) {
            oCommentWrapper = m_OAuthCommentMap.get(sKey);
        }
        if (oCommentWrapper != null) {
            boolean bl = bIsSatisfied = oCommentWrapper.getComments().size() >= _nPageIndex * _nPageSize;
        }
        if (!(bIsOutdated = this.needRefresh(_nCommentType, _sMCId)) && bIsSatisfied) {
            return false;
        }
        oCommentWrapper = !bIsOutdated && !bIsSatisfied && oCommentWrapper != null ? this.loadComments(oCommentWrapper, _nCommentType, _sMCId, _nPageIndex, _nPageSize, _extraParams) : this.loadComments(null, _nCommentType, _sMCId, _nPageIndex, _nPageSize, _extraParams);
        if (m_OAuthCommentMap == null) {
            m_OAuthCommentMap = new HashMap<String, CommentWrapper>();
        }
        if (m_oLastRefreshDate == null) {
            m_oLastRefreshDate = new HashMap<String, CMyDateTime>();
        }
        m_OAuthCommentMap.put(sKey, oCommentWrapper);
        m_oLastRefreshDate.put(sKey, CMyDateTime.now());
        return true;
    }

    private CommentWrapper loadComments(CommentWrapper _oWrapper, int _nCommentType, String _sMCId, int _nPageIndex, int _nPageSize, ExtraParams _extraParams) throws Exception {
        if (_nPageSize < 1 || _nPageSize > 70) {
            throw new Exception("\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u57281-70\u4e4b\u95f4");
        }
        if (_nPageIndex < 1) {
            _nPageIndex = 1;
        }
        CommentWrapper oAllCachedWrapper = _oWrapper;
        CommentWrapper oNewestWrapper = null;
        Paging page = null;
        int nRequestNumber = 0;
        nRequestNumber = oAllCachedWrapper == null || oAllCachedWrapper.getComments().size() == 0 ? _nPageSize : _nPageIndex * _nPageSize;
        page = T163ObjectUtil.constructPaging(nRequestNumber + 1, null);
        oNewestWrapper = this.loadCommentsByType(_nCommentType, _sMCId, page);
        if (oAllCachedWrapper == null || oAllCachedWrapper.getComments().size() == 0) {
            return oNewestWrapper;
        }
        if (oNewestWrapper == null || oNewestWrapper.getComments().size() == 0) {
            return oAllCachedWrapper;
        }
        this.mergeWrapper(oAllCachedWrapper, oNewestWrapper);
        int nSize = oAllCachedWrapper.getComments().size();
        if (nSize > 100 || nSize < nRequestNumber) {
            oAllCachedWrapper.setTotalNumber(nSize);
        } else {
            oAllCachedWrapper.setTotalNumber(100L);
        }
        return oAllCachedWrapper;
    }

    private CommentWrapper loadCommentsByType(int _nCommentType, String _sMCId, Paging page) throws Exception {
        List pCommentlist = null;
        try {
            switch (_nCommentType) {
                case 4: {
                    pCommentlist = this.tBlog.getMentions(page);
                    break;
                }
                case 2: {
                    pCommentlist = this.tBlog.getCommentsByMe(page);
                    break;
                }
                case 3: {
                    pCommentlist = this.tBlog.getCommentsToMe(page);
                    break;
                }
                case 1: {
                    pCommentlist = this.tBlog.getComments(Long.parseLong(_sMCId), page);
                    break;
                }
            }
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        CommentWrapper oResult = null;
        try {
            oResult = T163ObjectUtil.constructCommentWrapper(pCommentlist, this.tBlog);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    private CommentWrapper constructResult(int _nPageIndex, int _nPageSize, CommentWrapper commentWrapper) {
        if (commentWrapper == null) {
            return null;
        }
        List<Comment> oCommentsList = commentWrapper.getComments();
        int nNum = oCommentsList.size();
        if (oCommentsList == null || nNum == 0) {
            return null;
        }
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        int nToIndex = _nPageIndex * _nPageSize;
        if (nNum <= nFromIndex) {
            nToIndex = nNum;
            nFromIndex = nNum / _nPageSize * _nPageSize;
            commentWrapper.setTotalNumber(nNum);
        }
        if (nNum < nToIndex) {
            nToIndex = nNum;
            commentWrapper.setTotalNumber(nNum);
        }
        ArrayList<Comment> oAllComments = new ArrayList<Comment>();
        oAllComments.addAll(oCommentsList);
        List<Comment> oResultComments = oAllComments.subList(nFromIndex, nToIndex);
        CommentWrapper oResultCommentWrapper = new CommentWrapper(oResultComments, commentWrapper.getTotalNumber());
        return oResultCommentWrapper;
    }

    private boolean needRefresh(int _nCommentType, String _sMCId) {
        if (m_oLastRefreshDate == null) {
            return true;
        }
        String sKey = this.makeKey(_nCommentType, this.m_oT163OAuth.getOAuth_token(), _sMCId);
        CMyDateTime oLastRefreshTime = m_oLastRefreshDate.get(sKey);
        if (oLastRefreshTime == null) {
            return true;
        }
        CMyDateTime now = CMyDateTime.now();
        return now.getTimeInMillis() - oLastRefreshTime.getTimeInMillis() > 120000L;
    }

    private CommentWrapper mergeWrapper(CommentWrapper _oCachedWrapper, CommentWrapper _oNewWrapper) {
        if (_oCachedWrapper == null || _oCachedWrapper.getComments().size() == 0) {
            return _oNewWrapper;
        }
        List<Comment> oCachedComments = _oCachedWrapper.getComments();
        List<Comment> oLatestComments = null;
        if (_oNewWrapper != null) {
            oLatestComments = _oNewWrapper.getComments();
        }
        if (oLatestComments != null) {
            int index = 0;
            while (oLatestComments.get(index).getCreateDate().compareTo(oCachedComments.get(0).getCreateDate()) > 0) {
                ++index;
            }
            if (index > 0) {
                oCachedComments.addAll(0, oLatestComments.subList(0, index));
            }
            if (oCachedComments.size() + index < oLatestComments.size()) {
                oCachedComments.addAll(oLatestComments.subList(oCachedComments.size() + index, oLatestComments.size()));
            }
        }
        _oCachedWrapper.setComments(oCachedComments);
        return _oCachedWrapper;
    }

    private String makeKey(int _nCommentType, String _sAccessToken, String _sMCId) {
        if (_sMCId == null) {
            _sMCId = "";
        }
        return _nCommentType + "_" + _sAccessToken + "_" + _sMCId;
    }
}

