/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.crawler.impl;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.scm.domain.ISCMMicroContentMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.AccountMicroContent;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.persistent.SCMRetweededMC;
import com.trs.scm.sdk.crawler.IWeiboVisitor;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroUser;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class WeiboVisitorImpl
implements IWeiboVisitor {
    private static String SCM_WEIBO_SOURCE = "\u5b98\u7f51\u95e8\u6237\u7ba1\u5bb6";
    private static final int SCM_DEFAULT_GROUP_ID = 1;
    private static final String PIC_SEPERATOR = ";";
    private static Logger logger = Logger.getLogger(WeiboVisitorImpl.class);
    private Account m_oAccount;
    private ISCMMicroContentMgr m_oSCMMicroContentMgr = null;
    private static final String SQL_EXISTS_MICROCONTENT = "SELECT ACCOUNTMICROCONTENTID FROM XWCMACCOUNTMICROCONTENT where ACCOUNTID=? AND MICROCONTENTID=?";

    public WeiboVisitorImpl(Account oAccount) throws WCMException {
        this.m_oAccount = oAccount;
        this.m_oSCMMicroContentMgr = (ISCMMicroContentMgr)DreamFactory.createObjectById("ISCMMicroContentMgr");
        SCM_WEIBO_SOURCE = ConfigServer.getServer().getSysConfigValue("SCM_WEIBO_SOURCE", SCM_WEIBO_SOURCE);
    }

    private void printInfo(MicroContent oMicroContent) {
        System.out.println("=======================================");
        logger.info((Object)oMicroContent.getUser());
        logger.info((Object)("[" + oMicroContent.getUser().getName() + "] : " + oMicroContent.getContent()));
        logger.info((Object)("CommentCount:" + oMicroContent.getCommentCount() + "; RepostCount:" + oMicroContent.getRepostCount() + "; source:" + oMicroContent.getSource()));
        System.out.println("++++++++++++++++++++++++++++++++++++++++");
    }

    @Override
    public void visit(MicroContent oMicroContent) {
        if (oMicroContent == null) {
            return;
        }
        this.printInfo(oMicroContent);
        try {
            MicroContent oRetweetedMicroContent;
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(this.m_oAccount.getKey());
            parameters.add(oMicroContent.getId());
            int nAccountMicroContentId = DBManager.getDBManager().sqlExecuteIntQuery(SQL_EXISTS_MICROCONTENT, parameters);
            if (nAccountMicroContentId > 0) {
                AccountMicroContent oAccountMicroContent = AccountMicroContent.findById(nAccountMicroContentId);
                oAccountMicroContent.setIsRetweeted(oMicroContent.isRetweeted());
                oAccountMicroContent.setCommentCount(oMicroContent.getCommentCount());
                oAccountMicroContent.setRepostCount(oMicroContent.getRepostCount());
                oAccountMicroContent.save(User.getSystem());
                return;
            }
            SCMMicroContent oSCMMicroContent = SCMMicroContent.createNewInstance();
            oSCMMicroContent.setNextId();
            oSCMMicroContent.setGroupId(1);
            if (null == oMicroContent.getContent() || "".equals(oMicroContent.getContent())) {
                oSCMMicroContent.setContent("\u8f6c\u53d1\u5fae\u535a");
            } else {
                oSCMMicroContent.setContent(oMicroContent.getContent());
            }
            oSCMMicroContent.setSource(oMicroContent.getSource());
            oSCMMicroContent.setPublishAccountIds(String.valueOf(this.m_oAccount.getId()));
            oSCMMicroContent.setIsRetweeted(oMicroContent.isRetweeted());
            if (!CMyString.isEmpty(oMicroContent.getThumbnailPic()) && !CMyString.isEmpty(oMicroContent.getBmiddlePic())) {
                oSCMMicroContent.setPicture(oMicroContent.getThumbnailPic() + PIC_SEPERATOR + oMicroContent.getBmiddlePic());
            }
            oSCMMicroContent.setCrUser(User.getSystem());
            Date createDate = oMicroContent.getCreateDate();
            oSCMMicroContent.setProperty("CRTIME", new CMyDateTime(createDate.getTime()));
            AccountMicroContent oAccountMicroContent = AccountMicroContent.createNewInstance();
            oAccountMicroContent.setAccountId(this.m_oAccount.getId());
            oAccountMicroContent.setCommentCount(oMicroContent.getCommentCount());
            oAccountMicroContent.setIsRetweeted(oMicroContent.isRetweeted());
            oAccountMicroContent.setRepostCount(oMicroContent.getRepostCount());
            oAccountMicroContent.setSCMMicroContentId(oSCMMicroContent.getId());
            oAccountMicroContent.setMicroContentId(oMicroContent.getId());
            oAccountMicroContent.setProperty("CRTIME", new CMyDateTime(createDate.getTime()));
            oAccountMicroContent.save(User.getSystem());
            if (oSCMMicroContent.isRetweeted() && null != (oRetweetedMicroContent = oMicroContent.getRetweetedMicroContent())) {
                SCMRetweededMC oRetweededMC = SCMRetweededMC.createNewInstance();
                if (oRetweetedMicroContent.isRetweeted()) {
                    oRetweetedMicroContent = oRetweetedMicroContent.getRetweetedMicroContent();
                    oRetweededMC.setOriginalMCId(oRetweetedMicroContent.getId());
                }
                oRetweededMC.setContent(oRetweetedMicroContent.getContent());
                oRetweededMC.setMCId(oRetweetedMicroContent.getId());
                oRetweededMC.setSCMMCId(oSCMMicroContent.getId());
                CMyDateTime oDate = new CMyDateTime();
                oDate.setDateTime(oRetweetedMicroContent.getCreateDate());
                oRetweededMC.setCreateDate(oDate);
                MicroUser oMicroUser = oRetweetedMicroContent.getUser();
                if (oMicroUser != null) {
                    oRetweededMC.setAccountNickName(oMicroUser.getName());
                }
                oRetweededMC.setThumbnailPic(oRetweetedMicroContent.getThumbnailPic());
                oRetweededMC.setBmiddlePic(oRetweetedMicroContent.getBmiddlePic());
                oRetweededMC.setOriginalPic(oRetweetedMicroContent.getOriginalPic());
                oRetweededMC.setSource(oRetweetedMicroContent.getSource());
                oRetweededMC.save(User.getSystem());
                oSCMMicroContent.setRetweetedID(oRetweetedMicroContent.getId());
            }
            oSCMMicroContent.save(User.getSystem());
        }
        catch (Exception e) {
            logger.error((Object)("\u5904\u7406\u5fae\u535a\u4fe1\u606f[" + oMicroContent.getContent() + "]\u65f6\u53d1\u751f\u5f02\u5e38"), (Throwable)e);
        }
    }
}

