/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.crawler.impl;

import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.crawler.IWeiboVisitor;
import com.trs.scm.sdk.crawler.impl.SCMWeiboCrawler;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.SinaErrorMessage;
import com.trs.scm.sdk.util.SinaObjectUtil;
import java.util.List;
import org.apache.log4j.Logger;
import weibo4j.Timeline;
import weibo4j.Weibo;
import weibo4j.model.Paging;
import weibo4j.model.Status;
import weibo4j.model.StatusWapper;
import weibo4j.model.WeiboException;

public class SinaWeiboCrawler
extends SCMWeiboCrawler {
    private static Logger logger = Logger.getLogger(SinaWeiboCrawler.class);
    public static int SLEEP_MILLISECONDS_IN_EVERY_REQUEST = 1000;
    public static int MAX_REQUEST_RETRY_TIMES = 3;
    private int m_nCurrRetryTimes = 0;
    private Weibo m_oWeibo = new Weibo();
    private Timeline m_oTimeline;

    public SinaWeiboCrawler(OAuth oOauth) {
        super(oOauth);
        this.m_oWeibo.setToken(this.m_oOAuth.getOAuth_token());
        this.m_oTimeline = new Timeline();
        this.m_oTimeline.setToken(this.m_oOAuth.getOAuth_token());
    }

    @Override
    public void execute(IWeiboVisitor visitor) {
        ExtraParams extraParams = this.getExtraParams();
        int nPageIndex = extraParams.getParamAsInt("PageIndex", 0);
        int nPageSize = extraParams.getParamAsInt("PageSize", 200);
        int nPageNum = extraParams.getParamAsInt("PageNum", 10);
        int nPageFlag = extraParams.getParamAsInt("PageFlag", 0);
        boolean bIsSetNum = false;
        int nDestPageNum = nPageIndex + nPageNum;
        long lGrapWeiboCounts = 0L;
        if (nPageFlag == 2) {
            bIsSetNum = true;
        }
        if (nPageSize > 200) {
            nPageSize = 200;
        }
        while (true) {
            this.m_nCurrRetryTimes = 0;
            StatusWapper oStatusWapper = this.getWeiboInPage(nPageIndex, nPageSize);
            if (oStatusWapper == null) {
                return;
            }
            List oStatusList = oStatusWapper.getStatuses();
            if (null != oStatusList && oStatusList.size() > 0) {
                lGrapWeiboCounts += (long)oStatusList.size();
            }
            for (int i = 0; i < oStatusList.size(); ++i) {
                Status oStatus = (Status)oStatusList.get(i);
                if (oStatus == null) continue;
                MicroContent oMicroContent = null;
                try {
                    oMicroContent = SinaObjectUtil.constructMicroContent(oStatus);
                }
                catch (Exception _oException) {
                    throw new RuntimeException("\u6784\u9020MicroContent\u629b\u9519\uff01", _oException);
                }
                if (oMicroContent == null) continue;
                visitor.visit(oMicroContent);
            }
            long lTotalNumber = oStatusWapper.getTotalNumber();
            if ((long)((++nPageIndex - 1) * nPageSize) > lTotalNumber || bIsSetNum && nPageIndex >= nDestPageNum) {
                return;
            }
            try {
                Thread.sleep(SLEEP_MILLISECONDS_IN_EVERY_REQUEST);
                continue;
            }
            catch (InterruptedException e) {
                logger.debug((Object)"\u5c1d\u8bd5\u7ebf\u7a0b\u7761\u7720\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private StatusWapper getWeiboInPage(int pageIndex, int pageSize) {
        ExtraParams extraParams = this.getExtraParams();
        String sUID = extraParams.getParamAsString("UserId");
        Paging page = null;
        if (pageSize < 1 || pageSize > 200) {
            throw new RuntimeException("\u8f93\u5165\u7684\u9875\u9762\u5927\u5c0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u9875\u9762\u5927\u5c0f\u8303\u56f4\u4e3a\uff1a1-200\u3002");
        }
        int nPageIndex = pageIndex;
        int nPageSize = pageSize;
        if (pageIndex < 1) {
            nPageIndex = 1;
        }
        page = new Paging(nPageIndex, nPageSize);
        int base_app = extraParams.getParamAsInt("base_app", 0);
        int feature = extraParams.getParamAsInt("feature", 0);
        StatusWapper oSinaStatusWapper = null;
        try {
            oSinaStatusWapper = this.m_oTimeline.getUserTimelineByUid(sUID, page, new Integer(base_app), new Integer(feature));
        }
        catch (WeiboException _oWeiboException) {
            if (_oWeiboException.getErrorCode() == -1) {
                if (this.m_nCurrRetryTimes > MAX_REQUEST_RETRY_TIMES) {
                    logger.error((Object)("\u8bf7\u6c42\u8d85\u51fa\u4e86\u5c1d\u8bd5\u7684\u6700\u5927\u6b21\u6570[" + MAX_REQUEST_RETRY_TIMES + "]"), (Throwable)_oWeiboException);
                    return null;
                }
                ++this.m_nCurrRetryTimes;
                int nTimeOut = extraParams.getParamAsInt("TimeOut", 0);
                if (nTimeOut < 3) {
                    extraParams.setParam("TimeOut", nTimeOut + 1);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.getWeiboInPage(nPageIndex, nPageSize);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)("\u83b7\u53d6\u65b0\u6d6a\u5fae\u535a\u5185\u5bb9\u65f6\u51fa\u73b0\u5f02\u5e38:" + oCMyException.getMyMessage()), (Throwable)_oWeiboException);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u65b0\u6d6a\u5fae\u535a\u5185\u5bb9\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return oSinaStatusWapper;
    }
}

