/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.persistent;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.scm.publish.persistent.SCMMCPublishTasks;

public class SCMMicroContent
extends CMSObj {
    public static final int OBJ_TYPE = 1844552626;
    public static final String DB_TABLE_NAME = "XWCMSCMMICROCONTENT";
    public static final String DB_ID_NAME = "SCMMICROCONTENTID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1844552626;
    }

    public String getContent() {
        return this.getPropertyAsString("CONTENT");
    }

    public boolean setContent(String _sContent) throws WCMException {
        return this.setProperty("CONTENT", _sContent);
    }

    public String getPicture() {
        return this.getPropertyAsString("PICTURE");
    }

    public boolean setPicture(String _sPicture) throws WCMException {
        return this.setProperty("PICTURE", _sPicture);
    }

    public boolean isRetweeted() {
        return this.getPropertyAsBoolean("ISRETWEETED", false);
    }

    public String getRetweetedID() {
        return this.getPropertyAsString("RETWEETEDMICROCONTENTID");
    }

    public boolean setRetweetedID(String _nRetweetedID) throws WCMException {
        return this.setProperty("RETWEETEDMICROCONTENTID", _nRetweetedID);
    }

    public boolean setIsRetweeted(boolean _isRetweeted) throws WCMException {
        if (_isRetweeted) {
            return this.setProperty("ISRETWEETED", 1L);
        }
        return this.setProperty("ISRETWEETED", 0L);
    }

    public String getPublishAccountIds() {
        return this.getPropertyAsString("PUBLISHACCOUNTIDS", "");
    }

    public boolean setPublishAccountIds(String _PublishAccountIds) throws WCMException {
        return this.setProperty("PUBLISHACCOUNTIDS", _PublishAccountIds);
    }

    public Status getFlowStatus() throws WCMException {
        int nStatusId = this.getStatusId();
        if (nStatusId != 30 && nStatusId != 10) {
            return Status.findById(nStatusId);
        }
        return null;
    }

    public int getStatusId() {
        return this.getPropertyAsInt("FLOWSTATUS", -1);
    }

    public boolean setStatus(int _Status2) throws WCMException {
        return this.setProperty("FLOWSTATUS", _Status2);
    }

    public CMyDateTime getReviewTime() {
        return (CMyDateTime)this.getProperty("REVIEWTIME");
    }

    public boolean setReviewTime(CMyDateTime _dtReviewTime) throws WCMException {
        return this.setProperty("REVIEWTIME", _dtReviewTime);
    }

    public String getSource() {
        return this.getPropertyAsString("SOURCE");
    }

    public boolean setSource(String _sSource) throws WCMException {
        return this.setProperty("SOURCE", _sSource);
    }

    public int getGroupId() {
        return this.getPropertyAsInt("SCMGROUPID", 0);
    }

    public boolean setGroupId(int _GroupId) throws WCMException {
        return this.setProperty("SCMGROUPID", _GroupId);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("CONTENT") == null) {
                throw new WCMException(1106, "\u5c5e\u6027Content\u6ca1\u6709\u8bbe\u7f6e(SCMMicroContent.isValid)");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(SCMMicroContent.isValid)");
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final SCMMicroContent findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (SCMMicroContent)BaseObj.findById(SCMMicroContent.class, _nId);
    }

    public static final SCMMicroContent createNewInstance() throws WCMException {
        return (SCMMicroContent)BaseObj.createNewInstance(SCMMicroContent.class);
    }

    public static final SCMMicroContent findByKey(Object _oKey) throws WCMException {
        return (SCMMicroContent)BaseObj.findByKey(SCMMicroContent.class, _oKey);
    }

    public static final SCMMCPublishTasks findTasksBySCMMID(int SCMMCId) throws WCMException {
        WCMFilter oFilter = new WCMFilter("XWCMSCMMCPUBLISHTASK", "SCMMCID = ?", "");
        oFilter.addSearchValues(SCMMCId);
        return SCMMCPublishTasks.openWCMObjs(ContextHelper.getLoginUser(), oFilter);
    }

    @Override
    public String toString() {
        String sContent = CMyString.showNull(this.getContent());
        return sContent.length() < 20 ? sContent : sContent.substring(0, 20) + "...";
    }

    public static FlowDocs getFlowDocs(int nMCId, User user) {
        try {
            SCMMicroContent sc = SCMMicroContent.findById(nMCId);
            Status fs = sc.getFlowStatus();
            WCMFilter filter = new WCMFilter("wcmflowdoc", "ObjType=? and ObjId=? and ParentId=0", "PostTime desc, FlowDocId desc");
            filter.addSearchValues("1844552626");
            filter.addSearchValues(nMCId);
            FlowDocs oFlowDocs = null;
            oFlowDocs = FlowDocs.openWCMObjs(user, filter);
            if (oFlowDocs == null || oFlowDocs.size() == 0) {
                return null;
            }
            return oFlowDocs;
        }
        catch (WCMException e) {
            e.printStackTrace();
            return null;
        }
    }
}

