/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.tools;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.service.ITemplateService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SceneAutoCreator {
    private WebSites oWebSites = null;
    private WebSite newSite = null;
    private String localPath = null;
    private String sNewFileName = null;
    private BaseChannel baseChannel = null;
    private ITemplateService currTemplateService = (ITemplateService)DreamFactory.createObjectById("ITemplateService");
    private WCMFolderPublishConfig currPublishConfig = null;

    public int Create() throws Exception {
        WCMFilter filter = new WCMFilter("", "SITENAME=?", "");
        filter.addSearchValues(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label1", "\u573a\u666f\u5f0f\u670d\u52a1"));
        this.oWebSites = WebSites.openWCMObjs(ContextHelper.getLoginUser(), filter);
        if (!this.oWebSites.isEmpty()) {
            return this.oWebSites.getIdAt(0);
        }
        int result = this.createSite();
        this.localPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        this.localPath = CMyString.setStrEndWith(this.localPath, File.separatorChar);
        this.localPath = this.localPath + "scene" + File.separatorChar + "data" + File.separatorChar + "default_load.zip";
        this.sNewFileName = FilesMan.getFilesMan().getNextFilePathName("U0", "zip");
        CMyFile.copyFile(this.localPath, this.sNewFileName);
        this.baseChannel = this.newSite;
        this.currTemplateService.importFromZip(this.baseChannel, this.sNewFileName, 1, 1, null);
        this.changeTempName();
        this.copyImage();
        return result;
    }

    private int createSite() throws WCMException {
        User loginUser = this.getLoginUser();
        this.newSite = WebSite.createNewInstance();
        this.newSite.setName(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label1", "\u573a\u666f\u5f0f\u670d\u52a1"));
        this.newSite.setDesc(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label1", "\u573a\u666f\u5f0f\u670d\u52a1"));
        this.newSite.setParent(0);
        this.newSite.save();
        IPublishElement publishElement = PublishElementFactory.lookupElement(103, this.newSite.getId());
        this.currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        this.currPublishConfig.setFolderType(103, this.newSite.getId());
        this.currPublishConfig.setDataPath("scene");
        this.currPublishConfig.setRootDomain("http://127.0.0.1:8080/pub/scene");
        this.currPublishConfig.canEdit(loginUser);
        this.currPublishConfig.setDefineStatus(true);
        this.currPublishConfig.setStatusesCanDoPub("10,1,2");
        this.currPublishConfig.setPageEncoding("utf-8");
        this.currPublishConfig.save(loginUser);
        return this.newSite.getId();
    }

    public void changeTempName() throws CMyException {
        IPublishFolder root = (IPublishFolder)PublishElementFactory.makeElementFrom(this.baseChannel);
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
        String localPath1 = sWCMPath + "scene" + File.separatorChar + "images" + File.separatorChar + "moban.gif";
        String sNewFileName1 = FilesMan.getFilesMan().getNextFilePathName("P0", "gif");
        CMyFile.copyFile(localPath1, sNewFileName1);
        String realFileName = CMyFile.extractFileName(sNewFileName1);
        Template currTemplate = templateCacheMgr.lookupByName(root, I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label2", "scene_defaultIndex_HTML"));
        currTemplate.setDesc(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label3", "\u573a\u666f\u5f0f"));
        currTemplate.setAttribute("TempPicName", realFileName);
        currTemplate.save();
        currTemplate = templateCacheMgr.lookupByName(root, "scene_documentList");
        currTemplate.setOutputFileName("documentlist");
        currTemplate.save();
        currTemplate = templateCacheMgr.lookupByName(root, "scene_serviceProcess_XML");
        currTemplate.setOutputFileName("scene");
        currTemplate.save();
        String sImgFile = sWCMPath + "scene" + File.separatorChar + "images" + File.separatorChar + "flash.gif";
        String sNewFileName2 = FilesMan.getFilesMan().getNextFilePathName("P0", "gif");
        CMyFile.copyFile(sImgFile, sNewFileName2);
        String realFileName2 = CMyFile.extractFileName(sNewFileName2);
        currTemplate = templateCacheMgr.lookupByName(root, "scene_defaultIndex_Flash");
        currTemplate.setDesc(I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label3", "\u573a\u666f\u5f0f"));
        currTemplate.setAttribute("TempPicName", realFileName2);
        currTemplate.save();
    }

    public void copyImage() throws CMyException {
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
        String localSoucePath = sWCMPath + "scene" + File.separatorChar + "data" + File.separator + "images";
        String localDocPath = FilesMan.getFilesMan().getPathConfigValue("LV", 0);
        String[] temp = localDocPath.split(";");
        String DomiPath = temp[0];
        DomiPath = DomiPath + File.separatorChar + "scene";
        FileService sourceFolder = new FileService(localSoucePath);
        FileService dominateFolder = new FileService(DomiPath);
        SceneAutoCreator.copy(sourceFolder, dominateFolder);
        String localDocPath1 = FilesMan.getFilesMan().getPathConfigValue("LP", 0);
        String[] temp1 = localDocPath1.split(";");
        String DomiPath1 = temp1[0];
        DomiPath1 = DomiPath1 + File.separatorChar + "scene";
        FileService dominateFolder1 = new FileService(DomiPath1);
        SceneAutoCreator.copy(sourceFolder, dominateFolder1);
    }

    public void deleteAll() throws WCMException {
        WCMFilter filter = new WCMFilter("", "SITENAME=?", "");
        filter.addSearchValues(0, I18NMessage.get(SceneAutoCreator.class, "SceneAutoCreator.label1", "\u573a\u666f\u5f0f\u670d\u52a1"));
        WebSites oWebSites = WebSites.openWCMObjs(ContextHelper.getLoginUser(), filter);
        if (oWebSites.size() != 0) {
            oWebSites.removeAll(true);
        }
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    public static void copy(FileStore source, FileStore target) {
        FileService tarpath = new FileService(target, source.getName());
        if (source.isDirectory()) {
            tarpath.mkdir();
            FileStore[] dir = source.listFiles();
            for (int i = 0; i < dir.length; ++i) {
                SceneAutoCreator.copy(dir[i], tarpath);
            }
        } else {
            try {
                InputStream is = source.getInputStream();
                OutputStream os = tarpath.getOutputStream();
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = is.read(buf)) != -1) {
                    os.write(buf, 0, len);
                }
                is.close();
                os.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

