/*
 * Decompiled with CFR 0.152.
 */
package com.trs.recycle.service;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.ObjectTypesFinder;
import com.trs.recycle.IObjRecycleMgr;
import com.trs.recycle.ObjectRecycleMgrFactory;
import com.trs.recycle.ObjectRecycleXmlHandler;
import com.trs.recycle.RecycleObjConfXML;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ObjRecycleServiceProvider
implements IGlueServiceProvider {
    public static String RECYCLE_DELETE = "delete";
    public static String RECYCLE_RESTORE = "restore";
    public static String RECYCLE_QUERY = "query";
    public static String RECYCLE_DROP = "drop";
    private static Logger s_logger = Logger.getLogger(ObjRecycleServiceProvider.class);

    @Override
    public void delete(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        String sObjectIds = context.getValue("ObjectIds");
        int nObjectType = context.getValue("ObjectType", 0);
        int nHostId = context.getValue("HostId", 0);
        int nHostType = context.getValue("HostType", 0);
        String[] objectids = sObjectIds.split(",");
        for (int i = 0; i < objectids.length; ++i) {
            int nObjectId = Integer.parseInt(objectids[i]);
            CMSObj oCurrObj = (CMSObj)CMSObj.findById(nObjectType, nObjectId);
            if (oCurrObj == null) continue;
            RecycleObjConfXML objConfig = ObjectRecycleXmlHandler.newInstance().getObject(nObjectType);
            int rightValue = objConfig.getRightValue(RECYCLE_DELETE);
            if (!AuthServer.hasRight(loginUser, oCurrObj, rightValue)) {
                throw new WCMException("\u5f53\u524d\u7528\u6237\uff1a\u3010" + loginUser.getName() + "\u3011\u5bf9\u5bf9\u8c61\u3010ID:" + nObjectId + "-TYPE:" + nObjectType + "\u3011\u65e0\u64cd\u4f5c\u6743\u9650");
            }
            HashMap recycleMgrs = ObjectRecycleMgrFactory.getObjRecycleMgrs();
            IObjRecycleMgr oObjRecycleMgr = (IObjRecycleMgr)recycleMgrs.get(String.valueOf(nObjectType));
            try {
                oObjRecycleMgr.delete(oCurrObj, loginUser, nHostId, nHostType);
                continue;
            }
            catch (Exception e) {
                s_logger.info((Object)("\u5220\u9664\u5bf9\u8c61\u3010ID\uff1a" + nObjectId + "-TYPE:" + nObjectType + "\u3011\u5931\u8d25"));
            }
        }
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        RecycleObjConfXML objConfig;
        int rightValue;
        CMSObj oCurrObj;
        User loginUser = ContextHelper.getLoginUser();
        int nObjectType = context.getValue("FILTERTYPE", 102);
        int nHostId = context.getValue("HostId", 0);
        int nHostType = context.getValue("HostType", 0);
        if (nObjectType == 0) {
            nObjectType = 102;
            context.setValue("FILTERTYPE", nObjectType);
        }
        if (!AuthServer.hasRight(loginUser, oCurrObj = (CMSObj)CMSObj.findById(nHostType, nHostId), rightValue = (objConfig = ObjectRecycleXmlHandler.newInstance().getObject(nObjectType)).getRightValue(RECYCLE_DELETE))) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\uff1a\u3010" + loginUser.getName() + "\u3011\u6ca1\u6709\u6d4f\u89c8\u3010ID:" + nHostId + "-TYPE:" + nHostType + "\u3011\u7684\u6d4f\u89c8\u6743\u9650");
        }
        HashMap recycleMgrs = ObjectRecycleMgrFactory.getObjRecycleMgrs();
        IObjRecycleMgr oObjRecycleMgr = (IObjRecycleMgr)recycleMgrs.get(String.valueOf(nObjectType));
        return oObjRecycleMgr.query(nObjectType, nHostId, nHostType);
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        return 0;
    }

    public void restore(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        String sObjectIds = context.getValue("ObjectIds");
        int nObjectType = context.getValue("ObjectType", 0);
        Class clazz = ObjectTypesFinder.findObjectClassByType(nObjectType);
        String sDbTable = ((BaseObj)clazz.newInstance()).getDbTableName() + "RECYCLE";
        String[] objectids = sObjectIds.split(",");
        for (int i = 0; i < objectids.length; ++i) {
            int nObjectId = Integer.parseInt(objectids[i]);
            DefaultObj oCurrRecycleObj = DefaultObj.findById(nObjectId, sDbTable, "RECYCLEID");
            if (oCurrRecycleObj == null) continue;
            System.out.println("1111111==" + oCurrRecycleObj.getPropertyAsString("TEMPTEXT"));
            Hashtable<String, Object> recycleProp = oCurrRecycleObj.getAllProperty();
            recycleProp.remove("RECYCLEID");
            recycleProp.remove("HOSTID");
            recycleProp.remove("HOSTTYPE");
            recycleProp.remove("OPUSER");
            recycleProp.remove("OPTIME");
            CMSObj currOriObj = (CMSObj)clazz.newInstance();
            int nOriObjId = ((Number)recycleProp.get(currOriObj.getIdFieldName())).intValue();
            if (nOriObjId < 1) continue;
            currOriObj.setId(nOriObjId);
            currOriObj.setProperties(recycleProp);
            System.out.println("222222222==" + currOriObj.getPropertyAsString("TEMPTEXT"));
            RecycleObjConfXML objConfig = ObjectRecycleXmlHandler.newInstance().getObject(nObjectType);
            int rightValue = objConfig.getRightValue(RECYCLE_RESTORE);
            if (!AuthServer.hasRight(loginUser, currOriObj, rightValue)) {
                throw new WCMException("\u5f53\u524d\u7528\u6237\uff1a\u3010" + loginUser.getName() + "\u3011\u6ca1\u6709\u6d4f\u89c8\u3010ID:" + nOriObjId + "-TYPE:" + nObjectType + "\u3011\u7684\u6d4f\u89c8\u6743\u9650");
            }
            HashMap recycleMgrs = ObjectRecycleMgrFactory.getObjRecycleMgrs();
            IObjRecycleMgr oObjRecycleMgr = (IObjRecycleMgr)recycleMgrs.get(String.valueOf(nObjectType));
            try {
                oObjRecycleMgr.restore(currOriObj);
            }
            catch (Exception e) {
                s_logger.info((Object)("\u8fd8\u539f\u5bf9\u8c61\u3010ID\uff1a" + nObjectId + "-TYPE:" + nObjectType + "\u3011\u5931\u8d25"));
            }
            try {
                oCurrRecycleObj.delete();
                continue;
            }
            catch (Exception e) {
                s_logger.info((Object)("\u8fd8\u539f\u5bf9\u8c61\u65f6\uff0c\u5220\u9664\u56de\u6536\u7ad9\u4e2d\u5bf9\u8c61\u3010ID\uff1a" + nObjectId + "-TYPE:" + nObjectType + "\u3011\u5931\u8d25"));
            }
        }
    }

    public void drop(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        String sObjectIds = context.getValue("ObjectIds");
        int nObjectType = context.getValue("ObjectType", 0);
        Class clazz = ObjectTypesFinder.findObjectClassByType(nObjectType);
        String sDbTable = ((BaseObj)clazz.newInstance()).getDbTableName() + "RECYCLE";
        String[] objectids = sObjectIds.split(",");
        for (int i = 0; i < objectids.length; ++i) {
            int nObjectId = Integer.parseInt(objectids[i]);
            DefaultObj oCurrRecycleObj = DefaultObj.findById(nObjectId, sDbTable, "RECYCLEID");
            if (oCurrRecycleObj == null) continue;
            Hashtable<String, Object> recycleProp = oCurrRecycleObj.getAllProperty();
            recycleProp.remove("RECYCLEID");
            recycleProp.remove("HOSTID");
            recycleProp.remove("HOSTTYPE");
            recycleProp.remove("OPUSER");
            recycleProp.remove("OPTIME");
            CMSObj currOriObj = (CMSObj)clazz.newInstance();
            int nOriObjId = ((Number)recycleProp.get(currOriObj.getIdFieldName())).intValue();
            if (nOriObjId < 1) continue;
            currOriObj.setId(nOriObjId);
            currOriObj.setProperties(recycleProp);
            RecycleObjConfXML objConfig = ObjectRecycleXmlHandler.newInstance().getObject(nObjectType);
            int rightValue = objConfig.getRightValue(RECYCLE_DROP);
            if (!AuthServer.hasRight(loginUser, currOriObj, rightValue)) {
                throw new WCMException("\u5f53\u524d\u7528\u6237\uff1a\u3010" + loginUser.getName() + "\u3011\u6ca1\u6709\u5bf9\u8c61\u3010ID:" + nObjectId + "-TYPE:" + nObjectType + "\u3011\u7684\u5220\u9664\u6743\u9650");
            }
            HashMap recycleMgrs = ObjectRecycleMgrFactory.getObjRecycleMgrs();
            IObjRecycleMgr oObjRecycleMgr = (IObjRecycleMgr)recycleMgrs.get(String.valueOf(nObjectType));
            try {
                oObjRecycleMgr.dropObj(oCurrRecycleObj, loginUser);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }
}

