/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.DreamFactory;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.presentation.nav.INavHandler;
import java.util.Map;

public class ClassInfoNavHandler
implements INavHandler {
    private static final String ITEM_KEY = "classinfo";
    private MetaView m_oCurrView = null;

    @Override
    public String makeDefaultMainURL() throws WCMException {
        if (this.m_oCurrView == null) {
            throw new WCMException(I18NMessage.get(ClassInfoNavHandler.class, "ClassInfoNavHandler.label1", "\u4f7f\u7528\u9519\u8bef\uff0c\u5fc5\u987b\u5148\u8c03toNavInfoJSON\u65b9\u6cd5\uff01"));
        }
        IMetaDataDefMgr oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        ClassInfos oClassInfos = oMetaDataDefMgr.getClassInfosUsingMetaView(null, this.m_oCurrView);
        int nClassInfoId = 0;
        if (!oClassInfos.isEmpty()) {
            nClassInfoId = oClassInfos.getIdAt(0);
        }
        int nViewId = this.m_oCurrView.getId();
        String sURL = "metadata/application/" + nViewId + "/list_of_view_cls.jsp";
        sURL = sURL + "?viewId=" + nViewId;
        sURL = sURL + "&classinfoid=" + nClassInfoId;
        return sURL;
    }

    @Override
    public String toHandlerkey() {
        return ITEM_KEY;
    }

    @Override
    public String toNavInfoJSON(Map _oArguments) throws WCMException {
        String sViewDesc = (String)_oArguments.get("ViewDesc");
        this.m_oCurrView = MetaView.findByIdentity("ViewDesc", sViewDesc);
        if (this.m_oCurrView == null) {
            throw new WCMException(I18NMessage.get(ClassInfoNavHandler.class, "ClassInfoNavHandler.label2", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u89c6\u56fe\uff01[\u540d\u79f0=") + sViewDesc + "]");
        }
        StringBuffer sbItem = new StringBuffer(100);
        sbItem.append("{viewId : '" + this.m_oCurrView.getId() + "'\n");
        sbItem.append(",key : '" + this.m_oCurrView.getId() + "'\n");
        sbItem.append(",desc : '" + this.m_oCurrView.getDesc() + "'\n");
        sbItem.append(",cls : 'classinfo_logo'\n");
        sbItem.append(",container : 'tr_classInfo'}\n");
        return "navMode : 2,\nitem : " + sbItem + ",\n";
    }
}

