/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.jsputil;

import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class JspCheckerWithLogin {
    private static final int HTTP_OK = 200;
    private static final int HTTP_NOT_FOUND = 404;
    private static final int HTTP_ERROR = 500;
    private String localDir;
    private AppInfo appInfo;
    private Set includeJspSet = new HashSet(128);
    private boolean showErrorDetail = false;

    public JspCheckerWithLogin(String localDir, AppInfo appInfo) {
        this.localDir = new FileService(localDir).getAbsolutePath();
        this.appInfo = appInfo;
    }

    public void setIncludeJsp(String[] includes) {
        if (includes == null || includes.length == 0) {
            return;
        }
        this.includeJspSet.addAll(Arrays.asList(includes));
    }

    public void run() {
        System.out.println("loading jsp files from: " + this.localDir);
        List files = this.loadJspFiles();
        System.out.println("loaded, files=" + files.size());
        HttpClient client = this.login();
        if (client == null) {
            System.out.println("login failed.");
            System.exit(1);
        }
        System.out.println("testing....");
        this.test(client, files);
    }

    private void test(HttpClient client, List files) {
        int size = files.size() - 1;
        String appname = this.appInfo.appname + "/";
        boolean showDetail = this.isShowErrorDetail();
        for (int i = size; i >= 0; --i) {
            String file = (String)files.get(i);
            GetMethod getMethod = new GetMethod(appname + file);
            int status = 0;
            try {
                getMethod.setQueryString("jsp_precompile=true");
                status = client.executeMethod((HttpMethod)getMethod);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (status != 200 && status != 404) {
                System.out.println(file + "--RespCode=" + status);
            }
            if (showDetail && status == 500) {
                getMethod.setQueryString("");
                try {
                    client.executeMethod((HttpMethod)getMethod);
                    System.out.println(getMethod.getResponseBodyAsString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            getMethod.releaseConnection();
        }
    }

    private HttpClient login() {
        HttpClient client = new HttpClient();
        client.getHostConfiguration().setHost(this.appInfo.host, this.appInfo.port, "http");
        client.getParams().setContentCharset("utf-8");
        client.getParams().setCookiePolicy("compatibility");
        PostMethod authpost = new PostMethod(this.appInfo.loginPage);
        NameValuePair name = new NameValuePair(this.appInfo.loginName, this.appInfo.username);
        NameValuePair pass = new NameValuePair(this.appInfo.pwdName, this.appInfo.pwd);
        authpost.setRequestBody(new NameValuePair[]{name, pass});
        int status = 0;
        try {
            status = client.executeMethod((HttpMethod)authpost);
        }
        catch (Exception exception) {
            // empty catch block
        }
        authpost.releaseConnection();
        if (status != 200 && status != 302) {
            System.out.println("login failed. status=" + status);
            return null;
        }
        return client;
    }

    private List loadJspFiles() {
        final ArrayList result = new ArrayList(512);
        final int PATH_LEN = this.localDir.length();
        FileService fDir = new FileService(this.localDir);
        final List<String> apptemplates = Arrays.asList("metaresource", "template", "customtemplates");
        fDir.listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore pathname) {
                if (pathname.isDirectory()) {
                    String name = pathname.getName();
                    String parent = pathname.getParentFileStore().getName();
                    if (("application".equals(parent) || "govinfo".equals(parent)) && apptemplates.contains(name)) {
                        return false;
                    }
                    pathname.listFiles(this);
                } else {
                    String name = pathname.getName();
                    if (name.endsWith(".jsp") && !JspCheckerWithLogin.this.includeJspSet.contains(name)) {
                        String path = pathname.getAbsolutePath();
                        path = path.substring(PATH_LEN);
                        path = path.replace(File.separatorChar, '/');
                        result.add(path);
                    }
                }
                return false;
            }
        });
        return result;
    }

    public final boolean isShowErrorDetail() {
        return this.showErrorDetail;
    }

    public final void setShowErrorDetail(boolean showErrorDetail) {
        this.showErrorDetail = showErrorDetail;
    }

    public static void main(String[] args) {
        AppInfo appInfo = new AppInfo();
        appInfo.host = "192.9.200.241";
        appInfo.username = "renhua";
        String dir = "D:\\svn-merge-haier3\\release\\wcm";
        String[] jspIncludeFiles = new String[]{"doclevel_set.jsp", "metaviewdata_addedit_include_data_build.jsp", "metaviewdata_addedit_include_function.jsp", "metaviewdata_addedit_include_import.jsp", "metaviewdata_addedit_include_jquery_resource.jsp", "metaviewdata_addedit_include_resource.jsp", "metaviewdata_addedit_include_resource_4govinfo.jsp", "metaviewdata_query_include_data_build.jsp", "metaviewdata_query_include_function.jsp", "metaviewdata_query_include_import.jsp", "TemplateSelectHandler.jsp", "TopSetHandler.jsp", "element_processor.jsp", "element_processor4advsearch.jsp", "element_processor.jsp", "element_processor4advsearch.jsp", "element_processor.jsp", "element_processor4advsearch.jsp", "channel_add_edit_init.jsp", "document_field_init.jsp", "document_addedit_extendedfield.jsp", "document_addedit_import.jsp", "document_addedit_props.jsp", "document_query_import_4_extfield_query.jsp", "common.jsp", "docchannel.jsp", "docreltime.jsp", "filter_4_attributes.jsp", "pubconfig.jsp", "first_access_init.jsp", "convertor_helper.jsp", "fileupload_error_message_include.jsp", "file_upload_judgment.jsp", "findbyid_base.jsp", "list_base.jsp", "public_client_addedit.jsp", "public_client_list.jsp", "public_client_normal.jsp", "public_license_checker.jsp", "public_processor.jsp", "public_server.jsp", "public_server_nologin.jsp", "customize_config_include.jsp", "fetch_document.jsp", "infoview_config.jsp", "infoview_public_include.jsp", "menu.jsp", "plugins.jsp", "element_processor.jsp", "metaviewdata_addedit_include.jsp", "password_strength.jsp", "plugins.jsp", "reminder_weakpassword.jsp", "design_init_data_build_include.jsp", "layout_css_generator.jsp", "content_style_addedit_1.jsp", "content_style_addedit_2.jsp", "content_style_addedit_customstyle.jsp", "pager_generate.jsp", "resource_style_addedit_1.jsp", "resource_style_addedit_2.jsp", "resource_style_addedit_3.jsp", "resource_style_addedit_4.jsp", "style_other_dom_addedit_1.jsp", "widgetparameter_set_include_resource.jsp", "export_bonus_include.jsp", "user_doc_stat_include.jsp", "user_doc_stat_include.jsp", "chnl_doc_stat_include.jsp", "chnl_doc_stat_user_group_include.jsp", "export_stat_chnl_include.jsp", "group_channel_doc_stat_include.jsp", "group_doc_stat_include.jsp", "group_site_doc_stat_include.jsp", "group_trendchartdata_include.jsp", "export_stat_include.jsp", "site_doc_stat_include.jsp", "site_doc_stat_user_group_include.jsp", "export_include.jsp", "user_channel_doc_stat_include.jsp", "user_doc_stat_include.jsp", "user_site_doc_stat_include.jsp", "user_trendchartdata_include.jsp", "channel_hitscount_data_include.jsp", "document_hitscount_data_include.jsp", "export_include.jsp", "group_hitscount_data_include.jsp", "user_hitscount_data_include.jsp", "special_hitscount_data_include.jsp", "website_hitscount_data_include.jsp", "static_common.jsp", "create_swfview.jsp", "video_addedit_extendedfield.jsp", "video_addedit_props.jsp", "video_edit_import.jsp", "public_client_list.jsp", "public_client_normal.jsp", "website_add_edit_init.jsp", "fieldinfo_blankrows_include.jsp", "attachments_relations_include.jsp"};
        JspCheckerWithLogin checker = new JspCheckerWithLogin(dir, appInfo);
        checker.setIncludeJsp(jspIncludeFiles);
        checker.run();
    }

    public static class AppInfo {
        public String host;
        public int port = 8080;
        public String appname = "/wcm";
        public String username = "admin";
        public String pwd = "trsadmin";
        public String loginPage = "/wcm/app/login_dowith.jsp";
        public String loginName = "UserName";
        public String pwdName = "PassWord";
    }
}

