/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mas;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.HttpClientBuddy;
import com.trs.mas.MASClientServer;
import com.trs.mas.MediaHelper;
import com.trs.util.CMyString;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaDataLCListenerForMASDocument
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(MetaDataLCListenerForMASDocument.class);
    private IMetaDataDefCacheMgr oMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");

    private void doActionSelect(BaseObj _obj, Method _method) throws WCMException {
        if (!(_obj instanceof CMSObjDefaultImpl) || !_obj.getDbTableName().startsWith("WCMMetaTable")) {
            return;
        }
        int nMetaDataId = _obj.getPropertyAsInt("MetaDataId", 0);
        MetaViewData oMetaData = MetaViewData.findById(nMetaDataId);
        if (oMetaData == null) {
            return;
        }
        MetaView oMetaView = oMetaData.getMetaView();
        if (oMetaView == null) {
            return;
        }
        int nViewId = oMetaView.getId();
        Map oMasVideoViewFields = this.oMetaDataDefCacheMgr.getMetaViewFields(nViewId, 20);
        Map oMasLiveViewFields = this.oMetaDataDefCacheMgr.getMetaViewFields(nViewId, 21);
        oMasVideoViewFields.putAll(oMasLiveViewFields);
        if (oMasVideoViewFields.isEmpty()) {
            logger.debug((Object)("\u5143\u6570\u636e\u89c6\u56fe[" + nViewId + "]\u4e2d\u6ca1\u6709\u89c6\u9891\u5b57\u6bb5~~"));
            return;
        }
        Iterator iter = oMasVideoViewFields.keySet().iterator();
        StringBuffer sbMasIds = new StringBuffer();
        while (iter.hasNext()) {
            String sFieldName = (String)iter.next();
            String sMasIds = oMetaData.getPropertyAsString(sFieldName);
            logger.debug((Object)("\u89c6\u9891\u5b57\u6bb5\u503c\u4e3a\uff1a " + sMasIds));
            if (CMyString.isEmpty((String)sMasIds) || sMasIds == null) continue;
            sbMasIds.append(sMasIds).append(",");
            if (sbMasIds.length() <= 0) continue;
            sbMasIds.setLength(sbMasIds.length() - 1);
        }
        this.getHttpClientToMAS(_method, nMetaDataId, sbMasIds.toString());
    }

    private void doActionUnSelect(BaseObj _obj, Method _method) throws WCMException {
        if (_obj == null || _obj.getWCMType() != 614) {
            return;
        }
        ChnlDoc oChnlDoc = (ChnlDoc)_obj;
        int nViewId = oChnlDoc.getPropertyAsInt("DOCKIND", 0);
        if (nViewId == 0) {
            return;
        }
        MetaView oMetaView = MetaView.findById(nViewId);
        if (oMetaView == null) {
            return;
        }
        Map oMasVideoViewFields = this.oMetaDataDefCacheMgr.getMetaViewFields(oMetaView.getId(), 20);
        if (oMasVideoViewFields.isEmpty()) {
            return;
        }
        int nDocId = oChnlDoc.getDocId();
        this.getHttpClientToMAS(_method, nDocId, null);
    }

    private void getHttpClientToMAS(Method _method, int _nDocId, String _sMasIds) throws WCMException {
        String sMasURL = ConfigServer.getServer().getSysConfigValue("MAS_HOST_URL", "http://bbs.trs.net.cn/mas/openapi/pages.do");
        HttpClientBuddy oHttpClientBuddy = new HttpClientBuddy("utf-8");
        StringBuffer sbParameters = new StringBuffer();
        sbParameters.append("method=").append(_method.toString());
        sbParameters.append("&appKey=").append(MediaHelper.getMasAppKey());
        if (_sMasIds != null) {
            sbParameters.append("&id=").append(_sMasIds);
        }
        sbParameters.append("&docId=").append(_nDocId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5411MAS\u7aef\u540c\u6b65: " + sMasURL + "?" + sbParameters.toString()));
        }
        String sUrl = sMasURL + "?" + sbParameters.toString();
        try {
            MASClientServer oClientServer = (MASClientServer)TRSConfigServer.findConfigServerById(MASClientServer.class.getName());
            String sResponseText = oClientServer.getContentFromURL(sUrl);
            if (sResponseText == null) {
                throw new Exception("\u6307\u5b9a\u7684MAS\u7684URL\u65e0\u6548\uff1f[\u670d\u52a1\u5730\u5740=" + sUrl + "]");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[ " + sResponseText + " ]"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0eMAS\u4ea4\u4e92\u9519\u8bef\uff01[\u670d\u52a1\u5730\u5740=" + sUrl + "]"));
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _objAdded) throws WCMException {
        logger.debug((Object)"\u540c\u6b65\u65b0\u5efa\u6587\u6863\u7684DOCID\u4e0eMASID...");
        final BaseObj objAdded = _objAdded;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MetaDataLCListenerForMASDocument.this.doActionSelect(objAdded, Method.exSelect);
                }
                catch (Exception e) {
                    logger.error((Object)"\u65b0\u5efa\u6587\u6863\u65f6\u540c\u6b65\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        });
        thread.start();
    }

    @Override
    public void notifyOnModifyObj(BaseObj _objModified, int eventType) throws WCMException {
        if (eventType != 2) {
            return;
        }
        logger.debug((Object)"\u540c\u6b65\u4fee\u6539\u6587\u6863\u7684DOCID\u4e0eMASID...");
        final BaseObj objModified = _objModified;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MetaDataLCListenerForMASDocument.this.doActionSelect(objModified, Method.exSelect);
                }
                catch (Exception e) {
                    logger.error((Object)"\u4fee\u6539\u6587\u6863\u65f6\u540c\u6b65\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        });
        thread.start();
    }

    @Override
    public void notifyOnDelObj(BaseObj _objDeleted, int eventType) throws WCMException {
        if (eventType != 4) {
            return;
        }
        logger.debug((Object)"\u540c\u6b65\u5220\u9664\u6587\u6863\u7684DOCID\u4e0eMASID...");
        final BaseObj objDeleted = _objDeleted;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MetaDataLCListenerForMASDocument.this.doActionUnSelect(objDeleted, Method.exUnSelect);
                }
                catch (Exception e) {
                    logger.error((Object)"\u5220\u9664\u6587\u6863\u65f6\u540c\u6b65\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        });
        thread.start();
    }

    static enum Method {
        exSelect,
        exUnSelect;

    }
}

