/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.xml;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.xml.IXmlPersistentObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class XmlObjectPersistentor {
    public static final String MAPPINGPATH = "mapping.xml";
    public static final String DEFAULT_ENCODING = "GBK";
    private Marshaller m_oMarshaller = null;
    private Unmarshaller m_oUnmarshaller = null;
    private Mapping m_oMap = null;
    private boolean m_bHasMapping = false;
    private String m_sMappingSrc;
    private boolean m_bMappingRefreshed = false;

    public IXmlPersistentObject getParsedInstance(String _sXmlFile, String _sEncodingStyle) throws CMyException {
        if (_sXmlFile == null) {
            throw new CMyException("file to read is dimmy!");
        }
        IXmlPersistentObject result = null;
        InputStreamReader inReader = null;
        try {
            InputStream fis = new FileService(_sXmlFile).getInputStream();
            _sEncodingStyle = CMyString.isEmpty(_sEncodingStyle) ? DEFAULT_ENCODING : _sEncodingStyle;
            inReader = new InputStreamReader(fis, _sEncodingStyle);
        }
        catch (Exception ex) {
            throw new CMyException("Failed to retrive the input stream!", ex);
        }
        try {
            this.m_oUnmarshaller = new Unmarshaller();
            if (this.m_bHasMapping) {
                this.m_oUnmarshaller.setMapping(this.getMapping());
            }
            result = (IXmlPersistentObject)this.m_oUnmarshaller.unmarshal((Reader)inReader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CMyException("Failed to get the parsed instance from xmlfile[" + _sXmlFile + "]", ex);
        }
        this.m_bMappingRefreshed = false;
        return result;
    }

    public IXmlPersistentObject getParsedInstance(String _sXmlFile) throws CMyException {
        return this.getParsedInstance(_sXmlFile, DEFAULT_ENCODING);
    }

    public void updateInstance(IXmlPersistentObject _xmlObj, String _sXmlFile, String _sEncodingStyle) throws CMyException {
        if (_xmlObj == null) {
            throw new CMyException("object to marshall is dimmy!");
        }
        if (_sXmlFile == null) {
            throw new CMyException("file to write is dimmy!");
        }
        OutputStreamWriter outWriter = null;
        try {
            OutputStream fos = new FileService(_sXmlFile).getOutputStream();
            _sEncodingStyle = CMyString.isEmpty(_sEncodingStyle) ? DEFAULT_ENCODING : _sEncodingStyle;
            outWriter = new OutputStreamWriter(fos, _sEncodingStyle);
        }
        catch (Exception ex) {
            throw new CMyException("Failed to retrive the output stream!", ex);
        }
        try {
            this.m_oMarshaller = new Marshaller((Writer)outWriter);
            if (this.m_bHasMapping) {
                this.m_oMarshaller.setMapping(this.getMapping());
            }
            this.m_oMarshaller.setEncoding(_sEncodingStyle);
            this.m_oMarshaller.marshal((Object)_xmlObj);
        }
        catch (Exception ex) {
            throw new CMyException("Failed to update the xmlfile[" + _sXmlFile + "] with object[" + _xmlObj.toString() + "]", ex);
        }
        finally {
            if (outWriter != null) {
                try {
                    ((Writer)outWriter).close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_bMappingRefreshed = false;
    }

    public void updateInstance(IXmlPersistentObject _xmlObj, String _sXmlFile) throws CMyException {
        this.updateInstance(_xmlObj, _sXmlFile, DEFAULT_ENCODING);
    }

    protected Mapping getMapping() throws IOException, MappingException {
        if (this.m_oMap == null || this.m_bMappingRefreshed) {
            this.m_oMap = new Mapping();
            this.m_oMap.loadMapping(this.getMappingSrc());
        }
        return this.m_oMap;
    }

    public boolean isHasMapping() {
        return this.m_bHasMapping;
    }

    public void setHasMapping(boolean hasMapping) {
        this.m_bHasMapping = hasMapping;
    }

    public String getMappingSrc() {
        if (this.m_sMappingSrc == null) {
            this.m_sMappingSrc = MAPPINGPATH;
        }
        return this.m_sMappingSrc;
    }

    public void setMappingSrc(String mappingSrc) {
        this.m_sMappingSrc = mappingSrc;
        this.setHasMapping(true);
        this.m_bMappingRefreshed = true;
    }
}

