/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

import com.trs.infra.util.uftp.ChainNode;
import com.trs.infra.util.uftp.FtpConfig;
import java.sql.Timestamp;

public abstract class FtpConnection
extends ChainNode {
    protected String m_sHomePath;
    private FtpConfig m_oFtpConfig;
    private long m_lIdleTimestamp = System.currentTimeMillis();

    public String getHomePath() {
        return this.m_sHomePath;
    }

    public FtpConfig getFtpConfig() {
        return this.m_oFtpConfig;
    }

    void setConfig(FtpConfig config) {
        this.m_oFtpConfig = config;
    }

    protected String getTempFileName(String surfix) {
        String sTime = new Timestamp(System.currentTimeMillis()).toString();
        sTime = sTime.substring(0, 19).replace('-', '.').replace(' ', '_').replace(':', '.');
        StringBuffer sb = new StringBuffer(256);
        sb.append("__deleted_");
        sb.append(sTime);
        sb.append("__");
        if (surfix != null && surfix.length() > 0) {
            sb.append(surfix);
        }
        return sb.toString();
    }

    protected abstract String verifyConfig();

    protected abstract void open() throws Exception;

    protected abstract void close();

    public abstract void onIdle() throws Exception;

    public abstract boolean isReadOnly() throws Exception;

    public abstract String toAbsolutePath(String var1) throws Exception;

    public abstract boolean uploadFile(String var1, String var2) throws Exception;

    public abstract boolean hasTheFile(String var1) throws Exception;

    public abstract boolean deleteFile(String var1) throws Exception;

    public abstract boolean deleteDirectory(String var1) throws Exception;

    public abstract boolean renameFile(String var1, String var2) throws Exception;

    protected abstract void toHomeDirectory() throws Exception;

    public void setIdleTimestamp() {
        this.m_lIdleTimestamp = System.currentTimeMillis();
    }

    public long getIdleimestamp() {
        return this.m_lIdleTimestamp;
    }

    public long getIdleTimemills() {
        return System.currentTimeMillis() - this.m_lIdleTimestamp;
    }
}

