/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.image;

import com.trs.DreamFactory;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.image.ch.randelshofer.media.jpeg.CMYKJPEGImageReader;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;

public class CMyImage {
    public static int DEFAULT_WIDTH = 200;
    public static int NEED_SCALE_FILE_LENGTH = 512000;

    public static BufferedImage resize(BufferedImage source, int targetW) {
        if (targetW <= 0) {
            targetW = DEFAULT_WIDTH;
        }
        double sx = (double)targetW / (double)source.getWidth();
        int targetH = (int)Math.floor((double)source.getHeight() * sx);
        return CMyImage.resize(source, targetW, targetH);
    }

    public static BufferedImage resize(BufferedImage source, int targetW, int targetH) {
        int type = source.getType();
        BufferedImage target = null;
        double sx = (double)targetW / (double)source.getWidth();
        double sy = (double)targetH / (double)source.getHeight();
        if (type == 0) {
            ColorModel cm = source.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(targetW, targetH);
            boolean alphaPremultiplied = cm.isAlphaPremultiplied();
            target = new BufferedImage(cm, raster, alphaPremultiplied, null);
        } else {
            target = new BufferedImage(targetW, targetH, type);
        }
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawRenderedImage(source, AffineTransform.getScaleInstance(sx, sy));
        g.dispose();
        return target;
    }

    public static boolean ifNeedScale(String sFileName) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFilePath = filesMan.mapFilePath(sFileName, 0) + sFileName;
        return new FileService(sFilePath).length() > (long)NEED_SCALE_FILE_LENGTH;
    }

    public static String scaleImg(String fromFileName, int nScaleWidth) throws Exception {
        String sFileExt = CMyFile.extractFileExt(fromFileName);
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFromFilePathName = CMyString.setStrEndWith(filesMan.mapFilePath(fromFileName, 0), File.separatorChar) + fromFileName;
        String sSaveFilePathName = CMyImage.getThumbFilePath(fromFileName, nScaleWidth);
        FileService saveFile = new FileService(sSaveFilePathName);
        FileService fromFile = new FileService(sFromFilePathName);
        if (CMyImage.isPhotoLibCmdEnable()) {
            try {
                ImageMagickCmd.scale(fromFile.getAbsolutePath(), saveFile.getAbsolutePath(), nScaleWidth, true);
                return saveFile.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BufferedImage srcImage = null;
        try {
            srcImage = ImageIO.read(new FileWrapper(fromFile));
        }
        catch (Exception ioe) {
            String ext = sFileExt.toLowerCase();
            if (!"jpg".equals(ext) && !"jpeg".equals(ext)) {
                throw ioe;
            }
            try {
                srcImage = CMYKJPEGImageReader.read(new FileImageInputStream(new FileWrapper(fromFile)), true);
            }
            catch (Exception e) {
                return "";
            }
        }
        srcImage = CMyImage.resize(srcImage, nScaleWidth);
        ImageIO.write((RenderedImage)srcImage, sFileExt, new FileWrapper(saveFile));
        return saveFile.getName();
    }

    public static void moveThumbs(List _thumbPathList, String _sNewFileName) throws CMyException {
        for (int i = 0; i < _thumbPathList.size(); ++i) {
            String sThumbFilePath = (String)_thumbPathList.get(i);
            String sNewThumbFilePathName = CMyImage.getThumbFilePath(_sNewFileName, CMyImage.getThumbWidth(sThumbFilePath));
            CMyFile.moveFile(sThumbFilePath, sNewThumbFilePathName);
        }
    }

    public static String getThumbFileName(String srcFileName, int nWidth) throws WCMException {
        return CMyFile.excludeFileExt(srcFileName) + "_" + nWidth + "." + CMyFile.extractFileExt(srcFileName);
    }

    public static String getThumbFilePath(String srcFileName, int nWidth) throws WCMException {
        String sSrcFilePath = CMyString.setStrEndWith(FilesMan.getFilesMan().mapFilePath(srcFileName, 0), File.separatorChar);
        return sSrcFilePath + CMyImage.getThumbFileName(srcFileName, nWidth);
    }

    public static void formThumbsWidthSystemConfig(String sFileName) throws Exception {
        String sWidth = ConfigServer.getServer().getSysConfigValue("IMAGE_THUMB_WIDTHS", "");
        int[] nScales = CMyString.splitToInt(sWidth, ",");
        for (int i = 0; i < nScales.length; ++i) {
            CMyImage.scaleImg(sFileName, nScales[i]);
        }
    }

    public static int getThumbWidth(String _sThumbFile) {
        String sFileName = CMyFile.extractFileName(_sThumbFile);
        if (sFileName.indexOf("_") < 0) {
            return 0;
        }
        return Integer.parseInt(sFileName.substring(sFileName.indexOf("_") + 1, sFileName.indexOf(".")));
    }

    public static List getAllThumbFilePaths(String srcFileName) throws WCMException {
        String sSrcFilePath = CMyString.setStrEndWith(FilesMan.getFilesMan().mapFilePath(srcFileName, 0), File.separatorChar);
        String sFileNameWidthOutExt = CMyFile.excludeFileExt(srcFileName);
        FileService sPath = new FileService(sSrcFilePath);
        String[] sFileNames = sPath.list();
        ArrayList<String> sResult = new ArrayList<String>();
        for (int i = 0; i < sFileNames.length; ++i) {
            if (sFileNames[i].indexOf(sFileNameWidthOutExt + "_") < 0) continue;
            sResult.add(CMyString.setStrEndWith(sSrcFilePath, File.separatorChar) + sFileNames[i]);
        }
        return sResult;
    }

    public static int[] getImageSize(String sFileName) {
        int[] defaultSize = new int[]{-1, -1};
        FileService file = new FileService(sFileName);
        InputStream is = null;
        try {
            is = file.getInputStream();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return defaultSize;
        }
        try {
            ImageMagickCmd.ImageObj image = new ImageMagickCmd.ImageObj();
            image.setFilename(sFileName);
            return new int[]{image.width, image.height};
        }
        catch (Throwable t) {
            BufferedImage sourceImg = null;
            try {
                sourceImg = ImageIO.read(is);
                return new int[]{sourceImg.getWidth(), sourceImg.getHeight()};
            }
            catch (Throwable throwable) {
                return defaultSize;
            }
        }
    }

    public static void main(String[] argv) {
        try {
            CMyImage.moveThumbs(CMyImage.getAllThumbFilePaths("U020110211726748599846.jpg"), "UT2011021062266593104633333333.gif");
            System.out.println(CMyImage.getAllThumbFilePaths("UT20110210622665931046.bmp").toString());
            System.out.println(CMyImage.scaleImg("UT20110210622665931046.bmp", DEFAULT_WIDTH));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isPhotoLibCmdEnable() {
        IImageLibConfig m_libConf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        try {
            return m_libConf.isCmdUsed();
        }
        catch (WCMException e) {
            return false;
        }
    }
}

