/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;

public class TRSLocaleAuto {
    private static ArrayList s_listElements = null;
    private static ArrayList s_listOpers = null;
    private static final String INI_COMPONENTS = "/components.ini";
    private static final String INI_ELEMENTS = "/elements.ini";
    private static final String INI_OPERS = "/opers.ini";

    private static ArrayList loadINI(String _sFileName) throws CMyException {
        ArrayList<String> listConfig = new ArrayList<String>();
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        try {
            String sLine;
            fis = new FileService(CMyFile.mapResouceFullPath(_sFileName, TRSLocaleAuto.class)).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, CMyString.FILE_WRITING_ENCODING));
            while ((sLine = buffReader.readLine()) != null) {
                if ((sLine = sLine.trim()).length() <= 0 || sLine.charAt(0) == '#') continue;
                listConfig.add(sLine);
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(TRSLocaleAuto.class, "TRSLocaleAuto.label1", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)"), ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, I18NMessage.get(TRSLocaleAuto.class, "TRSLocaleAuto.label2", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)"), ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return listConfig;
    }

    public static String createLocal(String _sName, String _sComponentName) throws CMyException {
        String sResult = "";
        int nElementCount = TRSLocaleAuto.getElements().size();
        for (int i = 0; i < nElementCount; ++i) {
            String sElementName = (String)TRSLocaleAuto.getElements().get(i);
            sResult = sResult + TRSLocaleAuto.createLocal(_sName, _sComponentName, sElementName);
        }
        return sResult;
    }

    public static String createLocal(String _sName, String _sComponentName, String _sElementName) throws CMyException {
        String sResult = "";
        int nOperCount = TRSLocaleAuto.getOpers().size();
        for (int j = 0; j < nOperCount; ++j) {
            sResult = sResult + TRSLocaleAuto.createLocal(_sName, _sComponentName, _sElementName, (String)TRSLocaleAuto.getOpers().get(j), null) + "\n";
        }
        return sResult;
    }

    public static String createLocal(String _sName, String _sComponentName, String _sElementName, String _sOperName, String _sPropFile) {
        String sKey = _sComponentName + "." + _sElementName + "." + _sOperName;
        String sValue = _sName;
        String sOldValue = null;
        if (_sPropFile != null) {
            if (CMyFile.fileExists(_sPropFile)) {
                sOldValue = TRSLocaleAuto.setProperty(_sPropFile, sKey, sValue);
            } else {
                System.out.println(I18NMessage.get(TRSLocaleAuto.class, "TRSLocaleAuto.label3", "\u6307\u5b9a\u7684Properties\u6587\u4ef6\u4e0d\u5b58\u5728\uff01"));
            }
        }
        return "<%=LocaleServer.getString(\"" + sKey + "\", \"" + sValue + "\")%>" + (sOldValue == null ? "" : sOldValue);
    }

    public static String createJSPLocal(String _sName, String _sComponentName, String _sElementName, String _sOperName, String _sPropFile) {
        String sKey = _sComponentName + "." + _sElementName + "." + _sOperName;
        String sValue = _sName;
        if (_sPropFile != null) {
            if (CMyFile.fileExists(_sPropFile)) {
                TRSLocaleAuto.setProperty(_sPropFile, sKey, sValue);
            } else {
                System.out.println(I18NMessage.get(TRSLocaleAuto.class, "TRSLocaleAuto.label3", "\u6307\u5b9a\u7684Properties\u6587\u4ef6\u4e0d\u5b58\u5728\uff01"));
            }
        }
        return "LocaleServer.getString(\"" + sKey + "\", \"" + sValue + "\")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String setProperty(String _sPropFile, String _sKey, String _sValue) {
        InputStream fiProp = null;
        Properties aProperties = null;
        try {
            _sKey = _sKey.toLowerCase();
            String sFilePath = _sPropFile;
            fiProp = new FileService(sFilePath).getInputStream();
            aProperties = new Properties();
            aProperties.load(fiProp);
            if (!aProperties.containsKey(_sKey)) {
                aProperties.setProperty(_sKey, _sValue);
                aProperties.store(new FileService(sFilePath).getOutputStream(), "Generated by WCM Auto Tool");
                String string = null;
                return string;
            }
            if (aProperties.getProperty(_sKey).equals(_sValue)) {
                String string = null;
                return string;
            }
            String string = aProperties.getProperty(_sKey);
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        finally {
            try {
                if (fiProp != null) {
                    fiProp.close();
                }
                if (aProperties != null) {
                    aProperties.clear();
                    aProperties = null;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static ArrayList getElements() throws CMyException {
        if (s_listElements == null) {
            s_listElements = TRSLocaleAuto.loadINI(INI_ELEMENTS);
        }
        return s_listElements;
    }

    public static ArrayList getOpers() throws CMyException {
        if (s_listOpers == null) {
            s_listOpers = TRSLocaleAuto.loadINI(INI_OPERS);
        }
        return s_listOpers;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.print(I18NMessage.get(TRSLocaleAuto.class, "TRSLocaleAuto.label4", "\u4f20\u5165\u7684\u53c2\u6570\u9519\u8bef\uff01"));
            return;
        }
        try {
            if (args.length == 2) {
                System.out.println(TRSLocaleAuto.createLocal(args[0], args[1]));
            } else if (args.length == 3) {
                System.out.print(TRSLocaleAuto.createLocal(args[0], args[1], args[2]));
            } else if (args.length == 5) {
                System.out.print(TRSLocaleAuto.createLocal(args[0], args[1], args[2], args[3], args[4]));
            } else if (args.length == 6) {
                System.out.print(TRSLocaleAuto.createJSPLocal(args[0], args[1], args[2], args[3], args[4]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

