/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.FileNameExtFilter;
import com.trs.infra.util.TRSImportsOrgnize;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;

public class TRSJspAutoTool {
    private static String TEMPLATE_PATH = "/template/";
    private String m_sAuthor;
    private String m_sSrcFileName;
    private String m_sBaseObj;
    private String m_sDescription;
    private String m_sClassPath;
    private String m_sCodingTemplateFile = null;
    private String m_sConfigTemplateFile = null;
    private String m_sDowithTemplateFile = null;
    private String m_sSearchFields = null;
    private String m_sTemplateFile = null;
    private boolean m_bMergeFile = false;
    private boolean m_bFileNameByBaseObj = false;

    public TRSJspAutoTool(String _sAuthor, String _sClassPath, String _sFileName, String _sBaseObj, String _sDescription) {
        this.setAuthor(_sAuthor);
        this.setClassPath(_sClassPath);
        this.setSrcFileName(_sFileName);
        this.setBaseObj(_sBaseObj);
        this.setDescription(_sDescription);
    }

    protected String getAuthor() {
        return this.m_sAuthor;
    }

    protected void setAuthor(String author) {
        this.m_sAuthor = author;
    }

    protected String getBaseObj() {
        return this.m_sBaseObj;
    }

    protected void setBaseObj(String baseObj) {
        this.m_sBaseObj = baseObj;
    }

    protected String getClassPath() {
        return this.m_sClassPath;
    }

    protected void setClassPath(String classPath) {
        this.m_sClassPath = classPath;
    }

    protected String getDescription() {
        return this.m_sDescription;
    }

    protected void setDescription(String description) {
        this.m_sDescription = description;
    }

    protected String getSrcFileName() {
        return this.m_sSrcFileName;
    }

    protected void setSrcFileName(String fileName) {
        this.m_sSrcFileName = fileName;
    }

    private String extractFilePrex(String _sFileName) {
        int nPose = _sFileName.indexOf(46);
        if (nPose < 0) {
            return _sFileName;
        }
        return _sFileName.substring(0, nPose);
    }

    private String getDestFileName(String _sFileExt) {
        String sSrcFileName = this.getSrcFileName();
        if (this.isFileNameByBaseObj()) {
            String sSrcFilePath = CMyFile.extractFilePath(sSrcFileName);
            String sFileName = this.getBaseObj().toLowerCase() + "_" + this.extractFilePrex(this.getTemplateFile()) + "." + _sFileExt;
            return sSrcFilePath + sFileName;
        }
        String sDestFileName = sSrcFileName;
        int nPose = sSrcFileName.lastIndexOf(".");
        if (nPose > 0) {
            sDestFileName = sSrcFileName.substring(0, nPose);
        }
        sDestFileName = sDestFileName + "." + _sFileExt;
        return sDestFileName;
    }

    private String extractFileName() {
        String sSrcFileName = this.getSrcFileName();
        int nPose = sSrcFileName.lastIndexOf(".");
        if (nPose > 0) {
            sSrcFileName = sSrcFileName.substring(0, nPose);
        }
        if ((nPose = sSrcFileName.lastIndexOf(47)) < 0) {
            nPose = sSrcFileName.lastIndexOf(92);
        }
        return sSrcFileName.substring(nPose + 1);
    }

    private String dowithFileContent(String _sFileContent) {
        String sNewContent = _sFileContent;
        String sFileName = this.extractFileName();
        sNewContent = CMyString.replaceStr(sNewContent, "${Author}", this.getAuthor());
        sNewContent = CMyString.replaceStr(sNewContent, "${FileName}", sFileName);
        sNewContent = CMyString.replaceStr(sNewContent, "${BaseObj}", this.getBaseObj());
        sNewContent = CMyString.replaceStr(sNewContent, "${BaseObjLower}", this.getBaseObj().toLowerCase());
        sNewContent = CMyString.replaceStr(sNewContent, "${Description}", this.getDescription());
        sNewContent = CMyString.replaceStr(sNewContent, "${DateTime}", CMyDateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
        sNewContent = CMyString.replaceStr(sNewContent, "${Date}", CMyDateTime.now().toString("yyyy-MM-dd"));
        if (this.getSearchFields() != null) {
            sNewContent = CMyString.replaceStr(sNewContent, "${Fields}", this.getSearchFields());
            String[] arSearchFields = CMyString.split(this.getSearchFields(), ",");
            sNewContent = this.dowithFields(arSearchFields, sNewContent);
        }
        return sNewContent;
    }

    private String dowithFields(String[] _arSearchFields, String _sContent) {
        String sFieldBeginFlag = "${Field_Begin}";
        int nStartPose = _sContent.indexOf(sFieldBeginFlag);
        if (nStartPose < 0) {
            return _sContent;
        }
        String sFieldEndFlag = "${Field_End}";
        int nEndPose = _sContent.indexOf(sFieldEndFlag, nStartPose);
        if (nEndPose < 0) {
            return _sContent;
        }
        String sNewContent = "";
        String sNeedReplaceContent = _sContent.substring(nStartPose + sFieldBeginFlag.length(), nEndPose);
        for (int i = 0; i < _arSearchFields.length; ++i) {
            sNewContent = sNewContent + CMyString.replaceStr(sNeedReplaceContent, "${Field}", _arSearchFields[i]) + "\n";
        }
        return this.dowithFields(_arSearchFields, _sContent.substring(0, nStartPose) + sNewContent + _sContent.substring(nEndPose + sFieldEndFlag.length()));
    }

    private void writeFile(String _sFileName, String _sFileContent) throws CMyException {
        if (CMyFile.fileExists(_sFileName)) {
            CMyFile.copyFile(_sFileName, _sFileName + "_" + CMyDateTime.now().toString("yyyyMMddHHmm") + ".bak");
        }
        CMyFile.writeFile(_sFileName, this.dowithFileContent(_sFileContent));
    }

    public void createFile() throws CMyException {
        String sDstFileContent = CMyFile.readFile(this.getCodingTemplateFile());
        if (this.isMergeFile()) {
            String sSrcFileContent = CMyFile.readFile(this.getSrcFileName());
            sDstFileContent = sDstFileContent + "\n" + sSrcFileContent;
        }
        String sDestFileName = this.getDestFileName(CMyFile.extractFileExt(this.getCodingTemplateFile()));
        this.writeFile(sDestFileName, sDstFileContent);
        String[] arArgs = new String[]{this.getClassPath(), sDestFileName};
        TRSImportsOrgnize.main(arArgs);
        System.out.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label1", "\u4ea7\u751f\u4e86\u6587\u4ef6\uff1a") + sDestFileName);
        if (this.getDowithTemplateFile() != null) {
            sDstFileContent = CMyFile.readFile(this.getDowithTemplateFile());
            sDestFileName = this.getDestFileName(CMyFile.extractFileExt(this.getDowithTemplateFile()));
            this.writeFile(sDestFileName, sDstFileContent);
            System.out.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label2", "\u4ea7\u751f\u4e86dowith\u6587\u4ef6\uff1a") + sDestFileName);
        }
        if (this.getConfigTemplateFile() != null) {
            sDstFileContent = CMyFile.readFile(this.getConfigTemplateFile());
            sDestFileName = this.getDestFileName(CMyFile.extractFileExt(this.getConfigTemplateFile()));
            this.writeFile(sDestFileName, sDstFileContent);
            System.out.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label3", "\u4ea7\u751f\u4e86\u914d\u7f6e\u6587\u4ef6\uff1a") + sDestFileName);
        }
    }

    protected String getCodingTemplateFile() {
        return this.m_sCodingTemplateFile;
    }

    protected void setCodingTemplateFile(String codingTemplate) {
        this.m_sCodingTemplateFile = codingTemplate;
    }

    protected String getConfigTemplateFile() {
        return this.m_sConfigTemplateFile;
    }

    protected void setConfigTemplateFile(String configTemplate) {
        this.m_sConfigTemplateFile = configTemplate;
    }

    public boolean isMergeFile() {
        return this.m_bMergeFile;
    }

    public void setMergeFile(boolean mergeFile) {
        this.m_bMergeFile = mergeFile;
    }

    public void init(String _sTemplateFile, boolean _bMergeFile, String _sSearchFields) throws CMyException {
        this.setMergeFile(_bMergeFile);
        this.setTemplateFile(_sTemplateFile);
        String sAbsoulteTemplateFile = CMyFile.mapResouceFullPath(TEMPLATE_PATH + _sTemplateFile, this.getClass());
        this.setCodingTemplateFile(sAbsoulteTemplateFile);
        int nPose = sAbsoulteTemplateFile.lastIndexOf(46);
        String sAbsoluteConfigTemplateFile = sAbsoulteTemplateFile.substring(0, nPose) + ".xml";
        if (CMyFile.fileExists(sAbsoluteConfigTemplateFile)) {
            this.setConfigTemplateFile(sAbsoluteConfigTemplateFile);
        } else {
            this.setConfigTemplateFile(null);
        }
        String sAbsoluteDowithTemplateFile = sAbsoulteTemplateFile.substring(0, nPose) + "_dowith.jsp";
        if (CMyFile.fileExists(sAbsoluteDowithTemplateFile)) {
            this.setDowithTemplateFile(sAbsoluteDowithTemplateFile);
        } else {
            this.setDowithTemplateFile(null);
        }
        if (_sSearchFields != null && !_sSearchFields.equals("*")) {
            this.setSearchFields(_sSearchFields);
        } else {
            this.setSearchFields(null);
        }
    }

    public String getDowithTemplateFile() {
        return this.m_sDowithTemplateFile;
    }

    public void setDowithTemplateFile(String dowithTemplateFile) {
        this.m_sDowithTemplateFile = dowithTemplateFile;
    }

    public String getSearchFields() {
        return this.m_sSearchFields;
    }

    public void setSearchFields(String searchFields) {
        this.m_sSearchFields = searchFields;
    }

    public boolean isFileNameByBaseObj() {
        return this.m_bFileNameByBaseObj;
    }

    public void setFileNameByBaseObj(boolean fileNameByBaseObj) {
        this.m_bFileNameByBaseObj = fileNameByBaseObj;
    }

    public String getTemplateFile() {
        return this.m_sTemplateFile;
    }

    public void setTemplateFile(String templateFile) {
        this.m_sTemplateFile = templateFile;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 6) {
            System.err.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label4", "\u53c2\u6570\u60c5\u51b5\uff1a\u53ef\u4ee5\u6307\u5b9a8\u4e2a\u53c2\u6570\uff0c\u524d6\u4e2a\u53c2\u6570\u5fc5\u987b\u6307\u5b9a\uff0c\u540e\u4e00\u4e2a\u53c2\u6570\u53ef\u4ee5\u4e0d\u4f20\u5165\uff1a"));
            System.err.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label5", " 1:\u4f5c\u8005 \n 2:Class\u8def\u5f84 \n ") + I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label6", "3:\u6587\u4ef6\u540d(\u5e26\u8def\u5f84\u7684\u6587\u4ef6\u540d) \n 4:\u5bf9\u8c61\u540d\u79f0 \n ") + I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label7", "5:\u5bf9\u8c61\u7684\u63cf\u8ff0 \n 6:\u6a21\u677f \n 7:\u662f\u5426\u4ec5\u4ec5\u7ed3\u5408\u4f20\u5165\u7684\u6587\u4ef6\u540d(\u9ed8\u8ba4\u4e3atrue) \n 8:\u9700\u8981\u68c0\u7d22\u7684\u5b57\u6bb5(*\u8868\u793a\u4e0d\u9700\u8981) "));
            return;
        }
        FileService aFile = new FileService(args[1]);
        if (!aFile.exists()) {
            System.out.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label8", "\u6307\u5b9a\u7684ClassPath[") + args[1] + I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label9", "]\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        aFile = new FileService(args[2]);
        if (!aFile.exists()) {
            System.out.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label10", "\u6307\u5b9a\u5f85\u5904\u7406\u6587\u4ef6[") + args[2] + I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label9", "]\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        String sTemplateFile = args[5];
        TRSJspAutoTool aTool = new TRSJspAutoTool(args[0], args[1], args[2], args[3], args[4]);
        String sSearchFields = "*";
        if (args.length >= 8) {
            sSearchFields = args[7];
        }
        if (sTemplateFile.equalsIgnoreCase("all")) {
            aTool.setFileNameByBaseObj(true);
            FileService aTemplatePath = null;
            try {
                aTemplatePath = new FileService(CMyFile.extractFilePath(CMyFile.mapResouceFullPath(TEMPLATE_PATH, TRSJspAutoTool.class)));
            }
            catch (CMyException ex) {
                System.out.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label11", "\u6307\u5b9a\u7684\u6a21\u677f\u76ee\u5f55[") + TEMPLATE_PATH + I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label9", "]\u4e0d\u5b58\u5728\uff01"));
                ex.printStackTrace(System.err);
                return;
            }
            FileStore[] aTemplateFile = aTemplatePath.listFiles(new FileNameExtFilter("jsp"));
            for (int i = 0; i < aTemplateFile.length; ++i) {
                try {
                    aTool.init(aTemplateFile[i].getName(), false, sSearchFields);
                    aTool.setDowithTemplateFile(null);
                    aTool.createFile();
                    continue;
                }
                catch (Throwable ex) {
                    System.err.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label12", "\u6839\u636e\u6a21\u677f[") + aTemplateFile[i].getName() + I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label13", "]\u4ea7\u751f\u6587\u4ef6\u5931\u8d25\uff01"));
                    ex.printStackTrace(System.err);
                }
            }
        } else {
            try {
                if (sTemplateFile.indexOf(46) <= 0) {
                    System.out.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label14", "\u6307\u5b9a\u6a21\u677f\u6587\u4ef6[") + sTemplateFile + I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label15", "]\u4e0d\u7b26\u5408\u89c4\u8303,\u5fc5\u987b\u5177\u6709.\uff01"));
                    return;
                }
                aTool.init(sTemplateFile, !"false".equalsIgnoreCase(args[6]), sSearchFields);
            }
            catch (CMyException ex) {
                System.out.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label14", "\u6307\u5b9a\u6a21\u677f\u6587\u4ef6[") + sTemplateFile + I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label16", "]\u53ef\u80fd\u4e0d\u5b58\u5728\uff01"));
                ex.printStackTrace(System.err);
                return;
            }
            try {
                aTool.createFile();
            }
            catch (Throwable ex) {
                System.err.println(I18NMessage.get(TRSJspAutoTool.class, "TRSJspAutoTool.label17", "\u4ea7\u751f\u5217\u8868\u9875\u9762\u5931\u8d25\uff01"));
                ex.printStackTrace(System.err);
            }
        }
    }
}

