/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.tools.SymbolC2E;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;

public class PropertiesVARProcessor {
    protected String m_sSrcPath = null;
    protected String m_sComparePath = null;
    protected String m_sDstPath = null;
    protected String m_sStartPath = null;
    protected String m_sFileExt = "properties";
    protected String m_sFileEncoding = "GBK";
    private StringBuffer m_sbInfo = new StringBuffer();
    private boolean m_bRecordDetailInfo = false;
    private String m_sAlreadyCompareFile = null;

    public PropertiesVARProcessor(String _sSrcPath, String _sComparePath, String _sDstPath, String _sStartPath) {
        if (_sSrcPath.endsWith(".properties")) {
            _sSrcPath = CMyFile.extractFilePath(_sSrcPath);
        }
        if (_sComparePath.endsWith(".properties")) {
            _sComparePath = CMyFile.extractFilePath(_sComparePath);
        }
        this.m_sSrcPath = CMyString.setStrEndWith(_sSrcPath, File.separatorChar);
        this.m_sComparePath = CMyString.setStrEndWith(_sComparePath, File.separatorChar);
        this.m_sDstPath = CMyString.setStrEndWith(_sDstPath, File.separatorChar);
        this.m_sStartPath = CMyString.setStrEndWith(_sStartPath, File.separatorChar);
    }

    public String process() throws Exception {
        FileService file = new FileService(this.m_sSrcPath);
        if (!file.exists()) {
            throw new Exception("\u6307\u5b9a\u7684\u76ee\u5f55[" + this.m_sSrcPath + "]\u4e0d\u5b58\u5728\uff01");
        }
        if (!file.isDirectory()) {
            throw new Exception("\u6307\u5b9a\u7684\u76ee\u5f55[" + this.m_sSrcPath + "]\u4e0d\u662f\u76ee\u5f55\uff01");
        }
        this.processDIR(file);
        return this.m_sbInfo.toString();
    }

    private void processDIR(FileStore _oDiretory) throws Exception {
        FileStore[] pFiles = _oDiretory.listFiles();
        for (int i = 0; i < pFiles.length; ++i) {
            FileStore oFile = pFiles[i];
            if (!oFile.isFile()) {
                this.processDIR(oFile);
                continue;
            }
            String sFileName = oFile.getName();
            if (!sFileName.endsWith(this.m_sFileExt)) continue;
            String sAbsoluteFileName = oFile.getAbsolutePath();
            String sTemp = this.m_sComparePath.substring(this.m_sStartPath.length());
            int nPos = sAbsoluteFileName.indexOf(sTemp);
            String sCompareFileName = this.m_sComparePath + sAbsoluteFileName.substring(nPos + sTemp.length());
            this.process(sAbsoluteFileName, sCompareFileName);
        }
    }

    public String process(String sAbsoluteFileName, String sCompareFileName) throws Exception {
        FileService dstFile = new FileService(sCompareFileName);
        if (!dstFile.exists()) {
            this.m_sbInfo.append(sCompareFileName.substring(this.m_sStartPath.length()) + "\u4e0d\u5b58\u5728\uff01\n");
            CMyFile.copyFile(sAbsoluteFileName, sCompareFileName);
            String sDstFileName = this.makeDstFileName(sCompareFileName);
            CMyFile.copyFile(sAbsoluteFileName, sDstFileName);
            return this.m_sbInfo.toString();
        }
        HashMap hSrcResult = this.toMap(sAbsoluteFileName);
        HashMap hCompareResult = this.toMap(sCompareFileName);
        Iterator itKeys = hSrcResult.keySet().iterator();
        boolean bFindDiff = false;
        StringBuffer sbAppendContent = new StringBuffer();
        while (itKeys.hasNext()) {
            String sKey = (String)itKeys.next();
            String sValue = (String)hCompareResult.get(sKey);
            if (sValue == null) {
                if (!bFindDiff) {
                    this.m_sbInfo.append("\u6587\u4ef6[" + sCompareFileName.substring(this.m_sStartPath.length()) + "]\u5b58\u5728\u95ee\u9898\n");
                }
                bFindDiff = true;
                if (this.m_bRecordDetailInfo) {
                    this.m_sbInfo.append("\t[" + sKey + "]\u6ca1\u6709\u7ffb\u8bd1\n");
                }
                sbAppendContent.append(sKey + "=" + hSrcResult.get(sKey) + "\n");
            }
            if (!PropertiesVARProcessor.isNotEng(sValue)) continue;
            if (!bFindDiff) {
                this.m_sbInfo.append("\u6587\u4ef6[" + sCompareFileName.substring(this.m_sStartPath.length()) + "]\u5b58\u5728\u95ee\u9898\n");
            }
            bFindDiff = true;
            if (!this.m_bRecordDetailInfo) continue;
            this.m_sbInfo.append("\t[" + sKey + "]\u5b58\u5728\u4e2d\u6587[" + sValue + "]\n");
        }
        if (bFindDiff) {
            String sDstFileName = this.makeDstFileName(sCompareFileName);
            if (sbAppendContent.length() == 0) {
                if (this.m_sAlreadyCompareFile == null || !this.m_sAlreadyCompareFile.equals(sCompareFileName)) {
                    SymbolC2E.runtimeSymbols = SymbolC2E.pageSymbols;
                    SymbolC2E.replaceFile(sCompareFileName, sCompareFileName);
                    SymbolC2E.runtimeSymbols = SymbolC2E.resourceSymbols;
                    this.m_sAlreadyCompareFile = sCompareFileName;
                    return this.process(sAbsoluteFileName, sCompareFileName);
                }
                CMyFile.copyFile(sCompareFileName, sDstFileName);
            } else {
                sbAppendContent.setLength(sbAppendContent.length() - 1);
                String sNewContent = this.appendVar(sCompareFileName, sbAppendContent);
                String sEncoding = CharsetDetector.detect(sCompareFileName);
                CMyFile.writeFile(sCompareFileName, sNewContent, sEncoding);
                CMyFile.writeFile(sDstFileName, sNewContent, sEncoding);
            }
        }
        return this.m_sbInfo.toString();
    }

    private String makeDstFileName(String _sCompareFileName) throws Exception {
        int nPos = _sCompareFileName.indexOf(this.m_sStartPath);
        if (nPos < 0) {
            throw new Exception("\u4f20\u5165\u7684\u8d77\u59cb\u8def\u5f84\u6709\u95ee\u9898\uff01");
        }
        String sDstFileName = this.m_sDstPath + _sCompareFileName.substring(this.m_sStartPath.length());
        return sDstFileName;
    }

    private String appendVar(String _sFileName, StringBuffer _sAppendFileContent) throws Exception {
        String sEncoding = CharsetDetector.detect(_sFileName);
        String sContent = CMyFile.readFile(_sFileName, sEncoding);
        return sContent + '\n' + _sAppendFileContent;
    }

    private static boolean isNotEng(String _string) {
        if (_string == null) {
            return false;
        }
        char[] srcBuff = _string.toCharArray();
        for (int i = 0; i < srcBuff.length; ++i) {
            char aChar = srcBuff[i];
            if (aChar <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private HashMap toMap(String _sFileName) throws Exception {
        boolean bCaseSensitive = _sFileName.indexOf("wcm6-locale") < 0;
        HashMap<String, String> result = new HashMap<String, String>(30);
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        String sEncoding = CharsetDetector.detect(_sFileName);
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, sEncoding));
            while ((sLine = buffReader.readLine()) != null) {
                int nPos = (sLine = sLine.trim()).indexOf(61);
                if (nPos < 0) continue;
                String sVarName = sLine.substring(0, nPos).trim();
                if (!bCaseSensitive) {
                    sVarName = sVarName.toUpperCase();
                }
                String sValue = sLine.substring(nPos + 1).trim();
                result.put(sVarName, sValue);
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230", ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef", ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            String sSrcPath = "D:\\Temp\\Test\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\WebApp\\WEB-INF\\classes\\i18nmessage\\";
            String sComparePath = "D:\\Temp\\Test\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\WebApp\\TT\\WEB-INF\\classes\\i18nmessage\\";
            String sDstPath = "D:\\Temp\\Test\\MyWorkspace\\TRS.WCM.V6.1.Std\\Release\\";
            String sStartPath = "D:\\Temp\\Test\\MyWorkspace\\TRS.WCM.V6.1.Std\\SourceCode\\WebApp\\TT\\";
            PropertiesVARProcessor oProcessor = new PropertiesVARProcessor(sSrcPath, sComparePath, sDstPath, sStartPath);
            System.out.println(oProcessor.process());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

