/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.oss.OSSUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class CMyUnZipFile {
    private static Logger m_oLogger = Logger.getLogger(CMyUnZipFile.class);
    private Hashtable m_hAllFileNameIndex = null;
    private ArrayList m_listFilteredFiles = null;
    private ArrayList m_listFileExtFilters = null;
    private String m_sUnZipPath = null;
    private String m_sZipFile = null;
    private String m_sFileNameEncoding = null;

    public CMyUnZipFile(String _sZipFile, String _sUnZipPath) {
        this.setZipFile(_sZipFile);
        this.setUnZipPath(_sUnZipPath);
    }

    public void doUnZipAnd() throws CMyException {
        if (!CMyFile.fileExists(this.getZipFile())) {
            throw new CMyException(55, I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u538b\u7f29\u6587\u4ef6[") + this.getZipFile() + "]");
        }
        String sAbsoluteFileName = "";
        String sFileName = "";
        try {
            CMyUnzip unZip = new CMyUnzip();
            unZip.setEncoding(this.m_sFileNameEncoding);
            unZip.setZipFile(this.getZipFile());
            unZip.unzip(this.getUnZipPath(), true);
            Enumeration enFiles = unZip.getItems();
            while (enFiles.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)enFiles.nextElement();
                if (ze.isDirectory()) continue;
                sAbsoluteFileName = this.getUnZipPath() + ze.getName().replace('/', File.separatorChar);
                sFileName = CMyFile.extractFileName(sAbsoluteFileName);
                if (sAbsoluteFileName.indexOf("oss:") == 0) {
                    sAbsoluteFileName = OSSUtil.getAbsoluteFileName(sAbsoluteFileName);
                }
                this.putFileNameIndex(sFileName, sAbsoluteFileName);
                if (!this.isFilterFile(sFileName)) continue;
                this.addFilteredFile(sAbsoluteFileName);
            }
        }
        catch (Exception ex) {
            m_oLogger.error((Object)(I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label2", "\u89e3\u538b\u6587\u4ef6\u3010") + this.getZipFile() + I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label3", "\u3011\u5230\u76ee\u5f55\u3010") + this.getUnZipPath() + I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label4", "\u3011\u5931\u8d25\uff01")), (Throwable)ex);
            throw new CMyException(200, I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label2", "\u89e3\u538b\u6587\u4ef6\u3010") + this.getZipFile() + I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label3", "\u3011\u5230\u76ee\u5f55\u3010") + this.getUnZipPath() + I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label4", "\u3011\u5931\u8d25\uff01"), ex);
        }
    }

    public String getZipFile() {
        return this.m_sZipFile;
    }

    public void setZipFile(String zipFile) {
        this.m_sZipFile = zipFile;
    }

    public Hashtable getAllFileNameIndex() {
        return this.m_hAllFileNameIndex;
    }

    protected void putFileNameIndex(String _sFileName, String _sAbsoluteFileName) {
        if (_sFileName == null) {
            return;
        }
        if (this.m_hAllFileNameIndex == null) {
            this.m_hAllFileNameIndex = new Hashtable();
        }
        this.m_hAllFileNameIndex.put(_sFileName.toUpperCase(), _sAbsoluteFileName);
    }

    public ArrayList getFileExtFilters() {
        return this.m_listFileExtFilters;
    }

    public void addFileExtFilters(String _sFileExt) {
        if (_sFileExt == null) {
            return;
        }
        if (this.m_listFileExtFilters == null) {
            this.m_listFileExtFilters = new ArrayList();
        }
        this.m_listFileExtFilters.add(_sFileExt.toUpperCase());
    }

    public String getFileNameEncoding() {
        return this.m_sFileNameEncoding;
    }

    public void setFileNameEncoding(String fileNameEncoding) {
        this.m_sFileNameEncoding = fileNameEncoding;
    }

    public String getUnZipPath() {
        return this.m_sUnZipPath;
    }

    public void setUnZipPath(String unZipPath) {
        this.m_sUnZipPath = unZipPath;
    }

    public ArrayList getFilteredFiles() {
        return this.m_listFilteredFiles;
    }

    private boolean addFilteredFile(String _sFileName) {
        if (_sFileName == null) {
            return false;
        }
        if (this.m_listFilteredFiles == null) {
            this.m_listFilteredFiles = new ArrayList(1);
        }
        if (this.m_listFilteredFiles.indexOf(_sFileName) <= 0) {
            return this.m_listFilteredFiles.add(_sFileName);
        }
        return true;
    }

    private boolean isFilterFile(String _sFileName) {
        if (_sFileName == null) {
            return false;
        }
        if (this.getFileExtFilters() == null) {
            return false;
        }
        String sFileExt = CMyFile.extractFileExt(_sFileName);
        if (sFileExt == null) {
            return false;
        }
        return this.getFileExtFilters().indexOf(sFileExt.toUpperCase()) >= 0;
    }

    public static void main(String[] args) {
    }
}

