/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.URLCoder;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CMyString {
    public static String ENCODING_DEFAULT = "utf-8";
    public static String GET_ENCODING_DEFAULT = "utf-8";
    public static String FILE_WRITING_ENCODING = "GBK";
    private static final int PGVARNAME_MAX_LENGTH = 20;
    public static final int DEFAULT_ENTER_NUM = 1;
    public static String HTML_TAGS = "(?im)</?(?:STYLE|A|META|ACRONYM|ADDRESS|APPLET|AREA|B|BASE|BASEFONT|BDO|BGSOUND|BIG|BLOCKQUOTE|BODY|BR|BUTTON|CAPTION|CENTER|CITE|CODE|COL|COLGROUP|COMMENT|CUSTOM|DD|DEL|DFN|DIR|DIV|DL|DT|EM|EMBED|FIELDSET|FONT|FORM|FRAME|FRAMESET|HEAD|hn|HR|HTML|I|IFRAME|IMG|INPUT|INS|ISINDEX|KBD|LABEL|LEGEND|LI|LINK|LISTING|MAP|MARQUEE|MENU|nextID|NOBR|NOFRAMES|NOSCRIPT|OBJECT|OL|OPTION|P|PLAINTEXT|PRE|Q|RT|RUBY|S|SAMP|SCRIPT|SELECT|SMALL|SPAN|STRIKE|STRONG|styleSheet|SUB|SUP|TABLE|TBODY|TD|TEXTAREA|TFOOT|TH|THEAD|TITLE|TR|TT|U|UL|VAR|WBR|XML|XMP|\\?*[a-z1-9]+:?)[^>]*>";
    private static char[] charSQLEnds = new char[]{';', '\n', '\r'};
    private static String PY_RESOURCE_FILE = "winpy2000.txt";
    private static Hashtable m_hCharName = null;
    private static final String CDATA_END = "]]>";
    private static final String CDATA_END_REPLACER = "(TRSWCM_CDATA_END_HOLDER_TRSWCM)";

    public static boolean isEmpty(String _string) {
        return _string == null || _string.trim().length() == 0;
    }

    public static boolean isEmptyStr(String _string) {
        return _string == null || _string.trim().length() == 0;
    }

    public static String showObjNull(Object p_sValue) {
        return CMyString.showObjNull(p_sValue, "");
    }

    public static String showObjNull(Object _sValue, String _sReplaceIfNull) {
        if (_sValue == null) {
            return _sReplaceIfNull;
        }
        return _sValue.toString();
    }

    public static String showNull(String p_sValue) {
        return CMyString.showNull(p_sValue, "");
    }

    public static String showNull(String _sValue, String _sReplaceIfNull) {
        return _sValue == null ? _sReplaceIfNull : _sValue;
    }

    public static String showEmpty(String p_sValue) {
        return CMyString.showEmpty(p_sValue, "");
    }

    public static String showEmpty(String _sValue, String _sReplaceIfEmpty) {
        return CMyString.isEmpty(_sValue) ? _sReplaceIfEmpty : _sValue;
    }

    public static String expandStr(String _string, int _length, char _chrFill, boolean _bFillOnLeft) {
        int nLen = _string.length();
        if (_length <= nLen) {
            return _string;
        }
        String sRet = _string;
        for (int i = 0; i < _length - nLen; ++i) {
            sRet = _bFillOnLeft ? _chrFill + sRet : sRet + _chrFill;
        }
        return sRet;
    }

    public static String setStrEndWith(String _string, char _chrEnd) {
        return CMyString.setStrEndWith0(_string, _chrEnd);
    }

    private static String setStrEndWith0(String _str, char _charEnd) {
        if (CMyString.isEmpty(_str) || _str.endsWith(String.valueOf(_charEnd))) {
            return _str;
        }
        return _str + _charEnd;
    }

    public static String makeBlanks(int _length) {
        if (_length < 1) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(_length);
        for (int i = 0; i < _length; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String replaceStr(String _strSrc, String _strOld, String _strNew) {
        if (_strSrc == null || _strNew == null || _strOld == null) {
            return _strSrc;
        }
        char[] srcBuff = _strSrc.toCharArray();
        int nSrcLen = srcBuff.length;
        if (nSrcLen == 0) {
            return "";
        }
        char[] oldStrBuff = _strOld.toCharArray();
        int nOldStrLen = oldStrBuff.length;
        if (nOldStrLen == 0 || nOldStrLen > nSrcLen) {
            return _strSrc;
        }
        StringBuffer retBuff = new StringBuffer(nSrcLen * (1 + _strNew.length() / nOldStrLen));
        boolean bIsFound = false;
        int i = 0;
        while (i < nSrcLen) {
            bIsFound = false;
            if (srcBuff[i] == oldStrBuff[0]) {
                int j;
                for (j = 1; j < nOldStrLen && i + j < nSrcLen && srcBuff[i + j] == oldStrBuff[j]; ++j) {
                }
                boolean bl = bIsFound = j == nOldStrLen;
            }
            if (bIsFound) {
                retBuff.append(_strNew);
                i += nOldStrLen;
                continue;
            }
            int nSkipTo = i + nOldStrLen >= nSrcLen ? nSrcLen - 1 : i;
            while (i <= nSkipTo) {
                retBuff.append(srcBuff[i]);
                ++i;
            }
        }
        srcBuff = null;
        oldStrBuff = null;
        return retBuff.toString();
    }

    public static String replaceStr(StringBuffer _strSrc, String _strOld, String _strNew) {
        if (_strSrc == null) {
            return null;
        }
        int nSrcLen = _strSrc.length();
        if (nSrcLen == 0) {
            return "";
        }
        char[] oldStrBuff = _strOld.toCharArray();
        int nOldStrLen = oldStrBuff.length;
        if (nOldStrLen == 0 || nOldStrLen > nSrcLen) {
            return _strSrc.toString();
        }
        StringBuffer retBuff = new StringBuffer(nSrcLen * (1 + _strNew.length() / nOldStrLen));
        boolean bIsFound = false;
        int i = 0;
        while (i < nSrcLen) {
            bIsFound = false;
            if (_strSrc.charAt(i) == oldStrBuff[0]) {
                int j;
                for (j = 1; j < nOldStrLen && i + j < nSrcLen && _strSrc.charAt(i + j) == oldStrBuff[j]; ++j) {
                }
                boolean bl = bIsFound = j == nOldStrLen;
            }
            if (bIsFound) {
                retBuff.append(_strNew);
                i += nOldStrLen;
                continue;
            }
            int nSkipTo = i + nOldStrLen >= nSrcLen ? nSrcLen - 1 : i;
            while (i <= nSkipTo) {
                retBuff.append(_strSrc.charAt(i));
                ++i;
            }
        }
        oldStrBuff = null;
        return retBuff.toString();
    }

    public static String getStr(String _strSrc) {
        return _strSrc;
    }

    public static String getStr(String _strSrc, boolean _bPostMethod) {
        return _strSrc;
    }

    public static String getStr(String _strSrc, String _encoding) {
        if (_encoding == null || _encoding.length() == 0) {
            return _strSrc;
        }
        try {
            byte[] byteStr = new byte[_strSrc.length()];
            char[] charStr = _strSrc.toCharArray();
            for (int i = byteStr.length - 1; i >= 0; --i) {
                byteStr[i] = (byte)charStr[i];
            }
            return new String(byteStr, _encoding);
        }
        catch (Exception ex) {
            return _strSrc;
        }
    }

    public static String toISO_8859(String _strSrc) {
        if (_strSrc == null) {
            return null;
        }
        try {
            return new String(_strSrc.getBytes(), "ISO-8859-1");
        }
        catch (Exception ex) {
            return _strSrc;
        }
    }

    public static String toUnicode(String _strSrc) {
        return CMyString.toISO_8859(_strSrc);
    }

    public static byte[] getUTF8Bytes(String _string) {
        char[] c = _string.toCharArray();
        int len = c.length;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = c[i];
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            count += 3;
        }
        byte[] b = new byte[count];
        int off = 0;
        for (int i = 0; i < len; ++i) {
            char ch = c[i];
            if (ch <= '\u007f') {
                b[off++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                b[off++] = (byte)(ch >> 6 | 0xC0);
                b[off++] = (byte)(ch & 0x3F | 0x80);
                continue;
            }
            b[off++] = (byte)(ch >> 12 | 0xE0);
            b[off++] = (byte)(ch >> 6 & 0x3F | 0x80);
            b[off++] = (byte)(ch & 0x3F | 0x80);
        }
        return b;
    }

    public static String getUTF8String(byte[] b) {
        return CMyString.getUTF8String(b, 0, b.length);
    }

    public static String getUTF8String(byte[] b, int off, int len) {
        int count = 0;
        int max = off + len;
        int i = off;
        block10: while (i < max) {
            int c = b[i++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    continue block10;
                }
                case 12: 
                case 13: {
                    if ((b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
                case 14: {
                    if ((b[i++] & 0xC0) != 128 || (b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
            }
            throw new IllegalArgumentException();
        }
        if (i != max) {
            throw new IllegalArgumentException();
        }
        char[] cs = new char[count];
        i = 0;
        block11: while (off < max) {
            int c = b[off++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cs[i++] = (char)c;
                    continue block11;
                }
                case 12: 
                case 13: {
                    cs[i++] = (char)((c & 0x1F) << 6 | b[off++] & 0x3F);
                    continue block11;
                }
                case 14: {
                    int t = (b[off++] & 0x3F) << 6;
                    cs[i++] = (char)((c & 0xF) << 12 | t | b[off++] & 0x3F);
                    continue block11;
                }
            }
            throw new IllegalArgumentException();
        }
        return new String(cs, 0, count);
    }

    public static String byteToHexString(byte[] _bytes) {
        return CMyString.byteToHexString(_bytes, ',');
    }

    public static String byteToHexString(byte[] _bytes, char _delim) {
        String sRet = "";
        for (int i = 0; i < _bytes.length; ++i) {
            if (i > 0) {
                sRet = sRet + _delim;
            }
            sRet = sRet + Integer.toHexString(_bytes[i]);
        }
        return sRet;
    }

    public static String byteToString(byte[] _bytes, char _delim, int _radix) {
        String sRet = "";
        for (int i = 0; i < _bytes.length; ++i) {
            if (i > 0) {
                sRet = sRet + _delim;
            }
            sRet = sRet + Integer.toString(_bytes[i], _radix);
        }
        return sRet;
    }

    public static String transDisplay(String _sContent) {
        return CMyString.transDisplay(_sContent, true);
    }

    public static String transDisplay(String _sContent, boolean _bChangeBlank) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nSrcLen = srcBuff.length;
        StringBuffer retBuff = new StringBuffer(nSrcLen * 2);
        block9: for (int i = 0; i < nSrcLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case ' ': {
                    retBuff.append(_bChangeBlank ? "&nbsp;" : " ");
                    continue block9;
                }
                case '<': {
                    retBuff.append("&lt;");
                    continue block9;
                }
                case '>': {
                    retBuff.append("&gt;");
                    continue block9;
                }
                case '\n': {
                    if (_bChangeBlank) {
                        retBuff.append("<br/>");
                        continue block9;
                    }
                    retBuff.append(cTemp);
                    continue block9;
                }
                case '\"': {
                    retBuff.append("&quot;");
                    continue block9;
                }
                case '&': {
                    retBuff.append("&amp;");
                    continue block9;
                }
                case '\t': {
                    retBuff.append(_bChangeBlank ? "&nbsp;&nbsp;&nbsp;&nbsp;" : "    ");
                    continue block9;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        if (_bChangeBlank) {
            return retBuff.toString();
        }
        return CMyString.replaceParasStartEndSpaces(retBuff.toString());
    }

    public static String transDisplay_bbs(String _sContent, String p_sQuoteColor) {
        return CMyString.transDisplay_bbs(_sContent, p_sQuoteColor, true);
    }

    public static String transDisplay_bbs(String _sContent, String p_sQuoteColor, boolean _bChangeBlank) {
        if (_sContent == null) {
            return "";
        }
        boolean bIsQuote = false;
        boolean bIsNewLine = true;
        char[] srcBuff = _sContent.toCharArray();
        int nSrcLen = srcBuff.length;
        StringBuffer retBuff = new StringBuffer((int)((double)nSrcLen * 1.8));
        block10: for (int i = 0; i < nSrcLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case ':': {
                    if (bIsNewLine) {
                        bIsQuote = true;
                        retBuff.append("<font color=" + p_sQuoteColor + ">:");
                    } else {
                        retBuff.append(":");
                    }
                    bIsNewLine = false;
                    continue block10;
                }
                case ' ': {
                    retBuff.append(_bChangeBlank ? "&nbsp;" : " ");
                    bIsNewLine = false;
                    continue block10;
                }
                case '<': {
                    retBuff.append("&lt;");
                    bIsNewLine = false;
                    continue block10;
                }
                case '>': {
                    retBuff.append("&gt;");
                    bIsNewLine = false;
                    continue block10;
                }
                case '\"': {
                    retBuff.append("&quot;");
                    bIsNewLine = false;
                    continue block10;
                }
                case '&': {
                    retBuff.append("&amp;");
                    bIsNewLine = false;
                    continue block10;
                }
                case '\t': {
                    retBuff.append(_bChangeBlank ? "&nbsp;&nbsp;&nbsp;&nbsp;" : "    ");
                    bIsNewLine = false;
                    continue block10;
                }
                case '\n': {
                    if (bIsQuote) {
                        bIsQuote = false;
                        retBuff.append("</font>");
                    }
                    retBuff.append("<br/>");
                    bIsNewLine = true;
                    continue block10;
                }
                default: {
                    retBuff.append(cTemp);
                    bIsNewLine = false;
                }
            }
        }
        if (bIsQuote) {
            retBuff.append("</font>");
        }
        return retBuff.toString();
    }

    public static String transJsDisplay(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nSrcLen = srcBuff.length;
        StringBuffer retBuff = new StringBuffer((int)((double)nSrcLen * 1.5));
        block5: for (int i = 0; i < nSrcLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '<': {
                    retBuff.append("&lt;");
                    continue block5;
                }
                case '>': {
                    retBuff.append("&gt;");
                    continue block5;
                }
                case '\"': {
                    retBuff.append("&quot;");
                    continue block5;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String transDisplayMark(String _strSrc, char p_chrMark) {
        if (_strSrc == null) {
            return "";
        }
        char[] buff = new char[_strSrc.length()];
        for (int i = 0; i < buff.length; ++i) {
            buff[i] = p_chrMark;
        }
        return new String(buff);
    }

    public static String filterForSQL(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        int nLen = _sContent.length();
        if (nLen == 0) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.5));
        block4: for (int i = 0; i < nLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '\'': {
                    retBuff.append("''");
                    continue block4;
                }
                case ';': {
                    boolean bSkip = false;
                    for (int j = i + 1; j < nLen && !bSkip; ++j) {
                        char cTemp2 = srcBuff[j];
                        if (cTemp2 == ' ') continue;
                        if (cTemp2 == '&') {
                            retBuff.append(';');
                        }
                        bSkip = true;
                    }
                    if (bSkip) continue block4;
                    retBuff.append(';');
                    continue block4;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String filterForSQL2(String _sContent) {
        if (CMyString.isEmpty(_sContent)) {
            return _sContent;
        }
        return _sContent.replaceAll("(?i)([;\n\r])", "");
    }

    public static String filterForXsltValue(String _sAttrValue) {
        if (_sAttrValue == null) {
            return "";
        }
        _sAttrValue = _sAttrValue.replaceAll("\\{", "{{");
        _sAttrValue = _sAttrValue.replaceAll("\\}", "}}");
        return _sAttrValue;
    }

    public static String filterForXML(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        block7: for (int i = 0; i < nLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '&': {
                    retBuff.append("&amp;");
                    continue block7;
                }
                case '<': {
                    retBuff.append("&lt;");
                    continue block7;
                }
                case '>': {
                    retBuff.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    retBuff.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    retBuff.append("&apos;");
                    continue block7;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String filterForHTMLValue(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        block6: for (int i = 0; i < nLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '&': {
                    if (i + 1 < nLen) {
                        cTemp = srcBuff[i + 1];
                        if (cTemp == '#') {
                            retBuff.append("&");
                            continue block6;
                        }
                        retBuff.append("&amp;");
                        continue block6;
                    }
                    retBuff.append("&amp;");
                    continue block6;
                }
                case '<': {
                    retBuff.append("&lt;");
                    continue block6;
                }
                case '>': {
                    retBuff.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    retBuff.append("&quot;");
                    continue block6;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String unfilterForHTMLValue(String _sContent) {
        if (CMyString.isEmpty(_sContent)) {
            return "";
        }
        String[][] mapping = new String[][]{{"&amp;", "&"}, {"&lt;", "<"}, {"&gt;", ">"}, {"&quot;", "\""}};
        StringBuffer sbResult = new StringBuffer(_sContent.length());
        Pattern pattern = Pattern.compile("(?im)(&[^;]+;)");
        Matcher matcher = pattern.matcher(_sContent);
        int nStartIndex = 0;
        int nEndIndex = 0;
        block0: while (matcher.find()) {
            nStartIndex = matcher.start();
            sbResult.append(_sContent.substring(nEndIndex, nStartIndex));
            nEndIndex = matcher.end();
            String sTarget = matcher.group(1).toLowerCase();
            for (int i = 0; i < mapping.length; ++i) {
                if (!mapping[i][0].equals(sTarget)) continue;
                sbResult.append(mapping[i][1]);
                continue block0;
            }
        }
        if (nEndIndex < _sContent.length()) {
            sbResult.append(_sContent.substring(nEndIndex));
        }
        return sbResult.toString();
    }

    public static String filterForUrl(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        block7: for (int i = 0; i < nLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '%': {
                    retBuff.append("%25");
                    continue block7;
                }
                case '?': {
                    retBuff.append("%3F");
                    continue block7;
                }
                case '#': {
                    retBuff.append("%23");
                    continue block7;
                }
                case '&': {
                    retBuff.append("%26");
                    continue block7;
                }
                case ' ': {
                    retBuff.append("%20");
                    continue block7;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String filterForJs(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        block10: for (int i = 0; i < nLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '\"': {
                    retBuff.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    retBuff.append("\\'");
                    continue block10;
                }
                case '\\': {
                    retBuff.append("\\\\");
                    continue block10;
                }
                case '\n': {
                    retBuff.append("\\n");
                    continue block10;
                }
                case '\r': {
                    retBuff.append("\\r");
                    continue block10;
                }
                case '\f': {
                    retBuff.append("\\f");
                    continue block10;
                }
                case '\t': {
                    retBuff.append("\\t");
                    continue block10;
                }
                case '/': {
                    retBuff.append("\\/");
                    continue block10;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String filterForJson(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        block9: for (int i = 0; i < nLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '\"': {
                    retBuff.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    retBuff.append("\\\\");
                    continue block9;
                }
                case '\n': {
                    retBuff.append("\\n");
                    continue block9;
                }
                case '\r': {
                    retBuff.append("\\r");
                    continue block9;
                }
                case '\f': {
                    retBuff.append("\\f");
                    continue block9;
                }
                case '\t': {
                    retBuff.append("\\t");
                    continue block9;
                }
                case '/': {
                    retBuff.append("\\/");
                    continue block9;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String filterForJava(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        block4: for (int i = 0; i < nLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '\"': {
                    retBuff.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    retBuff.append("\\\\");
                    continue block4;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String numberToStr(int _nValue) {
        return CMyString.numberToStr(_nValue, 0);
    }

    public static String numberToStr(int _nValue, int _length) {
        return CMyString.numberToStr(_nValue, _length, '0');
    }

    public static String numberToStr(int _nValue, int _length, char _chrFill) {
        String sValue = String.valueOf(_nValue);
        return CMyString.expandStr(sValue, _length, _chrFill, true);
    }

    public static String numberToStr(long _lValue) {
        return CMyString.numberToStr(_lValue, 0);
    }

    public static String numberToStr(long _lValue, int _length) {
        return CMyString.numberToStr(_lValue, _length, '0');
    }

    public static String numberToStr(long _lValue, int _length, char _chrFill) {
        String sValue = String.valueOf(_lValue);
        return CMyString.expandStr(sValue, _length, _chrFill, true);
    }

    public static String circleStr(String _strSrc) {
        if (_strSrc == null) {
            return null;
        }
        String sResult = "";
        int nLength = _strSrc.length();
        for (int i = nLength - 1; i >= 0; --i) {
            sResult = sResult + _strSrc.charAt(i);
        }
        return sResult;
    }

    public static final boolean isChineseChar(int c) {
        return c > 127;
    }

    public static final int getCharViewWidth(int c) {
        return CMyString.isChineseChar(c) ? 2 : 1;
    }

    public static final int getStringViewWidth(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        int iWidth = 0;
        int iLength = s.length();
        for (int i = 0; i < iLength; ++i) {
            iWidth += CMyString.getCharViewWidth(s.charAt(i));
        }
        return iWidth;
    }

    public static String truncateStr(String _string, int _maxLength) {
        return CMyString.truncateStr(_string, _maxLength, "..");
    }

    public static String truncateStr(String _string, int _maxLength, String _sExt) {
        int nSrcLen;
        if (_string == null) {
            return null;
        }
        if (_sExt == null) {
            _sExt = "..";
        }
        if ((nSrcLen = CMyString.getStringViewWidth(_string)) <= _maxLength) {
            return _string;
        }
        int nExtLen = CMyString.getStringViewWidth(_sExt);
        if (nExtLen >= _maxLength) {
            return _string;
        }
        int iLength = _string.length();
        int iRemain = _maxLength - nExtLen;
        StringBuffer sb = new StringBuffer(_maxLength + 2);
        for (int i = 0; i < iLength; ++i) {
            char aChar = _string.charAt(i);
            int iNeed = CMyString.getCharViewWidth(aChar);
            if (iNeed > iRemain) {
                sb.append(_sExt);
                break;
            }
            sb.append(aChar);
            iRemain -= iNeed;
        }
        return sb.toString();
    }

    public static String filterForJDOM(String _string) {
        if (_string == null) {
            return null;
        }
        char[] srcBuff = _string.toCharArray();
        int nLen = srcBuff.length;
        StringBuffer dstBuff = new StringBuffer(nLen);
        for (int i = 0; i < nLen; ++i) {
            char aChar = srcBuff[i];
            if (!CMyString.isValidCharOfXML(aChar)) continue;
            dstBuff.append(aChar);
        }
        return dstBuff.toString();
    }

    public static boolean isValidCharOfXML(char _char) {
        return _char == '\t' || _char == '\n' || _char == '\r' || ' ' <= _char && _char <= '\ud7ff' || '\ue000' <= _char && _char <= '\ufffd' || '\u10000' <= _char && _char <= '\u10ffff';
    }

    public static int getBytesLength(String _string) {
        if (_string == null) {
            return 0;
        }
        char[] srcBuff = _string.toCharArray();
        int nGet = 0;
        for (int i = 0; i < srcBuff.length; ++i) {
            char aChar = srcBuff[i];
            nGet += aChar <= '\u007f' ? 1 : 2;
        }
        return nGet;
    }

    public static String cutStr(String _string, int _length) {
        return CMyString.truncateStr(_string, _length);
    }

    public static String URLEncode(String s) {
        try {
            return URLCoder.encode(s, GET_ENCODING_DEFAULT);
        }
        catch (Exception ex) {
            return s;
        }
    }

    public static String[] split(String _str, String _sDelim) {
        if (_str == null || _sDelim == null) {
            return new String[0];
        }
        StringTokenizer stTemp = new StringTokenizer(_str, _sDelim);
        int nSize = stTemp.countTokens();
        if (nSize == 0) {
            return new String[0];
        }
        String[] str = new String[nSize];
        int i = 0;
        while (stTemp.hasMoreElements()) {
            str[i] = stTemp.nextToken().trim();
            ++i;
        }
        return str;
    }

    public static int countTokens(String _str, String _sDelim) {
        StringTokenizer stTemp = new StringTokenizer(_str, _sDelim);
        return stTemp.countTokens();
    }

    public static int[] splitToInt(String _str, String _sDelim) {
        if (CMyString.isEmpty(_str)) {
            return new int[0];
        }
        if (CMyString.isEmpty(_sDelim)) {
            _sDelim = ",";
        }
        StringTokenizer stTemp = new StringTokenizer(_str, _sDelim);
        int[] arInt = new int[stTemp.countTokens()];
        int nIndex = 0;
        while (stTemp.hasMoreElements()) {
            String sValue = (String)stTemp.nextElement();
            arInt[nIndex] = Integer.parseInt(sValue.trim());
            ++nIndex;
        }
        return arInt;
    }

    public static String getIdListAsString(List vIdList, char _separate) {
        String sIdList = null;
        Object oKey = null;
        for (int i = 0; i < vIdList.size(); ++i) {
            oKey = vIdList.get(i);
            if (oKey == null) continue;
            int nId = oKey;
            sIdList = sIdList == null ? String.valueOf(nId) : sIdList + _separate + String.valueOf(nId);
        }
        return sIdList;
    }

    public static int[] getIdListAsIntArr(List vIdList) {
        return CMyString.splitToInt(CMyString.getIdListAsString(vIdList, ','), ",");
    }

    private static void loadFirstLetter(String _sFileName) throws Exception {
        if (m_hCharName == null) {
            m_hCharName = new Hashtable(300);
        } else {
            m_hCharName.clear();
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, FILE_WRITING_ENCODING));
            while ((sLine = buffReader.readLine()) != null) {
                char chrName;
                if ((sLine = sLine.trim()).length() < 2 || (chrName = sLine.charAt(1)) > '\u007f') continue;
                m_hCharName.put(sLine.substring(0, 1).toUpperCase(), sLine.substring(1, 2));
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(CMyString.class, "CMyString.label2", "\u8981\u8bfb\u53d6\u7684\u62fc\u97f3\u914d\u7f6e\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyString.getFirstLetter)"), ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, I18NMessage.get(CMyString.class, "CMyString.label3", "\u8bfb\u62fc\u97f3\u914d\u7f6e\u6587\u4ef6\u4ef6\u65f6\u9519\u8bef(CMyString.getFirstLetter)"), ex);
        }
        finally {
            if (buffReader != null) {
                buffReader.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Hashtable getPYResource() throws Exception {
        if (m_hCharName != null) {
            return m_hCharName;
        }
        String sResourcePath = CMyFile.mapResouceFullPath(PY_RESOURCE_FILE);
        CMyString.loadFirstLetter(sResourcePath);
        return m_hCharName;
    }

    public static String getFirstLetter(String _str) throws Exception {
        if (_str == null || _str.length() < 0) {
            return "";
        }
        char[] arChars = _str.toCharArray();
        String sFirstChar = _str.substring(0, 1);
        if (arChars[0] > '\u007f') {
            return ((String)CMyString.getPYResource().get(sFirstChar.toUpperCase())).toUpperCase();
        }
        return sFirstChar.toUpperCase();
    }

    public static final String encodeForCDATA(String _str) {
        if (_str == null || _str.length() < 1) {
            return _str;
        }
        return CMyString.replaceStr(_str, CDATA_END, CDATA_END_REPLACER);
    }

    public static final String decodeForCDATA(String _str) {
        if (_str == null || _str.length() < 1) {
            return _str;
        }
        return CMyString.replaceStr(_str, CDATA_END_REPLACER, CDATA_END);
    }

    public static final boolean isContainChineseChar(String _str) {
        if (_str == null) {
            return false;
        }
        return _str.getBytes().length != _str.length();
    }

    public static String join(ArrayList _arColl, String _sSeparator) {
        if (_arColl == null) {
            return null;
        }
        return CMyString.join(_arColl.toArray(), _sSeparator);
    }

    public static String join(Object[] _arColl, String _sSeparator) {
        if (_arColl == null || _arColl.length == 0 || _sSeparator == null) {
            return null;
        }
        if (_arColl.length == 1) {
            return _arColl[0].toString();
        }
        StringBuffer result = new StringBuffer(_arColl[0].toString());
        for (int i = 1; i < _arColl.length; ++i) {
            if (_arColl[i] == null) continue;
            result.append(_sSeparator);
            result.append(_arColl[i].toString());
        }
        return result.toString();
    }

    public static String join(int[] _intColl, String _sSeparator) {
        if (_intColl == null || _intColl.length == 0) {
            return "";
        }
        if (_sSeparator == null) {
            _sSeparator = ",";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(_intColl[0]);
        for (int i = 1; i < _intColl.length; ++i) {
            buf.append(_sSeparator).append(_intColl[i]);
        }
        return buf.toString();
    }

    public static boolean containsCDATAStr(String _sValue) {
        if (_sValue == null) {
            return false;
        }
        return _sValue.matches("(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*");
    }

    public static String parsePageVariables(String _sContent, Map _variables) throws WCMException {
        return CMyString.parsePageVariables(_sContent, _variables, new char[]{'{', '}'}, 20);
    }

    public static String parsePageVariables(String _sContent, Map _variables, char[] _aSep) throws WCMException {
        return CMyString.parsePageVariables(_sContent, _variables, _aSep, 20);
    }

    public static String parsePageVariables(String _sContent, Map _variables, int _nPgvarnameMaxLength) throws WCMException {
        return CMyString.parsePageVariables(_sContent, _variables, new char[]{'{', '}'}, _nPgvarnameMaxLength);
    }

    public static String parsePageVariables(String _sContent, Map _variables, char[] _aSep, int _nPgvarnameMaxLength) throws WCMException {
        if (_sContent == null) {
            return null;
        }
        StringBuffer buffResult = null;
        try {
            char[] chrArray = _sContent.toCharArray();
            int nLength = chrArray.length;
            int nPos = 0;
            buffResult = new StringBuffer();
            while (nPos < chrArray.length) {
                char aChar;
                if ((aChar = chrArray[nPos++]) == '$' && nPos < nLength && chrArray[nPos] == _aSep[0]) {
                    StringBuffer buffVarName = new StringBuffer(16);
                    ++nPos;
                    int iCount = 0;
                    boolean zFound = false;
                    while (iCount++ < _nPgvarnameMaxLength && nPos < nLength) {
                        if ((aChar = chrArray[nPos++]) == _aSep[1]) {
                            zFound = true;
                            break;
                        }
                        buffVarName.append(aChar);
                    }
                    if (zFound) {
                        String sKey = buffVarName.toString().toUpperCase();
                        String sVal = "";
                        Object oValue = _variables.get(sKey);
                        if (oValue != null) {
                            sVal = oValue.toString();
                        }
                        if (sVal != null) {
                            buffResult.append(sVal.toUpperCase());
                            continue;
                        }
                        buffResult.append("$").append(_aSep[0]).append(buffVarName).append(_aSep[1]);
                        continue;
                    }
                    buffResult.append("$").append(_aSep[0]).append(buffVarName);
                    continue;
                }
                buffResult.append(aChar);
            }
            return buffResult.toString();
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(CMyString.class, "CMyString.label4", "\u89e3\u6790\u5185\u5bb9\u4e2d\u7684\u53d8\u91cf\u5931\u8d25!"), ex);
        }
    }

    public static String transPrettyUrl(String _sUrl, int _nMaxLen) {
        return CMyString.transPrettyUrl(_sUrl, _nMaxLen, null);
    }

    public static String transPrettyUrl(String _sUrl, int _nMaxLen, String _sSkimWord) {
        int nDemPos = 0;
        if (_sUrl == null || _nMaxLen <= 0 || _sUrl.length() <= _nMaxLen || (nDemPos = _sUrl.lastIndexOf(47)) == -1) {
            return _sUrl;
        }
        int nFirstPartDemPos = _sUrl.lastIndexOf("://") + 3;
        String sFirstPart = _sUrl.substring(0, nFirstPartDemPos);
        String sMidPart = _sUrl.substring(nFirstPartDemPos, nDemPos);
        if (sMidPart.length() < 3) {
            return _sUrl;
        }
        int nMidLen = _nMaxLen + sMidPart.length() - _sUrl.length();
        if (nMidLen <= 3) {
            nMidLen = 3;
        }
        sMidPart = sMidPart.substring(0, nMidLen);
        sMidPart = sMidPart + (_sSkimWord != null ? _sSkimWord : "....");
        String sLastPart = _sUrl.substring(nDemPos);
        return sFirstPart + sMidPart + sLastPart;
    }

    public static String replaceStartEndSpaces(String _strValue) {
        Pattern pattern = Pattern.compile("(?m)^(\\s*)(.*?)(\\s*)$");
        Matcher matcher = pattern.matcher(_strValue);
        int nLineCount = 30;
        StringBuffer sbResult = new StringBuffer(nLineCount * 100 + _strValue.length());
        while (matcher.find()) {
            char c;
            String sStartSpaces = matcher.group(1);
            for (int i = 0; i < sStartSpaces.length(); ++i) {
                c = sStartSpaces.charAt(i);
                if (c == ' ') {
                    sbResult.append("&nbsp;");
                    continue;
                }
                sbResult.append(c);
            }
            sbResult.append(matcher.group(2));
            String sEndSpaces = matcher.group(3);
            c = '\u0000';
            for (int i = 0; i < sEndSpaces.length(); ++i) {
                c = sEndSpaces.charAt(i);
                if (c == ' ') {
                    sbResult.append("&nbsp;");
                    continue;
                }
                sbResult.append(c);
            }
        }
        return sbResult.toString();
    }

    public static String replaceParasStartEndSpaces(String _strValue) {
        Pattern pattern = Pattern.compile("\n\r|\n|\r");
        Matcher matcher = pattern.matcher(_strValue);
        int nLineCount = 30;
        StringBuffer sbResult = new StringBuffer(nLineCount * 100 + _strValue.length());
        int nLastIndex = 0;
        while (matcher.find()) {
            int nCurrIndex = matcher.start();
            String sTmpBefore = _strValue.substring(nLastIndex, nCurrIndex);
            sTmpBefore = CMyString.replaceStartEndSpaces(sTmpBefore);
            sbResult.append(sTmpBefore);
            sbResult.append("<br/>");
            nLastIndex = matcher.end();
        }
        String sTmpAfter = _strValue.substring(nLastIndex);
        sTmpAfter = CMyString.replaceStartEndSpaces(sTmpAfter);
        sbResult.append(sTmpAfter);
        return sbResult.toString();
    }

    public static Map split2AttrMap(String _sAttrStr) {
        Pattern pattern = Pattern.compile("([^\\s=]*)\\s*=(([^\\s'\"]+\\s)|(\\s*(['\"]?)(.*?)\\5))");
        Matcher matcher = pattern.matcher(_sAttrStr);
        HashMap<String, String> mpResult = new HashMap<String, String>();
        while (matcher.find()) {
            String sValue = CMyString.showNull(matcher.group(6), matcher.group(3));
            mpResult.put(matcher.group(1), sValue);
        }
        return mpResult;
    }

    public static String format(String _sFormat, String[] _args) {
        StringBuffer sbResult = new StringBuffer(_sFormat.length());
        Pattern pattern = Pattern.compile("\\{(\\d+)\\}");
        Matcher matcher = pattern.matcher(_sFormat);
        int nStart = 0;
        int nEnd = 0;
        while (matcher.find()) {
            nStart = matcher.start();
            sbResult.append(_sFormat.substring(nEnd, nStart));
            int nIndex = Integer.parseInt(matcher.group(1));
            sbResult.append(_args[nIndex]);
            nEnd = matcher.end();
        }
        if (nEnd < _sFormat.length()) {
            sbResult.append(_sFormat.substring(nEnd));
        }
        return sbResult.toString();
    }

    public static String format(String _sFormat, Object[] _args) {
        if (CMyString.isEmpty(_sFormat)) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer(_sFormat.length());
        Pattern pattern = Pattern.compile("\\{(\\d+)\\}");
        Matcher matcher = pattern.matcher(_sFormat);
        int nStart = 0;
        int nEnd = 0;
        while (matcher.find()) {
            nStart = matcher.start();
            sbResult.append(_sFormat.substring(nEnd, nStart));
            int nIndex = Integer.parseInt(matcher.group(1));
            sbResult.append(_args[nIndex]);
            nEnd = matcher.end();
        }
        if (nEnd < _sFormat.length()) {
            sbResult.append(_sFormat.substring(nEnd));
        }
        return sbResult.toString();
    }

    public static String format(String _sFormat, int[] _args) {
        if (CMyString.isEmpty(_sFormat)) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer(_sFormat.length());
        Pattern pattern = Pattern.compile("\\{(\\d+)\\}");
        Matcher matcher = pattern.matcher(_sFormat);
        int nStart = 0;
        int nEnd = 0;
        while (matcher.find()) {
            nStart = matcher.start();
            sbResult.append(_sFormat.substring(nEnd, nStart));
            int nIndex = Integer.parseInt(matcher.group(1));
            sbResult.append(_args[nIndex]);
            nEnd = matcher.end();
        }
        if (nEnd < _sFormat.length()) {
            sbResult.append(_sFormat.substring(nEnd));
        }
        return sbResult.toString();
    }

    public static String innerText(String _strValue) {
        return CMyString.transInnerText(_strValue, 1);
    }

    public static String innerText(String _strValue, int _enterNum) {
        return CMyString.transInnerText(_strValue, _enterNum);
    }

    private static String transInnerText(String _srcContent, int _nEnterNum) {
        if (CMyString.isEmpty(_srcContent)) {
            return "";
        }
        String sEnterCon = "";
        if (_nEnterNum <= 0) {
            _nEnterNum = 1;
        }
        for (int i = 0; i < _nEnterNum; ++i) {
            sEnterCon = sEnterCon + "\n";
        }
        sEnterCon = sEnterCon + "\u3000\u3000";
        String sValue = _srcContent.replaceAll("(?is)<style[^>]*>.*?</style>", "");
        sValue = sValue.replaceAll("(?is)<script[^>]*>.*?</script>", "");
        sValue = sValue.replaceAll("(?is)<br[^>]*>([\\n\\s]*(&nbsp;| |\u3000)*)*", "\n\u3000\u3000");
        sValue = sValue.replaceAll("(?is)<p[^>]*>([\\n\\s]*(&nbsp;| |\u3000)*)*", "\n\u3000\u3000");
        sValue = sValue.replaceAll("(?is)</p[^>]*>", "");
        sValue = sValue.replaceAll(HTML_TAGS, "");
        sValue = sValue.replaceAll("(?is)([ \u3000]*\n+)+", sEnterCon);
        sValue = sValue.replaceAll("(?is)(\n+[ \u3000]*)+", sEnterCon);
        sValue = sValue.replaceAll("(?is)([ \u3000]*\n+[ \u3000]*)+", sEnterCon);
        return sValue.replaceAll("&nbsp;", " ").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'").replaceAll("&amp;", "&").replaceAll("&ldquo;", "\u201c").replaceAll("&rdquo;", "\u201d").replaceAll("&hellip;", "\u2026").replaceAll("&mdash;", "\u2014").replaceAll("&lsquo;", "\u2018").replaceAll("&rsquo;", "\u2019");
    }

    public static String encodeForRegExp(String sSource) {
        String specialRegExpCharset = ".^${[(|}])*+?\";\\";
        StringBuffer sb = new StringBuffer(2 * sSource.length());
        int length = sSource.length();
        for (int i = 0; i < length; ++i) {
            char nCurrChar = sSource.charAt(i);
            if (specialRegExpCharset.indexOf(nCurrChar) >= 0) {
                sb.append("\\");
            }
            sb.append(nCurrChar);
        }
        return sb.toString();
    }

    public static String capitalize(String _strValue) {
        char capitalized;
        if (CMyString.isEmpty(_strValue)) {
            return _strValue;
        }
        char first = _strValue.charAt(0);
        return first == (capitalized = Character.toUpperCase(first)) ? _strValue : capitalized + _strValue.substring(1);
    }

    public static boolean isStringInArray(String string, String[] targetArray, boolean ignoreCase) {
        if (string == null || targetArray == null || targetArray.length == 0) {
            return false;
        }
        if (ignoreCase) {
            for (int i = targetArray.length - 1; i >= 0; --i) {
                if (!string.equalsIgnoreCase(targetArray[i])) continue;
                return true;
            }
        } else {
            for (int i = targetArray.length - 1; i >= 0; --i) {
                if (!string.equals(targetArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String cleanAttributes4Tags(String sHtml, String sTags) {
        String[] aTags = CMyString.split(sTags, ",");
        return CMyString.cleanAttributes4Tags(sHtml, aTags);
    }

    public static String cleanAttributes4Tags(String sHtml, String[] aTags) {
        String sResult = sHtml;
        for (int i = 0; i < aTags.length; ++i) {
            sResult = CMyString.cleanAttributes4Tag(sResult, aTags[i]);
        }
        return sResult;
    }

    public static String cleanAttributes4Tag(String sHtml, String tag) {
        String sPattern = "(?is)<(" + tag + ")[^>]*>";
        return sHtml.replaceAll(sPattern, "<$1>");
    }

    public static String includeTags(String sHtml, String sTags) {
        String[] aTags = CMyString.split(sTags, ",");
        return CMyString.includeTags(sHtml, aTags);
    }

    public static String includeTags(String sHtml, String[] tags) {
        Pattern m_oTagPattern = Pattern.compile("(?is)</?([^> ]*)[^>]*/?>");
        Matcher matcher = m_oTagPattern.matcher(sHtml);
        StringBuffer sbHtml = new StringBuffer(sHtml.length());
        int nStartIndex = 0;
        int nEndIndex = 0;
        while (matcher.find()) {
            nStartIndex = matcher.start();
            sbHtml.append(sHtml.substring(nEndIndex, nStartIndex));
            nEndIndex = matcher.end();
            String sMatchTag = matcher.group(1);
            if (!CMyString.isStringInArray(sMatchTag, tags, true)) continue;
            sbHtml.append(sHtml.substring(nStartIndex, nEndIndex));
        }
        if (nEndIndex < sHtml.length()) {
            sbHtml.append(sHtml.substring(nEndIndex));
        }
        return sbHtml.toString();
    }

    public static String excludeTags(String sHtml, String sTags) {
        String[] aTags = CMyString.split(sTags, ",");
        return CMyString.excludeTags(sHtml, aTags);
    }

    public static String excludeTags(String sHtml, String[] tags) {
        String sResult = sHtml;
        for (int i = 0; i < tags.length; ++i) {
            sResult = CMyString.excludeTag(tags[i], sResult);
        }
        return sResult;
    }

    public static String excludeTag(String tag, String sHtml) {
        String sPattern = "(?is)<" + tag + "[^>]*>.*?</" + tag + ">";
        sHtml = sHtml.replaceAll(sPattern, "");
        sPattern = "(?is)<" + tag + "[^>]*/>";
        return sHtml.replaceAll(sPattern, "");
    }

    public static float expressionEval(String sCalcuString) {
        float result = 0.0f;
        int cLastOperator = 43;
        StringBuffer sbCurrent = new StringBuffer(sCalcuString.length());
        int length = sCalcuString.length();
        for (int i = 0; i <= length; ++i) {
            int cTemp = i != length ? (int)sCalcuString.charAt(i) : 43;
            if (cTemp == 43 || cTemp == 45 || cTemp == 42 || cTemp == 47) {
                String sLastNumber = sbCurrent.toString();
                sbCurrent.setLength(0);
                float fLastNumber = Float.parseFloat(sLastNumber);
                switch (cLastOperator) {
                    case 43: {
                        result += fLastNumber;
                        break;
                    }
                    case 45: {
                        result -= fLastNumber;
                        break;
                    }
                    case 42: {
                        result *= fLastNumber;
                        break;
                    }
                    case 47: {
                        result /= fLastNumber;
                    }
                }
                cLastOperator = cTemp;
                continue;
            }
            sbCurrent.append((char)cTemp);
        }
        return result;
    }

    public static String stripHTMLTags(String sHtml) {
        if (CMyString.isEmpty(sHtml)) {
            return "";
        }
        sHtml = sHtml.replaceAll("(?is)<style[^>]*>.*?</style>", "");
        sHtml = sHtml.replaceAll("(?is)<script[^>]*>.*?</script>", "");
        return sHtml.replaceAll(HTML_TAGS, "");
    }

    public static String verifyHTMLIgnoreTRSTag(String sHtml) {
        String sResult = CMyString.verifyHTML(sHtml = sHtml.replaceAll("(?is)<(/?TRS[^>]*)>", "\u300a$1\u300b"));
        if (!CMyString.isEmpty(sResult)) {
            sResult = sResult.replaceAll("(?is)\u300a(/?TRS[^\u300b]*)\u300b", "<$1>");
        }
        return sResult;
    }

    public static String verifyHTML(String sHtml) {
        Pattern pattern = Pattern.compile("(?s)<(/?)([^> !/=]+)[^>]*?(/?)>");
        Stack<Object[]> result = new Stack<Object[]>();
        int nStartIndex = 0;
        int nRowIndex = 1;
        int nColIndex = 1;
        Matcher matcher = pattern.matcher(sHtml);
        while (matcher.find()) {
            int nLastStartIndex = nStartIndex;
            nStartIndex = matcher.start();
            int nTmpIndex = nLastStartIndex;
            while (true) {
                int nEnterIndex;
                if ((nEnterIndex = sHtml.indexOf(10, nTmpIndex)) < 0 || nEnterIndex >= nStartIndex) {
                    nColIndex += nStartIndex - nTmpIndex;
                    break;
                }
                ++nRowIndex;
                nColIndex = 1;
                nTmpIndex = nEnterIndex + 1;
            }
            String sTag = matcher.group(2).toLowerCase();
            String sEndSlash = matcher.group(3);
            if (sEndSlash.length() > 0) continue;
            String sStartSlash = matcher.group(1);
            if (sStartSlash.length() > 0 && !result.isEmpty()) {
                Object[] item = (Object[])result.pop();
                if (item[0].equals(sTag)) continue;
                return "\u5f00\u59cb\u6807\u8bb0[tag:" + item[0] + ",row:" + item[1] + ",col:" + item[2] + "]\u4e0e\u7ed3\u675f\u6807\u8bb0[tag:" + sTag + ",row:" + nRowIndex + ",col:" + nColIndex + "]\u4e0d\u5339\u914d\u3002\n\u5f00\u59cb\u6807\u8bb0\u7684\u4ee3\u7801\u7247\u6bb5\u4e3a:\n" + item[3] + "\n\u7ed3\u675f\u7684\u4ee3\u7801\u7247\u6bb5\u4e3a:\n" + matcher.group();
            }
            result.push(new Object[]{sTag, nRowIndex, nColIndex, matcher.group()});
        }
        if (!result.isEmpty()) {
            Object[] item = (Object[])result.pop();
            return "\u5f00\u59cb\u6807\u8bb0[tag:" + item[0] + ",row:" + item[1] + ",col:" + item[2] + "]\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed3\u675f\u6807\u8bb0\u3002\n\u5f00\u59cb\u6807\u8bb0\u7684\u4ee3\u7801\u7247\u6bb5\u4e3a:\n" + item[3];
        }
        return null;
    }

    public static boolean isAllowIP(String[] _pIPs, String _sRemoteAddr) {
        if (_pIPs == null) {
            return false;
        }
        String[] pRemoteIPList = _sRemoteAddr.split("\\.");
        for (int i = 0; i < _pIPs.length; ++i) {
            String[] pAllowIPList = _pIPs[i].split("\\.");
            if (pAllowIPList.length != pRemoteIPList.length) continue;
            boolean bNotEquals = false;
            for (int j = 0; j < pRemoteIPList.length; ++j) {
                if (pAllowIPList[j].equals("*") || pRemoteIPList[j].equals(pAllowIPList[j])) continue;
                bNotEquals = true;
                break;
            }
            if (bNotEquals) continue;
            return true;
        }
        return false;
    }

    public static String filterBlankLine(String _sContent, boolean _bTrimLine) {
        char c;
        int nStartIndex;
        StringBuffer sbResult = new StringBuffer(_sContent.length());
        int nLen = _sContent.length();
        for (nStartIndex = 0; nStartIndex < nLen && ((c = _sContent.charAt(nStartIndex)) == ' ' || c == '\u3000' || c == '\t' || c == '\r' || c == '\n'); ++nStartIndex) {
        }
        int nCharLineCount = 0;
        int nBlankCountInLine = 0;
        while (nStartIndex < nLen) {
            char c2 = _sContent.charAt(nStartIndex);
            if (nCharLineCount == 0 && (c2 == ' ' || c2 == '\u3000' || c2 == '\t')) {
                ++nBlankCountInLine;
                if (c2 == '\t') {
                    nBlankCountInLine += 3;
                }
                if (c2 == '\u3000') {
                    ++nBlankCountInLine;
                }
            } else if (c2 == '\n' || c2 == '\r') {
                if (nCharLineCount == 0) {
                    nBlankCountInLine = 0;
                } else {
                    nCharLineCount = 0;
                    sbResult.append(c2);
                }
            } else {
                if (!_bTrimLine && nCharLineCount == 0) {
                    for (int i = 0; i < nBlankCountInLine; ++i) {
                        sbResult.append(' ');
                    }
                }
                ++nCharLineCount;
                sbResult.append(c2);
            }
            ++nStartIndex;
        }
        return sbResult.toString();
    }

    public static void main(String[] args) throws CMyException {
        String sContent = CMyFile.readFile("C:\\Users\\huxiejin\\Desktop\\wjb-1120\\tags.html", "utf-8");
        String sCleanTagsAttrs = "p,span";
        sContent = CMyString.cleanAttributes4Tags(sContent, sCleanTagsAttrs);
        CMyFile.writeFile("C:\\Users\\huxiejin\\Desktop\\wjb-1120\\tags2.html", sContent, "utf-8");
    }
}

