/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class CMySMS {
    private static Logger logger = Logger.getLogger(CMySMS.class);
    private static String SENDURL_PRE = null;
    private static String PARAM_NAME_TO = "";
    private static String PARAM_NAME_CONTENT = "";
    public String sFrom = null;
    public String sTo = null;
    public String sContent = null;

    public static void setSendUrlPre(String _urlPre) {
        SENDURL_PRE = _urlPre;
    }

    public static void setParamNameTo(String _paramNameTo) {
        PARAM_NAME_TO = _paramNameTo;
    }

    public static void setParamNameContent(String _paramNameContent) {
        PARAM_NAME_CONTENT = _paramNameContent;
    }

    public static boolean isValidMobile(String _sMobile) {
        if (_sMobile == null) {
            return false;
        }
        if ((_sMobile = _sMobile.trim()).length() != 11) {
            return false;
        }
        String sKind = _sMobile.substring(0, 3);
        return !sKind.equals("130") && !sKind.equals("133");
    }

    private String getSendUrl() {
        String sUrl = SENDURL_PRE;
        try {
            String SMSCode = ConfigServer.getServer().getSysConfigValue("SMSCode", "utf-8");
            if (PARAM_NAME_TO.trim().length() > 0) {
                sUrl = sUrl + "&" + PARAM_NAME_TO + "=" + URLEncoder.encode(this.sTo, SMSCode);
                sUrl = sUrl + "&" + PARAM_NAME_CONTENT + "=" + URLEncoder.encode(this.sContent, SMSCode);
            } else {
                sUrl = CMyString.replaceStr(sUrl, "$$MOBILE$$", URLEncoder.encode(this.sTo, SMSCode));
                sUrl = CMyString.replaceStr(sUrl, "$$CONTENT$$", URLEncoder.encode(this.sContent, SMSCode));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)I18NMessage.get(CMySMS.class, "CMySMS.label1", "\u5bf9\u77ed\u4fe1\u8fdb\u884c\u7f16\u7801\u5931\u8d25!"), (Throwable)e);
        }
        catch (WCMException e) {
            logger.error((Object)I18NMessage.get(CMySMS.class, "CMySMS.label2", "\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u9879\u5931\u8d25!"), (Throwable)e);
        }
        return sUrl;
    }

    public String getFrom() {
        return this.sFrom;
    }

    public void setFrom(String _sFrom) {
        this.sFrom = _sFrom;
    }

    public String getTo() {
        return this.sTo;
    }

    public void setTo(String _sTo) throws CMyException {
        if (!CMySMS.isValidMobile(_sTo)) {
            throw new CMyException(10, I18NMessage.get(CMySMS.class, "CMySMS.label1", "\u624b\u673a\u53f7\u7801\u65e0\u6548\u6216\u4e0d\u652f\u6301\uff08CMySMS.setTo\uff09"));
        }
        this.sTo = _sTo;
    }

    public String getContent() {
        return this.sContent;
    }

    public void setContent(String _sContent) throws CMyException {
        if (_sContent == null || _sContent.trim().length() == 0) {
            throw new CMyException(10, I18NMessage.get(CMySMS.class, "CMySMS.label2", "\u77ed\u4fe1\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff08CMySMS.setContent\uff09"));
        }
        this.sContent = _sContent;
    }

    public boolean send() throws CMyException {
        if (this.sTo == null || this.sContent == null) {
            return false;
        }
        if (SENDURL_PRE == null) {
            throw new CMyException(10, I18NMessage.get(CMySMS.class, "CMySMS.label3", "\u53d1\u9001\u77ed\u4fe1\u606f\u7684URL\u6ca1\u6709\u8bbe\u5b9a\uff08CMySMS.send\uff09"));
        }
        try {
            if (this.sFrom != null) {
                this.sContent = this.sContent + "-" + this.sFrom;
            }
            return CMy3WLib.getFile(this.getSendUrl());
        }
        catch (Exception ex) {
            throw new CMyException(1, I18NMessage.get(CMySMS.class, "CMySMS.label4", "\u53d1\u9001\u77ed\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef\uff01"), ex);
        }
    }

    public static void main(String[] args) {
        CMySMS mySMS = new CMySMS();
        SENDURL_PRE = "http://gpdlm.easmart.net/s/index.php?message=myusername*mypassword*$$MOBILE$$*$$CONTENT$$";
        try {
            mySMS.setContent(I18NMessage.get(CMySMS.class, "CMySMS.label5", "\u4f60\u597d,\u4f5c\u4e2a\u6d4b\u8bd5"));
            mySMS.setFrom("TRS WCM 5.0");
            mySMS.setTo("13910839880");
            if (mySMS.send()) {
                System.out.println("Successful!");
            } else {
                System.out.println("False!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    static {
        try {
            SENDURL_PRE = ConfigServer.getServer().getSysConfigValue("SMS_SENDURL_PRE", null);
            PARAM_NAME_TO = ConfigServer.getServer().getSysConfigValue("SMS_PARAM_NAME_TO", null);
            PARAM_NAME_CONTENT = ConfigServer.getServer().getSysConfigValue("SMS_PARAM_NAME_CONTENT", null);
        }
        catch (WCMException e) {
            logger.debug((Object)"\u4ece\u7cfb\u7edf\u914d\u7f6e\u4e2d\u521d\u59cb\u5316\u77ed\u6d88\u606f\u7684\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

