/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class CMyDateTime
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5394662013475771975L;
    private Date m_dtDate = null;
    private SimpleDateFormat m_dtFormater = null;
    public static final int FORMAT_DEFAULT = 0;
    public static final int FORMAT_LONG = 1;
    public static final int FORMAT_SHORT = 2;
    public static final String DEF_DATE_FORMAT_PRG = "yyyy-MM-dd";
    public static final String DEF_TIME_FORMAT_PRG = "HH:mm:ss";
    public static final String DEF_DATETIME_FORMAT_PRG = "yyyy-MM-dd HH:mm:ss";
    public static final String DEF_DATETIME_FORMAT_DB = "YYYY-MM-DD HH24:MI:SS";
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 3;
    public static final int HOUR = 4;
    public static final int MINUTE = 5;
    public static final int SECOND = 6;
    public static final int QUATER = 11;
    public static final int WEEK = 12;
    public static final int DAY_OF_MONTH = 13;
    public static final int WEEK_OF_MONTH = 14;
    public static final int DAY_OF_YEAR = 15;
    public static final int WEEK_OF_YEAR = 16;
    public static final long ADAY_MILLIS = 86400000L;
    public static final String[] MONTHS = new String[]{"January", "February", " March", " April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String[] WEEKS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    public CMyDateTime() {
    }

    public CMyDateTime(long p_lDate) {
        this.m_dtDate = new Date(p_lDate);
    }

    public static CMyDateTime now() {
        CMyDateTime mydtNow = new CMyDateTime();
        mydtNow.setDateTimeWithCurrentTime();
        return mydtNow;
    }

    public boolean isNull() {
        return this.m_dtDate == null;
    }

    public long getTimeInMillis() {
        return this.m_dtDate == null ? 0L : this.m_dtDate.getTime();
    }

    public static int getTimeZoneRawOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        int nOffset = timeZone.getRawOffset();
        return nOffset;
    }

    public long compareTo(Date p_dtAnother) {
        long lMyTime = this.m_dtDate == null ? 0L : this.m_dtDate.getTime();
        long lAnotherTime = p_dtAnother == null ? 0L : p_dtAnother.getTime();
        return lMyTime - lAnotherTime;
    }

    public long compareTo(CMyDateTime p_mydtAnother) {
        return this.compareTo(p_mydtAnother.getDateTime());
    }

    public long dateDiff(int p_nPart, CMyDateTime p_mydtAnother) throws CMyException {
        if (p_mydtAnother == null) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label1", "\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u5bf9\u8c61\u53c2\u6570(CMyDateTime.dateDiff(CMyDateTime))"));
        }
        return this.dateDiff(p_nPart, p_mydtAnother.getDateTime());
    }

    public long dateDiff(int p_nPart, Date p_dtAnother) throws CMyException {
        if (p_dtAnother == null) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label2", "\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u53c2\u6570\uff08CMyDateTime.dateDiff(int,java.util.Date)\uff09"));
        }
        if (this.isNull()) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label3", "\u65e5\u671f\u65f6\u95f4\u4e3a\u7a7a\uff08CMyDateTime.dateDiff(int,java.util.Date)\uff09"));
        }
        if (p_nPart == 1) {
            return this.dateDiff_year(p_dtAnother);
        }
        if (p_nPart == 2) {
            return this.dateDiff_month(p_dtAnother);
        }
        long lMyTime = this.m_dtDate == null ? 0L : this.m_dtDate.getTime();
        long lAnotherTime = p_dtAnother == null ? 0L : p_dtAnother.getTime();
        long lDiffTime = (lMyTime - lAnotherTime) / 1000L;
        switch (p_nPart) {
            case 3: {
                return lDiffTime / 86400L;
            }
            case 4: {
                return lDiffTime / 3600L;
            }
            case 5: {
                return lDiffTime / 60L;
            }
            case 6: {
                return lDiffTime;
            }
            case 11: {
                return lDiffTime / 86400L / 91L;
            }
            case 12: {
                return lDiffTime / 86400L / 7L;
            }
        }
        throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label4", "\u53c2\u6570\u65e0\u6548(CMyDateTime.dateDiff(int,java.util.Date))"));
    }

    private long dateDiff_year(Date p_dtAnother) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getDefault());
        cal.setTime(this.m_dtDate);
        int nYear1 = cal.get(1);
        int nMonth1 = cal.get(2);
        cal.setTime(p_dtAnother);
        int nYear2 = cal.get(1);
        int nMonth2 = cal.get(2);
        if (nYear1 == nYear2) {
            return 0L;
        }
        if (nYear1 > nYear2) {
            return nYear1 - nYear2 + (nMonth1 >= nMonth2 ? 0 : -1);
        }
        return nYear1 - nYear2 + (nMonth1 > nMonth2 ? 1 : 0);
    }

    public long dateDiff_month(Date p_dtAnother) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getDefault());
        cal.setTime(this.m_dtDate);
        int nMonths1 = cal.get(1) * 12 + cal.get(2);
        int nDay1 = cal.get(5);
        cal.setTime(p_dtAnother);
        int nMonths2 = cal.get(1) * 12 + cal.get(2);
        int nDay2 = cal.get(5);
        if (nMonths1 == nMonths2) {
            return 0L;
        }
        if (nMonths1 > nMonths2) {
            return nMonths1 - nMonths2 + (nDay1 < nDay2 ? -1 : 0);
        }
        return nMonths1 - nMonths2 + (nDay1 > nDay2 ? 1 : 0);
    }

    public int get(int p_nField) throws CMyException {
        if (this.m_dtDate == null) {
            throw new CMyException(20, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label5", "\u65e5\u671f\u65f6\u95f4\u4e3a\u7a7a\uff08CMyDateTime.get\uff09"));
        }
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getDefault());
        cal.setTime(this.m_dtDate);
        switch (p_nField) {
            case 1: {
                return cal.get(1);
            }
            case 2: {
                return cal.get(2) + 1;
            }
            case 3: {
                return cal.get(5);
            }
            case 4: {
                return cal.get(11);
            }
            case 5: {
                return cal.get(12);
            }
            case 6: {
                return cal.get(13);
            }
            case 12: {
                return cal.get(7);
            }
            case 13: {
                return cal.getActualMaximum(5);
            }
            case 14: {
                return this.getWeekCountsOfMonth(true);
            }
            case 15: {
                return cal.getActualMaximum(6);
            }
            case 16: {
                return cal.getActualMaximum(3);
            }
        }
        throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label6", "\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u57df\u53c2\u6570\uff08CMyDateTime.get\uff09"));
    }

    public int getYear() throws CMyException {
        return this.get(1);
    }

    public int getMonth() throws CMyException {
        return this.get(2);
    }

    public int getDay() throws CMyException {
        return this.get(3);
    }

    public int getHour() throws CMyException {
        return this.get(4);
    }

    public int getMinute() throws CMyException {
        return this.get(5);
    }

    public int getSecond() throws CMyException {
        return this.get(6);
    }

    public int getDayOfWeek() throws CMyException {
        return this.get(12);
    }

    public CMyDateTime dateAdd(int p_nField, int p_nAdd) throws CMyException {
        if (this.m_dtDate == null) {
            throw new CMyException(20, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label7", "\u65e5\u671f\u65f6\u95f4\u4e3a\u7a7a\uff08CMyDateTime.dateAdd\uff09"));
        }
        int nCalField = 0;
        switch (p_nField) {
            case 1: {
                nCalField = 1;
                break;
            }
            case 2: {
                nCalField = 2;
                break;
            }
            case 12: {
                nCalField = 5;
                p_nAdd *= 7;
                break;
            }
            case 3: {
                nCalField = 5;
                break;
            }
            case 4: {
                nCalField = 10;
                break;
            }
            case 5: {
                nCalField = 12;
                break;
            }
            case 6: {
                nCalField = 13;
                break;
            }
            default: {
                throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label8", "\u65e0\u6548\u7684\u65e5\u671f\u65f6\u95f4\u57df\u53c2\u6570\uff08CMyDateTime.dateAdd\uff09"));
            }
        }
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getDefault());
        cal.setTime(this.m_dtDate);
        cal.set(nCalField, cal.get(nCalField) + p_nAdd);
        this.m_dtDate = cal.getTime();
        return this;
    }

    public synchronized Object clone() {
        CMyDateTime newMyDateTime = new CMyDateTime();
        newMyDateTime.m_dtDate = this.m_dtDate == null ? null : (Date)this.m_dtDate.clone();
        newMyDateTime.m_dtFormater = this.m_dtFormater == null ? null : (SimpleDateFormat)this.m_dtFormater.clone();
        return newMyDateTime;
    }

    public Date getDateTime() {
        return this.m_dtDate;
    }

    public String toString() {
        return this.toString(DEF_DATETIME_FORMAT_PRG);
    }

    public String toString(String p_sFormat) {
        if (this.m_dtDate == null) {
            return null;
        }
        try {
            return this.getDateTimeAsString(p_sFormat);
        }
        catch (CMyException ex) {
            return null;
        }
    }

    public String toString(String sFormat, String sLocaleId, String sTimezoneId) {
        boolean bWithTimezone;
        if (this.m_dtDate == null) {
            return null;
        }
        boolean bWithLocale = !CMyString.isEmpty(sLocaleId);
        boolean bl = bWithTimezone = !CMyString.isEmpty(sTimezoneId);
        if (!bWithLocale && !bWithTimezone) {
            return this.toString(sFormat);
        }
        try {
            Locale locale = bWithLocale ? new Locale(sLocaleId) : Locale.getDefault();
            TimeZone timeZone = bWithTimezone ? TimeZone.getTimeZone(sTimezoneId) : TimeZone.getDefault();
            SimpleDateFormat df = new SimpleDateFormat(sFormat, locale);
            df.setTimeZone(timeZone);
            return df.format(this.m_dtDate);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public java.sql.Date toDate() {
        if (this.m_dtDate == null) {
            return null;
        }
        return new java.sql.Date(this.m_dtDate.getTime());
    }

    public Time toTime() {
        if (this.m_dtDate == null) {
            return null;
        }
        return new Time(this.m_dtDate.getTime());
    }

    public Timestamp toTimestamp() {
        if (this.m_dtDate == null) {
            return null;
        }
        return new Timestamp(this.m_dtDate.getTime());
    }

    public void setDateTime(Date p_dtDate) {
        this.m_dtDate = p_dtDate;
    }

    public boolean setDateTimeWithString(String p_sValue, String p_sFormat) throws CMyException {
        try {
            SimpleDateFormat dtFormat = new SimpleDateFormat(p_sFormat);
            this.m_dtDate = dtFormat.parse(p_sValue);
            return true;
        }
        catch (Exception ex) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label9", "\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\u503c\u548c\u683c\u5f0f\u65e0\u6548\uff08CMyDateTime.setDateTimeWithString\uff09"), ex);
        }
    }

    public void setDateTimeWithCurrentTime() {
        if (this.m_dtDate == null) {
            this.m_dtDate = new Date(System.currentTimeMillis());
        } else {
            this.m_dtDate.setTime(System.currentTimeMillis());
        }
    }

    public void setDateTimeWithTimestamp(Timestamp p_tsDateTime) throws CMyException {
        try {
            if (p_tsDateTime == null) {
                this.m_dtDate = null;
            } else {
                if (this.m_dtDate == null) {
                    this.m_dtDate = new Date();
                }
                this.m_dtDate.setTime(p_tsDateTime.getTime());
            }
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label10", "\u4f7f\u7528Timestamp\u5bf9\u8c61\u8bbe\u7f6e\u65e5\u671f\u548c\u65f6\u95f4\u51fa\u9519\uff1aCMyDateTime.setDateTimeWithTimestamp()"), ex);
        }
    }

    public void setDateTimeWithRs(ResultSet p_rsData, int p_nFieldIndex) throws CMyException {
        try {
            Timestamp tsDateTime = p_rsData.getTimestamp(p_nFieldIndex);
            this.setDateTimeWithTimestamp(tsDateTime);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label11", "\u4ece\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6\u65f6\u95f4\u5b57\u6bb5\u65f6\u51fa\u9519\uff1aCMyDateTime.setDateTimeWithRs()"), ex);
        }
    }

    public void setDateTimeWithRs(ResultSet p_rsData, String p_sFieldName) throws CMyException {
        try {
            Timestamp tsDateTime = p_rsData.getTimestamp(p_sFieldName);
            this.setDateTimeWithTimestamp(tsDateTime);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label11", "\u4ece\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6\u65f6\u95f4\u5b57\u6bb5\u65f6\u51fa\u9519\uff1aCMyDateTime.setDateTimeWithRs()"), ex);
        }
    }

    public boolean setDate(java.sql.Date p_dDate) throws CMyException {
        if (p_dDate == null) {
            return false;
        }
        return this.setDateWithString(p_dDate.toString(), 0);
    }

    public boolean setTime(Time p_tTime) throws CMyException {
        if (p_tTime == null) {
            return false;
        }
        return this.setTimeWithString(p_tTime.toString(), 0);
    }

    public boolean setDateWithString(String p_sDateValue, int p_nFormatType) throws CMyException {
        boolean blHasSepChar = false;
        int nLen = p_sDateValue.length();
        if (nLen < 6) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label12", "\u65e5\u671f\u5b57\u7b26\u4e32\u65e0\u6548\uff08CMyDateTime.setDateWithString\uff09"));
        }
        try {
            String sDateValue;
            switch (p_nFormatType) {
                case 1: {
                    blHasSepChar = nLen >= 10;
                    sDateValue = p_sDateValue.substring(0, 4) + "-" + p_sDateValue.substring(blHasSepChar ? 5 : 4, blHasSepChar ? 7 : 6) + "-" + p_sDateValue.substring(blHasSepChar ? 8 : 6, blHasSepChar ? 10 : 8);
                    break;
                }
                case 2: {
                    sDateValue = p_sDateValue.charAt(0) < '5' ? "20" : "19";
                    blHasSepChar = nLen >= 8;
                    sDateValue = sDateValue + p_sDateValue.substring(0, 2) + "-" + p_sDateValue.substring(blHasSepChar ? 3 : 2, blHasSepChar ? 5 : 4) + "-" + p_sDateValue.substring(blHasSepChar ? 6 : 4, blHasSepChar ? 8 : 6);
                    break;
                }
                default: {
                    sDateValue = p_sDateValue;
                }
            }
            if (this.m_dtDate == null) {
                return this.setDateTimeWithString(sDateValue, DEF_DATE_FORMAT_PRG);
            }
            String sTimeValue = this.getDateTimeAsString(DEF_TIME_FORMAT_PRG);
            return this.setDateTimeWithString(sDateValue + " " + sTimeValue, DEF_DATETIME_FORMAT_PRG);
        }
        catch (Exception ex) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label13", "\u65e0\u6548\u7684\u65e5\u671f\u5b57\u7b26\u4e32\uff08CMyException.setDateWithString\uff09"), ex);
        }
    }

    public boolean setTimeWithString(String p_sTimeValue, int p_nFormatType) throws CMyException {
        boolean blHasSepChar = false;
        int nLen = p_sTimeValue.length();
        if (nLen < 4) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label14", "\u65f6\u95f4\u5b57\u7b26\u4e32\u683c\u5f0f\u65e0\u6548\uff08\uff09"));
        }
        try {
            String sTimeValue;
            switch (p_nFormatType) {
                case 1: {
                    blHasSepChar = nLen >= 8;
                    sTimeValue = p_sTimeValue.substring(0, 2) + ":" + p_sTimeValue.substring(blHasSepChar ? 3 : 2, blHasSepChar ? 5 : 4) + ":" + p_sTimeValue.substring(blHasSepChar ? 6 : 4, blHasSepChar ? 8 : 6);
                    break;
                }
                case 2: {
                    blHasSepChar = nLen >= 5;
                    sTimeValue = p_sTimeValue.substring(0, 2) + ":" + p_sTimeValue.substring(blHasSepChar ? 3 : 2, blHasSepChar ? 5 : 4) + ":00";
                    break;
                }
                default: {
                    sTimeValue = p_sTimeValue;
                }
            }
            if (this.m_dtDate == null) {
                return this.setDateTimeWithString(sTimeValue, DEF_TIME_FORMAT_PRG);
            }
            String sDateValue = this.getDateTimeAsString(DEF_DATE_FORMAT_PRG);
            return this.setDateTimeWithString(sDateValue + " " + sTimeValue, DEF_DATETIME_FORMAT_PRG);
        }
        catch (Exception ex) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label15", "\u65e0\u6548\u7684\u65f6\u95f4\u5b57\u7b26\u4e32\uff08CMyException.setTimeWithString\uff09"), ex);
        }
    }

    public void setDateTimeFormat(String p_sFormat) {
        if (this.m_dtFormater == null) {
            this.m_dtFormater = new SimpleDateFormat(p_sFormat);
        } else {
            this.m_dtFormater.applyPattern(p_sFormat);
        }
    }

    public String getDateTimeAsString(String p_sFormat) throws CMyException {
        if (this.m_dtDate == null) {
            return null;
        }
        try {
            this.setDateTimeFormat(p_sFormat);
            return this.m_dtFormater.format(this.m_dtDate);
        }
        catch (Exception ex) {
            throw new CMyException(10, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label16", "\u6307\u5b9a\u7684\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u6709\u9519\uff08CMyDateTime.getDateTimeAsString\uff09"), ex);
        }
    }

    public String getDateTimeAsString() throws CMyException {
        if (this.m_dtDate == null || this.m_dtFormater == null) {
            return null;
        }
        try {
            return this.m_dtFormater.format(this.m_dtDate);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CMyDateTime.class, "CMyDateTime.label17", "\u683c\u5f0f\u5316\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\u51fa\u9519\uff08CMyDateTime.getDateTimeAsString()\uff09"), ex);
        }
    }

    public static String extractDateTimeFormat(String _sValue) {
        char[] FORMAT_CHAR = new char[]{'y', 'M', 'd', 'H', 'm', 's'};
        return CMyDateTime.extractFormat(_sValue, FORMAT_CHAR);
    }

    public static String extractDateFormat(String _sValue) {
        char[] FORMAT_CHAR = new char[]{'y', 'M', 'd'};
        return CMyDateTime.extractFormat(_sValue, FORMAT_CHAR);
    }

    public static String extractTimeFormat(String _sValue) {
        char[] FORMAT_CHAR = new char[]{'H', 'm', 's'};
        return CMyDateTime.extractFormat(_sValue, FORMAT_CHAR);
    }

    private static String extractFormat(String _sValue, char[] _formatChar) {
        if (_sValue == null) {
            return null;
        }
        char[] buffValue = _sValue.trim().toCharArray();
        if (buffValue.length == 0) {
            return null;
        }
        StringBuffer buffFormat = new StringBuffer(19);
        int nAt = 0;
        int nAtField = 0;
        while (nAt < buffValue.length) {
            char aChar;
            if (Character.isDigit(aChar = buffValue[nAt++])) {
                buffFormat.append(_formatChar[nAtField]);
                continue;
            }
            buffFormat.append(aChar);
            if (++nAtField < _formatChar.length) continue;
            break;
        }
        return buffFormat.toString();
    }

    public boolean setDateTimeWithString(String _sValue) throws CMyException {
        String sFormat = CMyDateTime.extractDateTimeFormat(_sValue);
        if (_sValue == null) {
            return false;
        }
        return this.setDateTimeWithString(_sValue, sFormat);
    }

    public static final String formatTimeUsed(long iMillis) {
        if (iMillis <= 0L) {
            return "";
        }
        int iSecond = 0;
        int iMinute = 0;
        StringBuffer sb = new StringBuffer(16);
        iSecond = (int)(iMillis / 1000L);
        iMillis %= 1000L;
        if (iSecond > 0) {
            iMinute = iSecond / 60;
            iSecond %= 60;
        }
        if (iMinute > 0) {
            if (iMinute > 1) {
                sb.append(iMinute).append(I18NMessage.get(CMyDateTime.class, "CMyDateTime.label18", "\u5206"));
            } else {
                sb.append(iMinute).append(I18NMessage.get(CMyDateTime.class, "CMyDateTime.label20", "\u5206"));
            }
            if (iSecond < 10) {
                sb.append('0');
            }
            sb.append(iSecond);
        } else {
            sb.append(iSecond).append('.');
            if (iMillis < 10L) {
                sb.append('0').append('0');
            } else if (iMillis < 100L) {
                sb.append('0');
            }
            sb.append(iMillis);
        }
        if (iMillis > 1L) {
            sb.append(I18NMessage.get(CMyDateTime.class, "CMyDateTime.label19", "\u79d2"));
        } else {
            sb.append(I18NMessage.get(CMyDateTime.class, "CMyDateTime.label21", "\u79d2"));
        }
        return sb.toString();
    }

    public static String getStr(Object _dtTime, String _sFormat) {
        if (_dtTime instanceof CMyDateTime) {
            return ((CMyDateTime)_dtTime).toString(_sFormat);
        }
        return CMyString.showObjNull(_dtTime);
    }

    public static void main(String[] args) {
        CMyDateTime myDateTime = new CMyDateTime();
        try {
            int i;
            CMyDateTime now = CMyDateTime.now();
            System.out.println("now:" + now.toString(DEF_DATETIME_FORMAT_PRG));
            CMyDateTime nowClone = (CMyDateTime)now.clone();
            CMyDateTime execStartTime = nowClone.dateAdd(3, -30);
            System.out.println("now-30:" + execStartTime.toString(DEF_DATETIME_FORMAT_PRG));
            System.out.println("now:" + now.toString(DEF_DATETIME_FORMAT_PRG));
            System.out.println("nowClone:" + nowClone.toString(DEF_DATETIME_FORMAT_PRG));
            now = CMyDateTime.now();
            execStartTime = now.dateAdd(3, -3);
            System.out.println("now-3:" + execStartTime.toString(DEF_DATETIME_FORMAT_PRG));
            now = CMyDateTime.now();
            execStartTime = now.dateAdd(4, -3);
            System.out.println("now-3:" + execStartTime.toString(DEF_DATETIME_FORMAT_PRG));
            execStartTime.setDateTimeWithString("2002.1.1 00:00:00", "yyyy.MM.dd HH:mm:ss");
            System.out.println("time:" + execStartTime.toString(DEF_DATETIME_FORMAT_PRG));
            execStartTime.setDateTimeWithString(execStartTime.toString(DEF_DATE_FORMAT_PRG) + " 23:00:00", DEF_DATETIME_FORMAT_PRG);
            CMyDateTime execEndTime = CMyDateTime.now();
            execEndTime.setDateTimeWithString(execEndTime.toString(DEF_DATE_FORMAT_PRG) + " 24:00:00", DEF_DATETIME_FORMAT_PRG);
            System.out.println("now:" + now.toString());
            System.out.println("execStartTime:" + execStartTime.toString());
            System.out.println("now.compareTo(execStartTime):" + now.compareTo(execStartTime));
            System.out.println("TimeZone = " + CMyDateTime.getTimeZoneRawOffset());
            myDateTime.setDateTimeWithCurrentTime();
            System.out.println("Start:" + myDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            long nTime = myDateTime.getTimeInMillis() % 3600000L;
            System.out.print("\nTime=" + nTime);
            Time tempTime = new Time(nTime);
            System.out.print("  " + tempTime.toString());
            System.out.print("\n");
            myDateTime.setDateWithString("2001-04-15", 0);
            System.out.println(myDateTime.getDateTimeAsString("yyyy.MM.dd"));
            myDateTime.setDateWithString("000505", 2);
            System.out.println(myDateTime.getDateTimeAsString("yyyy.MM.dd"));
            myDateTime.setTimeWithString("12:01:02", 0);
            System.out.println(myDateTime.getDateTimeAsString(DEF_TIME_FORMAT_PRG));
            myDateTime.setTimeWithString("00:25", 2);
            System.out.println(myDateTime.getDateTimeAsString(DEF_DATETIME_FORMAT_PRG));
            java.sql.Date dDate = new java.sql.Date(0L);
            Time tTime = new Time(0L);
            dDate = java.sql.Date.valueOf("1978-02-04");
            tTime = Time.valueOf("12:00:20");
            System.out.println(myDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            myDateTime.setDate(dDate);
            System.out.println(myDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            myDateTime.setTime(tTime);
            System.out.println(myDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            myDateTime.setDateTimeWithCurrentTime();
            System.out.println("End:" + myDateTime.getDateTimeAsString("yyyy/MM/dd HH:mm:ss"));
            CMyDateTime myDateTime2 = new CMyDateTime();
            int[] nFields = new int[]{1, 2, 3, 4, 5, 6, 11, 12};
            myDateTime2.setDateTimeWithString("2001-02-07 14:34:00", DEF_DATETIME_FORMAT_PRG);
            myDateTime.setDateTimeWithString("2001-03-07 15:35:01", DEF_DATETIME_FORMAT_PRG);
            for (i = 0; i < 8; ++i) {
                long lDateDiff = myDateTime.dateDiff(nFields[i], myDateTime2.getDateTime());
                System.out.println("DateDiff(" + nFields[i] + ")=" + lDateDiff);
            }
            for (i = 0; i < 6; ++i) {
                System.out.println("get(" + nFields[i] + ")=" + myDateTime.get(nFields[i]));
            }
            System.out.println("getWeek=" + myDateTime.get(12));
            System.out.println("Test for dateAdd()");
            System.out.println("oldDateTime = " + myDateTime.toString());
            myDateTime.dateAdd(1, 12);
            System.out.println("dateAdd(YEAR,12) = " + myDateTime.toString());
            myDateTime.dateAdd(1, -12);
            System.out.println("dateAdd(YEAR,-12) = " + myDateTime.toString());
            myDateTime.dateAdd(2, -3);
            System.out.println("dateAdd(MONTH,-3) = " + myDateTime.toString());
            myDateTime.dateAdd(3, 10);
            System.out.println("dateAdd(DAY,10) = " + myDateTime.toString());
            myDateTime.setDateTimeWithCurrentTime();
            int nWeek = myDateTime.getDayOfWeek();
            myDateTime.dateAdd(3, -nWeek);
            System.out.println("Monday of this week is:" + myDateTime.toString(DEF_DATE_FORMAT_PRG));
            for (int j = 1; j < 7; ++j) {
                myDateTime.dateAdd(3, 1);
                System.out.println(j + 1 + " of this week is:" + myDateTime.toString(DEF_DATE_FORMAT_PRG));
            }
            System.out.println("\n\n===== test for CMyDateTime.set() ====== ");
            String[] sValues = new String[]{"2002.06.13 12:00:12", "1900.2.4 3:4:5", "1901-03-15 23:05:10", "1978-2-4 5:6:7", "2001/12/31 21:08:22", "1988/2/5 9:1:2", "1986.12.24", "0019.2.8", "2002-12-20", "1999-8-1", "2001/12/21", "2000/1/5", "78.02.04", "89.2.6", "99-12-31", "22-3-6", "01/02/04", "02/5/8"};
            for (int j = 0; j < sValues.length; ++j) {
                myDateTime.setDateTimeWithString(sValues[j]);
                System.out.println("[" + j + "]" + CMyDateTime.extractDateTimeFormat(sValues[j]) + "  " + myDateTime.toString());
            }
        }
        catch (CMyException ex) {
            ex.printStackTrace(System.out);
        }
    }

    public boolean isLeapYear() throws CMyException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.m_dtDate);
        return calendar.isLeapYear(this.getYear());
    }

    public boolean isToday() {
        CMyDateTime today = CMyDateTime.now();
        return this.toString(DEF_DATE_FORMAT_PRG).equals(today.toString(DEF_DATE_FORMAT_PRG));
    }

    public int getWeekCountsOfMonth(boolean _bSundayStart) throws CMyException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.m_dtDate);
        int nWeekCounts = calendar.getActualMaximum(4);
        if (_bSundayStart) {
            return nWeekCounts;
        }
        CMyDateTime firstDay = new CMyDateTime();
        firstDay.setDateTime(this.m_dtDate);
        firstDay.setDateTimeWithString(firstDay.getYear() + "-" + firstDay.getMonth() + "-1");
        if (firstDay.getDayOfWeek() == 6) {
            ++nWeekCounts;
        }
        return nWeekCounts;
    }

    public boolean equals(Object _another) {
        return _another != null && _another instanceof CMyDateTime && ((CMyDateTime)_another).getTimeInMillis() == this.getTimeInMillis();
    }

    public boolean testDateFormat(String _sFieldValue) {
        try {
            boolean isValid = this.setDateTimeWithString(_sFieldValue);
            return isValid;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setMinDayTime() throws CMyException {
        Date date;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.getYear());
        calendar.set(2, this.getMonth() - 1);
        calendar.set(5, this.getDay());
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, calendar.getActualMinimum(14));
        this.m_dtDate = date = calendar.getTime();
    }

    public void setMaxDayTime() throws CMyException {
        Date date;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.getYear());
        calendar.set(2, this.getMonth() - 1);
        calendar.set(5, this.getDay());
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, calendar.getActualMaximum(14));
        this.m_dtDate = date = calendar.getTime();
    }
}

