/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.cms.ObjectTypeServer;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.log.OperType;
import com.trs.infra.support.log.OperTypes;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class LogListUtil {
    private static final Map LOG_OBJS = new HashMap(15, 0.2f);
    private static final Map LOG_TYPES = new HashMap(100, 0.2f);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLogObjs(boolean forceLoad) {
        if (forceLoad || LOG_TYPES.size() <= 15) {
            String sql = "select distinct LOGOBJTYPE from WCMLOG";
            DBManager dbmanager = DBManager.getDBManager();
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            HashMap<String, String> temp = new HashMap<String, String>(15, 0.2f);
            try {
                conn = dbmanager.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int type = rs.getInt(1);
                    String objName = WCMTypes.getObjName(type, true);
                    if ("\u672a\u77e5".equals(objName)) {
                        try {
                            objName = ObjectTypeServer.get(type).getName();
                            int ix = objName.lastIndexOf(".");
                            if (ix != -1) {
                                objName = objName.substring(ix + 1);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    temp.put(String.valueOf(type), objName);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("\u521d\u59cb\u5316\u64cd\u4f5c\u5bf9\u8c61\u7f13\u51b2\u5931\u8d25", ex);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (conn != null) {
                    try {
                        dbmanager.freeConnection(conn);
                    }
                    catch (Exception exception) {}
                }
            }
            if (temp.size() > LOG_OBJS.size()) {
                Map map = LOG_OBJS;
                synchronized (map) {
                    LOG_OBJS.putAll(temp);
                }
            }
            temp.clear();
        }
        TreeMap result = new TreeMap();
        result.putAll(LOG_OBJS);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLogOpTypes(boolean forceLoad) {
        if (forceLoad || LOG_TYPES.size() <= 100) {
            String sql = "select distinct LOGOPTYPE from WCMLOG";
            DBManager dbmanager = DBManager.getDBManager();
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            StringBuffer buff = new StringBuffer(256);
            try {
                conn = dbmanager.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    buff.append(",").append(rs.getInt(1));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("\u521d\u59cb\u5316\u64cd\u4f5c\u7c7b\u578b\u7f13\u51b2\u5931\u8d25", ex);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (conn != null) {
                    try {
                        dbmanager.freeConnection(conn);
                    }
                    catch (Exception exception) {}
                }
            }
            HashMap<Integer, String> temp = new HashMap<Integer, String>(100, 0.2f);
            if (buff.length() > 0) {
                OperTypes types = OperTypes.findByIds(buff.substring(1));
                int size = types.size();
                for (int i = 0; i < size; ++i) {
                    OperType type = (OperType)types.getAt(i);
                    if (type == null) continue;
                    temp.put(type.getKey(), type.getDesc());
                }
                types.clear();
            }
            if (temp.size() > LOG_TYPES.size()) {
                Map map = LOG_TYPES;
                synchronized (map) {
                    LOG_TYPES.putAll(temp);
                }
            }
            temp.clear();
        }
        TreeMap result = new TreeMap();
        result.putAll(LOG_TYPES);
        return result;
    }
}

