/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.file;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.config.Configs;
import com.trs.infra.support.config.PathConfig;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class FilesMan {
    private static Logger s_logger = Logger.getLogger(FilesMan.class);
    private static FilesMan m_filesMan = new FilesMan();
    public static final int FILENAME_MIN_LENGTH = 22;
    public static final int FILENAME_FLAG_LENGTH = 2;
    public static final int FILENAME_DATE_LENGTH = 8;
    public static final int FILENAME_TIME_LENGTH = 8;
    public static final int FILENAME_RANDOM_LENGTH = 4;
    private static final int TIMEZONE_RAWOFFSET = TimeZone.getDefault().getRawOffset();
    public static final String FLAG_NORMAL = "N0";
    public static final String FLAG_PROTECTED = "P0";
    public static final String FLAG_UPLOAD = "U0";
    public static final String FLAG_SYSTEMTEMP = "ST";
    public static final String FLAG_USERTEMP = "UT";
    public static final String FLAG_TEMPLATE = "TM";
    public static final String FLAG_LOCALPUB = "LP";
    public static final String FLAG_LOCALPREVIEW = "LV";
    public static final String FLAG_WEBFILE = "W0";
    public static final String FLAG_DOCUMENTSOURCE = "DS";
    public static final String FLAG_SITEFROM = "SF";
    public static final String FLAG_BIGTABLE = "BT";
    public static final String FLAG_INFOVIEW = "IV";
    public static final String FLAG_TRANSFORMER = "TF";
    public static final String FLAG_HELPSEARCH = "HS";
    public static final int PATH_LOCAL = 0;
    public static final int PATH_HTTP = 1;
    public static final int PATH_FTP = 2;
    private final HashMap m_hPathConfig = new HashMap(11);

    private FilesMan() {
    }

    public static FilesMan getFilesMan() {
        if (FilesMan.m_filesMan.m_hPathConfig.isEmpty()) {
            FilesMan.loadFilesMan();
        }
        return m_filesMan;
    }

    private synchronized void loadPathConfigs(boolean _bMakeDirIfNotExists) throws WCMException {
        if (!FilesMan.m_filesMan.m_hPathConfig.isEmpty()) {
            return;
        }
        Configs configs = null;
        Config aConfig = null;
        ConfigServer server = ConfigServer.getServer();
        try {
            configs = new Configs();
            configs.open(new WCMFilter("", "CType=10", ""));
            for (int i = 0; i < configs.size(); ++i) {
                aConfig = (Config)configs.getAt(i);
                if (aConfig == null) continue;
                String sKey = aConfig.getConfigKey();
                String sPath = server.getInitProperty(sKey);
                if (CMyString.isEmpty(sPath)) {
                    sPath = aConfig.getValue();
                    server.setInitProperties(sKey, sPath);
                }
                try {
                    this.putPathConfig(sKey, sPath, _bMakeDirIfNotExists);
                    continue;
                }
                catch (Exception ex) {
                    s_logger.error((Object)(I18NMessage.get(FilesMan.class, "FilesMan.label1", "--->\u914d\u7f6e\u8bb0\u5f55\uff1aWCMConfig Id=[") + aConfig.getId() + "] Key=[" + aConfig.getConfigKey() + "]  Value=[" + aConfig.getValue() + "] \uff09"), (Throwable)ex);
                }
            }
            configs.clear();
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label2", "\u88c5\u8f7d\u6587\u4ef6\u76ee\u5f55\u914d\u7f6e\u4fe1\u606f\u65f6\u5931\u8d25(FilesMan.loadPathConfigs)"), ex);
        }
    }

    public boolean putPathConfig(Config _config, boolean _bMakeDirIfNotExists) throws WCMException {
        if (_config == null || !_config.isValidInstance()) {
            return false;
        }
        try {
            String sKey = _config.getConfigKey().trim();
            if (sKey.length() != 2) {
                throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label3", "\u76ee\u5f55\u914d\u7f6e\u4e2d\u5173\u952e\u5b57\u5fc5\u987b\u4e3a2\u4f4d(FilesMan.loadPathConfig)"));
            }
            PathConfig pathConfig = new PathConfig(_config.getValue());
            return this.putPathConfig(sKey, pathConfig, _bMakeDirIfNotExists);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label4", "\u88c5\u8f7d\u914d\u7f6e\u4fe1\u606f\u5931\u8d25(FilesMan.putPathConfig)"), ex);
        }
    }

    public boolean putPathConfig(String sKey, String sPath, boolean _bMakeDirIfNotExists) throws WCMException {
        if (CMyString.isEmpty(sKey) || CMyString.isEmpty(sPath)) {
            return false;
        }
        try {
            sKey = sKey.trim();
            if (sKey.length() != 2) {
                throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label3", "\u76ee\u5f55\u914d\u7f6e\u4e2d\u5173\u952e\u5b57\u5fc5\u987b\u4e3a2\u4f4d(FilesMan.loadPathConfig)"));
            }
            PathConfig pathConfig = new PathConfig(sPath);
            return this.putPathConfig(sKey, pathConfig, _bMakeDirIfNotExists);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label4", "\u88c5\u8f7d\u914d\u7f6e\u4fe1\u606f\u5931\u8d25(FilesMan.putPathConfig)"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putPathConfig(String _sPathFlag, PathConfig _pathConfig, boolean _bMakeDirIfNotExists) throws Exception {
        if (_pathConfig == null) {
            return false;
        }
        String sLocalPath = _pathConfig.getLocalPath();
        if (!CMyFile.fileExists(sLocalPath)) {
            if (_bMakeDirIfNotExists) {
                CMyFile.makeDir(sLocalPath, true);
            } else {
                throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label5", "\u672c\u5730\u8def\u5f84") + sLocalPath + I18NMessage.get(FilesMan.class, "FilesMan.label6", "\u4e0d\u5b58\u5728(FilesMan.loadPathConfig)"));
            }
        }
        HashMap hashMap = this.m_hPathConfig;
        synchronized (hashMap) {
            this.m_hPathConfig.put(_sPathFlag.toUpperCase(), _pathConfig);
        }
        return true;
    }

    public PathConfig removePathConfig(String _sPathFlag) {
        return null;
    }

    public PathConfig getPathConfig(String _sPathFlag) {
        return (PathConfig)this.m_hPathConfig.get(_sPathFlag);
    }

    public String getPathConfigValue(String _sPathFlag, int _nPathType) {
        String sPath;
        PathConfig pathConfig = this.getPathConfig(_sPathFlag);
        if (pathConfig == null) {
            return null;
        }
        switch (_nPathType) {
            case 0: {
                sPath = pathConfig.getLocalPath();
                sPath = FilesMan.getLocalFormatPath(sPath);
                break;
            }
            case 1: {
                sPath = pathConfig.getHttpPath();
                break;
            }
            case 2: {
                sPath = pathConfig.getFtpPath();
                break;
            }
            default: {
                return null;
            }
        }
        return sPath;
    }

    private static String getLocalFormatPath(String sPath) {
        return sPath;
    }

    public String mapFilePath(String _sFileName, int _nPathType) throws WCMException {
        String sPath;
        if (_sFileName == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label7", "\u6587\u4ef6\u540d\u4e3a\u7a7a(FilesMan.mapFilePath)"));
        }
        if ((_sFileName = _sFileName.trim()).indexOf("..") >= 0) {
            throw new WCMException(10, "[" + _sFileName + I18NMessage.get(FilesMan.class, "FilesMan.label8", "]\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.mapFilePath)"));
        }
        if ((_sFileName = CMyFile.extractFileName(_sFileName)).length() < 22) {
            throw new WCMException(10, "[" + _sFileName + I18NMessage.get(FilesMan.class, "FilesMan.label8", "]\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.mapFilePath)"));
        }
        PathConfig pathConfig = null;
        pathConfig = this.getPathConfig(_sFileName.substring(0, 2));
        if (pathConfig == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label9", "_sFileName:[" + _sFileName + "]\uff0c\u6587\u4ef6\u683c\u5f0f\u4e0d\u5339\u914d\uff1a\u7c7b\u578b\u6807\u8bc6\u65e0\u6548(FilesMan.mapFilePath)"));
        }
        char chrPathSeparator = _nPathType == 0 ? File.separatorChar : (char)'/';
        switch (_nPathType) {
            case 0: {
                sPath = pathConfig.getLocalPath();
                break;
            }
            case 1: {
                sPath = pathConfig.getHttpPath();
                break;
            }
            case 2: {
                sPath = pathConfig.getFtpPath();
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label10", "\u65e0\u6548\u7684\u8def\u5f84\u7c7b\u522b(FilesMan.mapFilePath)"));
            }
        }
        sPath = sPath + _sFileName.substring(0, 8) + chrPathSeparator + _sFileName.substring(0, 10) + chrPathSeparator;
        return sPath;
    }

    public synchronized String getNextFileName(String _sPathFlag, String _sFileExt, CMyDateTime _crTime, boolean _bIncludePath) throws WCMException {
        if (_sFileExt.indexOf("..") >= 0) {
            throw new WCMException("\u975e\u6cd5\u6587\u4ef6\u540e\u7f00\u4fe1\u606f\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u6587\u4ef6\u540d");
        }
        if ((_sFileExt = _sFileExt.replace("?", "")).length() > 8) {
            throw new WCMException("\u4e0d\u662f\u5e38\u89c4\u540e\u7f00\u4fe1\u606f\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u6587\u4ef6\u540d");
        }
        PathConfig pathConfig = null;
        if (_sPathFlag == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label11", "\u8def\u5f84\u6807\u8bc6\u4e3a\u7a7a\uff08FilesMan.getNextFileName\uff09"));
        }
        pathConfig = (PathConfig)this.m_hPathConfig.get(_sPathFlag = _sPathFlag.trim().toUpperCase());
        if (pathConfig == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label12", "\u65e0\u6548\u7684\u8def\u5f84\u6807\u8bc6\u53c2\u6570(FilesMan.getNextFileName)"));
        }
        if (_crTime == null || _crTime.isNull()) {
            _crTime = CMyDateTime.now();
        }
        String sDate = _crTime.toString("yyyyMMdd");
        String sFilePath = pathConfig.getLocalPath() + _sPathFlag + sDate.substring(0, 6) + File.separatorChar + _sPathFlag + sDate.substring(0, 8) + File.separatorChar;
        if (!CMyFile.fileExists(sFilePath)) {
            try {
                CMyFile.makeDir(sFilePath, true);
            }
            catch (Exception ex) {
                throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label13", "\u6307\u5b9a\u8def\u5f84") + sFilePath + I18NMessage.get(FilesMan.class, "FilesMan.label14", "\u65e0\u6cd5\u521b\u5efa(FilesMan.getNextFileName)"));
            }
        }
        long lTime = (_crTime.getTimeInMillis() + (long)TIMEZONE_RAWOFFSET) % 86400000L;
        String sTime = CMyString.numberToStr(lTime, 8, '0');
        String sRandom = CMyString.numberToStr(Math.round(Math.random() * 10000.0), 4, '0');
        String sFileExt = _sFileExt.trim();
        if (sFileExt.length() > 0 && sFileExt.charAt(0) != '.') {
            sFileExt = "." + sFileExt;
        }
        String sFileName = _sPathFlag + sDate + sTime + sRandom;
        for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                sFileName = sFileName + CMyString.numberToStr(Math.round(Math.random() * 100.0), 2, '0');
            }
            if (CMyFile.fileExists(sFilePath + sFileName + sFileExt)) continue;
            return (_bIncludePath ? sFilePath : "") + sFileName + sFileExt;
        }
        return null;
    }

    public synchronized String getNextFileName(String _sPathFlag, String _sFileExt) throws WCMException {
        return this.getNextFileName(_sPathFlag, _sFileExt, null, false);
    }

    public synchronized String getTmpNextPath() throws WCMException {
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar) + "WEB-INF\\tmp\\";
        char replaceChar = File.separatorChar == '/' ? (char)'\\' : '/';
        sWCMPath = sWCMPath.replace(replaceChar, File.separatorChar);
        return sWCMPath;
    }

    public synchronized String getTmpNextFilePath(String _sFileExt) throws WCMException {
        return this.getTmpNextFilePath(FLAG_SYSTEMTEMP, _sFileExt);
    }

    public synchronized String getTmpNextFilePath(String _sPathFlag, String _sFileExt) throws WCMException {
        String sFileName = this.getNextFileName(_sPathFlag, _sFileExt, CMyDateTime.now());
        return this.getTmpNextPath() + sFileName;
    }

    public synchronized String getNextFileName(String _sPathFlag, String _sFileExt, CMyDateTime _crTime) throws WCMException {
        return this.getNextFileName(_sPathFlag, _sFileExt, _crTime, false);
    }

    public synchronized String getNextFilePathName(String _sPathFlag, String _sFileExt) throws WCMException {
        return this.getNextFileName(_sPathFlag, _sFileExt, null, true);
    }

    public synchronized String getNextFilePathName(String _sPathFlag, String _sFileExt, CMyDateTime _crTime) throws WCMException {
        return this.getNextFileName(_sPathFlag, _sFileExt, _crTime, true);
    }

    public static String extractFileCrDateValue(String _sFileName) throws WCMException {
        if (_sFileName.length() < 22) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label15", "\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.extractFileCrDateValue)"));
        }
        String sDate = _sFileName.substring(2, 6) + "-" + _sFileName.substring(6, 8) + "-" + _sFileName.substring(8, 10);
        return sDate;
    }

    public static long extractFileCrTimeValue(String _sFileName) throws WCMException {
        long lTime;
        if (_sFileName.length() < 22) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label16", "\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.extractFileCrTimeValue)"));
        }
        try {
            lTime = Integer.parseInt(_sFileName.substring(10, 18));
        }
        catch (Exception ex) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label16", "\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.extractFileCrTimeValue)"), ex);
        }
        return lTime;
    }

    public static CMyDateTime extractFileCrDate(String _sFileName) throws WCMException {
        CMyDateTime mydtCrDate;
        String sDate = FilesMan.extractFileCrDateValue(_sFileName);
        try {
            mydtCrDate = new CMyDateTime();
            mydtCrDate.setDateWithString(sDate, 0);
        }
        catch (CMyException ex) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label17", "\u65e0\u6548\u7684\u6587\u4ef6\u683c\u5f0f(FilesMan.extractFileCrDate)"), ex);
        }
        return mydtCrDate;
    }

    public static CMyDateTime extractFileCrDateTime(String _sFileName) throws WCMException {
        CMyDateTime mydtCrDate = null;
        mydtCrDate = FilesMan.extractFileCrDate(_sFileName);
        long lTime = FilesMan.extractFileCrTimeValue(_sFileName);
        return new CMyDateTime(mydtCrDate.getTimeInMillis() + lTime);
    }

    public String copyFile(String _srcFilePathName, String _dstPathFlag, boolean _bReturnPath) throws WCMException {
        try {
            String sFileExt = CMyFile.extractFileExt(_srcFilePathName);
            String sSaveFilePathName = this.getNextFilePathName(_dstPathFlag, sFileExt);
            CMyFile.copyFile(_srcFilePathName, sSaveFilePathName);
            return _bReturnPath ? sSaveFilePathName : CMyFile.extractFileName(sSaveFilePathName);
        }
        catch (BizError ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label18", "\u590d\u5236\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5931\u8d25\uff08FilesMan.copyFile\uff09"), ex);
        }
    }

    public String moveFile(String _srcFilePathName, String _dstPathFlag, boolean _bReturnPath) throws WCMException {
        try {
            String sSaveFile = this.copyFile(_srcFilePathName, _dstPathFlag, _bReturnPath);
            CMyFile.deleteFile(_srcFilePathName);
            return sSaveFile;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label19", "\u79fb\u52a8\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5931\u8d25\uff08FilesMan.moveFile\uff09"), ex);
        }
    }

    public boolean deleteFile(String _sFileName) throws WCMException {
        try {
            _sFileName = CMyFile.extractFileName(_sFileName.trim());
            String sFilePathName = this.mapFilePath(_sFileName, 0) + _sFileName;
            return CMyFile.deleteFile(sFilePathName);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label20", "\u5220\u9664\u6307\u5b9a\u7684\u6587\u4ef6\u5931\u8d25\uff08FilesMan.deleteFile\uff09"), ex);
        }
    }

    public String getTempAppendixFilePath(int _nSiteId, int _nPathType, boolean _bCreateWhenNotExists) throws WCMException {
        return this.getTemplateAppendixPath(103, _nSiteId, _nPathType, _bCreateWhenNotExists);
    }

    public String getTemplateAppendixPath(int _nRootType, int _nRootId, int _nPathType, boolean _bCreateWhenNotExists) throws WCMException {
        String sPath = this.getPathConfigValue(FLAG_TEMPLATE, _nPathType);
        if (sPath == null) {
            throw new WCMException(1100, "Path config for TM missing!");
        }
        char chrSpearator = _nPathType == 0 ? File.separatorChar : (char)'/';
        sPath = _nRootType == 103 ? sPath + "site" : sPath + "root" + Integer.toHexString(_nRootType) + chrSpearator;
        sPath = sPath + _nRootId + "" + chrSpearator;
        if (_nPathType == 0 && _bCreateWhenNotExists) {
            try {
                CMyFile.makeDir(sPath, true);
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to create template appendixes path:" + sPath, ex);
            }
        }
        return sPath;
    }

    public String getFileFlag(String _sFileName) {
        String sFlag = "";
        String sFileHeader = "";
        if (_sFileName == null) {
            sFlag = "";
        }
        if ((sFileHeader = _sFileName.substring(0, 2)).equals(FLAG_PROTECTED)) {
            sFlag = FLAG_PROTECTED;
        }
        if (sFileHeader.equals(FLAG_NORMAL)) {
            sFlag = FLAG_NORMAL;
        }
        if (sFileHeader.equals(FLAG_UPLOAD)) {
            sFlag = FLAG_UPLOAD;
        }
        if (sFileHeader.equals(FLAG_SYSTEMTEMP)) {
            sFlag = FLAG_SYSTEMTEMP;
        }
        if (sFileHeader.equals(FLAG_USERTEMP)) {
            sFlag = FLAG_USERTEMP;
        }
        if (sFileHeader.equals(FLAG_TEMPLATE)) {
            sFlag = FLAG_TEMPLATE;
        }
        if (sFileHeader.equals(FLAG_LOCALPUB)) {
            sFlag = FLAG_LOCALPUB;
        }
        if (sFileHeader.equals(FLAG_WEBFILE)) {
            sFlag = FLAG_WEBFILE;
        }
        return sFlag;
    }

    public String moveWCMFile(String _srcFileName, String _dstPathFlag, boolean _bReturnPath) throws WCMException {
        if (_srcFileName == null) {
            throw new WCMException(10, I18NMessage.get(FilesMan.class, "FilesMan.label21", "\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01"));
        }
        String sPathName = this.mapFilePath(_srcFileName, 0);
        try {
            String sMoveFile = this.moveFile(sPathName + _srcFileName, _dstPathFlag, _bReturnPath);
            return sMoveFile;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label19", "\u79fb\u52a8\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5931\u8d25\uff08FilesMan.moveFile\uff09"), ex);
        }
    }

    public String copyWCMFile(String _srcFileName, String _dstPathFlag) throws WCMException {
        try {
            String sFileName = this.mapFilePath(_srcFileName, 0) + _srcFileName;
            return this.copyFile(sFileName, _dstPathFlag, false);
        }
        catch (BizError ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FilesMan.class, "FilesMan.label22", "\u590d\u5236WCM\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5931\u8d25"), ex);
        }
    }

    private static void loadFilesMan() {
        try {
            m_filesMan.loadPathConfigs(true);
            s_logger.info((Object)I18NMessage.get(FilesMan.class, "FilesMan.label23", "\u88c5\u8f7d\u76ee\u5f55\u914d\u7f6e\u4fe1\u606f\u5b8c\u6210\uff01"));
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(FilesMan.class, "FilesMan.label24", "\u88c5\u8f7d\u76ee\u5f55\u914d\u7f6e\u4fe1\u606f\u5931\u8d25"), (Throwable)ex);
        }
    }

    public static boolean isValidFile(String _sFileName, String _sPathFlag) {
        int nLastPos = _sFileName.lastIndexOf(47);
        if (nLastPos >= 0) {
            boolean bValidFile;
            String sFileName = _sFileName.substring(nLastPos + 1);
            if (_sFileName.trim().toUpperCase().indexOf("HTTP") == 0) {
                try {
                    if (!CMyFile.fileExists(FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName)) {
                        return false;
                    }
                }
                catch (WCMException e) {
                    return false;
                }
                catch (Exception e) {
                    s_logger.warn((Object)(I18NMessage.get(FilesMan.class, "FilesMan.label29", "\u6821\u9a8c\u6587\u4ef6[") + sFileName + I18NMessage.get(FilesMan.class, "FilesMan.label30", "]\u683c\u5f0f\u65f6\u51fa\u73b0\u672a\u6355\u83b7\u7684\u5f02\u5e38\uff1a") + e.getMessage()), (Throwable)new Exception("who call me!"));
                    return false;
                }
            }
            if (!(bValidFile = FilesMan.isValidFile(sFileName, _sPathFlag))) {
                return false;
            }
            try {
                String sPath = FilesMan.getFilesMan().mapFilePath(sFileName, 1);
                return _sFileName.indexOf(sPath) >= 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (_sFileName == null || _sFileName.length() < 22 || _sFileName.length() > 28) {
            return false;
        }
        int nPos = _sFileName.indexOf(46);
        if (nPos != 22) {
            return false;
        }
        return _sFileName.indexOf(_sPathFlag) == 0;
    }

    public boolean fileExists(String _sFileName) {
        if (_sFileName == null) {
            return false;
        }
        try {
            String sFullName = this.mapFilePath(_sFileName, 0) + _sFileName;
            if (CMyFile.fileExists(sFullName)) {
                return true;
            }
        }
        catch (WCMException ex) {
            s_logger.warn((Object)I18NMessage.get(FilesMan.class, "FilesMan.label31", "\u65e0\u6cd5\u6620\u5c04\u6587\u4ef6\u7684\u672c\u5730\u8def\u5f84\uff0c\u53ef\u80fd\u662f\u6b63\u5e38\u903b\u8f91\uff0c\u7a0b\u5e8f\u7ee7\u7eed\u8fd0\u884c\u3002"));
            return false;
        }
        return false;
    }

    public boolean refreshPathConfig(Config _config) throws Exception {
        return true;
    }
}

