/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyEncrypt;
import com.trs.infra.util.CMyString;

public class Config
extends BaseObj {
    public static final int OBJ_TYPE = 701;
    public static final String DB_TABLE_NAME = "WCMCONFIG";
    public static final String DB_ID_NAME = "CONFIGID";
    public static final int TYPE_NORM = 0;
    public static final int TYPE_FILE_PATH = 10;
    public static final int TYPE_JOB_SERVER = 15;
    public static final int TYPE_SCHEDULE_SERVER = 16;
    public static final int TYPE_CLUSTER_META = 13;
    public static final int TYPE_CUSTOM_ADD = 20;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 701;
    }

    public int getType() {
        return this.getPropertyAsInt("CTYPE", 0);
    }

    public String getTypeName() {
        return ConfigServer.getServer().getTypeName(this.getType());
    }

    public boolean setType(int _nType) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Config.class, "Config.label1", "\u5c5e\u6027Type\u4e0d\u5141\u8bb8\u4fee\u6539\uff08Config.setType\uff09"));
        }
        return this.setProperty("CTYPE", _nType);
    }

    public String getConfigKey() {
        return (String)this.getProperty("CKEY");
    }

    public boolean setConfigKey(String _key) throws WCMException {
        return this.setProperty("CKEY", _key);
    }

    public boolean isEncrypted() {
        return this.getPropertyAsBoolean("ENCRYPTED", false);
    }

    public String getDesc() {
        return (String)this.getProperty("CDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("CDESC", _desc);
    }

    public String getValue() {
        String sValue = (String)this.getProperty("CVALUE");
        if (sValue == null) {
            return null;
        }
        if (this.isEncrypted()) {
            sValue = CMyEncrypt.setAnotherChar(sValue);
        }
        return sValue;
    }

    public boolean setValue(String _value) throws WCMException {
        boolean bEncrypted = this.isAddMode() ? false : this.isEncrypted();
        return this.setValue(_value, bEncrypted);
    }

    public boolean setValue(String _value, boolean _bEncrypted) throws WCMException {
        if (_value == null) {
            throw new WCMException(10, I18NMessage.get(Config.class, "Config.label2", "\u914d\u7f6e\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff08Config.setValue\uff09"));
        }
        if (!this.setProperty("ENCRYPTED", _bEncrypted)) {
            return false;
        }
        if (_bEncrypted) {
            _value = CMyEncrypt.setAnotherChar(_value);
        }
        return this.setProperty("CVALUE", _value);
    }

    @Override
    public boolean isValid() throws WCMException {
        int nSiteId = 0;
        String sKey = null;
        String sValue = null;
        if (this.isAddMode()) {
            String sType;
            if (this.getAllProperty().get("SITEID") != null) {
                nSiteId = ((Number)this.getAllProperty().get("SITEID")).intValue();
            }
            if ((sType = this.getPropertyAsString("CTYPE")) == null) {
                throw new WCMException(1106, I18NMessage.get(Config.class, "Config.label3", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e(Config.isValid)"));
            }
            sKey = (String)this.getAllProperty().get("CKEY");
            if (sKey == null) {
                throw new WCMException(1106, I18NMessage.get(Config.class, "Config.label4", "\u5c5e\u6027ConfigKey\u6ca1\u6709\u8bbe\u7f6e(Config.isValid)"));
            }
            if (10 == Integer.parseInt(sType) && sKey.length() != 2) {
                throw new WCMException(1104, I18NMessage.get(Config.class, "Config.label5", "\u76ee\u5f55\u914d\u7f6e\u4e2d\u5173\u952e\u5b57\u5fc5\u987b\u4e3a2\u4f4d!\u60a8\u8bbe\u7f6e\u7684\u5173\u952e\u5b57\u662f[") + sKey + "]");
            }
            this.getAllProperty().put("CKEY", sKey.toUpperCase());
            sValue = (String)this.getAllProperty().get("CVALUE");
            if (this.getAllProperty().get("CVALUE") == null) {
                throw new WCMException(1106, I18NMessage.get(Config.class, "Config.label6", "\u5c5e\u6027Value\u6ca1\u6709\u8bbe\u7f6e(Config.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Config.class, "Config.label7", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Config.isValid)"));
            }
            sValue = this.getNewPropertyAsString("CVALUE");
        }
        if (sValue != null) {
            boolean bEncrypted = this.isEncrypted();
            if (this.isChangeProperty("ENCRYPTED")) {
                bEncrypted = this.getNewPropertyAsInt("ENCRYPTED", 0) == 1;
            }
            this.setValue(sValue, bEncrypted);
        }
        if (sKey != null) {
            String strCondition = " (CKey='" + CMyString.filterForSQL(sKey) + "') and (CType=" + this.getType() + ") and SiteId=" + nSiteId;
            if (!this.isAddMode()) {
                strCondition = strCondition + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(Config.class, "Config.label8", "\u76f8\u540c\u7c7b\u522b\u7684\u914d\u7f6e\u4fe1\u606f\u4e2d\u5173\u952e\u5b57\u5df2\u7ecf\u5b58\u5728\uff08Config.isValid\uff09"));
            }
        }
        return true;
    }

    public static final Config findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Config)BaseObj.findById(Config.class, _nId);
    }

    public static final Config createNewInstance() throws WCMException {
        return (Config)BaseObj.createNewInstance(Config.class);
    }

    public static final Config findByKey(Object _oKey) throws WCMException {
        return (Config)BaseObj.findByKey(Config.class, _oKey);
    }

    @Override
    public void insert() throws WCMException {
        super.insert();
    }

    @Override
    public synchronized void update() throws WCMException {
        super.update();
    }

    @Override
    public int delete() throws WCMException {
        return super.delete();
    }
}

