/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.persistent.IObjTypeLookup;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ObjTypeLookupImpl
implements IObjTypeLookup {
    public static String CONFIG_FILE = "wcmtypes.ini";
    private static final Logger logger = Logger.getLogger((String)ObjTypeLookupImpl.class.getName());
    private HashMap m_types = new HashMap();
    private boolean m_bLoaded = false;

    @Override
    public int lookupByClassName(String _sClassName) {
        try {
            this.insureLoaded();
            Integer iValue = (Integer)this.m_types.get(_sClassName);
            if (iValue == null) {
                logger.error((Object)("Type for class " + _sClassName + " is required in " + CONFIG_FILE));
                return 0;
            }
            return iValue;
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to lookup the object type of " + _sClassName), (Throwable)ex);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insureLoaded() throws Exception {
        if (this.m_bLoaded) {
            return;
        }
        HashMap hashMap = this.m_types;
        synchronized (hashMap) {
            if (this.m_bLoaded) {
                return;
            }
            logger.debug((Object)("to load " + CONFIG_FILE + " ..."));
            String sFullPath = CMyFile.mapResouceFullPath(CONFIG_FILE);
            Properties properties = null;
            try (InputStream is = null;){
                is = new FileService(sFullPath).getInputStream();
                properties = new Properties();
                properties.load(is);
            }
            logger.debug((Object)("to parse " + CONFIG_FILE + " ..."));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                try {
                    int nType = Integer.parseInt((String)entry.getValue());
                    this.m_types.put(entry.getKey(), new Integer(nType));
                }
                catch (Exception ex) {
                    logger.error((Object)("Integer value is required: " + entry.getKey() + "=" + entry.getValue()));
                }
            }
            logger.debug((Object)(CONFIG_FILE + " has been loaded successfully!"));
            this.m_bLoaded = true;
        }
    }
}

