/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.TableInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class InjectSQLHelper {
    private static Logger logger = Logger.getLogger(InjectSQLHelper.class);
    public static final String KEYWORDS_DEFAULT = "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp";
    public static final String KEYWORDS_SELECT = "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from";
    public static final String KEYWORDS_FROM = "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from|where";
    public static final String KEYWORDS_WHERE = "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp";
    public static final String KEYWORDS_ORDER = "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from";
    public static final String KEYWORDS_GROUPBY = "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from|where";
    public static final String KEYWORDS_INFO = "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from|where";
    public static final String REG_INJECT_SQL_PRE = "(?i)((^|[^a-zA-Z]+)(";
    public static final String REG_INJECT_SQL_SUF = ")([^a-zA-Z]+|$))";

    public static final boolean containsInjectSQL(String _sSQL) {
        return InjectSQLHelper.containsInjectKeyWord(_sSQL, "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp");
    }

    public static final boolean containsInjectSelectSQL(String _sSQL) {
        return InjectSQLHelper.containsInjectKeyWord(_sSQL, "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from");
    }

    public static final boolean containsInjectSelectSQL(String _sSQL, String _sTableName) {
        if (CMyString.isEmpty(_sSQL) || _sSQL.trim().equals("*")) {
            return false;
        }
        boolean bContains = InjectSQLHelper.containsInjectKeyWord(_sSQL, "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from");
        if (bContains) {
            return true;
        }
        if (CMyString.isEmpty(_sTableName)) {
            return bContains;
        }
        if (_sSQL.trim().toUpperCase().equals(_sTableName.toUpperCase() + ".*")) {
            return false;
        }
        try {
            String[] pFieldNames;
            DBManager dbMgr = DBManager.getDBManager();
            TableInfo tableInfo = dbMgr.getTableInfo(_sTableName);
            for (String sFieldName : pFieldNames = _sSQL.split(",")) {
                int nPos = (sFieldName = sFieldName.trim().toLowerCase()).indexOf(" as ");
                if (nPos <= 0) {
                    nPos = sFieldName.indexOf(" ");
                }
                if (nPos > 0) {
                    sFieldName = sFieldName.substring(0, nPos).trim();
                }
                if ((nPos = sFieldName.indexOf(".")) >= 0) {
                    sFieldName = sFieldName.substring(nPos + 1);
                }
                if (sFieldName.equals("*") || tableInfo.getFieldInfo(sFieldName) != null) continue;
                logger.error((Object)("Find the field[" + sFieldName + "] not in the table[" + _sTableName + "]![SelectFields=" + _sSQL + "]"), (Throwable)new Exception("who call me"));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"Fail to get field info!", (Throwable)e);
            return bContains;
        }
    }

    public static final boolean containsInjectFromSQL(String _sSQL) {
        return InjectSQLHelper.containsInjectKeyWord(_sSQL, "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from|where");
    }

    public static final boolean containsInjectWhereSQL(String _sSQL) {
        return InjectSQLHelper.containsInjectKeyWord(_sSQL, "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp");
    }

    public static final boolean containsInjectOrderSQL(String _sSQL) {
        return InjectSQLHelper.containsInjectKeyWord(_sSQL, "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from");
    }

    public static final boolean containsInjectGroupBySQL(String _sSQL) {
        return InjectSQLHelper.containsInjectKeyWord(_sSQL, "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from|where");
    }

    public static final boolean containsInjectInfoSQL(String _sSQL) {
        return InjectSQLHelper.containsInjectKeyWord(_sSQL, "delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp|select|from|where");
    }

    public static final boolean containsInjectKeyWord(String _sSQL, String _sKeyWords) {
        if (CMyString.isEmpty(_sSQL)) {
            return false;
        }
        Pattern oPattern = Pattern.compile(REG_INJECT_SQL_PRE + _sKeyWords + REG_INJECT_SQL_SUF);
        Matcher oMatcher = oPattern.matcher(_sSQL);
        return oMatcher.find();
    }

    public static final void validSQL(String _sSQL, Object _parameters) {
        if (InjectSQLHelper.containsInjectSQL(_sSQL)) {
            logger.error((Object)("Find Inject SQL[" + _sSQL + "]" + (_parameters != null ? ",Parameters Info:\n" + _parameters : "")), (Throwable)new Exception("who call me"));
            throw new RuntimeException("Find Inject SQL,Please Contact administrator!");
        }
    }

    public static void main(String[] args) {
        String[] pSelectSQL;
        String[] pTestSQL;
        for (String sTestSQL : pTestSQL = new String[]{"User select  distinct User USERID from WCMUSER where UserName=? User"}) {
            System.out.println("======" + sTestSQL + "=======");
            Pattern oPattern = Pattern.compile("(?i)((^|[^a-zA-Z]+)(delete|update|insert|outfile|extractvalue|updatexml|floor|NAME_CONST|sleep|dumpfile|benchmark|exp)([^a-zA-Z]+|$))");
            Matcher oMatcher = oPattern.matcher(sTestSQL);
            int nCount = 0;
            while (oMatcher.find()) {
                System.out.println("======Index:" + nCount++ + "=======");
                System.out.println("======group.length=======");
                System.out.println(oMatcher.groupCount());
                System.out.println("======group(0)=======");
                System.out.println(oMatcher.group(0));
                System.out.println(oMatcher.end());
            }
        }
        for (String sSelectSQL : pSelectSQL = new String[]{"selectuser"}) {
            System.out.println(InjectSQLHelper.containsInjectSelectSQL(sSelectSQL));
        }
    }
}

