/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.DreamFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class BaseObjs
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Integer ID_NOT_LOAD = new Integer(0);
    private static Logger logger = Logger.getLogger(BaseObjs.class);
    public static boolean IS_DEBUG = false;
    protected static final int MODE_NORM = 0;
    protected static final int MODE_ADD = 1;
    protected static final int MODE_EDIT = 2;
    protected static final int POS_UNKNOWN = -1;
    protected static final int POS_BOF = -2;
    protected static final int POS_EOF = -3;
    public static final int BOOKMARK_CURRENT = 0;
    public static final int BOOKMARK_FIRST = 1;
    public static final int BOOKMARK_LAST = 2;
    protected Hashtable<Integer, BaseObj> m_oObjsBuffer = null;
    protected BaseObjs parentObjs = null;
    protected int maxSize = 0;
    protected Vector<Integer> vIdList = null;
    protected transient WCMFilter filter = null;
    protected int currIndex = -1;
    protected int currMode = 0;
    protected BaseObj objNew = null;
    protected int pageSize = 20;
    protected int currPage = -1;
    private int maxBufferSize = 0;
    private int[] oldPages = null;
    private int oldestPageAt = -1;
    private int loadedPageCount = 0;
    protected transient WCMFilter pageFilterMum = null;
    private boolean bIsLoadText = false;
    private static final int FLAG_NOT_INIT_CACHE_INDEX = -1000;
    private int m_nCacheIndex = -1000;
    public static long DEBUG_USE_TIME = 700L;
    private int m_nRecCount = -1;

    public BaseObjs() {
        this.vIdList = new Vector();
    }

    public BaseObjs(int _initCapacity, int _incCapacity) {
        this.vIdList = new Vector(_initCapacity, _incCapacity);
    }

    protected void finalize() {
        if (this.size() > 0) {
            this.clear();
        }
    }

    public boolean isCached() {
        try {
            return BaseObjs.getCachedPOMgr().isCached(this.getElementClass());
        }
        catch (WCMException e) {
            logger.error((Object)I18NMessage.get(BaseObjs.class, "BaseObjs.label1", "\u83b7\u53d6\u7f13\u51b2\u5bf9\u8c61\u7ba1\u7406\u5668\u5931\u8d25\uff01"), (Throwable)e);
            return false;
        }
    }

    protected abstract String getDbTableName();

    public abstract String getIdFieldName();

    public abstract Class getElementClass();

    public abstract BaseObjs newInstance() throws Exception;

    public String getClassName(boolean _bIncludePackage) {
        int nPos;
        String sClassName = this.getClass().getName();
        if (!_bIncludePackage && (nPos = sClassName.lastIndexOf(46)) >= 0) {
            sClassName = sClassName.substring(nPos + 1);
        }
        return sClassName;
    }

    public BaseObjs getParent() {
        return this.parentObjs;
    }

    protected Hashtable<Integer, BaseObj> getObjsBuffer() {
        if (this.m_oObjsBuffer == null) {
            this.m_oObjsBuffer = new Hashtable();
        }
        return this.m_oObjsBuffer;
    }

    public WCMFilter getFilter() {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        return this.filter;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int _nMaxSize) {
        this.maxSize = _nMaxSize > 0 ? _nMaxSize : 0;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public boolean setMaxBufferSize(int _maxSize) {
        if (_maxSize < 0) {
            _maxSize = 0;
        } else if (this.maxSize > 0 && _maxSize > this.maxSize) {
            _maxSize = this.maxSize;
        }
        if (this.maxBufferSize == _maxSize) {
            return false;
        }
        this.maxBufferSize = _maxSize;
        this.resetBufferLimit();
        return true;
    }

    private void resetBufferLimit() {
        if (this.oldPages == null) {
            return;
        }
        if (this.maxBufferSize == 0) {
            this.oldPages = null;
        } else {
            int newPageLimit = this.maxBufferSize / this.pageSize + 1;
            if (newPageLimit > this.oldPages.length) {
                int[] newSpace = new int[newPageLimit];
                int nLoaded = this.loadedPageCount;
                if (nLoaded > this.oldPages.length) {
                    nLoaded = this.oldPages.length;
                }
                for (int i = 0; i < nLoaded; ++i) {
                    newSpace[i] = this.oldPages[i];
                }
                this.oldPages = newSpace;
                Object var2_2 = null;
            }
        }
    }

    public int size() {
        if (this.m_nRecCount <= 0) {
            return this.vIdList.size();
        }
        return this.m_nRecCount;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.vIdList.clear();
        this.currIndex = -2;
        this.currPage = -1;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean setPageSize(int _pageSize) {
        if (this.pageSize == _pageSize) {
            return false;
        }
        this.pageSize = _pageSize;
        if (this.currPage >= 0) {
            this.currPage = -1;
        }
        return true;
    }

    public int getPageCount() {
        int nSize = this.size();
        int nPages = nSize / this.pageSize;
        if (this.pageSize * nPages < nSize) {
            ++nPages;
        }
        return nPages;
    }

    public int getCurrPage() {
        return this.currPage;
    }

    public void setCurrPage(int _pageIndex) {
        if (_pageIndex <= 0) {
            _pageIndex = 0;
        }
        this.currPage = _pageIndex;
    }

    protected boolean ensurePageLoaded(int _pageIndex) throws WCMException {
        try {
            if (this.isPageLoaded(_pageIndex)) {
                return true;
            }
            boolean bSaveOldPage = false;
            if (this.maxBufferSize > 0) {
                if (this.loadedPageCount * this.pageSize > this.maxBufferSize) {
                    this.unloadOldestPage(_pageIndex);
                } else {
                    bSaveOldPage = true;
                }
            }
            this.loadPage(_pageIndex);
            if (bSaveOldPage) {
                if (this.oldPages == null) {
                    this.oldPages = new int[this.maxBufferSize / this.pageSize + 1];
                    this.oldestPageAt = 0;
                }
                this.oldPages[this.loadedPageCount++] = _pageIndex;
            }
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label3", "\u88c5\u8f7d\u6307\u5b9a\u9875\uff08") + _pageIndex + I18NMessage.get(BaseObjs.class, "BaseObjs.label4", "\uff09\u5931\u8d25(") + this.getClass().getName() + ".ensurePageLoaded)", ex);
        }
    }

    private boolean loadPage(int _pageIndex) throws WCMException {
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        String strSQL = "";
        try {
            strSQL = this.makePageSQL(_pageIndex);
            if (strSQL == null) {
                boolean bl = false;
                return bl;
            }
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setMaxRows(this.pageSize);
            if (this.pageSize > 1000) {
                oStmt.setFetchSize(1000);
            } else {
                oStmt.setFetchSize(this.pageSize);
            }
            this.setPagePreStmtParams(_pageIndex, (PreparedStatement)oStmt);
            aTimer.start();
            rsData = oStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            aTimer.start();
            while (rsData.next()) {
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                this.loadAObjFromRs(rsData, rsmdData);
            }
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    private void setPagePreStmtParams(int _pageIndex, PreparedStatement stmt) throws SQLException {
        int nEnd;
        int nStart = this.getStartPos(_pageIndex);
        if (nStart >= (nEnd = this.getEndPos(nStart)) || nStart < 0) {
            return;
        }
        int i = nStart;
        int nParamIndex = 1;
        while (i < nEnd) {
            stmt.setInt(nParamIndex, this.getIdAt(i));
            ++i;
            ++nParamIndex;
        }
    }

    private String makePageSQL(int _pageIndex) throws WCMException {
        int nEnd;
        int nStart = this.getStartPos(_pageIndex);
        if (nStart >= (nEnd = this.getEndPos(nStart)) || nStart < 0) {
            return null;
        }
        if (nEnd - nStart > 2000) {
            throw new WCMException(I18NMessage.get(BaseObjs.class, "BaseObjs.label6", "\u6570\u636e\u5e93\u4e0d\u652f\u6301\u4e00\u6b21\u62fc\u51fa2000\u6761\u4ee5\u4e0a\u8bb0\u5f55\u7684\u5206\u9875\u8f7d\u5165SQL\uff01"));
        }
        WCMFilter pageFilter = this.preparePageFilter(_pageIndex);
        String sWhere = this.getIdFieldName() + " in(";
        sWhere = sWhere + "?";
        for (int i = nStart + 1; i < nEnd; ++i) {
            sWhere = sWhere + ", ?";
        }
        sWhere = sWhere + ")";
        pageFilter.setWhere(sWhere);
        return pageFilter.toSQL();
    }

    private boolean isPageLoaded(int _pageIndex) {
        if (this.isCached()) {
            return true;
        }
        int index = this.getStartPos(_pageIndex);
        Integer oKey = this.vIdList.elementAt(index);
        return this.getObjFromBuffer(oKey) != null;
    }

    protected BaseObj loadAObjFromRs(ResultSet _rsData, ResultSetMetaData _rsmdData) throws WCMException {
        try {
            BaseObj newObj = this.createElementInstance();
            newObj.setLoadText(this.bIsLoadText);
            newObj.readFromRs(_rsData, _rsmdData);
            int nIndex = this.indexOf(newObj.getId());
            if (nIndex < 0) {
                return null;
            }
            if (this.getObjsBuffer().containsKey(newObj.getKey())) {
                BaseObj currObj = this.getObjsBuffer().get(newObj.getKey());
                if (currObj == null) {
                    return null;
                }
                currObj.resetProperties(newObj.getAllProperty());
                newObj.clearProperties();
                newObj = null;
                return currObj;
            }
            this.getObjsBuffer().put(newObj.getKey(), newObj);
            return newObj;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label7", "\u4ece\u8bb0\u5f55\u96c6\u4e2d\u88c5\u8f7d\u5bf9\u8c61\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".loadAObjFromRs\uff09", ex);
        }
    }

    protected BaseObj createElementInstance() throws WCMException {
        return BaseObj.createNewInstance(this.getElementClass());
    }

    protected WCMFilter preparePageFilter(int _pageIndex) throws WCMException {
        String sIdList = this.getIdListOfPage(_pageIndex);
        if (sIdList == null) {
            return null;
        }
        if (this.pageFilterMum != null) {
            return this.pageFilterMum;
        }
        this.pageFilterMum = new WCMFilter();
        String sSelect = this.getFilter().getSelect();
        if (sSelect == null || sSelect.trim().length() == 0) {
            sSelect = "*";
        }
        if (sSelect.toUpperCase().indexOf("*") < 0 && sSelect.toUpperCase().indexOf(this.getIdFieldName().toUpperCase()) < 0) {
            sSelect = sSelect + "," + this.getDbTableName() + "." + this.getIdFieldName();
        }
        this.pageFilterMum.setSelect(sSelect);
        this.pageFilterMum.setFrom(this.getDbTableName());
        return this.pageFilterMum;
    }

    protected String getIdListOfPage(int _pageIndex) throws WCMException {
        String sIdList = null;
        try {
            int nStart = this.getStartPos(_pageIndex);
            int nEnd = this.getEndPos(nStart);
            if (nEnd <= nStart) {
                return null;
            }
            sIdList = "?";
            for (int index = nStart + 1; index < nEnd; ++index) {
                sIdList = ",?";
            }
            return sIdList;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label8", "\u63d0\u53d6\u6307\u5b9a\u9875\u5185\u7684\u5143\u7d20ID\u5931\u8d25\uff08") + this.getClass().getName() + ".getIdListOfPage\uff09", ex);
        }
    }

    protected int getEndPos(int nStart) {
        int nEnd = nStart + this.pageSize;
        int nSize = this.size();
        if (nEnd > nSize) {
            nEnd = nSize;
        }
        return nEnd;
    }

    protected int getStartPos(int _pageIndex) {
        return _pageIndex * this.pageSize;
    }

    protected BaseObj getObjFromBuffer(Object _key) {
        BaseObj baseObj = this.getObjsBuffer().get(_key);
        if (baseObj != null) {
            return baseObj;
        }
        try {
            return BaseObjs.getCachedPOMgr().getObjFromBuffer(this.getElementClass(), _key);
        }
        catch (WCMException e) {
            logger.error((Object)I18NMessage.get(BaseObjs.class, "BaseObjs.label1", "\u83b7\u53d6\u7f13\u51b2\u5bf9\u8c61\u7ba1\u7406\u5668\u5931\u8d25\uff01"), (Throwable)e);
            return null;
        }
    }

    protected BaseObj getObjFromBuffer(int _nId) {
        return this.getObjFromBuffer(new Integer(_nId));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void isValidSQL() throws WCMException {
        if (this.isCached()) {
            return;
        }
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsData = null;
        String strSQL = "";
        try {
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label9", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            this.clear();
            String sTableName = this.getDbTableName();
            String sIdFieldName = this.getIdFieldName().toUpperCase();
            String sTemp = this.filter.getSelect().toUpperCase();
            if (sTemp.length() == 0) {
                sTemp = sTableName + ".*";
            } else if (sTemp.indexOf("*") < 0 && sTemp.indexOf(sIdFieldName) < 0) {
                sTemp = sTemp + "," + sTableName + "." + sIdFieldName;
            }
            this.filter.setSelect(sTemp);
            sTemp = this.filter.getFrom().toUpperCase();
            if (sTemp.length() == 0) {
                this.filter.setFrom(sTableName);
            } else if (sTemp.indexOf(sTableName) < 0) {
                this.filter.setFrom(sTemp + "," + sTableName);
            }
            strSQL = this.filter.toSQL();
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.createStatement();
            oStmt.setMaxRows(1);
            rsData = oStmt.executeQuery(strSQL);
            rsData.close();
        }
        catch (SQLException ex) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".isValidSQL)\uff1aSQL=" + strSQL, ex);
                catch (Exception ex2) {
                    throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".isValidSQL)\uff1aSQL=" + strSQL, ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oStmt != null) {
                        oStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn == null) throw throwable;
                this.getDBManager().freeConnection(oConn);
                throw throwable;
            }
        }
        try {
            if (oStmt != null) {
                oStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn == null) return;
        this.getDBManager().freeConnection(oConn);
    }

    private String getSelectSql(String _sOrder, String _sSelect) {
        if (_sOrder != null && _sOrder.trim().length() > 0) {
            Vector<String> vSelectField = new Vector<String>(4);
            _sSelect = _sSelect.toUpperCase();
            StringTokenizer stSelectFields = new StringTokenizer(_sSelect, ",");
            while (stSelectFields.hasMoreElements()) {
                String sField = ((String)stSelectFields.nextElement()).trim();
                int nPos = sField.indexOf(46);
                if (nPos > 0) {
                    sField = sField.substring(nPos + 1);
                }
                vSelectField.add(sField);
            }
            _sOrder = _sOrder.toUpperCase();
            StringTokenizer stFields = new StringTokenizer(_sOrder, ",");
            while (stFields.hasMoreElements()) {
                String sField = ((String)stFields.nextElement()).trim();
                int nPos = sField.indexOf(32);
                if (nPos > 0) {
                    sField = sField.substring(0, nPos);
                }
                String sTempField = sField;
                nPos = sField.indexOf(46);
                if (nPos > 0) {
                    sTempField = sField.substring(nPos + 1);
                }
                if (vSelectField.indexOf(sTempField) >= 0) continue;
                _sSelect = _sSelect + "," + sField;
            }
        }
        return _sSelect;
    }

    private WCMFilter getIdFilter() {
        String sFieldAsId;
        boolean bFromMultiTable;
        String sTableName = this.getDbTableName();
        String sIdFieldName = this.getIdFieldName();
        WCMFilter idFilter = new WCMFilter(this.filter);
        String strFrom = this.filter.getFrom();
        String strSelect = this.filter.getSelect();
        if (strFrom == null || (strFrom = strFrom.trim()).length() == 0) {
            idFilter.setFrom(sTableName);
        }
        boolean bl = bFromMultiTable = strFrom.indexOf(44) >= 0;
        if (strSelect == null || (strSelect = strSelect.trim()).length() == 0) {
            sFieldAsId = bFromMultiTable ? sTableName + "." + sIdFieldName : sIdFieldName;
        } else if (strSelect.indexOf(42) >= 0) {
            sFieldAsId = bFromMultiTable ? sTableName + "." + sIdFieldName : sIdFieldName;
        } else {
            sFieldAsId = this.filter.findSelectField(sIdFieldName);
            if (sFieldAsId == null) {
                sFieldAsId = bFromMultiTable ? sTableName + "." + sIdFieldName : sIdFieldName;
            } else if (bFromMultiTable && (sFieldAsId = sFieldAsId.trim()).equalsIgnoreCase(sIdFieldName)) {
                sFieldAsId = sTableName + "." + sIdFieldName;
            }
        }
        sFieldAsId = this.getFilter().getOderSelect().length() == 0 ? this.getSelectSql(this.filter.getOrder(), sFieldAsId) : sFieldAsId + "," + this.getFilter().getOderSelect();
        if ((" " + sFieldAsId.toUpperCase()).indexOf(" DISTINCT ") < 0) {
            if (idFilter.getWhere().toLowerCase().indexOf("group by") >= 0 || idFilter.getGroup().trim().length() > 0) {
                idFilter.setSelect(sFieldAsId);
            } else {
                idFilter.setSelect(" distinct " + sFieldAsId);
            }
        } else {
            idFilter.setSelect(sFieldAsId);
        }
        if (this.filter.getMaxRowNumber() > 0) {
            idFilter.setMaxRowNumber(this.filter.getMaxRowNumber());
        }
        return idFilter;
    }

    private WCMFilter getCurrDataFilter() {
        String sTableName = this.getDbTableName();
        String sIdFieldName = this.getIdFieldName();
        WCMFilter currFilter = new WCMFilter(this.filter);
        String strFrom = this.filter.getFrom();
        String strSelect = this.filter.getSelect();
        if (strFrom == null || (strFrom = strFrom.trim()).length() == 0) {
            currFilter.setFrom(sTableName);
        }
        if (strSelect == null || (strSelect = strSelect.trim()).length() == 0) {
            strSelect = strFrom.indexOf(44) >= 0 ? sTableName + ".*" : "*";
        } else if (strSelect.indexOf(42) < 0 && currFilter.findSelectField(sIdFieldName) == null) {
            strSelect = sTableName + "." + sIdFieldName + "," + strSelect;
        }
        currFilter.setSelect(strSelect);
        return currFilter;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void refresh() throws WCMException {
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        Statement oPreStmt = null;
        ResultSet rsData = null;
        String strSQL = "";
        WCMFilter idFilter = null;
        try {
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label9", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            this.clear();
            idFilter = this.getIdFilter();
            strSQL = idFilter.toSQL();
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            if (idFilter.getMaxRowNumber() > 0) {
                oPreStmt.setMaxRows(idFilter.getMaxRowNumber());
                if (idFilter.getMaxRowNumber() > 1000) {
                    oPreStmt.setFetchSize(1000);
                } else {
                    oPreStmt.setFetchSize(idFilter.getMaxRowNumber());
                }
            }
            this.setParameters((PreparedStatement)oPreStmt);
            aTimer.start();
            rsData = oPreStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("get id from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)idFilter);
            }
            while (rsData.next()) {
                int nId = rsData.getInt(this.getIdFieldName());
                Integer temp = new Integer(nId);
                if (this.vIdList.indexOf(temp) >= 0) continue;
                this.vIdList.addElement(temp);
            }
            rsData.close();
            this.currIndex = this.size() > 0 ? 0 : -2;
        }
        catch (SQLException ex) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label11", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + idFilter, ex);
                catch (Exception ex2) {
                    throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oPreStmt != null) {
                        oPreStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn == null) throw throwable;
                this.getDBManager().freeConnection(oConn);
                throw throwable;
            }
        }
        try {
            if (oPreStmt != null) {
                oPreStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn == null) return;
        this.getDBManager().freeConnection(oConn);
    }

    public int getSelectCount() throws WCMException {
        WCMFilter aFilter = new WCMFilter();
        aFilter.copy(this.getIdFilter());
        aFilter.setSelect("count(*)");
        aFilter.setOrder("");
        aFilter.setMaxRowNumber(0);
        Connection conn = null;
        Statement prepStmt = null;
        try {
            conn = this.getDBManager().getConnection();
            prepStmt = conn.prepareStatement(aFilter.toSQL());
            prepStmt.setFetchSize(1);
            ResultSet rs = prepStmt.executeQuery();
            rs.next();
            int result = rs.getInt(1);
            rs.close();
            int n = result;
            return n;
        }
        catch (Exception e) {
            throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label12", "\u83b7\u53d6count\u5931\u8d25\uff01"), e);
        }
        finally {
            if (prepStmt != null) {
                try {
                    prepStmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                this.getDBManager().freeConnection(conn);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void loadCurrentData(int _nMaxSize) throws WCMException {
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        Statement oPreStmt = null;
        ResultSet rsData = null;
        String strSQL = "";
        try {
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label9", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            this.clear();
            WCMFilter currFilter = this.getCurrDataFilter();
            strSQL = currFilter.toSQL();
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            oPreStmt.setFetchSize(_nMaxSize);
            oPreStmt.setMaxRows(_nMaxSize);
            this.setParameters((PreparedStatement)oPreStmt);
            aTimer.start();
            rsData = oPreStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadCurrentData[MaxSize=" + _nMaxSize + "] execute query from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)currFilter);
            }
            aTimer.start();
            ResultSetMetaData rsmdData = null;
            while (rsData.next()) {
                int nId = rsData.getInt(this.getIdFieldName());
                Integer temp = new Integer(nId);
                if (this.vIdList.indexOf(temp) < 0) {
                    this.vIdList.addElement(temp);
                }
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                this.loadAObjFromRs(rsData, rsmdData);
            }
            rsData.close();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadCurrentData[MaxSize=" + _nMaxSize + "] read data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)currFilter);
            }
            this.currIndex = this.size() > 0 ? 0 : -2;
        }
        catch (SQLException ex) {
            try {
                throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)\uff1aSQL=" + strSQL, ex);
                catch (Exception ex2) {
                    throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)\uff1aSQL=" + strSQL, ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oPreStmt != null) {
                        oPreStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn == null) throw throwable;
                this.getDBManager().freeConnection(oConn);
                throw throwable;
            }
        }
        try {
            if (oPreStmt != null) {
                oPreStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn == null) return;
        this.getDBManager().freeConnection(oConn);
    }

    private void setParameters(PreparedStatement _oPreStmt) throws WCMException {
        if (_oPreStmt == null || this.filter == null) {
            return;
        }
        List listSearchValues = this.filter.getSearchValues();
        DBManager.setParameters(_oPreStmt, listSearchValues);
    }

    public synchronized void open(WCMFilter _filter) throws WCMException {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        this.filter.copy(_filter);
        this.setPageSize(this.filter.getPageSize());
        this.setMaxBufferSize(this.filter.getPageSize());
        if (this.getMaxSize() > 0) {
            this.filter.setMaxRowNumber(this.getMaxSize());
        } else if (this.filter.getMaxRowNumber() > 0) {
            this.setMaxSize(this.filter.getMaxRowNumber());
        }
        int nMaxSize = this.getMaxSize();
        if (this.filter.isForceFirstLoadIds() || nMaxSize <= 0 || nMaxSize > 20 && nMaxSize > this.getMaxBufferSize() || this.isCached()) {
            this.refresh();
        } else {
            this.loadCurrentData(this.getMaxSize());
        }
    }

    public synchronized BaseObjs filter(WCMFilter _filter) throws WCMException {
        try {
            WCMFilter subFilter = new WCMFilter(this.filter);
            subFilter.mergeWith(_filter);
            BaseObjs subObjs = this.newInstance();
            subObjs.open(subFilter);
            return subObjs;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label13", "\u7b5b\u9009\u96c6\u5408\u751f\u6210\u5b50\u96c6\u5931\u8d25\uff08") + this.getClass().getName() + ".filter\uff09", ex);
        }
    }

    public int getIdAt(int _index) {
        Integer oKey = this.vIdList.elementAt(_index);
        return oKey == null ? 0 : oKey;
    }

    public BaseObj getAt(int _index) {
        try {
            Integer oKey = this.vIdList.elementAt(_index);
            if (oKey == null) {
                this.currIndex = _index >= 0 ? -3 : -2;
                return null;
            }
            this.currIndex = _index;
            BaseObj aObj = this.getObjFromBuffer(oKey);
            if (this.isCached()) {
                return aObj;
            }
            if (aObj != null) {
                return aObj;
            }
            if (!this.ensurePageLoaded(_index / this.pageSize)) {
                return null;
            }
            return this.getObjFromBuffer(oKey);
        }
        catch (Exception ex) {
            logger.error((Object)("Fail to get the [" + _index + "] obj!"), (Throwable)ex);
            return null;
        }
    }

    public synchronized int indexOf(int _nId) {
        return this.vIdList.indexOf(new Integer(_nId));
    }

    public synchronized int indexOf(int _nId, int _nStartPos) {
        return this.vIdList.indexOf(new Integer(_nId), _nStartPos);
    }

    public synchronized int indexOf(Integer _iId) {
        return this.vIdList.indexOf(_iId);
    }

    public synchronized int indexOf(BaseObj _aObj) {
        int nCount = this.size();
        int nOldIndex = this.currIndex;
        BaseObj aObj = null;
        for (int i = 0; i < nCount; ++i) {
            aObj = this.getAt(i);
            if (aObj == null || !aObj.equals(_aObj)) continue;
            this.currIndex = nOldIndex;
            return i;
        }
        this.currIndex = nOldIndex;
        return -1;
    }

    public synchronized BaseObj getById(int _nId) {
        int index = this.indexOf(_nId);
        if (index < 0) {
            this.currIndex = -3;
            return null;
        }
        return this.getAt(index);
    }

    public boolean isBOF() {
        return this.currIndex == -2 || this.size() == 0;
    }

    public boolean isEOF() {
        return this.currIndex == -3 || this.size() == 0;
    }

    public int position() {
        return this.currIndex;
    }

    public int moveNext() {
        if (this.currIndex != -3) {
            int nCount = this.size();
            this.currIndex = nCount == 0 ? -3 : (this.currIndex == -2 ? 0 : (this.currIndex >= nCount - 1 ? -3 : this.currIndex + 1));
        }
        return this.currIndex;
    }

    public int movePrevious() {
        if (this.currIndex != -2) {
            this.currIndex = this.size() == 0 ? -2 : (this.currIndex == -3 ? this.size() - 1 : (this.currIndex == 0 ? -2 : this.currIndex - 1));
        }
        return this.currIndex;
    }

    public int moveFirst() {
        this.currIndex = this.size() == 0 ? -2 : 0;
        return this.currIndex;
    }

    public int moveLast() {
        int nCount = this.size();
        this.currIndex = nCount == 0 ? -3 : nCount - 1;
        return this.currIndex;
    }

    public int moveTo(int _nIndex) {
        this.currIndex = _nIndex < 0 ? -2 : (_nIndex >= this.size() ? -2 : _nIndex);
        return this.currIndex;
    }

    public int move(int _nStep) {
        if (_nStep == 0) {
            return this.currIndex;
        }
        switch (this.currIndex) {
            case -2: {
                if (_nStep <= 0) break;
                this.moveTo(_nStep - 1);
                break;
            }
            case -3: {
                if (_nStep >= 0) break;
                this.moveTo(this.size() + _nStep);
                break;
            }
            default: {
                this.moveTo(this.currIndex + _nStep);
            }
        }
        return this.currIndex;
    }

    public int move(int _nStep, int _nStart) {
        if (_nStep == 0) {
            return this.currIndex;
        }
        switch (_nStart) {
            case 1: {
                this.moveTo(_nStep);
                break;
            }
            case 2: {
                if (_nStep > 0) {
                    this.currIndex = -3;
                    break;
                }
                int nCount = this.size();
                if (nCount == 0) {
                    this.currIndex = -2;
                    break;
                }
                this.moveTo(nCount - 1 + _nStep);
                break;
            }
            default: {
                this.move(_nStep);
            }
        }
        return this.currIndex;
    }

    public BaseObj getCurrent() {
        return this.getAt(this.currIndex);
    }

    public final BaseObj addNew() throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label15", "\u5f53\u524d\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u65b0\u589e\u5143\u7d20(") + this.getClass().getName() + ".addNew)");
        }
        try {
            this.objNew = BaseObj.createNewInstance(this.getElementClass());
            this.currMode = 1;
            return this.objNew;
        }
        catch (Exception ex) {
            this.currMode = 0;
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label16", "\u521b\u5efa\u65b0\u5143\u7d20\u65f6\u5931\u8d25\uff08") + this.getClassName(false) + ".addNew\uff09", ex);
        }
    }

    public synchronized boolean addElement(BaseObj _aObj) throws WCMException {
        if (_aObj == null) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label17", "\u6307\u5b9a\u6dfb\u52a0\u7684\u5143\u7d20\u4e3a\u7a7a(") + this.getClass().getName() + ".addElement)");
        }
        try {
            if (!_aObj.isValidInstance()) {
                _aObj.insert();
            } else if (this.indexOf(_aObj.getId()) >= 0) {
                return false;
            }
            this.vIdList.addElement(new Integer(_aObj.getId()));
            if (!this.isCached()) {
                this.getObjsBuffer().put(_aObj.getKey(), _aObj);
            }
            this.currIndex = this.size() - 1;
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label18", "\u6dfb\u52a0\u5143\u7d20\u5230\u96c6\u5408\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".addElement).", ex);
        }
    }

    public synchronized boolean addElement(BaseObj _aObj, int _nIndex) throws WCMException {
        if (_aObj == null) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label17", "\u6307\u5b9a\u6dfb\u52a0\u7684\u5143\u7d20\u4e3a\u7a7a(") + this.getClass().getName() + ".addElement)");
        }
        if (this.size() <= _nIndex) {
            return this.addElement(_aObj);
        }
        try {
            if (!_aObj.isValidInstance()) {
                _aObj.insert();
            } else if (this.indexOf(_aObj.getId()) >= 0) {
                return false;
            }
            this.vIdList.add(_nIndex, new Integer(_aObj.getId()));
            if (!this.isCached()) {
                this.getObjsBuffer().put(_aObj.getKey(), _aObj);
            }
            this.currIndex = _nIndex;
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label18", "\u6dfb\u52a0\u5143\u7d20\u5230\u96c6\u5408\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".addElement).", ex);
        }
    }

    protected void updateElement(BaseObj _aObj) throws WCMException {
        if (_aObj == null) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label19", "\u6307\u5b9a\u66f4\u65b0\u7684\u5143\u7d20\u4e3a\u7a7a(") + this.getClass().getName() + ".updateElement)");
        }
        _aObj.update();
    }

    public boolean set(String _sName, Object _oValue) throws WCMException {
        switch (this.currMode) {
            case 1: {
                if (this.objNew == null) {
                    throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label20", "\u65b0\u589e\u5bf9\u8c61\u4e3a\u7a7a(") + this.getClass().getName() + ".set)");
                }
                return this.objNew.setProperty(_sName, _oValue);
            }
            case 2: {
                BaseObj currObj = this.getCurrent();
                if (currObj == null) {
                    throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label21", "\u4fee\u6539\u7684\u5bf9\u8c61\u4e3a\u7a7a(") + this.getClass().getName() + ".set)");
                }
                return currObj.setProperty(_sName, _oValue);
            }
        }
        throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label22", "\u5f53\u524d\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u5143\u7d20\u5c5e\u6027(") + this.getClass().getName() + ".set)");
    }

    public void update() throws WCMException {
        switch (this.currMode) {
            case 1: {
                this.addElement(this.objNew);
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                this.updateElement(this.getCurrent());
                this.currMode = 0;
                break;
            }
            default: {
                throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label23", "\u975e\u66f4\u65b0\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u66f4\u65b0\u64cd\u4f5c(") + this.getClass().getName() + ".update)");
            }
        }
    }

    protected boolean removeElement(BaseObj _aObj, int _index, boolean _bDropObj) throws WCMException {
        try {
            if (_bDropObj) {
                _aObj.delete();
                if (!_aObj.isCached() && this.getObjsBuffer().remove(_aObj.getKey()) == null) {
                    return false;
                }
            }
            this.vIdList.removeElementAt(_index);
            this.currIndex = _index >= this.size() ? -3 : _index;
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label24", "\u4ece\u96c6\u5408\u4e2d\u5220\u9664\u5143\u7d20\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".removeElement).", ex);
        }
    }

    public synchronized boolean remove(BaseObj _aObj, boolean _bDrop) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        int nIndex = this.indexOf(_aObj);
        if (nIndex < 0) {
            return false;
        }
        return this.removeElement(_aObj, nIndex, _bDrop);
    }

    public synchronized boolean remove(BaseObj _aObj) throws WCMException {
        return this.remove(_aObj, true);
    }

    public synchronized boolean remove(int _id, boolean _bDrop) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        int nIndex = this.indexOf(_id);
        if (nIndex < 0) {
            return false;
        }
        BaseObj aObj = this.getAt(nIndex);
        return this.removeElement(aObj, nIndex, _bDrop);
    }

    public synchronized boolean remove(int _id) throws WCMException {
        return this.remove(_id, true);
    }

    public synchronized boolean remove(boolean _bDrop) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        BaseObj currObj = this.getCurrent();
        if (currObj == null) {
            return false;
        }
        return this.removeElement(currObj, this.currIndex, _bDrop);
    }

    public synchronized boolean remove() throws WCMException {
        return this.remove(true);
    }

    public synchronized boolean removeAt(int _index, boolean _bDrop) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        BaseObj aObj = this.getAt(_index);
        if (aObj == null) {
            this.vIdList.remove(_index);
            return true;
        }
        return this.removeElement(aObj, _index, _bDrop);
    }

    public synchronized boolean removeAt(int _index) throws WCMException {
        return this.removeAt(_index, true);
    }

    public synchronized void removeAll(boolean _bDrop) throws WCMException {
        if (this.currMode != 0) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label25", "\u975e\u666e\u901a\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6267\u884c\u5220\u9664\u64cd\u4f5c(") + this.getClass().getName() + ".remove)");
        }
        if (this.isEmpty()) {
            return;
        }
        BaseObj aObj = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            aObj = this.getAt(i);
            if (aObj == null) continue;
            this.removeElement(aObj, i, _bDrop);
        }
    }

    public synchronized void removeAll() throws WCMException {
        this.removeAll(true);
    }

    public synchronized void addWith(BaseObjs _anotherObjs) throws WCMException {
        if (!_anotherObjs.getClass().equals(this.getClass())) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label26", "\u6307\u5b9a\u96c6\u5408\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d\uff08") + this.getClass().getName() + ".addWith\uff09");
        }
        if (_anotherObjs == null || _anotherObjs.isEmpty()) {
            return;
        }
        for (int i = 0; i < _anotherObjs.size(); ++i) {
            BaseObj obj = _anotherObjs.getAt(i);
            if (obj == null) continue;
            this.addElement(obj);
        }
    }

    public synchronized void minusWith(BaseObjs _anotherObjs) throws WCMException {
        if (!_anotherObjs.getClass().equals(this.getClass())) {
            throw new WCMException(1100, I18NMessage.get(BaseObjs.class, "BaseObjs.label26", "\u6307\u5b9a\u96c6\u5408\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d\uff08") + this.getClass().getName() + ".addWith\uff09");
        }
        if (_anotherObjs == null || _anotherObjs.isEmpty()) {
            return;
        }
        for (int i = 0; i < _anotherObjs.size(); ++i) {
            int index;
            BaseObj obj = _anotherObjs.getAt(i);
            if (obj == null || (index = this.indexOf(obj)) < 0) continue;
            this.removeAt(index, false);
        }
    }

    public String getIdListAsString(char _chrDelim) {
        String sIdList = null;
        Integer oKey = null;
        for (int i = 0; i < this.vIdList.size(); ++i) {
            oKey = this.vIdList.elementAt(i);
            if (oKey == null) continue;
            int nId = oKey;
            sIdList = sIdList == null ? String.valueOf(nId) : sIdList + _chrDelim + String.valueOf(nId);
        }
        return sIdList;
    }

    public String getIdListAsString() {
        return this.getIdListAsString(',');
    }

    public synchronized void setFilter(WCMFilter _filter) {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        this.filter.copy(_filter);
    }

    public synchronized void setSelect(String _sSelect) {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        this.filter.setSelect(_sSelect);
    }

    public synchronized void setOrder(String _sOrder) {
        if (this.filter == null) {
            this.filter = new WCMFilter();
        }
        this.filter.setOrder(_sOrder);
    }

    public static BaseObjs createInstance(String _sObjsClassName) throws WCMException {
        try {
            return BaseObjs.createInstance(Class.forName(_sObjsClassName));
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw new WCMException(1351, I18NMessage.get(BaseObjs.class, "BaseObjs.label28", "\u521b\u5efa\u5bf9\u8c61[") + _sObjsClassName + I18NMessage.get(BaseObjs.class, "BaseObjs.label29", "]\u5b9e\u4f8b\u5931\u8d25!"), ex);
        }
    }

    public static BaseObjs createInstance(Class _classObjs) throws WCMException {
        try {
            return (BaseObjs)_classObjs.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw new WCMException(1351, I18NMessage.get(BaseObjs.class, "BaseObjs.label28", "\u521b\u5efa\u5bf9\u8c61[") + _classObjs.getName() + I18NMessage.get(BaseObjs.class, "BaseObjs.label29", "]\u5b9e\u4f8b\u5931\u8d25!"), ex);
        }
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null) {
            throw new WCMException(10, I18NMessage.get(BaseObjs.class, "BaseObjs.label30", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(BaseObjs.class, "BaseObjs.label31", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    private int unloadOldestPage(int _currPageIndex) {
        if (this.oldPages == null || this.oldestPageAt < 0) {
            return -1;
        }
        int pageToUnload = this.oldPages[this.oldestPageAt];
        this.oldPages[this.oldestPageAt] = _currPageIndex;
        ++this.oldestPageAt;
        if (this.oldestPageAt >= this.oldPages.length) {
            this.oldestPageAt = 0;
        }
        int nStart = this.getStartPos(pageToUnload);
        Integer oKey = null;
        int nMaxSize = this.size();
        if (nMaxSize > nStart + this.pageSize) {
            nMaxSize = nStart + this.pageSize;
        }
        for (int index = nStart; index < nMaxSize; ++index) {
            oKey = this.vIdList.elementAt(index);
            this.getObjsBuffer().remove(oKey);
        }
        return pageToUnload;
    }

    public int getQueryCount() throws WCMException {
        int nSize = this.size();
        if (this.maxSize <= 0 || nSize < this.maxSize) {
            return nSize;
        }
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsData = null;
        int nRecCount = 0;
        String strSQL = "";
        try {
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.createStatement();
            WCMFilter countFilter = new WCMFilter(this.filter);
            countFilter.setSelect("count(" + this.getDbTableName() + "." + this.getIdFieldName() + ")");
            countFilter.setOrder("");
            strSQL = countFilter.toSQL();
            rsData = oStmt.executeQuery(strSQL);
            if (rsData.next()) {
                nRecCount = rsData.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label32", "\u8f7d\u5165\u672c\u6b21\u96c6\u5408\u67e5\u8be2\u7684\u8bb0\u5f55\u6570\u5931\u8d25\uff08") + this.getClass().getName() + ".loadRecCount)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label32", "\u8f7d\u5165\u672c\u6b21\u96c6\u5408\u67e5\u8be2\u7684\u8bb0\u5f55\u6570\u5931\u8d25\uff08") + this.getClass().getName() + ".loadRecCount)\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
        return nRecCount;
    }

    public void cancelUpdateAll(int _end) {
        if (_end <= 0) {
            return;
        }
        switch (this.currMode) {
            case 1: {
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                int nMax = this.size() > _end ? _end : this.size();
                for (int i = 0; i < nMax; ++i) {
                    try {
                        this.getAt(i).cancelUpdate();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
        }
    }

    public void cancelUpdateAll() {
        this.cancelUpdateAll(this.size());
    }

    public void cancelUpdate() {
        switch (this.currMode) {
            case 1: {
                this.objNew = null;
                this.currMode = 0;
                break;
            }
            case 2: {
                try {
                    BaseObj currObj = this.getCurrent();
                    if (currObj != null) {
                        currObj.cancelUpdate();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currMode = 0;
            }
        }
    }

    public void setLoadText(boolean _isLoadText) {
        this.bIsLoadText = _isLoadText;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reloadSpecailData(String _sFrom, String _sWhere, String _sSelect) throws WCMException {
        boolean bl;
        Statement oStmt;
        Connection oConn;
        block28: {
            if (this.isCached()) {
                logger.error((Object)I18NMessage.get(BaseObjs.class, "BaseObjs.label33", "\u7f13\u51b2\u5bf9\u8c61\u6267\u884creloadSpecailData!"));
                return true;
            }
            oConn = null;
            oStmt = null;
            ResultSet rsData = null;
            ResultSetMetaData rsmdData = null;
            String strSQL = "";
            try {
                WCMFilter pageFilter = new WCMFilter();
                String sSelect = this.getDbTableName() + "." + this.getIdFieldName();
                if (_sSelect != null && _sSelect.toUpperCase().indexOf("*") < 0) {
                    ArrayList<String> aSelectList = new ArrayList<String>(20);
                    StringTokenizer st = new StringTokenizer(sSelect, ",");
                    while (st.hasMoreTokens()) {
                        aSelectList.add(st.nextToken().trim().toUpperCase());
                    }
                    st = new StringTokenizer(_sSelect, ",");
                    while (st.hasMoreTokens()) {
                        String sItem = st.nextToken().trim().toUpperCase();
                        if (aSelectList.indexOf(sItem) >= 0) continue;
                        sSelect = sSelect + "," + sItem;
                        aSelectList.add(sItem);
                    }
                    st = null;
                    aSelectList.clear();
                }
                pageFilter.setSelect(sSelect);
                pageFilter.setWhere(_sWhere);
                if (_sFrom == null || _sFrom.trim().length() <= 0) {
                    pageFilter.setFrom(this.getDbTableName());
                } else if (_sFrom.indexOf(this.getDbTableName()) >= 0) {
                    pageFilter.setFrom(_sFrom);
                } else {
                    pageFilter.setFrom(this.getDbTableName() + "," + _sFrom);
                }
                strSQL = pageFilter.toSQL();
                oConn = this.getDBManager().getConnection();
                oStmt = oConn.createStatement();
                rsData = oStmt.executeQuery(strSQL);
                while (rsData.next()) {
                    if (rsmdData == null) {
                        rsmdData = rsData.getMetaData();
                    }
                    this.loadAObjFromRs(rsData, rsmdData);
                }
                bl = true;
                if (rsData == null) break block28;
            }
            catch (SQLException ex) {
                try {
                    throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label34", " \u91cd\u65b0\u88c5\u8f7d\u6307\u5b9a\u7684\u6570\u636e\u5931\u8d25\uff08") + this.getClass().getName() + ".reloadSpecailData)\uff1aSQL=" + strSQL, ex);
                    catch (Exception ex2) {
                        throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label35", "\u91cd\u65b0\u88c5\u8f7d\u6307\u5b9a\u7684\u6570\u636e\u5931\u8d25\uff08") + this.getClass().getName() + ".reloadSpecailData)\uff1aSQL=" + strSQL, ex2);
                    }
                }
                catch (Throwable throwable) {
                    if (rsData != null) {
                        try {
                            rsData.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (oStmt != null) {
                        try {
                            oStmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (oConn != null) {
                        this.getDBManager().freeConnection(oConn);
                    }
                    throw throwable;
                }
            }
            try {
                rsData.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oStmt != null) {
            try {
                oStmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oConn != null) {
            this.getDBManager().freeConnection(oConn);
        }
        return bl;
    }

    public void addElement(String _sIds) {
        int[] arId = CMyString.splitToInt(_sIds, ",");
        int nCount = arId.length;
        if (nCount <= 0) {
            return;
        }
        for (int i = 0; i < nCount; ++i) {
            this.addElement(arId[i]);
        }
        this.currIndex = 0;
    }

    public void addElements(BaseObjs _objs) {
        if (_objs == null || _objs.isEmpty()) {
            return;
        }
        int nSize = _objs.size();
        for (int i = 0; i < nSize; ++i) {
            try {
                this.addElement(_objs.getAt(i));
                continue;
            }
            catch (Exception ignore) {
                logger.warn((Object)("Exception to add element![Index=" + i + "]"), (Throwable)ignore);
            }
        }
    }

    public void addElement(int _nId) {
        this.addElement(new Integer(_nId));
    }

    public void addElement(Integer _iKey) {
        if (this.vIdList.indexOf(_iKey) >= 0) {
            return;
        }
        this.vIdList.addElement(_iKey);
    }

    public void addElement(int _nId, int _nIndex) {
        if (this.size() <= _nIndex) {
            this.addElement(_nId);
            return;
        }
        Integer _iKey = new Integer(_nId);
        if (this.vIdList.indexOf(_iKey) >= 0) {
            return;
        }
        this.vIdList.add(_nIndex, _iKey);
        this.currIndex = _nIndex;
    }

    protected static ICachedPOMgr getCachedPOMgr() throws WCMException {
        ICachedPOMgr currCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        if (currCachedPOMgr == null) {
            throw new WCMException(10, "ICachedPOMgr Config Error!");
        }
        return currCachedPOMgr;
    }

    public void loadObjsOfCurrPage(int _nPageIndex, int _nPageSize, WCMFilter _filterForLoadID, String _sSelectFieldsOfLoadObj) throws WCMException {
        int nCount;
        DBManager dbManager = DBManager.getDBManager();
        String sQueryCountSQL = "select count(" + _filterForLoadID.getSelect() + ") from " + _filterForLoadID.getFrom();
        if (!CMyString.isEmpty(_filterForLoadID.getWhere())) {
            sQueryCountSQL = sQueryCountSQL + " where " + _filterForLoadID.getWhere();
        }
        if ((nCount = dbManager.sqlExecuteIntQuery(sQueryCountSQL, _filterForLoadID.getSearchValues())) <= 0) {
            return;
        }
        CPager pager = new CPager(_nPageSize);
        pager.setItemCount(nCount);
        pager.setCurrentPageIndex(_nPageIndex);
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        boolean bIsCached = this.isCached();
        String sIdFieldName = this.getIdFieldName();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement(_filterForLoadID.toSQL());
            oPreStmt.setFetchSize(_nPageSize);
            DBManager.setParameters(oPreStmt, _filterForLoadID);
            result = oPreStmt.executeQuery();
            this.setRecCount(nCount);
            int nCurrIndex = 0;
            int nCurrPageCount = 0;
            while (result.next()) {
                if (++nCurrIndex < pager.getFirstItemIndex()) {
                    this.vIdList.add(ID_NOT_LOAD);
                    continue;
                }
                int nCurrObjId = result.getInt(sIdFieldName);
                if (bIsCached) {
                    this.addElement(nCurrObjId);
                } else {
                    BaseObj baseObj = (BaseObj)this.getElementClass().newInstance();
                    baseObj.loadById(nCurrObjId, _sSelectFieldsOfLoadObj);
                    this.addElement(baseObj);
                }
                if (++nCurrPageCount <= _nPageSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to Desc!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public void setRecCount(int _nRecCount) {
        if (_nRecCount < 0) {
            return;
        }
        this.m_nRecCount = _nRecCount;
    }

    public int getRecCount() {
        if (this.m_nRecCount < 0) {
            return this.size();
        }
        return this.m_nRecCount;
    }

    public String makeFiledValueListAsString(String _sFieldName) {
        StringBuilder sbResult = new StringBuilder();
        int nSize = this.size();
        for (int i = 0; i < nSize; ++i) {
            BaseObj obj = this.getAt(i);
            if (obj == null) continue;
            sbResult.append(obj.getPropertyAsString(_sFieldName));
            sbResult.append(',');
        }
        sbResult.setLength(sbResult.length() - 1);
        return sbResult.toString();
    }

    public synchronized void addWith(List<BaseObj> _objs) throws WCMException {
        if (_objs == null || _objs.isEmpty()) {
            return;
        }
        int nSize = _objs.size();
        for (int i = 0; i < nSize; ++i) {
            BaseObj obj = _objs.get(i);
            this.addElement(obj);
        }
    }
}

