/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.database.CDBText;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseObjToXmlConverterForSpecialProperty
extends BaseObjToXmlConverter {
    private static final String PATTERN_CDATA = "(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*";
    private String m_sPrefix = this.getClass().getName() + ".";
    private NamesRegister m_oSpecialPropertiesRegister = new NamesRegister();
    private HashMap m_hmNewTagNames = new HashMap(1);

    protected abstract void registerHostSpecialProperties();

    protected abstract String[][] getSpecialProperty(BaseObj var1, int var2, String var3, Object var4) throws ConvertException;

    @Override
    protected Element toXmlElement(BaseObj _baseObj, String _sFieldsList) throws WCMException {
        StringTokenizer enumKeys = null;
        String sKey = null;
        Object objValue = null;
        Hashtable<String, Object> hProperty = _baseObj.getAllProperty();
        Element currElement = DocumentHelper.createElement((String)this.getElementTag(_baseObj));
        if (this.isAddVersion()) {
            currElement.addAttribute("Version", "6.0");
        }
        Element eleProperties = currElement.addElement("PROPERTIES");
        Element eleItem = null;
        String sFieldList = _sFieldsList;
        if (sFieldList == null || sFieldList.trim().length() == 0) {
            sFieldList = this.getFieldList(_baseObj);
        }
        enumKeys = sFieldList != null && sFieldList.trim().length() > 0 ? new StringTokenizer(sFieldList.toUpperCase(), ",") : hProperty.keys();
        while (enumKeys.hasMoreElements()) {
            try {
                boolean bContinueDoWith;
                sKey = enumKeys.nextElement().trim();
                objValue = _baseObj.getProperty(sKey);
                if (objValue == null || !(bContinueDoWith = this.convertSpecialProperty(_baseObj, sKey, objValue, eleItem = eleProperties.addElement(sKey))) || objValue == null || objValue instanceof NullValue) continue;
                if (objValue instanceof String) {
                    String strValue = (String)objValue;
                    if (strValue.matches(PATTERN_CDATA)) {
                        eleItem.setText(strValue);
                        continue;
                    }
                    eleItem.addCDATA(strValue);
                    continue;
                }
                if (objValue instanceof CDBText) {
                    String textValue = ((CDBText)objValue).getText();
                    if (CMyString.isEmpty(textValue)) continue;
                    if (textValue.matches(PATTERN_CDATA)) {
                        eleItem.setText(textValue);
                        continue;
                    }
                    eleItem.addCDATA(textValue);
                    continue;
                }
                if (objValue instanceof CMyDateTime) {
                    CMyDateTime dtTemp = (CMyDateTime)objValue;
                    if (dtTemp.isNull()) continue;
                    eleItem.setText(dtTemp.toString());
                    continue;
                }
                eleItem.setText(objValue.toString());
            }
            catch (Throwable ex) {
                throw new WCMException(I18NMessage.get(BaseObjToXmlConverterForSpecialProperty.class, "BaseObjToXmlConverterForSpecialProperty.label1", "\u5904\u7406[") + sKey + I18NMessage.get(BaseObjToXmlConverterForSpecialProperty.class, "BaseObjToXmlConverterForSpecialProperty.label2", "]\u5b57\u6bb5\u5931\u8d25!"), ex);
            }
        }
        Element[] childElements = this.getChildElement(_baseObj);
        if (childElements == null) {
            return currElement;
        }
        for (int i = 0; i < childElements.length; ++i) {
            Element element = childElements[i];
            if (element == null) continue;
            currElement.add(element);
        }
        return currElement;
    }

    private boolean convertSpecialProperty(BaseObj _baseObj, String _sKey, Object _objValue, Element _eleItem) throws ConvertException {
        String[][] pSpecialProperty;
        int nSpecialPropertyId = this.lookupHostSpecialPropertyId(_sKey);
        if (nSpecialPropertyId > 0 && (pSpecialProperty = this.getSpecialProperty(_baseObj, nSpecialPropertyId, _sKey, _objValue)) != null) {
            String sNewTagName = (String)this.m_hmNewTagNames.get(_sKey);
            if (sNewTagName != null) {
                _eleItem.setName(sNewTagName);
            }
            if (pSpecialProperty.length == 1 && pSpecialProperty[0].length == 1) {
                String strValue = pSpecialProperty[0][0];
                if (strValue.matches(PATTERN_CDATA)) {
                    _eleItem.setText(strValue);
                } else {
                    _eleItem.addCDATA(strValue);
                }
                return false;
            }
            if (pSpecialProperty.length == 1 && pSpecialProperty[0].length == 2) {
                _eleItem.addAttribute(pSpecialProperty[0][0], pSpecialProperty[0][1]);
            } else {
                for (int j = 0; j < pSpecialProperty.length; ++j) {
                    _eleItem.addAttribute(pSpecialProperty[j][0], pSpecialProperty[j][1]);
                }
                return false;
            }
        }
        return true;
    }

    protected void registerHostSpecialProperty(String _sName, int _nId) {
        this.registerHostSpecialProperty(_sName, _nId, null);
    }

    protected void registerHostSpecialProperty(String _sName, int _nId, String _sNewTagName) {
        this.m_oSpecialPropertiesRegister.register(this.m_sPrefix + _sName.toUpperCase(), _nId);
        if (_sNewTagName != null) {
            this.m_hmNewTagNames.put(_sName.toUpperCase(), _sNewTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lookupHostSpecialPropertyId(String _sName) {
        if (!this.m_oSpecialPropertiesRegister.contains(this.m_sPrefix)) {
            NamesRegister namesRegister = this.m_oSpecialPropertiesRegister;
            synchronized (namesRegister) {
                if (!this.m_oSpecialPropertiesRegister.contains(this.m_sPrefix)) {
                    this.registerHostSpecialProperties();
                    this.m_oSpecialPropertiesRegister.register(this.m_sPrefix, 0);
                }
            }
        }
        return this.m_oSpecialPropertiesRegister.lookup(this.m_sPrefix + _sName.toUpperCase(), -1);
    }
}

