/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BaseObjHandler
extends DefaultHandler {
    private BaseObj m_oWCMObj;
    private StringBuffer m_sbValue;
    private boolean m_bParseObjProp;
    private String m_sWCMObjTagName = "WCMOBJ";
    private boolean m_bParasingObj = false;

    public BaseObjHandler(BaseObj _obj) {
        this.m_oWCMObj = _obj;
        this.m_bParseObjProp = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ((qName = qName.toUpperCase()).equals(this.m_sWCMObjTagName) || qName.equals(this.m_oWCMObj.getDbTableName())) {
            this.m_bParasingObj = true;
            return;
        }
        if (this.m_bParasingObj && qName.equals("PROPERTIES")) {
            this.m_bParseObjProp = true;
            this.m_sbValue = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_bParseObjProp && this.m_sbValue != null) {
            this.m_sbValue.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ((qName = qName.toUpperCase()).equals("PROPERTIES")) {
            this.m_bParseObjProp = false;
            return;
        }
        if (qName.equals(this.m_sWCMObjTagName) || qName.equals(this.m_oWCMObj.getDbTableName())) {
            this.m_bParasingObj = false;
            return;
        }
        if (this.m_bParseObjProp) {
            try {
                this.m_oWCMObj.setPropertyWithString(qName, this.m_sbValue.toString().trim());
            }
            catch (Exception e) {
                throw new SAXException(I18NMessage.get(BaseObjHandler.class, "BaseObjHandler.label1", "\u8bbe\u7f6e[") + qName.toUpperCase() + I18NMessage.get(BaseObjHandler.class, "BaseObjHandler.label2", "]\u5c5e\u6027\u5931\u8d25\uff01"), e);
            }
            finally {
                this.m_sbValue.delete(0, this.m_sbValue.length());
            }
        }
    }

    public BaseObj getWCMObj() {
        return this.m_oWCMObj;
    }
}

