/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.config.domain.ConfigFilesFinder;
import com.trs.infra.config.domain.ConfigHelper;
import com.trs.infra.config.domain.ConfigObjectLoader;
import com.trs.infra.config.persistent.BeanConfig;
import com.trs.infra.config.persistent.ConfigFiles;
import com.trs.infra.config.persistent.PluginConfig;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.store.FileStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.mapping.Mapping;

public class BeanConfigServer
extends BaseServer {
    private ConfigFilesFinder m_oConfigFileFinder = new ConfigFilesFinder(ConfigHelper.getDomainConfigPaths(), "beans.xml");
    private Map m_hmBeanIdMap = new HashMap();
    private Map m_hmPluginIdMap = new HashMap();
    private List m_listBeanConfigCollection = new ArrayList();
    private static BeanConfigServer itsInstance = new BeanConfigServer();

    private BeanConfigServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanConfigServer getInstance() {
        if (itsInstance == null) {
            itsInstance = new BeanConfigServer();
        }
        if (!itsInstance.isStarted()) {
            BeanConfigServer beanConfigServer = itsInstance;
            synchronized (beanConfigServer) {
                if (itsInstance.isStarted()) {
                    return itsInstance;
                }
                itsInstance.startup();
                if (!itsInstance.isStarted()) {
                    throw new RuntimeException("Bean Config Server startup Error!" + itsInstance.getErrors());
                }
            }
        }
        return itsInstance;
    }

    @Override
    protected void doShutdown() {
        this.m_hmBeanIdMap.clear();
        this.m_hmPluginIdMap.clear();
        this.m_listBeanConfigCollection.clear();
        if (this.m_oConfigFileFinder != null) {
            this.m_oConfigFileFinder = null;
        }
    }

    @Override
    protected boolean doStart() throws WCMException {
        try {
            if (this.m_bIsStarted) {
                return false;
            }
            this.load();
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label1", "\u521d\u59cb\u5316\u914d\u7f6e\u670d\u52a1\u5668\u5931\u8d25"), ex);
        }
    }

    public List getBeanConfigCollection() {
        return this.m_listBeanConfigCollection;
    }

    public List getBeanConfigCollection(String _sPluginId) {
        return (List)this.m_hmPluginIdMap.get(_sPluginId);
    }

    void load() throws CMyException {
        ConfigFiles cfgFiles = this.m_oConfigFileFinder.getConfigFiles();
        Mapping map = new Mapping();
        try {
            map.loadMapping(ConfigHelper.getMappingSource(ConfigConstants.getAbsoluteFileNameOfCoreMapping()));
        }
        catch (Exception ex) {
            throw new RuntimeException(I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label2", "\u88c5\u8f7dCastor\u7684mapping\u6587\u4ef6\u65f6\u51fa\u9519:") + ex.getMessage(), ex);
        }
        for (int nConfigFileIndex = 0; nConfigFileIndex < cfgFiles.size(); ++nConfigFileIndex) {
            try {
                FileStore fPlugin = cfgFiles.get(nConfigFileIndex).getPlugin();
                PluginConfig cfgObj = ConfigObjectLoader.loadUnmarshallerRoot(fPlugin, map);
                this.loadBeanCollectionFromPlugin(cfgObj);
                this.loadBeanIdMapFromPlugin(cfgObj);
                this.loadPluginIdFromPluginMap(cfgObj);
                continue;
            }
            catch (Exception ex) {
                throw new CMyException(I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label3", "\u5206\u6790\u914d\u7f6e\u6587\u4ef6[config-file=") + cfgFiles.get(nConfigFileIndex).getPlugin().getPath() + I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label4", "]\u5931\u8d25\uff1a") + ex.getLocalizedMessage(), ex);
            }
        }
    }

    private void loadPluginIdFromPluginMap(PluginConfig _oPlugin) throws CMyException {
        if (this.m_hmPluginIdMap.containsKey(_oPlugin.getId())) {
            throw new CMyException("[id=" + _oPlugin.getId() + I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label5", "]\u7684plugin\u5df2\u5b9a\u4e49"));
        }
        this.m_hmPluginIdMap.put(_oPlugin.getId(), _oPlugin.getBeans());
    }

    private void loadBeanCollectionFromPlugin(PluginConfig _oPlugin) {
        this.m_listBeanConfigCollection.addAll(_oPlugin.getBeans());
    }

    void loadBeanIdMapFromPlugin(PluginConfig _oPlugin) {
        ArrayList beans = _oPlugin.getBeans();
        for (int i = 0; i < beans.size(); ++i) {
            BeanConfig beanCfg = (BeanConfig)beans.get(i);
            this.m_hmBeanIdMap.put(beanCfg.getId(), beanCfg.getClassName());
        }
    }

    public boolean containsBean(String _beanId) {
        return this.m_hmBeanIdMap.containsKey(_beanId);
    }

    public static boolean started() {
        return itsInstance.isStarted();
    }
}

