/*
 * Decompiled with CFR 0.152.
 */
package com.trs.index.util;

import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.resource.Status;
import com.trs.index.LuceneContext;
import com.trs.index.config.IndexConfig;
import com.trs.index.config.TableDesc;
import com.trs.index.config.TableFieldDesc;
import com.trs.index.domain.ChnlDocLCListenerForIndex;
import com.trs.index.domain.IndexMrg;
import com.trs.index.vo.IndexField;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.CDBText;
import com.trs.util.CMyString;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;

public class IndexUtil {
    public static int INDEX_ADD = 1;
    public static int INDEX_UPD = 2;
    public static int INDEX_DEL = 3;

    public static IndexField doc2IndexField(com.trs.components.wcm.content.persistent.Document doc) {
        if (doc == null) {
            return null;
        }
        IndexField indexField = new IndexField();
        try {
            indexField.setId(doc.getId());
            indexField.setTitle(doc.getTitle());
            indexField.setContent(doc.getContent());
            indexField.setCruser(doc.getCrUserName());
            indexField.setKeyWords(doc.getKeywords());
            indexField.setCreateDate(doc.getCrTime());
            if (doc.getSource() != null) {
                indexField.setDocSource(doc.getSource().getName());
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        return indexField;
    }

    /*
     * Loose catch block
     */
    public static void makeIndexForListener(Object obj, String relation, int operType) throws WCMException {
        block43: {
            ResultSet rsData;
            Statement oPreStmt;
            Connection oConn;
            block42: {
                oConn = null;
                oPreStmt = null;
                rsData = null;
                String s_where = "WCMCHNLDOC.RECID=";
                if (obj instanceof ChnlDoc) {
                    ChnlDoc chnlDoc = (ChnlDoc)obj;
                    s_where = s_where + chnlDoc.getProperty("RECID") + "";
                } else if (obj instanceof String) {
                    s_where = (String)obj;
                }
                StringBuilder from = new StringBuilder();
                StringBuilder select = new StringBuilder();
                StringBuilder where = new StringBuilder();
                where.append(s_where);
                IndexConfig indexConfig = LuceneContext.getInstance().getIndexConfig();
                where.append(" AND ");
                if (!CMyString.isEmpty((String)relation)) {
                    where.append(relation);
                } else {
                    where.append(indexConfig.getRelative());
                }
                if (!CMyString.isEmpty((String)indexConfig.getWhere())) {
                    where.append(" AND ");
                    where.append(indexConfig.getWhere());
                }
                WCMFilter _filter = new WCMFilter();
                List<TableDesc> tableDescList = indexConfig.getTableDescList();
                for (int i = 0; i < tableDescList.size(); ++i) {
                    TableDesc tableDesc = tableDescList.get(i);
                    from.append(tableDesc.getTableName() + ",");
                    List<TableFieldDesc> tableFieldDescList = tableDesc.getTableFieldDescList();
                    for (int j = 0; j < tableFieldDescList.size(); ++j) {
                        TableFieldDesc tableField = tableFieldDescList.get(j);
                        select.append(tableDesc.getTableName() + "." + tableField.getFieldName() + ",");
                    }
                }
                select.deleteCharAt(select.length() - 1);
                from.deleteCharAt(from.length() - 1);
                _filter.setFrom(from.toString());
                _filter.setSelect(select.toString());
                _filter.setWhere(where.toString());
                String strSQL = "";
                ResultSetMetaData rsmdData = null;
                strSQL = _filter.toSQL();
                oConn = DBManager.getDBManager().getConnection();
                oPreStmt = oConn.prepareStatement(strSQL);
                rsData = oPreStmt.executeQuery();
                IndexMrg indeMrg = new IndexMrg();
                while (rsData.next()) {
                    if (rsmdData == null) {
                        rsmdData = rsData.getMetaData();
                    }
                    IndexField indexField = IndexUtil.readData(rsData, rsmdData);
                    if (operType == INDEX_ADD) {
                        indeMrg.addIndex(indexField, true, operType);
                        continue;
                    }
                    if (operType == INDEX_DEL) {
                        indeMrg.deleteIndex(indexField.getRecId(), true, operType);
                        continue;
                    }
                    indeMrg.updateIndex(indexField, true, operType);
                }
                if (rsData == null) break block42;
                try {
                    rsData.close();
                }
                catch (Exception e) {
                    throw new WCMException("\u5173\u95edResultSet\u51fa\u73b0\u5f02\u5e38", e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    throw new WCMException("\u5173\u95edPreparedStatement\u51fa\u73b0\u5f02\u5e38", ex);
                }
            }
            if (oConn != null) {
                try {
                    DBManager.getDBManager().freeConnection(oConn);
                }
                catch (Exception e) {
                    throw new WCMException("\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38", e);
                }
            }
            break block43;
            catch (WCMException e) {
                e.printStackTrace();
                break block43;
            }
            catch (SQLException e2) {
                throw new WCMException(40, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label2", "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + ChnlDocLCListenerForIndex.class.getName() + ".refresh)\uff1a\n", e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (rsData != null) {
                    try {
                        rsData.close();
                    }
                    catch (Exception e) {
                        throw new WCMException("\u5173\u95edResultSet\u51fa\u73b0\u5f02\u5e38", e);
                    }
                }
                if (oPreStmt != null) {
                    try {
                        oPreStmt.close();
                    }
                    catch (Exception ex) {
                        throw new WCMException("\u5173\u95edPreparedStatement\u51fa\u73b0\u5f02\u5e38", ex);
                    }
                }
                if (oConn != null) {
                    try {
                        DBManager.getDBManager().freeConnection(oConn);
                    }
                    catch (Exception e) {
                        throw new WCMException("\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38", e);
                    }
                }
            }
        }
    }

    public static String getAllStatus() {
        Field[] fields = Status.class.getDeclaredFields();
        Status status = new Status();
        StringBuilder s_Status = new StringBuilder();
        for (Field field : fields) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                if (!(field.get(status) instanceof Integer)) continue;
                Integer value = (Integer)field.get(status);
                s_Status.append(value + ",");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        s_Status.deleteCharAt(s_Status.length() - 1);
        return s_Status.toString();
    }

    private static Field.Store getStore(boolean store) {
        if (store) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    private static Field.Index getAnalyzed(boolean index, boolean analyzed) {
        if (!index) {
            return Field.Index.NO;
        }
        if (analyzed) {
            return Field.Index.ANALYZED;
        }
        return Field.Index.NOT_ANALYZED;
    }

    private static Fieldable getIndexField(TableFieldDesc tableFieldDesc, Object value) {
        if (value == null) {
            return null;
        }
        NumericField fieldAble = null;
        boolean analyzed = tableFieldDesc.isAnalyzed();
        boolean store = tableFieldDesc.isStore();
        String tpye = tableFieldDesc.getType();
        String key = tableFieldDesc.getKey();
        boolean index = tableFieldDesc.isIndex();
        if ("long".equalsIgnoreCase(tpye)) {
            NumericField numericField = new NumericField(key, IndexUtil.getStore(store), true);
            Long v = (Long)value;
            numericField.setLongValue(v.longValue());
            fieldAble = numericField;
        } else if ("date".equalsIgnoreCase(tpye)) {
            CMyDateTime date = (CMyDateTime)value;
            long time = date.getTimeInMillis();
            NumericField numericField = new NumericField(key, IndexUtil.getStore(store), true);
            numericField.setLongValue(time);
            fieldAble = numericField;
        } else {
            CDBText text;
            String v = "";
            if (value instanceof Long) {
                Long temp = (Long)value;
                v = temp.toString();
            } else if (value instanceof String) {
                v = (String)value;
            } else if (value instanceof CDBText && (v = (text = (CDBText)value).getText()) == null) {
                return null;
            }
            fieldAble = new org.apache.lucene.document.Field(key, v, IndexUtil.getStore(store), IndexUtil.getAnalyzed(index, analyzed));
        }
        return fieldAble;
    }

    public static Document field2Doc(IndexField indexField) {
        Document doc = new Document();
        Map<String, TableFieldDesc> tableFieldMap = LuceneContext.getInstance().getIndexConfig().getAllFieldMap();
        Set<Map.Entry<String, TableFieldDesc>> set = tableFieldMap.entrySet();
        for (Map.Entry<String, TableFieldDesc> entry : set) {
            Object object = indexField.getProperty(entry.getKey());
            TableFieldDesc tableFieldDesc = entry.getValue();
            Fieldable field = IndexUtil.getIndexField(tableFieldDesc, object);
            if (field == null) continue;
            doc.add(field);
        }
        return doc;
    }

    public static void makeIndex(BaseObj obj, int operType) {
        IndexMrg indeMrg = new IndexMrg();
        com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)obj;
        IndexField indexField = IndexUtil.doc2IndexField(document);
        try {
            if (operType == INDEX_ADD) {
                indeMrg.addIndex(indexField, true, operType);
            } else if (operType == INDEX_DEL) {
                indeMrg.deleteIndex(indexField.getId(), true, operType);
            } else {
                indeMrg.updateIndex(indexField, true, operType);
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }

    public static IndexField chnlDoc2Field(ChnlDoc chnlDoc) {
        if (chnlDoc == null) {
            return null;
        }
        try {
            Channel channel = chnlDoc.getChannel();
            com.trs.components.wcm.content.persistent.Document document = chnlDoc.getDocument();
            IndexField indexField = new IndexField();
            IndexUtil.fillIndexField(indexField, document);
            IndexUtil.fillIndexField(indexField, channel);
            IndexUtil.fillIndexField(indexField, chnlDoc);
            return indexField;
        }
        catch (WCMException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IndexField readData(ResultSet _rsData, ResultSetMetaData _rsmdData) throws WCMException {
        try {
            if (_rsData == null) {
                return null;
            }
            Object objValue = null;
            ResultSetMetaData rsmdData = _rsmdData != null ? _rsmdData : _rsData.getMetaData();
            IndexField indexField = new IndexField();
            int nColCount = rsmdData.getColumnCount();
            for (int i = 1; i <= nColCount; ++i) {
                String sFieldName = rsmdData.getColumnLabel(i).toUpperCase();
                objValue = null;
                switch (rsmdData.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (rsmdData.getScale(i) <= 0) {
                            long lValue = _rsData.getLong(i);
                            if (_rsData.wasNull()) break;
                            objValue = new Long(lValue);
                            break;
                        }
                        Double dValue = new Double(_rsData.getDouble(i));
                        if (_rsData.wasNull()) break;
                        objValue = dValue;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long lValue = _rsData.getLong(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Long(lValue);
                        break;
                    }
                    case 12: {
                        objValue = _rsData.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = new CMyDateTime();
                        ((CMyDateTime)objValue).setDateTimeWithRs(_rsData, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        objValue = new CDBText(IndexUtil.getDBManager().getDBType());
                        ((CDBText)objValue).readFromRs(_rsData, i);
                        break;
                    }
                    case 8: {
                        double dValue = _rsData.getDouble(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Double(dValue);
                        break;
                    }
                    default: {
                        objValue = _rsData.getObject(i);
                    }
                }
                if (objValue == null) continue;
                indexField.setProperty(sFieldName, objValue);
            }
            return indexField;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + IndexUtil.class.getName() + ".readChnlDocPropertyFromRs).", ex);
        }
        catch (CMyException ex) {
            throw new WCMException(1, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + IndexUtil.class.getName() + ".readChnlDocPropertyFromRs).", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(ViewDocument.class, "ViewDocument.label15", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + IndexUtil.class.getName() + ".readChnlDocPropertyFromRs).", ex);
        }
    }

    public static void fillIndexField(IndexField indexField, CMSObj cmsObj) {
        Map<String, TableDesc> map = LuceneContext.getInstance().getIndexConfig().getTableDescMap();
        if (cmsObj instanceof Channel) {
            Channel channel = (Channel)cmsObj;
            List<TableFieldDesc> list = map.get("WCMCHANNEL").getTableFieldDescList();
            for (int i = 0; i < list.size(); ++i) {
                TableFieldDesc tableFieldDesc = list.get(i);
                String name = tableFieldDesc.getFieldName();
                indexField.setProperty(name, channel.getProperty(name));
            }
            return;
        }
        if (cmsObj instanceof ChnlDoc) {
            ChnlDoc chnlDoc = (ChnlDoc)cmsObj;
            List<TableFieldDesc> list = map.get("WCMCHNLDOC").getTableFieldDescList();
            for (int i = 0; i < list.size(); ++i) {
                TableFieldDesc tableFieldDesc = list.get(i);
                String name = tableFieldDesc.getFieldName();
                indexField.setProperty(name, chnlDoc.getProperty(name));
            }
            return;
        }
        if (cmsObj instanceof com.trs.components.wcm.content.persistent.Document) {
            com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)cmsObj;
            List<TableFieldDesc> list = map.get("WCMDOCUMENT").getTableFieldDescList();
            for (int i = 0; i < list.size(); ++i) {
                TableFieldDesc tableFieldDesc = list.get(i);
                String name = tableFieldDesc.getFieldName();
                indexField.setProperty(name, document.getProperty(name));
            }
            return;
        }
    }

    private static DBManager getDBManager() {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new Error(I18NMessage.get(BaseObj.class, "BaseObj.label42", "\u6570\u636e\u5e93\u6ca1\u6709\u6b63\u5e38\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }
}

